﻿CREATE PROC [dbo].[usp_CommonPagination]
@TableName     sysname,           --要分页显示的表名
@FieldKey   nvarchar(1000),  --用于定位记录的主键(惟一键)字段,可以是逗号分隔的多个字段
@FieldShow nvarchar(1000)='',  --以逗号分隔的要显示的字段列表,如果不指定,则显示所有字段
@FieldOrder nvarchar(1000)='',  --以逗号分隔的排序字段列表,可以指定在字段后面指定DESC/ASC用于指定排序顺序                                         
@Where    nvarchar(max)='', --查询条件
@PageSize   int=10,            --每页的大小(记录数)
@PageIndex int=1         --要显示的页码

AS
SET NOCOUNT ON

--检查对象是否有效
IF OBJECT_ID(@TableName) IS NULL
BEGIN
RAISERROR(N'对象"%s"不存在',1,16,@TableName)
RETURN
END
IF OBJECTPROPERTY(OBJECT_ID(@TableName),N'IsTable')=0
AND OBJECTPROPERTY(OBJECT_ID(@TableName),N'IsView')=0
AND OBJECTPROPERTY(OBJECT_ID(@TableName),N'IsTableFunction')=0
BEGIN
RAISERROR(N'"%s"不是表、视图或者表值函数',1,16,@TableName)
RETURN
END

--分页字段检查
IF ISNULL(@FieldKey,N'')=''
BEGIN
RAISERROR(N'分页处理需要主键（或者惟一键）',1,16)
RETURN
END

--其他参数检查及规范
IF ISNULL(@PageIndex,0)<1 SET @PageIndex=1
IF ISNULL(@PageSize,0)<1 SET @PageSize=10
IF ISNULL(@FieldShow,N'')=N'' SET @FieldShow=N'*'
IF ISNULL(@FieldOrder,N'')=N''
SET @FieldOrder=N''
ELSE
SET @FieldOrder=N'ORDER BY '+LTRIM(@FieldOrder)

IF ISNULL(@Where,N'')=N''
SET @Where=N''
ELSE
SET @Where=N'WHERE ('+@Where+N')'

--计算分页显示的TOPN值
DECLARE @TopN varchar(20),@TopN1 varchar(20)
SELECT @TopN=@PageSize,
@TopN1=(@PageIndex-1)*@PageSize

--第一页直接显示
IF @PageIndex=1
EXEC(N'SELECT TOP '+@TopN
+N' '+@FieldShow
+N' FROM '+@TableName
+N' '+@Where
+N' '+@FieldOrder)
ELSE
BEGIN
--处理别名
IF @FieldShow=N'*'
SET @FieldShow=N'a.*'

--生成主键(惟一键)处理条件
DECLARE @Where1 nvarchar(max),@Where2 nvarchar(max),
@s nvarchar(1000),@Field sysname
SELECT @Where1=N'',@Where2=N'',@s=@FieldKey
WHILE CHARINDEX(N',',@s)>0
SELECT @Field=LEFT(@s,CHARINDEX(N',',@s)-1),
@s=STUFF(@s,1,CHARINDEX(N',',@s),N''),
@Where1=@Where1+N' AND a.'+@Field+N'=b.bkey',
@Where2=@Where2+N' AND b.bkey IS NULL',
@Where=N' '+@Where,
@Where=REPLACE(@Where,' '+@s,N' a.'+@s),
@Where=REPLACE(@Where,','+@s,N',a.'+@s),
@FieldOrder=N' '+@FieldOrder,
@FieldOrder=REPLACE(@FieldOrder,' '+@s,N' a.'+@s),
@FieldOrder=REPLACE(@FieldOrder,','+@s,N',a.'+@s),
@FieldShow=N' '+@FieldShow,
@FieldShow=REPLACE(@FieldShow,' '+@s,N' a.'+@s),
@FieldShow=REPLACE(@FieldShow,','+@s,N',a.'+@s)
SELECT
@Where=N' '+@Where,
@Where=REPLACE(@Where,' '+@s,N' a.'+@s),
@Where=REPLACE(@Where,','+@s,N',a.'+@s),
@FieldOrder=N' '+@FieldOrder,
@FieldOrder=REPLACE(@FieldOrder,' '+@s,N' a.'+@s),
@FieldOrder=REPLACE(@FieldOrder,','+@s,N',a.'+@s),
@FieldShow=N' '+@FieldShow,
@FieldShow=REPLACE(@FieldShow,' '+@s,N' a.'+@s),
@FieldShow=REPLACE(@FieldShow,','+@s,N',a.'+@s),
@Where1=STUFF(@Where1+N' AND a.'+@s+N'=b.bkey',1,5,N''),
@Where2=CASE
WHEN @Where='' THEN N'WHERE ('
ELSE @Where+N' AND ('
END+N'b.bkey IS NULL'+@Where2+N')'

--执行查询
EXEC(N'SELECT TOP '+@TopN
+N' '+@FieldShow
+N' FROM '+@TableName
+N' a LEFT JOIN(SELECT TOP '+@TopN1
+N' '+@FieldKey
+N' as bkey FROM '+@TableName
+N' a '+@Where
+N' '+@FieldOrder
+N')b ON '+@Where1
+N' '+@Where2
+N' '+@FieldOrder)
END
 





GO


