﻿create proc [dbo].[p_backupdb] 
@dbname sysname='', --要备份的数据库名称,不指定则备份当前数据库 
--@bkpath nvarchar(260)='', --备份文件的存放目录,不指定则使用SQL默认的备份目录 
@bkfname nvarchar(260)='', --备份文件名,文件名中可以用\DBNAME\代表数据库名,\DATE\代表日期,\TIME\代表时间 
@bktype nvarchar(10)='DB', --备份类型:'DB'备份数据库,'DF' 差异备份,'LOG' 日志备份 
@appendfile bit=1 --追加/覆盖备份文件 
as 
declare @sql varchar(8000) 
if isnull(@dbname,'')='' set @dbname=db_name() 
--if isnull(@bkpath,'')='' set @bkpath=dbo.f_getdbpath(null) 
if isnull(@bkfname,'')='' set @bkfname='\DBNAME\_\DATE\_\TIME\.BAK' 
set @bkfname=replace(replace(replace(@bkfname,'\DBNAME\',@dbname) 
,'\DATE\',convert(varchar,getdate(),112)) 
,'\TIME\',replace(convert(varchar,getdate(),108),':','')) 
set @sql='backup '+case @bktype when 'LOG' then 'log ' else 'database ' end +@dbname 
+' to disk='''+@bkfname 
+''' with '+case @bktype when 'DF' then 'DIFFERENTIAL,' else '' end 
+case @appendfile when 1 then 'NOINIT' else 'INIT' end 
print @sql 
exec(@sql) 