﻿<%@ Page Language="C#" AutoEventWireup="True" Inherits="install.install_Step4" CodeBehind="step4.aspx.cs" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta content="IE=EmulateIE7" http-equiv="X-UA-Compatible" />
    <meta content="text/html; charset=UTF-8" http-equiv="content-type" />
    <meta name="author" content="LebiShop" />
    <link rel="icon" type="image/x-icon" href="http://www.lebi.cn/favicon.ico" media="screen" />
    <link rel="shortcut icon" type="image/x-icon" href="http://www.lebi.cn/favicon.ico"
        media="screen" />
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <script src="../Theme/system/js/jquery-1.7.2.min.js" type="text/javascript"></script>
    <link rel="stylesheet" type="text/css" href="css/css.css" media="screen" />
    <title>乐彼多语言网上商店系统 - LebiShop 安装程序</title>
</head>
<body>
    <form id="Form1" runat="server">
        <div class="main">
            <div class="license">
                <a href="http://www.lebi.cn/down/" target="_blank"><span>LebiShop <%=version+"."+version_son%></span></a>
            </div>
            <div class="faq">
                <h2>我们是您的坚强后盾</h2>
                您尽可满怀信心地安装使用 LebiShop 。在线帮助将在这里为您提供针对 LebiShop 安装和使用的一对一支持。有关安装和使用的问题，请查看我们的<a target="_blank" href="http://www.lebi.cn/faq/">帮助中心</a>，或在<a target="_blank" href="http://www.lebi.cn/forum/">用户社区</a>中查看您的问题是否已得到解答或者发布一个新问题。
            <h2>安装遇到的常见问题</h2>
                <a href="http://www.lebi.cn/faq/info.aspx?id=212" target="_blank">Install安装向导数据库安装失败</a><br />
                <a href="http://www.lebi.cn/faq/info.aspx?id=89" target="_blank">图解在本机安装SQL Server客户端</a><br />
                <a href="http://www.lebi.cn/faq/info.aspx?id=90" target="_blank">在SQL Server中新建数据库</a>
            </div>
            <div class="login-form">
                <ul>
                    <li class="text">数据库类型：
                    <input type="radio" name="dbtype" onclick="SetTable();" value="sql" checked />MSSQL Server
<%--                    <input type="radio" name="dbtype" onclick="SetTable();" value="access" />Access</li>--%>
                </ul>
                <ul id="sqlul">
                    <li class="text">数据库地址：<em id="msg_ip">一般为localhost</em></li>
                    <li>
                        <input type="text" class="input-name" id="Text1" value="localhost"
                            onblur="viaIP();" /></li>
                    <li class="text">数据库名称：<em id="msg_dbName">安装前确保此数据库名称已存在</em></li>
                    <li>
                        <input type="text" class="input-name" id="Text2" value="LebiShop"
                            onblur="viaDBName();" /></li>
                    <li class="text">数据库用户名：<em id="msg_userName"></em></li>
                    <li>
                        <input type="text" class="input-name" id="Text3" value="sa" onblur="viaUserName();" /></li>
                    <li class="text">数据库密码：<em id="msg_userPwd"></em></li>
                    <li>
                        <input type="text" class="input-name" id="Text4" value="" onblur="viaUserPwd();" /></li>
                    <li class="text">
                        <input type="button" id="TestConnect" class="btn" onclick="TestConnent();" value="测试连接" />
                        <label id="lbDBStatus" class="red">
                        </label>
                    </li>
                </ul>
                <div class="both">
                </div>
                <div style="font-size: 12px; padding: 0 0 5px 0; color: Navy" id="msg">
                </div>
                <div class="login-btn">
                    <input id="Button2" type="button" value="上一步" class="submit" onclick="location.href = 'Step3.aspx'" />
                    <input id="Button1" type="button" value="下一步" class="submit" onclick="CreateDB();" />
                </div>
            </div>
            <div class="both">
            </div>
        </div>
    </form>
</body>
</html>
<script type="text/javascript">
    function via() {
        var flag = true;
        if (!viaIP()) {
            flag = false;
        }
        if (!viaDBName()) {
            flag = false;
        }
        if (!viaUserName()) {
            flag = false;
        }
        if (!viaUserPwd()) {
            flag = false;
        }
        return flag;
    }
    function viaIP() {
        if ($("#Text1").val() == "") {
            $("#msg_ip").html("<span class='msg_submit'>数据库地址不能为空！</span>");
            $("#lbDBStatus").html("");
            $("#Button1").attr("disabled", "disabled");
            return false;
        } else {
            $("#msg_ip").html("(一般为localhost)");
            return true;
        }
    }
    function viaDBName() {
        if ($("#Text2").val() == "") {
            $("#msg_dbName").html("<span class='msg_submit'>数据库名称不能为空！</span>");
            $("#Button1").attr("disabled", "disabled");
            $("#lbDBStatus").html("");
            return false;
        } else {
            $("#msg_dbName").html("");
            return true;
        }
    }
    function viaUserName() {
        if ($("#Text3").val() == "") {
            $("#msg_userName").html("<span class='msg_submit'>数据库用户名不能为空！</span>");
            $("#Button1").attr("disabled", "disabled");
            $("#lbDBStatus").html("");
            return false;
        } else {
            $("#msg_userName").html("");
            return true;
        }
    }

    function viaUserPwd() {
        if ($("#Text4").val() == "") {
            $("#msg_userPwd").html("<span class='msg_submit'>数据库密码不能为空！</span>");
            $("#Button1").attr("disabled", "disabled");
            $("#lbDBStatus").html("");
            return false;
        } else {
            $("#msg_userPwd").html("");
            return true;
        }
    }
    function SetTable() {
        var dbtype = $("input[name='dbtype']:checked").val();
        if (dbtype == "access") {
            $("#sqlul").hide();
            $("#Button1").removeAttr("disabled");
        }
        else {
            $("#sqlul").show();
            $("#Button1").attr("disabled", "disabled");
        }
    }
    SetTable();
    function TestConnent() {
        if (!via())
            return false;
        var ip = $("#Text1").val();
        var databasename = $("#Text2").val();
        var username = $("#Text3").val();
        var pwd = $("#Text4").val();
        var jsondata = { "ip": ip, "databasename": databasename, "username": username, "pwd": pwd };
        var url = "ajax.aspx?__Action=TestConnect";
        $.ajax({
            type: "POST",
            url: url,
            data: jsondata,
            dataType: 'html',
            success: function (res) {
                if (res == "OK") {
                    //window.location = "step5.aspx";
                    $("#lbDBStatus").html("测试成功");
                    $("#Button1").removeAttr("disabled");
                }
                else {
                    $("#lbDBStatus").html(res);
                    $("#Button1").attr("disabled", "disabled");
                    return false;
                }
            }
        });
    }
    function CreateDB() {
        var dbtype = $("input[name='dbtype']:checked").val();
        if (dbtype != "access") {
            if (!via())
                return false;
        }
        var ip = $("#Text1").val();
        var databasename = $("#Text2").val();
        var username = $("#Text3").val();
        var pwd = $("#Text4").val();
        var jsondata = { "ip": ip, "databasename": databasename, "username": username, "pwd": pwd, "dbtype": dbtype };
        var url = "ajax.aspx?__Action=CreateDB";
        $.ajax({
            type: "POST",
            url: url,
            data: jsondata,
            dataType: 'html',
            beforeSend: function () {
                $("#msg").html("<img src=\"../theme/system/images/Load.gif\" height=16 />正在生成数据库，根据您的计算机情况，可能需要几分钟的时间，请不要关闭浏览器耐心等待！");
                $("#Button1").attr("disabled", "disabled");
            },
            success: function (res) {
                if (res == "OK") {
                    window.location = "step5.aspx";
                }
                else {
                    $("#lbDBStatus").html(res);
                    return false;
                }
            }
        });
    }
</script>
