﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="card_edit.aspx.cs" Inherits="SKtms.Web.admin.plugins.card.card_edit" ValidateRequest="false" %>
<%@ Import Namespace="SKtms.Common" %>

<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=no" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <title>充值卡管理</title>
    <link href="../../../scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
    <link href="../../skin/default/style.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript" charset="utf-8" src="../../../scripts/jquery/jquery-1.11.2.min.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../../scripts/jquery/Validform_v5.3.2_min.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../../scripts/datepicker/WdatePicker.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../../scripts/artdialog/dialog-plus-min.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../../scripts/webuploader/webuploader.min.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../js/uploader.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../js/laymain.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../js/common.js"></script>
    <script type="text/javascript">
        $(function () {
            //初始化表单验证
            $("#form1").initValidform();
        });
    </script>
</head>

<body class="mainbody">
<form id="form1" runat="server">
    <!--导航栏-->
    <div class="location">
        <a href="card_list.aspx" class="back"><i></i><span>返回列表页</span></a>
        <a href="../center.aspx" class="home"><i></i><span>首页</span></a>
        <i class="arrow"></i>
        <span>应用管理</span>
        <i class="arrow"></i>
        <span>充值卡管理</span>
    </div>
    <div class="line10"></div>
    <!--/导航栏-->

    <!--内容-->
    <div id="floatHead" class="content-tab-wrap">
        <div class="content-tab">
            <div class="content-tab-ul-wrap">
                <ul>
                    <%if(action == BSEnums.ActionEnum.Edit.ToString()){ %>
                    <li><a class="selected" href="javascript:;">编辑充值卡</a></li>
                    <%}else{ %>
                    <li><a class="selected" href="javascript:;">添加充值卡</a></li>
                    <%} %>
                </ul>
            </div>
        </div>
    </div>

    <div class="tab-content">
        <dl>
            <dt>充值卡名称</dt>
            <dd>
                <asp:TextBox ID="txt_card_name" runat="server" CssClass="input normal" datatype="s" sucmsg=" "/>
                <span class="Validform_checktip">*充值卡名称,如“一个月VIP会员卡 28元”</span>
            </dd>
        </dl>
        <dl>
            <dt>充值方式</dt>
            <dd>
                <div class="rule-multi-radio">
                    <asp:RadioButtonList ID="rb_card_type" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow">
                        <asp:ListItem Value="1" Selected="True">在线充值购买（会员中心自行购买）</asp:ListItem>
                        <asp:ListItem Value="2" Enabled="false">线下销售</asp:ListItem>
                    </asp:RadioButtonList>
                </div>
            </dd>
        </dl>
        <dl>
            <dt>充值卡面值</dt>
            <dd>
                <asp:TextBox ID="txt_card_money" runat="server" CssClass="input mini" datatype="/^[\d\.]+$/" sucmsg=" "/>&nbsp;&nbsp;元
                <span class="Validform_checktip">*即购买人需要花费的实际金额</span>
            </dd>
        </dl>
        <dl>
            <dt>充值卡类型</dt>
            <dd>
                <asp:DropDownList ID="ddl_valid_unit" runat="server" CssClass="select">
                    <asp:ListItem Value="1">增加天数</asp:ListItem>
                    <asp:ListItem Value="2">增加金额(元)</asp:ListItem>
                    <asp:ListItem Value="3">增加发布点</asp:ListItem>
                    <asp:ListItem Value="4">增加收藏点</asp:ListItem>
                    <asp:ListItem Value="5">增加流量点</asp:ListItem>
                    <asp:ListItem Value="6">会员组转换</asp:ListItem>
                </asp:DropDownList>
            </dd>
        </dl>
        <dl>
            <dt>有效期天数|点数|资金</dt>
            <dd>
                <asp:TextBox ID="txt_valid_num" runat="server" CssClass="input mini" datatype="n" sucmsg=" "/>
                <span class="Validform_checktip">*根据上面卡类型填写，购买后可以得到的会员有效天数、点数、资金等（若会员组转换 填1商家 0买家）</span>
            </dd>
        </dl>
        <dl>
            <dt>是否禁止兑换资金</dt>
            <dd>
                <div class="rule-single-checkbox">
                    <asp:CheckBox ID="cb_is_forbid_exchange" runat="server" />
                </div>
                <span class="Validform_checktip">*选中此项，用户购买该卡后会禁止该用户兑换资金 (一般用于发布点类型，谨慎使用)</span>
            </dd>
        </dl>
        <dl>
            <dt>允许购买此卡的用户组</dt>
            <dd>
                <div class="rule-multi-checkbox">
                    <asp:CheckBoxList ID="cb_allow_use_group_id" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow">
                    </asp:CheckBoxList>
                </div>
                <span class="Validform_checktip">*不选或全选表示不限制</span>
            </dd>
        </dl>
        <dl>
            <dt>充值后归入的用户组</dt>
            <dd>
                <asp:DropDownList ID="ddl_join_group_id" runat="server" CssClass="select">
                </asp:DropDownList>
                <span class="Validform_checktip">*充值后自动归入的用户组</span>
            </dd>
        </dl>
        <dl>
            <dt>到期后归入的用户组</dt>
            <dd>
                <asp:DropDownList ID="ddl_expire_group_id" runat="server" CssClass="select">
                </asp:DropDownList>
                <span class="Validform_checktip">*指用户购买充值卡充值后，当账户的有效天数|点数|资金用完后或已过期，将自动归入低一级别的用户组。【注:目前仅对有效期天数卡有效】</span>
            </dd>
        </dl>
        <dl>
            <dt>充值截止日期</dt>
            <dd>
                <asp:TextBox ID="txt_end_time" runat="server" CssClass="input txt" onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss'});" datatype="*" sucmsg=" "></asp:TextBox>
                <span class="Validform_checktip">*注：截止期过后就不能再充值了</span>
            </dd>
        </dl>
        <dl>
            <dt>充值卡图片</dt>
            <dd>
                <asp:TextBox ID="txt_page_card_img_url" runat="server" CssClass="input normal" datatype="*" sucmsg=" " ignore="ignore" />
                <span class="Validform_checktip">*图片可预先上传到服务器，再手工填写上</span>
            </dd>
        </dl>
        <dl>
            <dt>充值卡标题</dt>
            <dd>
                <asp:TextBox ID="txt_page_card_title" runat="server" TextMode="MultiLine" CssClass="input" datatype="*" sucmsg=" " ignore="ignore" />
                <span class="Validform_checktip">*显示在购买点卡页面上的，支持HTML语法</span>
            </dd>
        </dl>
        <dl>
            <dt>充值卡描述</dt>
            <dd>
                <asp:TextBox ID="txt_page_card_desc" runat="server" TextMode="MultiLine" CssClass="input" datatype="*" sucmsg=" " ignore="ignore" />
                <span class="Validform_checktip">*显示在购买点卡页面上的，支持HTML语法</span>
            </dd>
        </dl>
        <dl>
            <dt>排序显示</dt>
            <dd>
                <asp:TextBox ID="txt_sort_id" runat="server" CssClass="input small" datatype="n" sucmsg=" " value="99" />
                <span class="Validform_checktip">*前台购买点卡页面是按这排序显示的</span>
            </dd>
        </dl>
        <dl>
            <dt>是否禁用</dt>
            <dd>
                <div class="rule-single-checkbox">
                    <asp:CheckBox ID="cb_is_pause" runat="server" />
                </div>
                <span class="Validform_checktip">*禁用就不能使用了，也不会显示在前台购买页面中</span>
            </dd>
        </dl>
        <dl>
            <dt>是否在前台显示</dt>
            <dd>
                <div class="rule-single-checkbox">
                    <asp:CheckBox ID="cb_is_show" runat="server" />
                </div>
                <span class="Validform_checktip">*是否在前台购买点卡页面中显示</span>
            </dd>
        </dl>
    </div>
    <!--/内容-->

    <!--工具栏-->
    <div class="page-footer">
        <div class="btn-wrap">
            <asp:Button ID="btnSubmit" runat="server" Text="提交保存" CssClass="btn" OnClick="btnSubmit_Click" />
            <input name="btnReturn" type="button" value="返回上一页" class="btn yellow" onclick="javascript: history.back(-1);" />
        </div>
    </div>
    <!--/工具栏-->

</form>
</body>
</html>
