﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="express_api_config.aspx.cs" Inherits="SKtms.Web.admin.plugins.express.express_api_config" ValidateRequest="false" %>
<%@ Import namespace="SKtms.Common" %>

<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=no" />
<meta name="apple-mobile-web-app-capable" content="yes" />
<title>空包参数设置</title>
<link href="../../../scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
<link href="../../skin/default/style.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" charset="utf-8" src="../../../scripts/jquery/jquery-1.11.2.min.js"></script>
<script type="text/javascript" charset="utf-8" src="../../../scripts/jquery/Validform_v5.3.2_min.js"></script>
<script type="text/javascript" charset="utf-8" src="../../../scripts/artdialog/dialog-plus-min.js"></script>
<script type="text/javascript" charset="utf-8" src="../../js/laymain.js"></script>
<script type="text/javascript" charset="utf-8" src="../../js/common.js"></script>
<script type="text/javascript">
    $(function () {
        //初始化表单验证
        $("#form1").initValidform();
    });
</script>
</head>

<body class="mainbody">
<form id="form1" runat="server">
<!--导航栏-->
<div class="location">
  <a href="javascript:history.back(-1);" class="back"><i></i><span>返回上一页</span></a>
  <a href="../center.aspx" class="home"><i></i><span>首页</span></a>
  <i class="arrow"></i>
  <span>应用管理</span>
  <i class="arrow"></i>
  <span>空包参数设置</span>
</div>
<div class="line10"></div>
<!--/导航栏-->

<!--内容-->
<div id="floatHead" class="content-tab-wrap">
  <div class="content-tab">
    <div class="content-tab-ul-wrap">
      <ul>
        <li><a class="selected" href="javascript:;">API接口设置</a></li>
      </ul>
    </div>
  </div>
</div>

<!--参数设置-->
<div class="tab-content">
  <dl>
    <dt></dt>
    <dd>
      <span class="red size14">注：如果选了非自己进出货，就要到所选网站申请账号再填写上才有效</span>
    </dd>
  </dl>
  <dl>
    <dt>快递单号进货渠道</dt>
    <dd>
      <div class="rule-single-select">
        <asp:DropDownList id="api_id" runat="server" datatype="*" sucmsg=" " AutoPostBack="True" OnSelectedIndexChanged="api_id_SelectedIndexChanged">
          <asp:ListItem Value="1" Selected="True">自己进出货</asp:ListItem>
          <asp:ListItem Value="2" url="http://www.kongbaohy.com">空包货源网</asp:ListItem>
          <asp:ListItem Value="3" url="http://www.zzkc.cc">站长空包网</asp:ListItem>
        </asp:DropDownList>
      </div>
      <span class="Validform_checktip" runat="server" id="site_url">*选择单号进货渠道商</span>
    </dd>
  </dl>
  <dl id="dl_amount" runat="server" visible="false">
    <dt>账户可用余额</dt>
    <dd>
        <asp:Label ID="amount" runat="server" Text="-" CssClass="red"></asp:Label>
    </dd>
  </dl>
  <dl>
    <dt>接口账号</dt>
    <dd>
      <asp:TextBox ID="api_account" runat="server" CssClass="input txt" ignore="ignore" datatype="*3-30" sucmsg=" " />
      <span class="Validform_checktip">*在相关空包网申请的账号</span> &nbsp;<a href="http://www.hsktms.com/kb/gourl.htm" target="_blank">还没有账号？点我申请</a>
    </dd>
  </dl>
  <dl>
    <dt>接口密码</dt>
    <dd>
      <asp:TextBox ID="api_pwd" runat="server" CssClass="input txt" ignore="ignore" datatype="*3-30" sucmsg=" " TextMode="Password" />
      <span class="Validform_checktip">*在相关空包网申请的密码</span>
    </dd>
  </dl>
  <dl style="display:none;">
    <dt>接口URL</dt>
    <dd>
      <asp:TextBox ID="api_url" runat="server" CssClass="input normal" ignore="ignore" datatype="url" sucmsg=" " />
      <span class="Validform_checktip">*填写接口网关URL</span>
    </dd>
  </dl>
  <dl>
    <dt>出单号方式</dt>
    <dd>
      <div class="rule-multi-radio">
        <asp:RadioButtonList ID="api_submit_type" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow">
        <asp:ListItem Value="0" Selected="True">即时出单</asp:ListItem>
        <asp:ListItem Value="1">手工提交出单</asp:ListItem>
        </asp:RadioButtonList>
      </div>
      <span class="Validform_checktip">*推荐即时出单方式，请保证所在空包网的账户有充足余额</span>
    </dd>
  </dl>
</div>
<!--/参数设置-->

<!--/内容-->

<!--工具栏-->
<div class="page-footer">
  <div class="btn-wrap">
    <asp:Button ID="btnSubmit" runat="server" Text="提交保存" CssClass="btn" onclick="btnSubmit_Click" />
    <input name="btnReturn" type="button" value="返回上一页" class="btn yellow" onclick="javascript:history.back(-1);" />
  </div>
</div>
<!--/工具栏-->
</form>
</body>
</html>
