﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="express_buy_list.aspx.cs" Inherits="SKtms.Web.admin.plugins.express.express_buy_list" %>

<%@ Import Namespace="SKtms.Common" %>

<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=no" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <title>空包快递管理</title>
    <link href="../../../scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
    <link href="../../skin/default/style.css" rel="stylesheet" type="text/css" />
    <link href="../../../css/pagination.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript" src="../../../scripts/jquery/jquery-1.11.2.min.js"></script>
    <script type="text/javascript" src="../../../scripts/artdialog/dialog-plus-min.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../js/laymain.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../js/common.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../../scripts/datepicker/WdatePicker.js"></script>
</head>

<body class="mainbody">
    <script type="text/javascript">
        $(function () {
            //点击右边单个删除连接
            $(".del_link").click(function () {
                $(this).parents().find(".checkall input[type='checkbox']").prop("checked", false);
                $(this).parent().parent().find(".checkall input[type='checkbox']").prop("checked", true);
                return jsConfirm($(this), '你确定要删除记录吗？<br /><br />注：还没单号的订单会退还金额，已有单号的仅删除。<br />tips：左上角的删除按钮可批量删除，均不退还金额。');
            });
            //点击右边单个删除单号连接
            $(".del_dh_link").click(function () { return del_danhao(this, this); });
            $(".del_dh_btn").click(function () { return del_danhao(null, this); });
            function del_danhao(obj, subobj) {
                if (obj) {
                    $(obj).parents().find(".checkall input[type='checkbox']").prop("checked", false);
                    $(obj).parent().parent().find(".checkall input[type='checkbox']").prop("checked", true);
                }
                return jsConfirm($(subobj), '你确定要删除订单的快递单号吗？<br /><br />注：一般晚上20点前(具体以官网公示为准)的快递单号可以删除<br />资金退回你的API接口账号中，如果总部提交发货后将不可删除。<br />（一般是订购信息有误或者订购者想撤销订单才使用本功能）');
            }
            //表格点击显示下一隐藏列
            $(".msg-tr").click(function () {
                $(this).next().addClass("odd_bg").toggle();
            });
        });
    </script>
    <script type="text/javascript">
        function ExportOption() {
            var content = $("#export_msg");
            var d = dialog({
                title: '导出订购信息',
                content: content,
                okValue: "导出Excel",
                ok: function () {
                    var value = {
                        com_name_val: get_DropDownList_Value("#com_name"),
                        export_has_num_val: get_RadioButtonList_Value("#export_has_num"),
                        export_date_option_val: get_RadioButtonList_Value("#export_date_option"),
                        begin_date_val: $("#begin_date").val(),
                        end_date_val: $("#end_date").val(),
                        export_cols_option_val: get_CheckBoxList_Values("#export_cols_option")
                    };
                    d.close(value).remove();
                },
                cancelValue: '关闭取消',
                cancel: function () {
                    d.close().remove();
                }
            });
            d.addEventListener('close', function () {
                if (this.returnValue != '') {
                    $("#order_type_value").val('<%=this.order_type%>');
                    $("#com_name_value").val(this.returnValue.com_name_val);
                    $("#export_has_num_value").val(this.returnValue.export_has_num_val);
                    $("#export_date_option_value").val(this.returnValue.export_date_option_val);
                    $("#begin_date_value").val(this.returnValue.begin_date_val);
                    $("#end_date_value").val(this.returnValue.end_date_val);
                    $("#export_cols_option_value").val(this.returnValue.export_cols_option_val);
                    __doPostBack("btnExport", '');
                }
            });
            d.width(780).showModal();
            return false;
        }

        function get_DropDownList_Value(obj) {
            return $(obj).val();
        }
        function get_RadioButtonList_Value(obj) {
            return $(obj).find(':checked').val();
        }
        function get_CheckBoxList_Values(obj) {
            var values = "";
            $(obj).find(':checked').each(function () {
                if ($(this).val()) {
                    values += $(this).val() + ",";
                }
            });
            return values.substr(0, values.length - 1);
        }
    </script>
    <form id="form1" runat="server">
        <!--导航栏-->
        <div class="location">
            <a href="javascript:history.back(-1);" class="back"><i></i><span>返回上一页</span></a>
            <a href="../center.aspx" class="home"><i></i><span>首页</span></a>
            <i class="arrow"></i>
            <span>应用管理</span>
            <i class="arrow"></i>
            <span>空包快递管理</span>
        </div>
        <!--/导航栏-->

        <!--工具栏-->
        <div id="floatHead" class="toolbar-wrap">
            <div class="toolbar">
                <div class="box-wrap">
                    <a class="menu-btn"></a>
                    <div class="l-list">
                        <ul class="icon-list">
                            <li><a class="all" href="javascript:;" onclick="checkAll(this);"><i></i><span>全选</span></a></li>
                            <li>
                                <asp:LinkButton ID="btnDelete" runat="server" CssClass="del" OnClientClick="return ExePostBack('btnDelete','你确定要删除吗？<br /><br />注：本项删除不退还订单金额，如需退还请点击订单右边的删除连接！');" OnClick="btnDelete_Click"><i></i><span>删除</span></asp:LinkButton></li>
                            <li>
                                <asp:LinkButton ID="btnDeleteDH" runat="server" CssClass="del del_dh_btn" OnClick="btnDelete_Right_Danhao_Click"><i></i><span>删除单号</span></asp:LinkButton></li>
                            <li>
                                <asp:LinkButton ID="btnExport" runat="server" CssClass="save" OnClientClick="return ExportOption();" OnClick="btnExport_Click"><i></i><span>导出订购信息</span></asp:LinkButton></li>
                        </ul>
                        <div class="menu-list">
                            <div class="rule-single-select">
                                <asp:DropDownList ID="ddlStatus" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlStatus_SelectedIndexChanged">
                                    <asp:ListItem Selected="True" Value="0">任务状态筛选</asp:ListItem>
                                    <asp:ListItem Value="1">已发货</asp:ListItem>
                                    <asp:ListItem Value="2">未发货</asp:ListItem>
                                </asp:DropDownList>
                            </div>
                        </div>
                        <%if (config != null && config.api_id > 1) {%>
                        <div class="menu-list" style="display: inline-block; width: 50%; margin: 0 auto; text-align: center;">
                            提交时间
                        <asp:TextBox ID="OrderBeginDate" runat="server" CssClass="input rule-date-input" onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss'})" datatype="/^\s*$|^\d{4}\-\d{1,2}\-\d{1,2}\s+\d{1,2}:\d{1,2}:\d{1,2}$/" errormsg="请选择正确的日期" sucmsg=" " title="留空则提交全部还没单号订单" />
                            至
                        <asp:TextBox ID="OrderEndDate" runat="server" CssClass="input rule-date-input" onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss'})" datatype="/^\s*$|^\d{4}\-\d{1,2}\-\d{1,2}\s+\d{1,2}:\d{1,2}:\d{1,2}$/" errormsg="请选择正确的日期" sucmsg=" " title="留空则提交全部还没单号订单" />
                            <asp:Button ID="btnOnkeyUpdate" runat="server" Text="一键提交到官网出单号" title="请注意空包接口账户余额是否充足" CssClass="btn green" OnClick="btnOnkeyUpdate_Click" OnClientClick="return confirm('您确定要提交吗？')" />
                        </div>
                        <% } %>
                    </div>
                    <div class="r-list">
                        <div class="menu-list">
                            <div class="rule-single-select">
                                <asp:DropDownList ID="ddlSearchType" runat="server">
                                    <asp:ListItem Selected="True" Value="">查找类型</asp:ListItem>
                                    <asp:ListItem Value="2">按快递单号查找</asp:ListItem>
                                    <asp:ListItem Value="3">按任务编号查找</asp:ListItem>
                                    <asp:ListItem Value="4">按购买人查找</asp:ListItem>
                                </asp:DropDownList>
                            </div>
                        </div>
                        <asp:TextBox ID="txtKeywords" runat="server" CssClass="keyword" />
                        <asp:LinkButton ID="lbtnSearch" runat="server" CssClass="btn-search" OnClick="btnSearch_Click">查询</asp:LinkButton>
                    </div>
                </div>
            </div>
        </div>
        <!--/工具栏-->

        <!--导出选项-->
        <asp:Hiddenfield ID="order_type_value" Value="0" runat="server" />
        <asp:HiddenField ID="com_name_value" Value="" runat="server" />
        <asp:HiddenField ID="export_has_num_value" Value="" runat="server" />
        <asp:HiddenField ID="export_date_option_value" Value="" runat="server" />
        <asp:HiddenField ID="begin_date_value" Value="" runat="server" />
        <asp:HiddenField ID="end_date_value" Value="" runat="server" />
        <asp:HiddenField ID="export_cols_option_value" Value="" runat="server" />
        <asp:HiddenField ID="hidden_order_type" Value="" runat="server" />

        <div id="export_msg" style="display: none;">
            <div class="tab-content">
                <dl>
                    <dt>快递类型</dt>
                    <dd>
                        <div class="rule-single-select">
                            <asp:DropDownList ID="com_name" runat="server" CssClass="select"></asp:DropDownList>
                        </div>
                    </dd>
                </dl>
                <dl>
                    <dt>是否有单号</dt>
                    <dd>
                        <div class="rule-multi-radio">
                            <asp:RadioButtonList ID="export_has_num" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow">
                                <asp:ListItem Value="0">有单号</asp:ListItem>
                                <asp:ListItem Value="1" Selected="True">没单号</asp:ListItem>
                                <asp:ListItem Value="2">不限</asp:ListItem>
                            </asp:RadioButtonList>
                        </div>
                    </dd>
                </dl>

                <dl>
                    <dt>订购时间</dt>
                    <dd>
                        <div class="rule-multi-radio">
                            <asp:RadioButtonList ID="export_date_option" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow">
                                <asp:ListItem Value="0" Selected="True">今天</asp:ListItem>
                                <asp:ListItem Value="1">昨天</asp:ListItem>
                                <asp:ListItem Value="2">自定义时间</asp:ListItem>
                            </asp:RadioButtonList>
                        </div>
                    </dd>
                </dl>
                <dl>
                    <dt>自定义时间</dt>
                    <dd>从
                        <asp:TextBox ID="begin_date" runat="server" CssClass="input rule-date-input" onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss'})" datatype="/^\s*$|^\d{4}\-\d{1,2}\-\d{1,2}\s+\d{1,2}:\d{1,2}:\d{1,2}$/" errormsg="请选择正确的日期" sucmsg=" " />
                        至
                        <asp:TextBox ID="end_date" runat="server" CssClass="input rule-date-input" onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss'})" datatype="/^\s*$|^\d{4}\-\d{1,2}\-\d{1,2}\s+\d{1,2}:\d{1,2}:\d{1,2}$/" errormsg="请选择正确的日期" sucmsg=" " />
                    </dd>

                </dl>
                <dl>
                    <dt>导出项目</dt>
                    <dd>
                        <div class="rule-multi-checkbox">
                            <asp:CheckBoxList ID="export_cols_option" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow">
                                <asp:ListItem Value="0">全部</asp:ListItem>
                                <asp:ListItem Value="1" Selected="True">快递公司</asp:ListItem>
                                <asp:ListItem Value="2">快递单号</asp:ListItem>
                                <asp:ListItem Value="3" Selected="True">订购人</asp:ListItem>
                                <asp:ListItem Value="4">订购时间</asp:ListItem>
                                <asp:ListItem Value="5" Selected="True">发货省市区(分列)</asp:ListItem>
                                <asp:ListItem Value="6">发货省市区(紧凑)</asp:ListItem>
                                <asp:ListItem Value="7">发货地址</asp:ListItem>
                                <asp:ListItem Value="8" Selected="True">发货详细地址</asp:ListItem>
                                <asp:ListItem Value="9" Selected="True">发件人姓名</asp:ListItem>
                                <asp:ListItem Value="10" Selected="True">发货人电话</asp:ListItem>
                                <asp:ListItem Value="11" Selected="True">收货省市区(分列)</asp:ListItem>
                                <asp:ListItem Value="12">收货省市区(紧凑)</asp:ListItem>
                                <asp:ListItem Value="13" Selected="True">收件人姓名</asp:ListItem>
                                <asp:ListItem Value="14" Selected="True">收货人电话</asp:ListItem>
                                <asp:ListItem Value="15">收货地址</asp:ListItem>
                                <asp:ListItem Value="16" Selected="True">收货详细信息</asp:ListItem>
                                <asp:ListItem Value="17" Selected="True">包裹名称</asp:ListItem>
                                <asp:ListItem Value="18" Selected="True">重量</asp:ListItem>
                            </asp:CheckBoxList>
                        </div>
                    </dd>
                </dl>
            </div>
        </div>
        <!--/导出选项-->

        <!--列表-->
        <script type="text/javascript">
            function WirtKuaidiNum(obj) {
                var w_id = $(obj).attr("target-id")
                var content = '填写快递单号：&nbsp;&nbsp;<input type="text" id="new_kuaidi_num_input" class="input txt" /><br /><br />';
                content += '<input type="checkbox" id="is_phone_msg_input"class="checkbox" />&nbsp;&nbsp;<label for="is_phone_msg_input">是否发手机短信通知</label><br />';
                content += '<input type="checkbox" id="is_site_msg_input" class="checkbox" />&nbsp;&nbsp;<label for="is_site_msg_input">是否发送站内信通知</label><br />';
                var d = dialog({
                    title: '请填写快递单号',
                    content: content,
                    okValue: "确定",
                    ok: function () {
                        if ($("#new_kuaidi_num_input").val() == '') {
                            var dd = dialog({ content: '请先填写快递单号' }).show();
                            setTimeout(function () {
                                dd.close().remove();
                            }, 2000);
                            return false;
                        }
                        var value = {
                            new_kuaidi_num: $("#new_kuaidi_num_input").val(),
                            is_phone_msg: $("#is_phone_msg_input").prop("checked"),
                            is_site_msg: $("#is_site_msg_input").prop("checked"),
                            w_id: w_id
                        };
                        d.close(value).remove();
                    },
                    cancelValue: '取消',
                    cancel: function () {
                        d.close().remove();
                    }
                });
                d.addEventListener('close', function () {
                    if (this.returnValue != '') {
                        $("#new_kuaidi_num").val(this.returnValue.new_kuaidi_num);
                        $("#is_phone_msg").val(this.returnValue.is_phone_msg);
                        $("#is_site_msg").val(this.returnValue.is_site_msg);
                        $("#w_id").val(this.returnValue.w_id);
                        __doPostBack("link_btn_wirte_kuaidi_num", '');
                    }
                });
                d.showModal();
                return false;
            }
        </script>
        <div class="table-container">
            <asp:HiddenField ID="new_kuaidi_num" Value="" runat="server" />
            <asp:HiddenField ID="new_scan_date" Value="" runat="server" />
            <asp:HiddenField ID="is_phone_msg" Value="" runat="server" />
            <asp:HiddenField ID="is_site_msg" Value="" runat="server" />
            <asp:HiddenField ID="w_id" Value="" runat="server" />
            <div style="display: none">
                <asp:LinkButton ID="link_btn_wirte_kuaidi_num" runat="server" CssClass="del_link" OnClick="WriteKuaidiNum_Click">删除</asp:LinkButton>
            </div>

            <asp:Repeater ID="rptList" runat="server">
                <HeaderTemplate>
                    <table width="100%" border="0" cellspacing="0" cellpadding="0" class="ltable">
                        <tr>
                            <th align="center" width="5%">选择</th>
                            <th align="center" width="5%">ID号</th>
                            <th align="center" width="11%">任务编号</th>
                            <th align="center" width="">快递公司</th>
                            <th align="center" width="12%">快递单号</th>
                            <th align="center" width="12%">发货地</th>
                            <th align="center" width="11%">订购人用户名</th>
                            <th align="center" width="12%">订购时间</th>
                            <th align="center" width="7.5%">价格</th>
                            <th align="center" width="11%">操作</th>
                        </tr>
                </HeaderTemplate>
                <ItemTemplate>
                    <tr class="msg-tr">
                        <td align="center">
                            <asp:CheckBox ID="chkId" CssClass="checkall" runat="server" Style="vertical-align: middle;" />
                            <asp:HiddenField ID="hidId" Value='<%#Eval("id")%>' runat="server" />
                        </td>
                        <td align="center"><%#Eval("id")%></td>
                        <td align="center"><%#Eval("task_no")%></td>
                        <td align="center"><a href="express_buy_list.aspx?kuaidi_id=<%#Eval("kuaidi_id")%>" title="查看该快递公司"><%#Eval("com_name")%></a></td>
                        <td align="center"><%#Get_kuaidi_num(Eval("kuaidi_num"),Eval("id"))%></td>
                        <td align="center"><%#Eval("fh_city")%></td>
                        <td align="center"><%#Eval("buy_user_name")%></td>
                        <td align="center"><%#Eval("add_date")%></td>
                        <td align="center"><%#Eval("money","{0:F2}")%>&nbsp;元</td>
                        <td align="center"><a  href="express_buy_detail.aspx?action=<%=BSEnums.ActionEnum.Edit %>&id=<%#Eval("id")%>">修改</a> |
                            <asp:LinkButton ID="btnDelete_Right" runat="server" CssClass="del_link" OnClick="btnDelete_Right_Click"><i></i><span>删除</span></asp:LinkButton>
                            <%if (config != null && config.api_id > 1)
                              {%>
                            <%#(Eval("kuaidi_num").ToString() != "") ? " | " : "" %>
                            <asp:LinkButton ID="btnDelete_Right_DH" runat="server" Visible=<%#(Eval("kuaidi_num").ToString() != "") ? true : false %> CssClass="del_dh_link" OnClick="btnDelete_Right_Danhao_Click"><i></i><span>删除单号</span></asp:LinkButton>
                            <% } %>
                        </td>
                    </tr>
                    <tr style="display: none;">
                        <td colspan="10" align="center">发货地：<%#Eval("fh_city").ToString()%> <%#Eval("fh_addr").ToString()%>&nbsp; &nbsp; 
                          发货人：<%#Eval("fh_user_name")%> &nbsp; &nbsp; 
                          发货人电话：<%#Eval("fh_mobile")%> &nbsp; &nbsp; 
                          收货地：<%#Eval("md_city")%> &nbsp; &nbsp; 
                          包裹名称：<%#Eval("package_name")%> / <%#Utils.GetNum(Eval("kg").ToString())%> kg
                        </td>
                    </tr>
                </ItemTemplate>
                <FooterTemplate>
                    <%#rptList.Items.Count == 0 ? "<tr><td align=\"center\" colspan=\"10\">暂无记录</td></tr>" : ""%>
                    </table>
                </FooterTemplate>
            </asp:Repeater>
        </div>
        <!--/列表-->
        <div class="line10"></div>

        <!--内容底部-->
        <div class="line10"></div>
        <div class="pagelist">
            <div class="l-btns">
                <span>显示</span><asp:TextBox ID="txtPageNum" runat="server" CssClass="pagenum" onkeydown="return checkNumber(event);"
                    OnTextChanged="txtPageNum_TextChanged" AutoPostBack="True"></asp:TextBox><span>条/页</span>
            </div>
            <div id="PageContent" runat="server" class="default"></div>
        </div>
        <!--/内容底部-->

    </form>
    
<div class="line10"></div>
<asp:Literal ID="Tips" runat="server"></asp:Literal>
</body>
</html>
