﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="express_buy_list2.aspx.cs" Inherits="SKtms.Web.admin.plugins.express.express_buy_list2" %>

<%@ Import Namespace="SKtms.Common" %>

<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=no" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <title>指定快递管理</title>
    <link href="../../../scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
    <link href="../../skin/default/style.css" rel="stylesheet" type="text/css" />
    <link href="../../../css/pagination.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript" src="../../../scripts/jquery/jquery-1.11.2.min.js"></script>
    <script type="text/javascript" src="../../../scripts/artdialog/dialog-plus-min.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../js/laymain.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../js/common.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../../scripts/datepicker/WdatePicker.js"></script>
</head>

<body class="mainbody">
    <script type="text/javascript">
        $(function () {
            //点击右边单个删除连接
            $(".del_link").click(function () {
                $(this).parents().find(".checkall input[type='checkbox']").prop("checked", false);
                $(this).parent().parent().find(".checkall input[type='checkbox']").prop("checked", true);
                return jsConfirm($(this), '你确定要删除吗？<br /><br />注：还没单号的订单会退还金额，已有单号的仅删除。<br />tips：左上角的删除按钮可批量删除，均不退还金额。');
            });
            //表格点击显示下一隐藏列
            $(".msg-tr").click(function () {
                $(this).next().addClass("odd_bg").toggle();
            });
        });
    </script>
    <script type="text/javascript">
        function ExportOption() {
            var content = $("#export_msg");
            var d = dialog({
                title: '导出订购信息',
                content: content,
                okValue: "导出Excel",
                ok: function () {
                    var value = {
                        com_name_val: get_DropDownList_Value("#com_name"),
                        export_has_num_val: get_RadioButtonList_Value("#export_has_num"),
                        export_date_option_val:get_RadioButtonList_Value("#export_date_option"),
                        begin_date_val: $("#begin_date").val(),
                        end_date_val: $("#end_date").val(),
                        export_cols_option_val: get_CheckBoxList_Values("#export_cols_option")
                    };
                    d.close(value).remove();
                },
                cancelValue: '关闭取消',
                cancel: function () {
                    d.close().remove();
                }
            });
            d.addEventListener('close', function () {
                if (this.returnValue != '') {
                    $("#order_type_value").val('<%=this.order_type%>');
                    $("#com_name_value").val(this.returnValue.com_name_val);
                    $("#export_has_num_value").val(this.returnValue.export_has_num_val);
                    $("#export_date_option_value").val(this.returnValue.export_date_option_val);
                    $("#begin_date_value").val(this.returnValue.begin_date_val);
                    $("#end_date_value").val(this.returnValue.end_date_val);
                    $("#export_cols_option_value").val(this.returnValue.export_cols_option_val);
                    __doPostBack("btnExport", '');
                }
            });
            d.width(780).showModal();
            return false;
        }

        function get_DropDownList_Value(obj) {
            return $(obj).val();
        }
        function get_RadioButtonList_Value(obj) {
            return $(obj).find(':checked').val();
        }
        function get_CheckBoxList_Values(obj) {
            var values = "";
            $(obj).find(':checked').each(function () {
                if ($(this).val()) {
                    values += $(this).val() + ",";
                }
            });
            return values.substr(0, values.length - 1);
        }
    </script>
    <form id="form1" runat="server">
        <!--导航栏-->
        <div class="location">
            <a href="javascript:history.back(-1);" class="back"><i></i><span>返回上一页</span></a>
            <a href="../center.aspx" class="home"><i></i><span>首页</span></a>
            <i class="arrow"></i>
            <span>应用管理</span>
            <i class="arrow"></i>
            <span>指定快递管理</span>
        </div>
        <!--/导航栏-->

        <!--工具栏-->
        <div id="floatHead" class="toolbar-wrap">
            <div class="toolbar">
                <div class="box-wrap">
                    <a class="menu-btn"></a>
                    <div class="l-list">
                        <ul class="icon-list">
                            <li><a class="all" href="javascript:;" onclick="checkAll(this);"><i></i><span>全选</span></a></li>
                            <li>
                                <asp:LinkButton ID="btnDelete" runat="server" CssClass="del" OnClientClick="return ExePostBack('btnDelete','你确定要删除吗？<br /><br />注：本项删除不退还订单金额，如需退还请点击订单右边的删除连接！');" OnClick="btnDelete_Click"><i></i><span>删除</span></asp:LinkButton></li>
                            <li>
                                <asp:LinkButton ID="btnExport" runat="server" CssClass="save" OnClientClick="return ExportOption();" OnClick="btnExport_Click"><i></i><span>导出订购信息</span></asp:LinkButton></li>
                        </ul>
                        <div class="menu-list">
                            <div class="rule-single-select">
                                <asp:DropDownList ID="ddlStatus" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlStatus_SelectedIndexChanged">
                                    <asp:ListItem Selected="True" Value="0">任务状态筛选</asp:ListItem>
                                    <asp:ListItem Value="1">已发货</asp:ListItem>
                                    <asp:ListItem Value="2">未发货</asp:ListItem>
                                </asp:DropDownList>
                            </div>
                        </div>
                    </div>
                    <div class="r-list">
                        <div class="menu-list">
                            <div class="rule-single-select">
                                <asp:DropDownList ID="ddlSearchType" runat="server">
                                    <asp:ListItem Selected="True" Value="">查找类型</asp:ListItem>
                                    <asp:ListItem Value="1">按快递公司查找</asp:ListItem>
                                    <asp:ListItem Value="2">按快递单号查找</asp:ListItem>
                                    <asp:ListItem Value="3">按任务编号查找</asp:ListItem>
                                    <asp:ListItem Value="4">按购买人查找</asp:ListItem>
                                </asp:DropDownList>
                            </div>
                        </div>
                        <asp:TextBox ID="txtKeywords" runat="server" CssClass="keyword" />
                        <asp:LinkButton ID="lbtnSearch" runat="server" CssClass="btn-search" OnClick="btnSearch_Click">查询</asp:LinkButton>
                    </div>
                </div>
            </div>
        </div>
        <!--/工具栏-->

        <!--导出选项-->
        <asp:Hiddenfield ID="order_type_value" Value="1" runat="server" />
        <asp:HiddenField ID="com_name_value" Value="" runat="server" />
        <asp:HiddenField ID="export_has_num_value" Value="" runat="server" />
        <asp:HiddenField ID="export_date_option_value" Value="" runat="server" />
        <asp:HiddenField ID="begin_date_value" Value="" runat="server" />
        <asp:HiddenField ID="end_date_value" Value="" runat="server" />
        <asp:HiddenField ID="export_cols_option_value" Value="" runat="server" />
        <asp:HiddenField ID="hidden_order_type" Value="" runat="server" />

        <div id="export_msg" style="display: none;">
            <div class="tab-content">
                <dl>
                    <dt>快递类型</dt>
                    <dd>
                        <div class="rule-single-select">
                            <asp:DropDownList ID="com_name" runat="server" CssClass="select"></asp:DropDownList>
                        </div>
                    </dd>
                </dl>
                <dl>
                    <dt>是否有单号</dt>
                    <dd>
                        <div class="rule-multi-radio">
                            <asp:RadioButtonList ID="export_has_num" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow">
                                <asp:ListItem Value="0">有单号</asp:ListItem>
                                <asp:ListItem Value="1" Selected="True">没单号</asp:ListItem>
                                <asp:ListItem Value="2">不限</asp:ListItem>
                            </asp:RadioButtonList>
                        </div>
                    </dd>
                </dl>

                <dl>
                    <dt>订购时间</dt>
                    <dd>
                        <div class="rule-multi-radio">
                            <asp:RadioButtonList ID="export_date_option" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow">
                                <asp:ListItem Value="0" Selected="True">今天</asp:ListItem>
                                <asp:ListItem Value="1">昨天</asp:ListItem>
                                <asp:ListItem Value="2">自定义时间</asp:ListItem>
                            </asp:RadioButtonList>
                        </div>
                    </dd>
                </dl>
                <dl>
                    <dt>自定义时间</dt>
                    <dd>从
                        <asp:TextBox ID="begin_date" runat="server" CssClass="input rule-date-input" onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss'})" datatype="/^\s*$|^\d{4}\-\d{1,2}\-\d{1,2}\s+\d{1,2}:\d{1,2}:\d{1,2}$/" errormsg="请选择正确的日期" sucmsg=" " />
                        至
                        <asp:TextBox ID="end_date" runat="server" CssClass="input rule-date-input" onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss'})" datatype="/^\s*$|^\d{4}\-\d{1,2}\-\d{1,2}\s+\d{1,2}:\d{1,2}:\d{1,2}$/" errormsg="请选择正确的日期" sucmsg=" " />
                    </dd>

                </dl>
                <dl>
                    <dt>导出项目</dt>
                    <dd>
                        <div class="rule-multi-checkbox">
                            <asp:CheckBoxList ID="export_cols_option" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow">
                                <asp:ListItem Value="0">全部</asp:ListItem>
                                <asp:ListItem Value="1" Selected="True">快递公司</asp:ListItem>
                                <asp:ListItem Value="2">快递单号</asp:ListItem>
                                <asp:ListItem Value="3" Selected="True">订购人</asp:ListItem>
                                <asp:ListItem Value="4">订购时间</asp:ListItem>
                                <asp:ListItem Value="5" Selected="True">发货地</asp:ListItem>
                                <asp:ListItem Value="6" Selected="True">收货地信息</asp:ListItem>
                            </asp:CheckBoxList>
                        </div>
                    </dd>
                </dl>
            </div>
        </div>
        <!--/导出选项-->

        <!--列表-->
        <script type="text/javascript">
            function WirtKuaidiNum(obj) {
                var w_id = $(obj).attr("target-id")
                var content = '填写快递单号：&nbsp;&nbsp;<input type="text" id="new_kuaidi_num_input" class="input txt" /><br />';
                content += '发送快递的时间：&nbsp;&nbsp;<input name="new_scan_date_input" id="new_scan_date_input" type="text" class="input rule-date-input" maxlength="30" onfocus="WdatePicker({dateFmt:\'yyyy-MM-dd HH:mm:ss\'});" nullmsg=" " sucmsg=" " /><br /><br />';
                content += '<input type="checkbox" id="is_phone_msg_input"class="checkbox" />&nbsp;&nbsp;<label for="is_phone_msg_input">是否发手机短信通知</label><br />';
                content += '<input type="checkbox" id="is_site_msg_input" class="checkbox" />&nbsp;&nbsp;<label for="is_site_msg_input">是否发送站内信通知</label><br />';
                var d = dialog({
                    title: '请填写快递单号',
                    content: content,
                    okValue: "确定",
                    ok: function () {
                        if ($("#new_kuaidi_num_input").val() == '' || $("#new_scan_date_input").val() == '') {
                            var dd = dialog({ content: '请先填写快递单号和发货时间' }).show();
                            setTimeout(function () {
                                dd.close().remove();
                            }, 2000);
                            return false;
                        }
                        var value = {
                            new_kuaidi_num: $("#new_kuaidi_num_input").val(),
                            new_scan_date: $("#new_scan_date_input").val(),
                            is_phone_msg: $("#is_phone_msg_input").prop("checked"),
                            is_site_msg: $("#is_site_msg_input").prop("checked"),
                            w_id: w_id
                        };
                        d.close(value).remove();
                    },
                    cancelValue: '取消',
                    cancel: function () {
                        d.close().remove();
                    }
                });
                d.addEventListener('close', function () {
                    if (this.returnValue != '') {
                        $("#new_kuaidi_num").val(this.returnValue.new_kuaidi_num);
                        $("#new_scan_date").val(this.returnValue.new_scan_date);
                        $("#is_phone_msg").val(this.returnValue.is_phone_msg);
                        $("#is_site_msg").val(this.returnValue.is_site_msg);
                        $("#w_id").val(this.returnValue.w_id);
                        __doPostBack("link_btn_wirte_kuaidi_num", '');
                    }
                });
                d.showModal();
                return false;
            }
        </script>
        <div class="table-container">
            <asp:HiddenField ID="new_kuaidi_num" Value="" runat="server" />
            <asp:HiddenField ID="new_scan_date" Value="" runat="server" />
            <asp:HiddenField ID="is_phone_msg" Value="" runat="server" />
            <asp:HiddenField ID="is_site_msg" Value="" runat="server" />
            <asp:HiddenField ID="w_id" Value="" runat="server" />
            <div style="display: none">
                <asp:LinkButton ID="link_btn_wirte_kuaidi_num" runat="server" CssClass="del_link" OnClick="WriteKuaidiNum_Click">删除</asp:LinkButton>
            </div>

            <asp:Repeater ID="rptList" runat="server">
                <HeaderTemplate>
                    <table width="100%" border="0" cellspacing="0" cellpadding="0" class="ltable">
                        <tr>
                            <th align="center" width="5%">选择</th>
                            <th align="center" width="5%">ID号</th>
                            <th align="center" width="12%">任务编号</th>
                            <th align="center" width="">快递公司</th>
                            <th align="center" width="12%">快递单号</th>
                            <th align="center" width="13%">发快递时间</th>
                            <th align="center" width="12%">订购人用户名</th>
                            <th align="center" width="12%">订购时间</th>
                            <th align="center" width="8%">价格/点</th>
                            <th align="center" width="8%">操作</th>
                        </tr>
                </HeaderTemplate>
                <ItemTemplate>
                    <tr class="msg-tr">
                        <td align="center">
                            <asp:CheckBox ID="chkId" CssClass="checkall" runat="server" Style="vertical-align: middle;" />
                            <asp:HiddenField ID="hidId" Value='<%#Eval("id")%>' runat="server" />
                        </td>
                        <td align="center"><%#Eval("id")%></td>
                        <td align="center"><%#Eval("task_no")%></td>
                        <td align="center"><%#Eval("com_name")%></td>
                        <td align="center"><%#Get_kuaidi_num(Eval("kuaidi_num"),Eval("id"))%></td>
                        <td align="center"><%#Eval("scan_date")%></td>
                        <td align="center"><%#Eval("buy_user_name")%></td>
                        <td align="center"><%#Eval("add_date")%></td>
                        <td align="center"><%#Eval("money","{0:F2}")%>&nbsp;元</td>
                        <td align="center"><a  href="express_buy_detail2.aspx?action=<%=BSEnums.ActionEnum.Edit %>&id=<%#Eval("id")%>">修改</a> |
                            <asp:LinkButton ID="btnDelete_Right" runat="server" CssClass="del_link" OnClick="btnDelete_Right_Click"><i></i><span>删除</span></asp:LinkButton></td>
                    </tr>
                    <tr style="display: none;">
                        <td colspan="10" align="center">发货地：<%#Eval("fh_city").ToString()%> &nbsp; &nbsp; 
                          发货人：<%#Eval("fh_user_name")%> &nbsp; &nbsp; 
                          发货人电话：<%#Eval("fh_mobile")%> &nbsp; &nbsp; 
                          收货地：<%#Eval("md_city")%> &nbsp; &nbsp; 
                          订购时间：<%#Eval("add_date")%>
                        </td>
                    </tr>
                </ItemTemplate>
                <FooterTemplate>
                    <%#rptList.Items.Count == 0 ? "<tr><td align=\"center\" colspan=\"10\">暂无记录</td></tr>" : ""%>
                    </table>
                </FooterTemplate>
            </asp:Repeater>
        </div>
        <!--/列表-->
        <div class="line10"></div>

        <!--内容底部-->
        <div class="line10"></div>
        <div class="pagelist">
            <div class="l-btns">
                <span>显示</span><asp:TextBox ID="txtPageNum" runat="server" CssClass="pagenum" onkeydown="return checkNumber(event);"
                    OnTextChanged="txtPageNum_TextChanged" AutoPostBack="True"></asp:TextBox><span>条/页</span>
            </div>
            <div id="PageContent" runat="server" class="default"></div>
        </div>
        <!--/内容底部-->

    </form>
</body>
</html>
