﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="express_deliver_addr_list.aspx.cs" Inherits="SKtms.Web.admin.plugins.express.express_deliver_addr_list" %>

<%@ Import Namespace="SKtms.Common" %>

<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=no" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <title>快递发货地址管理</title>
    <link href="../../../scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
    <link href="../../skin/default/style.css" rel="stylesheet" type="text/css" />
    <link href="../../../css/pagination.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript" src="../../../scripts/jquery/jquery-1.11.2.min.js"></script>
    <script type="text/javascript" src="../../../scripts/artdialog/dialog-plus-min.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../js/laymain.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../js/common.js"></script>
</head>

<body class="mainbody">
    <form id="form1" runat="server">
        <!--导航栏-->
        <div class="location">
            <a href="javascript:history.back(-1);" class="back"><i></i><span>返回上一页</span></a>
            <a href="../center.aspx" class="home"><i></i><span>首页</span></a>
            <i class="arrow"></i>
            <span>应用管理</span>
            <i class="arrow"></i>
            <span>发货地址管理</span>
        </div>
        <!--/导航栏-->

        <!--工具栏-->
        <div id="floatHead" class="toolbar-wrap">
            <div class="toolbar">
                <div class="box-wrap">
                    <a class="menu-btn"></a>
                    <div class="l-list">
                        <ul class="icon-list">
                            <li><a class="all" href="javascript:;" onclick="checkAll(this);"><i></i><span>全选</span></a></li>
                            <li>
                                <asp:LinkButton ID="btnDelete" runat="server" CssClass="del" OnClientClick="return ExePostBack('btnDelete','你确定要删除吗？');" OnClick="btnDelete_Click"><i></i><span>删除</span></asp:LinkButton></li>
                        </ul>
                    </div>
                    <div class="r-list">
                        <asp:TextBox ID="txtKeywords" runat="server" CssClass="keyword" />
                        <asp:LinkButton ID="lbtnSearch" runat="server" CssClass="btn-search" OnClick="btnSearch_Click">查询</asp:LinkButton>
                    </div>
                </div>
            </div>
        </div>
        <!--/工具栏-->
        
        <!--列表-->
        <div class="table-container">
            <asp:Repeater ID="rptList" runat="server">
                <HeaderTemplate>
                    <table width="100%" border="0" cellspacing="0" cellpadding="0" class="ltable">
                        <tr>
                            <th align="center" width="5%">选择</th>
                            <th align="center" width="5%">ID号</th>
                            <th align="center" width="10%">用户名</th>
                            <th align="center" width="">快递公司</th>
                            <th align="center" width="23%">发货详细地址</th>
                            <th align="center" width="8%">发货人姓名</th>
                            <th align="center" width="9%">发货人电话</th>
                            <th align="center" width="10%">包裹名/重量</th>
                            <th align="center" width="6%">是否默认</th>
                            <th align="center" width="10%">添加时间</th>
                        </tr>
                </HeaderTemplate>
                <ItemTemplate>
                    <tr class="msg-tr">
                        <td align="center">
                            <asp:CheckBox ID="chkId" CssClass="checkall" runat="server" Style="vertical-align: middle;" />
                            <asp:HiddenField ID="hidId" Value='<%#Eval("id")%>' runat="server" />
                        </td>
                        <td align="center"><%#Eval("id")%></td>
                        <td align="center"><a href="?search_type=2&keywords=<%#Eval("user_id")%>" title="查看该用户"><%#Eval("user_name")%></a></td>
                        <td align="center"><a href="?search_type=1&keywords=<%#Eval("kuaidi_id")%>" title="查看该公司"><%#GetKuaidiTitle(Utils.ObjToInt(Eval("kuaidi_id")))%></a></td>
                        <td align="center"><%#Eval("province")%> <%#Eval("city")%> <%#Eval("area")%> <%#Eval("address")%></td>
                        <td align="center"><%#Eval("nick_name")%></td>
                        <td align="center"><%#Eval("mobile")%></td>
                        <td align="center"><%#Eval("package_name")%> / <%#Eval("kg")%> kg</td>
                        <td align="center"><%#Eval("is_default").ToString()=="1"?"<span class=red>是</span>" : "否"%></td>
                        <td align="center"><%#Eval("add_date")%></td>
                    </tr>
                </ItemTemplate>
                <FooterTemplate>
                    <%#rptList.Items.Count == 0 ? "<tr><td align=\"center\" colspan=\"10\">暂无记录</td></tr>" : ""%>
                    </table>
                </FooterTemplate>
            </asp:Repeater>
        </div>
        <!--/列表-->
        <div class="line10"></div>

        <!--内容底部-->
        <div class="line10"></div>
        <div class="pagelist">
            <div class="l-btns">
                <span>显示</span><asp:TextBox ID="txtPageNum" runat="server" CssClass="pagenum" onkeydown="return checkNumber(event);"
                    OnTextChanged="txtPageNum_TextChanged" AutoPostBack="True"></asp:TextBox><span>条/页</span>
            </div>
            <div id="PageContent" runat="server" class="default"></div>
        </div>
        <!--/内容底部-->

    </form>
</body>
</html>
