﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="express_lq_list.aspx.cs" Inherits="SKtms.Web.admin.plugins.express.express_lq_list" %>

<%@ Import Namespace="SKtms.Common" %>

<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=no" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <title>领取快递管理</title>
    <link href="../../../scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
    <link href="../../skin/default/style.css" rel="stylesheet" type="text/css" />
    <link href="../../../css/pagination.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript" src="../../../scripts/jquery/jquery-1.11.2.min.js"></script>
    <script type="text/javascript" src="../../../scripts/artdialog/dialog-plus-min.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../js/laymain.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../js/common.js"></script>
</head>

<body class="mainbody">
    <script type="text/javascript">
        $(function () {
            //点击右边单个删除连接
            $(".del_link").click(function () {
                $(this).parents().find(".checkall input[type='checkbox']").prop("checked", false);
                $(this).parent().parent().find(".checkall input[type='checkbox']").prop("checked", true);
                return jsConfirm($(this), '你确定要删除吗？');
            });
            //表格点击显示下一隐藏列
            $(".msg-tr").click(function () {
                $(this).next().addClass("odd_bg").toggle();
            });
        });
    </script>
    <form id="form1" runat="server">
        <!--导航栏-->
        <div class="location">
            <a href="javascript:history.back(-1);" class="back"><i></i><span>返回上一页</span></a>
            <a href="../center.aspx" class="home"><i></i><span>首页</span></a>
            <i class="arrow"></i>
            <span>应用管理</span>
            <i class="arrow"></i>
            <span>领取快递管理</span>
        </div>
        <!--/导航栏-->

        <!--工具栏-->
        <div id="floatHead" class="toolbar-wrap">
            <div class="toolbar">
                <div class="box-wrap">
                    <a class="menu-btn"></a>
                    <div class="l-list">
                        <ul class="icon-list">
                            <li><a class="all" href="javascript:;" onclick="checkAll(this);"><i></i><span>全选</span></a></li>
                            <li><a class="link" href="express_lq_detail.aspx?action=<%=BSEnums.ActionEnum.Add.ToString() %>"><i></i><span>添加快递单</span></a></li>
                            <li><a class="link" href="express_lq_add_list.aspx?action=<%=BSEnums.ActionEnum.Add.ToString() %>"><i></i><span>批量添加快递单</span></a></li>
                            <li>
                                <asp:LinkButton ID="btnDelete" runat="server" CssClass="del" OnClientClick="return ExePostBack('btnDelete','你确定要批量删除吗？');" OnClick="btnDelete_Click"><i></i><span>批量删除</span></asp:LinkButton></li>
                        </ul>
                        <div class="menu-list">
                            <div class="rule-single-select">
                                <asp:DropDownList ID="ddlStatus" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlStatus_SelectedIndexChanged">
                                    <asp:ListItem Selected="True" Value="0">任务状态筛选</asp:ListItem>
                                    <asp:ListItem Value="1">未使用</asp:ListItem>
                                    <asp:ListItem Value="2">已领取</asp:ListItem>
                                    <asp:ListItem Value="3">已停用</asp:ListItem>
                                </asp:DropDownList>
                            </div>
                        </div>
                    </div>
                    <div class="r-list">
                        <div class="menu-list">
                            <div class="rule-single-select">
                                <asp:DropDownList ID="ddlSearchType" runat="server">
                                    <asp:ListItem Selected="True" Value="">查找类型</asp:ListItem>
                                    <asp:ListItem Value="1">按快递公司查找</asp:ListItem>
                                    <asp:ListItem Value="2">按快递单号查找</asp:ListItem>
                                    <asp:ListItem Value="3">按任务编号查找</asp:ListItem>
                                    <asp:ListItem Value="4">按购买人查找</asp:ListItem>
                                </asp:DropDownList>
                            </div>
                        </div>
                        <asp:TextBox ID="txtKeywords" runat="server" CssClass="keyword" />
                        <asp:LinkButton ID="lbtnSearch" runat="server" CssClass="btn-search" OnClick="btnSearch_Click">查询</asp:LinkButton>
                    </div>
                </div>
            </div>
        </div>
        <!--/工具栏-->

        <!--列表-->
        <div class="table-container">
            <asp:Repeater ID="rptList" runat="server">
                <HeaderTemplate>
                    <table width="100%" border="0" cellspacing="0" cellpadding="0" class="ltable">
                        <tr>
                            <th align="center" width="5%">选择</th>
                            <th align="center" width="5%">ID号</th>
                            <th align="center" width="10%">快递公司</th>
                            <th align="center" width="15%">快递单号</th>
                            <th align="center" width="10%">预计扫描日期</th>
                            <th align="center" width="5%">是否扫描</th>
                            <th align="center" width="10%">任务编号</th>
                            <th align="center" width="10%">购买人用户名</th>
                            <th align="center" width="10%">购买时间</th>
                            <th align="center" width="10%">状态</th>
                            <th align="center" width="10%">操作</th>
                        </tr>
                </HeaderTemplate>
                <ItemTemplate>
                    <tr class="msg-tr">
                        <td align="center">
                            <asp:CheckBox ID="chkId" CssClass="checkall" runat="server" Style="vertical-align: middle;" />
                            <asp:HiddenField ID="hidId" Value='<%#Eval("id")%>' runat="server" />
                        </td>
                        <td align="center"><%#Eval("id")%></td>
                        <td align="center"><a href="express_lq_list.aspx?keywords=<%#Eval("com_name")%>&search_type=1" title="查看该快递公司"><%#Eval("com_name")%></a></td>
                        <td align="center"><%#Eval("kuaidi_num")%></td>
                        <td align="center"><%#Eval("scan_date")%></td>
                        <td align="center"><%#DateTime.Compare(DateTime.Now,Utils.ObjectToDateTime(Eval("scan_date")))>0 ? "<span class=\"red\">已扫描</span>" : "未扫描"%></td>
                        <td align="center"><%#Eval("task_no")%></td>
                        <td align="center"><%#Eval("buy_user_name")%></td>
                        <td align="center"><%#Eval("buy_date")%></td>
                        <td align="center"><%#GetStatusInfo(Utils.ObjToInt(Eval("id"),0))%></td>
                        <td align="center"><a href="express_lq_detail.aspx?action=<%=BSEnums.ActionEnum.Edit.ToString()%>&id=<%#Eval("id")%>">修改</a> |
                            <asp:LinkButton ID="btnDelete_Right" runat="server" CssClass="del_link" OnClick="btnDelete_Right_Click"><i></i><span>删除</span></asp:LinkButton></td>
                    </tr>
                    <tr style="display: none">
                        <td colspan="11" align="center">
                          发货地址：<%#Eval("fh_city").ToString()%>&nbsp; &nbsp;
                          收货地址：<%#Eval("md_city")%>&nbsp; &nbsp;
                          收货人：<%#Eval("sh_user_name")%>&nbsp; &nbsp;
                          电话：<%#Eval("mobile")%>&nbsp; &nbsp;
                          添加时间：<%#Eval("add_date")%>&nbsp; &nbsp;
                        </td>
                    </tr>
                </ItemTemplate>
                <FooterTemplate>
                    <%#rptList.Items.Count == 0 ? "<tr><td align=\"center\" colspan=\"11\">暂无记录</td></tr>" : ""%>
                    </table>
                </FooterTemplate>
            </asp:Repeater>
        </div>
        <!--/列表-->
        <div class="line10"></div>

        <!--内容底部-->
        <div class="line10"></div>
        <div class="pagelist">
            <div class="l-btns">
                <span>显示</span><asp:TextBox ID="txtPageNum" runat="server" CssClass="pagenum" onkeydown="return checkNumber(event);"
                    OnTextChanged="txtPageNum_TextChanged" AutoPostBack="True"></asp:TextBox><span>条/页</span>
            </div>
            <div id="PageContent" runat="server" class="default"></div>
        </div>
        <!--/内容底部-->

    </form>
</body>
</html>
