﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="express_name_list.aspx.cs" Inherits="SKtms.Web.admin.plugins.express.express_name_list" %>
<%@ Import namespace="SKtms.Common" %>

<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=no" />
<meta name="apple-mobile-web-app-capable" content="yes" />
<title>空包货源数据</title>
<link href="../../../scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
<link href="../../skin/default/style.css" rel="stylesheet" type="text/css" />
<link href="../../../css/pagination.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" charset="utf-8" src="../../../scripts/jquery/jquery-1.11.2.min.js"></script>
<script type="text/javascript" charset="utf-8" src="../../../scripts/artdialog/dialog-plus-min.js"></script>
<script type="text/javascript" charset="utf-8" src="../../js/laymain.js"></script>
<script type="text/javascript" charset="utf-8" src="../../js/common.js"></script>
</head>

<body class="mainbody">
<form id="form1" runat="server">
<!--导航栏-->
<div class="location">
  <a href="javascript:history.back(-1);" class="back"><i></i><span>返回上一页</span></a>
  <a href="../center.aspx" class="home"><i></i><span>首页</span></a>
  <i class="arrow"></i>
  <span>应用管理</span>
  <i class="arrow"></i>
  <span>空包货源数据</span>
</div>
<!--/导航栏-->

<!--工具栏-->
<div id="floatHead" class="toolbar-wrap">
  <div class="toolbar">
    <div class="box-wrap">
      <a class="menu-btn"></a>
      <div class="l-list">
        <ul class="icon-list">
          <li><a class="add" href="express_name_edit.aspx?action=<%=BSEnums.ActionEnum.Add %>"><i></i><span>新增</span></a></li>
          <li><asp:LinkButton ID="btnSave" runat="server" CssClass="save" onclick="btnSave_Click" title="保存排序"><i></i><span>保存</span></asp:LinkButton></li>
          <li><a class="all" href="javascript:;" onclick="checkAll(this);"><i></i><span>全选</span></a></li>
          <li><asp:LinkButton ID="btnDelete" runat="server" CssClass="del" OnClientClick="return ExePostBack('btnDelete');" onclick="btnDelete_Click"><i></i><span>删除</span></asp:LinkButton></li>
        </ul>
        <div class="menu-list">
            <div class="rule-single-select">
                <asp:DropDownList ID="ddlApiID" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlApiID_SelectedIndexChanged">
                    <asp:ListItem Value="0" Selected="True">所有进货渠道</asp:ListItem>
                    <asp:ListItem Value="1">自己进出货</asp:ListItem>
                    <asp:ListItem Value="2">空包货源网</asp:ListItem>
                    <asp:ListItem Value="3">站长空包网</asp:ListItem>
                </asp:DropDownList>
            </div>
        </div>
        <%if (config != null && config.api_id > 1) {%>
        <div class="menu-list orange" style="display:inline-block; width:35%; margin:0 auto; text-align:center;">
            <asp:Button ID="btnOnkeyUpdate" runat="server" Text="一键同步更新官网快递数据" title="只更新当前进货渠道接口数据" CssClass="btn green" OnClick="btnOnkeyUpdate_Click" OnClientClick="return confirm('您确定要更新吗？')" />
            <a href="express_price_config.aspx"><span class="orange">如有更新，点我重新设置一次各会员组价格</span></a>
        </div>
        <% } %>
      </div>
      <div class="r-list">
        <asp:TextBox ID="txtKeywords" runat="server" CssClass="keyword" />
        <asp:LinkButton ID="lbtnSearch" runat="server" CssClass="btn-search" onclick="btnSearch_Click">查询</asp:LinkButton>
      </div>
    </div>
  </div>
</div>
<!--/工具栏-->

<!--列表-->
<div class="table-container">
<asp:Repeater ID="rptList" runat="server">
<HeaderTemplate>
<table width="100%" border="0" cellspacing="0" cellpadding="0" class="ltable">
  <tr>
    <th width="5%">选择</th>
    <th width="6%">ID号</th>
    <th width="10%">进货渠道</th>
    <th>快递名称</th>
    <th width="10%">调用ID/别名</th>
    <th width="10%">物流编码</th>
    <th width="8%">成本价</th>
    <th width="13%">更新时间</th>
    <th width="8%">排序</th>
    <th width="6%">状态</th>
    <th width="7%">操作</th>
  </tr>
</HeaderTemplate>
<ItemTemplate>
  <tr>
    <td align="center">
      <asp:CheckBox ID="chkId" CssClass="checkall" runat="server" style="vertical-align:middle;" />
      <asp:HiddenField ID="hidId" Value='<%#Eval("id")%>' runat="server" />
    </td>
    <td align="center"><%#Eval("id")%></td>
    <td align="center"><a href="express_name_list.aspx?api_id=<%#Eval("api_id")%>"><%#GetApiSiteName(Utils.ObjToInt(Eval("api_id")))%></a></td>
    <td align="center"><a href="express_name_edit.aspx?action=<%#BSEnums.ActionEnum.Edit %>&id=<%#Eval("id")%>"><%#Eval("title")%></a></td>
    <td align="center"><%#Eval("call_index")%></td>
    <td align="center"><%#Eval("express_code")%></td>
    <td align="center"><%#Eval("express_fee")%> 元</td>
    <td align="center"><%#Eval("update_time")%></td>
    <td align="center"><asp:TextBox ID="txtSortId" runat="server" Text='<%#Eval("sort_id")%>' CssClass="sort" onkeydown="return checkNumber(event);" /></td>
    <td align="center"><%#Convert.ToInt32(Eval("is_lock")) == 1 ? "<span class='red'>已下架</span>" : "在线"%></td>
    <td align="center"><a href="express_name_edit.aspx?action=<%#BSEnums.ActionEnum.Edit %>&id=<%#Eval("id")%>">修改</a></td>
  </tr>
</ItemTemplate>
<FooterTemplate>
  <%#rptList.Items.Count == 0 ? "<tr><td align=\"center\" colspan=\"11\">暂无记录</td></tr>" : ""%>
</table>
</FooterTemplate>
</asp:Repeater>
</div>
<!--/列表-->

<!--内容底部-->
<div class="line20"></div>
<div class="pagelist">
  <div class="l-btns">
    <span>显示</span><asp:TextBox ID="txtPageNum" runat="server" CssClass="pagenum" onkeydown="return checkNumber(event);"
                OnTextChanged="txtPageNum_TextChanged" AutoPostBack="True"></asp:TextBox><span>条/页</span>
  </div>
  <div id="PageContent" runat="server" class="default"></div>
</div>
<!--/内容底部-->

</form>

<div class="line10"></div>
<asp:Literal ID="Tips" runat="server"></asp:Literal>
</body>
</html>
