﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="express_num_add_list.aspx.cs" Inherits="SKtms.Web.admin.plugins.express.express_num_add_list" ValidateRequest="false" %>

<%@ Import Namespace="SKtms.Common" %>
<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=no" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <title>添加/编辑空包快递单</title>
    <link href="../../../scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
    <link href="../../skin/default/style.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript" charset="utf-8" src="../../../scripts/jquery/jquery-1.11.2.min.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../../scripts/jquery/Validform_v5.3.2_min.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../../scripts/datepicker/WdatePicker.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../../scripts/artdialog/dialog-plus-min.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../js/laymain.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../js/common.js"></script>
    <script type="text/javascript">
        $(function () {
            //初始化表单验证
            $("#form1").initValidform();
        });
    </script>
</head>

<body class="mainbody">
    <form id="form1" runat="server">
        <!--内容-->
        <div id="floatHead" class="content-tab-wrap">
            <div class="content-tab">
                <div class="content-tab-ul-wrap">
                    <ul>
                        <li><a class="selected" href="javascript:;">
                            <asp:Literal ID="head_title" runat="server"></asp:Literal></a></li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="tab-content">
            <dl>
                <dt>快递公司</dt>
                <dd>
                    <asp:DropDownList ID="com_name" runat="server" CssClass="select" datatype="*" errormsg="" sucmsg=" ">
                    </asp:DropDownList>
                    <span class="Validform_checktip"></span>
                </dd>
            </dl>
            <dl>
                <dt>快递单号</dt>
                <dd>
                    <asp:TextBox ID="kuaidi_num_list" runat="server" CssClass="input normal" TextMode="MultiLine" datatype="*" errormsg="" sucmsg=" " />
                    <span class="Validform_checktip"></span>
                </dd>
            </dl>
            <dl>
                <dt>初始状态设置</dt>
                <dd>
                    <div class="rule-single-select">
                        <asp:DropDownList ID="ddlStatus" runat="server" datatype="*" errormsg="" sucmsg=" ">
                            <asp:ListItem Value="0" Selected="True">未使用</asp:ListItem>
                            <asp:ListItem Value="1">已使用</asp:ListItem>
                        </asp:DropDownList>
                        <span class="Validform_checktip"></span>
                    </div>
                </dd>
            </dl>
            <dl>
                <dt>预计扫描时间</dt>
                <dd>
                    <asp:TextBox ID="scan_date" runat="server" CssClass="input rule-date-input" onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss'})" datatype="/^\s*$|^\d{4}\-\d{1,2}\-\d{1,2}\s+\d{1,2}:\d{1,2}:\d{1,2}$/" errormsg="请选择正确的日期" sucmsg=" " />
                    <span class="Validform_checktip"></span>
                </dd>
            </dl>

        </div>
        <!--/内容-->

        <!--工具栏-->
        <div class="page-footer">
            <div class="btn-wrap">
                <asp:Button ID="Button1" runat="server" Text="提交保存" CssClass="btn" OnClick="btnSubmit_Click" />
                <input name="btnReturn" type="button" value="返回上一页" class="btn yellow" onclick="javascript: history.back(-1);" />
            </div>
        </div>
        <!--/工具栏-->
    </form>
</body>
</html>
