﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="express_num_list.aspx.cs" Inherits="SKtms.Web.admin.plugins.express.express_num_list" %>

<%@ Import Namespace="SKtms.Common" %>

<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=no" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <title>导入快递单号</title>
    <link href="../../../scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
    <link href="../../skin/default/style.css" rel="stylesheet" type="text/css" />
    <link href="../../../css/pagination.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript" src="../../../scripts/jquery/jquery-1.11.2.min.js"></script>
    <script type="text/javascript" src="../../../scripts/artdialog/dialog-plus-min.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../js/laymain.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../js/common.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../../scripts/datepicker/WdatePicker.js"></script>
</head>

<body class="mainbody">
    <script type="text/javascript">
        $(function () {
            //点击右边单个删除连接
            $(".del_link").click(function () {
                $(this).parents().find(".checkall input[type='checkbox']").prop("checked", false);
                $(this).parent().parent().find(".checkall input[type='checkbox']").prop("checked", true);
                return jsConfirm($(this), '你确定要删除吗？<br />');
            });
            //表格点击显示下一隐藏列
            $(".msg-tr").click(function () {
                $(this).next().addClass("odd_bg").toggle();
            });
            //绑定是否已分配使用下拉框
            $(":radio[name='export_use_num']").click(function () {
                if ($(this).val() == '1') {
                    $("#td_name").html("发布时间");
                }
                else {
                    $("#td_name").html("订购时间");
                }
            });
        });
    </script>
    <script type="text/javascript">
        function ExportOption() {
            var content = $("#export_msg");
            var d = dialog({
                title: '导出快递单号',
                content: content,
                okValue: "导出Excel",
                ok: function () {
                    var value = {
                        com_name_val: get_DropDownList_Value("#com_name"),
                        export_use_num_val: get_RadioButtonList_Value("#export_use_num"),
                        export_date_option_val: get_RadioButtonList_Value("#export_date_option"),
                        begin_date_val: $("#begin_date").val(),
                        end_date_val: $("#end_date").val(),
                        export_cols_option_val: get_CheckBoxList_Values("#export_cols_option")
                    };
                    d.close(value).remove();
                },
                cancelValue: '关闭取消',
                cancel: function () {
                    d.close().remove();
                }
            });
            d.addEventListener('close', function () {
                if (this.returnValue != '') {
                    $("#com_name_value").val(this.returnValue.com_name_val);
                    $("#export_use_num_value").val(this.returnValue.export_use_num_val);
                    $("#export_date_option_value").val(this.returnValue.export_date_option_val);
                    $("#begin_date_value").val(this.returnValue.begin_date_val);
                    $("#end_date_value").val(this.returnValue.end_date_val);
                    $("#export_cols_option_value").val(this.returnValue.export_cols_option_val);
                    __doPostBack("btnExport", '');
                }
            });
            d.width(780).showModal();
            return false;
        }

        function get_DropDownList_Value(obj) {
            return $(obj).val();
        }
        function get_RadioButtonList_Value(obj) {
            return $(obj).find(':checked').val();
        }
        function get_CheckBoxList_Values(obj) {
            var values = "";
            $(obj).find(':checked').each(function () {
                if ($(this).val()) {
                    values += $(this).val() + ",";
                }
            });
            return values.substr(0, values.length - 1);
        }
    </script>
    <form id="form1" runat="server">
        <!--导航栏-->
        <div class="location">
            <a href="javascript:history.back(-1);" class="back"><i></i><span>返回上一页</span></a>
            <a href="../center.aspx" class="home"><i></i><span>首页</span></a>
            <i class="arrow"></i>
            <span>应用管理</span>
            <i class="arrow"></i>
            <span>导入快递单号</span>
        </div>
        <!--/导航栏-->

        <!--工具栏-->
        <div id="floatHead" class="toolbar-wrap">
            <div class="toolbar">
                <div class="box-wrap">
                    <a class="menu-btn"></a>
                    <div class="l-list">
                        <ul class="icon-list">
                            <li><a class="all" href="javascript:;" onclick="checkAll(this);"><i></i><span>全选</span></a></li>
                            <li><asp:LinkButton ID="btnDelete" runat="server" CssClass="del" OnClientClick="return ExePostBack('btnDelete','你确定要删除吗？');" OnClick="btnDelete_Click"><i></i><span>删除</span></asp:LinkButton></li>
                            <li><a class="link" href="express_num_add_list.aspx"><i></i><span>添加快递单号</span></a></li>
                            <li><asp:LinkButton ID="btnExport" runat="server" CssClass="save" OnClientClick="return ExportOption();" OnClick="btnExport_Click"><i></i><span>导出快递单号</span></asp:LinkButton></li>                            
                        </ul>
                        <div class="menu-list">
                            <div class="rule-single-select">
                                <asp:DropDownList ID="ddlStatus" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlStatus_SelectedIndexChanged">
                                    <asp:ListItem Selected="True" Value="0">任务状态筛选</asp:ListItem>
                                    <asp:ListItem Value="1">未使用</asp:ListItem>
                                    <asp:ListItem Value="2">已使用</asp:ListItem>
                                </asp:DropDownList>
                            </div>
                        </div>
                        <div class="menu-list orange" style="display:inline-block; padding:10px;">
                            <%=GetUsableKuaidiNum()%>
                        </div>
                    </div>
                    <div class="r-list">
                        <div class="menu-list">
                            <div class="rule-single-select">
                                <asp:DropDownList ID="ddlSearchType" runat="server">
                                    <asp:ListItem Selected="True" Value="">查找类型</asp:ListItem>
                                    <asp:ListItem Value="2">按快递单号查找</asp:ListItem>
                                    <asp:ListItem Value="3">按购买人查找</asp:ListItem>
                                </asp:DropDownList>
                            </div>
                        </div>
                        <asp:TextBox ID="txtKeywords" runat="server" CssClass="keyword" />
                        <asp:LinkButton ID="lbtnSearch" runat="server" CssClass="btn-search" OnClick="btnSearch_Click">查询</asp:LinkButton>
                    </div>
                </div>
            </div>
        </div>
        <!--/工具栏-->

        <!--导出选项-->
        <asp:HiddenField ID="com_name_value" Value="" runat="server" />
        <asp:HiddenField ID="export_use_num_value" Value="" runat="server" />
        <asp:HiddenField ID="export_date_option_value" Value="" runat="server" />
        <asp:HiddenField ID="begin_date_value" Value="" runat="server" />
        <asp:HiddenField ID="end_date_value" Value="" runat="server" />
        <asp:HiddenField ID="export_cols_option_value" Value="" runat="server" />

        <div id="export_msg" style="display: none;">
            <div class="tab-content">
                <dl>
                    <dt>快递类型</dt>
                    <dd>
                        <div class="rule-single-select">
                            <asp:DropDownList ID="com_name" runat="server" CssClass="select"></asp:DropDownList>
                        </div>
                    </dd>
                </dl>
                <dl>
                    <dt>是否已分配使用</dt>
                    <dd>
                        <div class="rule-multi-radio">
                            <asp:RadioButtonList ID="export_use_num" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow">
                                <asp:ListItem Value="0" Selected="True">已使用</asp:ListItem>
                                <asp:ListItem Value="1">没使用</asp:ListItem>
                                <asp:ListItem Value="2">不限</asp:ListItem>
                            </asp:RadioButtonList>
                        </div>
                    </dd>
                </dl>

                <dl>
                    <dt><span id="td_name">订购时间</span></dt>
                    <dd>
                        <div class="rule-multi-radio">
                            <asp:RadioButtonList ID="export_date_option" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow">
                                <asp:ListItem Value="0" Selected="True">今天</asp:ListItem>
                                <asp:ListItem Value="1">昨天</asp:ListItem>
                                <asp:ListItem Value="2">自定义时间</asp:ListItem>
                            </asp:RadioButtonList>
                        </div>
                    </dd>
                </dl>
                <dl>
                    <dt>自定义时间</dt>
                    <dd>从
                        <asp:TextBox ID="begin_date" runat="server" CssClass="input rule-date-input" onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss'})" datatype="/^\s*$|^\d{4}\-\d{1,2}\-\d{1,2}\s+\d{1,2}:\d{1,2}:\d{1,2}$/" errormsg="请选择正确的日期" sucmsg=" " />
                        至
                        <asp:TextBox ID="end_date" runat="server" CssClass="input rule-date-input" onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss'})" datatype="/^\s*$|^\d{4}\-\d{1,2}\-\d{1,2}\s+\d{1,2}:\d{1,2}:\d{1,2}$/" errormsg="请选择正确的日期" sucmsg=" " />
                    </dd>

                </dl>
                <dl>
                    <dt>导出项目</dt>
                    <dd>
                        <div class="rule-multi-checkbox">
                            <asp:CheckBoxList ID="export_cols_option" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow">
                                <asp:ListItem Value="0">全部</asp:ListItem>
                                <asp:ListItem Value="1" Selected="True">快递公司</asp:ListItem>
                                <asp:ListItem Value="2" Selected="True">快递单号</asp:ListItem>
                                <asp:ListItem Value="3">订购人</asp:ListItem>
                                <asp:ListItem Value="4">订购时间</asp:ListItem>
                            </asp:CheckBoxList>
                        </div>
                    </dd>
                </dl>
            </div>
        </div>
        <!--/导出选项-->

        <!--列表-->
        <div class="table-container">
            <asp:Repeater ID="rptList" runat="server">
                <HeaderTemplate>
                    <table width="100%" border="0" cellspacing="0" cellpadding="0" class="ltable">
                        <tr>
                            <th align="center" width="5%">选择</th>
                            <th align="center" width="5%">ID号</th>
                            <th align="center" width="10%">快递公司</th>
                            <th align="center" width="15%">快递单号</th>
                            <th align="center" width="15%">预计扫描日期</th>
                            <th align="center" width="10%">是否使用</th>
                            <th align="center" width="10%">购买人</th>
                            <th align="center" width="10%">购买时间</th>
                            <th align="center" width="15%">操作</th>
                        </tr>
                </HeaderTemplate>
                <ItemTemplate>
                    <tr class="msg-tr">
                        <td align="center">
                            <asp:CheckBox ID="chkId" CssClass="checkall" runat="server" Style="vertical-align: middle;" />
                            <asp:HiddenField ID="hidId" Value='<%#Eval("id")%>' runat="server" />
                        </td>
                        <td align="center"><%#Eval("id")%></td>
                        <td align="center"><a href="express_num_list.aspx?kuaidi_id=<%#Eval("kuaidi_id")%>" title="查看该快递公司"><%#GetKuaidiTitle(Utils.ObjToInt(Eval("kuaidi_id")))%></a></td>
                        <td align="center"><a href="express_buy_list.aspx?keywords=<%#Eval("kuaidi_num")%>&search_type=2" title="查看订购人"><%#Eval("kuaidi_num")%></a></td>
                        <td align="center"><%#Eval("scan_date")%></td>
                        <td align="center"><%#Utils.ObjToInt(Eval("is_buy")) == 1 ? "是" :　"否"%></td>
                        <td align="center"><%#Eval("buy_user_name")%></td>
                        <td align="center"><%#Eval("buy_date")%></td>
                        <td align="center"><a href="express_num_add_list.aspx?id=<%#Eval("id")%>&action=<%=BSEnums.ActionEnum.Edit %>">修改</a> |
                            <asp:LinkButton ID="btnDelete_Right" runat="server" CssClass="del_link" OnClick="btnDelete_Right_Click"><i></i><span>删除</span></asp:LinkButton></td>
                    </tr>
                    <tr style="display: none">
                        <td colspan="9" align="center">
                          购买人IP：<%#Eval("buy_ip")%>&nbsp;&nbsp;
                          单号添加日期：<%#Eval("add_date")%>&nbsp;&nbsp;
                        </td>
                    </tr>
                </ItemTemplate>
                <FooterTemplate>
                    <%#rptList.Items.Count == 0 ? "<tr><td align=\"center\" colspan=\"9\">暂无记录</td></tr>" : ""%>
                    </table>
                </FooterTemplate>
            </asp:Repeater>
        </div>
        <!--/列表-->
        <div class="line10"></div>

        <!--内容底部-->
        <div class="line10"></div>
        <div class="pagelist">
            <div class="l-btns">
                <span>显示</span><asp:TextBox ID="txtPageNum" runat="server" CssClass="pagenum" onkeydown="return checkNumber(event);"
                    OnTextChanged="txtPageNum_TextChanged" AutoPostBack="True"></asp:TextBox><span>条/页</span>
            </div>
            <div id="PageContent" runat="server" class="default"></div>
        </div>
        <!--/内容底部-->

    </form>
    
<div class="line10"></div>
<div class="foot_del_bar">
    <div class="tips red">
        特别提醒： 导入空包快递单号只适用于“空包参数设置”页面中的快递单号进货渠道是“自己进出货”方式才有效；当用户订购空包时如果有预存单号会自动分配单号给用户，晚上再把单号导出上报给你的供货商即可。 
    </div>
</div>
</body>
</html>
