﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="express_price_config.aspx.cs" Inherits="SKtms.Web.admin.plugins.express.express_price_config" ValidateRequest="false" %>

<%@ Import Namespace="SKtms.Common" %>
<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=no" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <title>快递空包价格设置</title>
    <link href="../../../scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
    <link href="../../skin/default/style.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript" charset="utf-8" src="../../../scripts/jquery/jquery-1.11.2.min.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../../scripts/jquery/Validform_v5.3.2_min.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../../scripts/artdialog/dialog-plus-min.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../js/laymain.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../js/common.js"></script>
    <style type="text/css">
        .tab-content dl dt{ width:280px; }
	    .tab-content dl dd{ margin-left:300px; }
    </style>
    <script type="text/javascript">
        $(function () {
            $(".content-tab-ul-wrap>ul>li a").eq(0).addClass("selected");
            $(".tab-content").eq(0).show();
            $(".child-tab-content").eq(0).show();
            //初始化表单验证
            $("#form1").initValidform();
            //初始化子tab
            $(".child-tab-wrap").initChildTab();
            //绑定复制上一用户组设置按钮
            $(".tab-content .default").each(function () {
                $(this).bind("click", function () {
                    copyConfig('tab-content', $(this).attr("index"));
                });
            });
            //绑定复制上一频道组设置按钮
            $(".child-tab-content .green").each(function () {
                $(this).bind("click", function () {
                    copyConfig($(".tab-content").eq($(this).attr("parent_index")).find(".child-tab-content"), $(this).attr("index"));
                });
            });
            //绑定复制上一选项卡设置按钮
            //$(".child-tab-content .green").each(function () {
            //    $(this).bind("click", function () {
            //        copyConfig('child-tab-content', $(".child-tab-content .green").index(this));
            //    });
            //});
        });

        //批量修改价格
        function changePrice(obj, index) {
            if (typeof (obj) == "object") {
                var tabObj = obj;             //直接取传入的选项卡tab对象
            } else {
                var tabObj = $('.' + obj);    //根据选项卡tab的class名称取对象
            }
            var currObj = tabObj.eq(index);     //当前tab
            var stockPriceObj = currObj.find('input[name="stock_price"]');
            var price = currObj.find('input[name="price"]').eq(0).val();
            if (price.length == 0 || parseFloat(price) <= 0) {
                alert('请填写好价格再修改！');
                return;
            }
            currObj.find('input[type="text"][name^="item_value"]').each(function () {
                var indexNum = currObj.find('input[type="text"][name^="item_value"]').index(this);
                $(this).val((parseFloat(stockPriceObj.eq(indexNum).val()) + parseFloat(price)).toFixed(2));
            });
        }
    </script>
</head>

<body class="mainbody">
    <form id="form1" runat="server">
        <!--导航栏-->
        <div class="location">
            <a href="javascript:history.back(-1);" class="back"><i></i><span>返回上一页</span></a>
            <a href="../center.aspx" class="home"><i></i><span>首页</span></a>
            <i class="arrow"></i>
            <span>应用管理</span>
            <i class="arrow"></i>
            <span>快递空包价格设置</span>
        </div>
        <div class="line10"></div>
        <!--/导航栏-->

        <!--内容-->
        <div id="floatHead" class="content-tab-wrap">
            <div class="content-tab">
                <div class="content-tab-ul-wrap">
                    <ul>
                    </ul>
                </div>
            </div>
        </div>

        <asp:Repeater ID="rptList" runat="server">
            <ItemTemplate>
                <script type="text/javascript">$(".content-tab-ul-wrap>ul").append('<li><a href="javascript:;"><%#Eval("title")%>的设置</a></li>');</script>
                <!--空包快递价格设置-->
                <!--第1层tab选项卡-->
                <div class="tab-content" style="display: none">
                    <!--第2层tab外围选项卡-->
                    <div class="child-tab-wrap">
                        <input type="hidden" name="group_id" value="<%#Eval("id")%>" />
                        <div class="child-tab-bar">
                            <span class="current">单独购买空包价格(无任务编号)</span>
                            <span>凭任务编号购买价格</span>
                        </div>
                        <!-- 空包快递价格设置 --->
                        <div class="child-tab-content" style="display: none;">
                            <dl>
                                <dt>批量改价</dt>
                                <dd>
                                    成本价 + <input type="text" name="price" class="input small" value="" datatype="/^\d+(\.\d{1,2})?$/" ignore="ignore" sucmsg=" " errormsg="请输入有效价格！" nullmsg="请输入有效价格！"> 元 &nbsp; <input type="button" value="修改" class="btn yellow" onclick="changePrice('child-tab-content', <%#Container.ItemIndex*2%>)" /> &nbsp; 
                                    <%#Container.ItemIndex > 0 ? "<input type=\"button\" value=\"复制上一会员组的设置\" class=\"btn default\" index=\"" + Container.ItemIndex + "\" />" : ""%>
                                </dd>
                            </dl>
                            <!-- 以下为动态输出各快递价格类别项 --->
                            <%#GetItemsConfig(Convert.ToInt32(Eval("id")), 0)%>
                        </div>
                        <div class="child-tab-content" style="display: none;">
                            <dl>
                                <dt>批量改价</dt>
                                <dd>
                                    成本价 + <input type="text" name="price" class="input small" value="" datatype="/^\d+(\.\d{1,2})?$/" ignore="ignore" sucmsg=" " errormsg="请输入有效价格！" nullmsg="请输入有效价格！"> 元 &nbsp; <input type="button" value="修改" class="btn yellow" onclick="changePrice('child-tab-content', <%#Container.ItemIndex*2+1%>)" /> &nbsp; 
                                    <input type="button" value="复制左边单独购买的价格" class="btn green" parent_index="<%#Container.ItemIndex%>" index="1" /> &nbsp; 
                                    <%#Container.ItemIndex > 0 ? "<input type=\"button\" value=\"复制上一用户组的设置\" class=\"btn default\" index=\"" + Container.ItemIndex + "\" />" : ""%>
                                </dd>
                            </dl>
                            <%#GetItemsConfig(Convert.ToInt32(Eval("id")), 1)%>
                        </div>
                        <!-- /空包快递价格设置 --->
                    </div>
                    <!--/第2层tab外围选项卡-->
                </div>
                <!--/第1层tab选项卡-->
                <!--/空包快递价格设置-->
            </ItemTemplate>
            <FooterTemplate>
                <% if (rptList.Items.Count == 0)
                   {%>
                <div class="tab-content">
                    <dd>请先创建用户组再回来设置！
                    </dd>
                </div>
                <%}%>
            </FooterTemplate>
        </asp:Repeater>

        <!--/内容-->

        <!--工具栏-->
        <div class="page-footer">
            <div class="btn-wrap">
                <asp:Button ID="btnSubmit" runat="server" Text="提交保存" CssClass="btn" OnClick="btnSubmit_Click" />
                <input name="btnReturn" type="button" value="返回上一页" class="btn yellow" onclick="javascript: history.back(-1);" />
            </div>
        </div>
        <!--/工具栏-->
    </form>
</body>
</html>
