﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="softservice_buy_detail.aspx.cs" Inherits="SKtms.Web.admin.plugins.softservice.softservice_buy_detail" ValidateRequest="false" %>

<%@ Import Namespace="SKtms.Common" %>
<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=no" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <title>添加/编辑软件卡密</title>
    <link href="../../../scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
    <link href="../../skin/default/style.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript" charset="utf-8" src="../../../scripts/jquery/jquery-1.11.2.min.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../../scripts/jquery/Validform_v5.3.2_min.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../../scripts/datepicker/WdatePicker.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../../scripts/artdialog/dialog-plus-min.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../js/laymain.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../js/common.js"></script>
    <script type="text/javascript">
        $(function () {
            //初始化表单验证
            $("#form1").initValidform();
        });
    </script>
</head>

<body class="mainbody">
    <form id="form1" runat="server">
        <!--导航栏-->
        <div class="location">
            <a href="javascript:history.back(-1);" class="back"><i></i><span>返回上一页</span></a>
            <a href="../center.aspx" class="home"><i></i><span>首页</span></a>
            <i class="arrow"></i>
            <span>应用管理</span>
            <i class="arrow"></i>
            <span>添加/编辑软件卡密</span>
        </div>
        <div class="line10"></div>
        <!--/导航栏-->
        <!--内容-->
        <div id="floatHead" class="content-tab-wrap">
            <div class="content-tab">
                <div class="content-tab-ul-wrap">
                    <ul>
                        <li><a class="selected" href="javascript:;">
                            <asp:Literal ID="title_txt" runat="server" Text="添加软件卡密"></asp:Literal></a></li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="tab-content">
            <dl>
                <dt>软件名称</dt>
                <dd>
                    <asp:TextBox ID="title" runat="server" CssClass="input normal" datatype="*" errormsg="" sucmsg=" " />
                    <span class="Validform_checktip"></span>
                </dd>
            </dl>
            <dl>
                <dt>卡密类型</dt>
                <dd>
                    <div class="rule-single-select">
                        <asp:DropDownList ID="ddlAccountType" runat="server" datatype="*" errormsg="" sucmsg=" ">
                            <asp:ListItem Value="">点这可选择类型</asp:ListItem>
                            <asp:ListItem Value="半月卡">半月卡</asp:ListItem>
                            <asp:ListItem Value="一月卡">一月卡</asp:ListItem>
                            <asp:ListItem Value="三月卡">三月卡</asp:ListItem>
                            <asp:ListItem Value="半年卡">半年卡</asp:ListItem>
                            <asp:ListItem Value="一年卡">一年卡</asp:ListItem>
                            <asp:ListItem Value="终身卡">终身卡</asp:ListItem>
                        </asp:DropDownList>
                        <span class="Validform_checktip"></span>
                    </div>
                </dd>
            </dl>
            <dl>
                <dt>卡号</dt>
                <dd>
                    <asp:TextBox ID="account" runat="server" CssClass="input normal"  datatype="*" errormsg="" sucmsg=" "/>
                    <span class="Validform_checktip"></span>
                </dd>
            </dl>
            <dl>
                <dt>密码</dt>
                <dd>
                    <asp:TextBox ID="password" runat="server" CssClass="input normal" datatype="*" errormsg="" sucmsg=" " />
                    <span class="Validform_checktip"></span>
                </dd>
            </dl>
            <dl>
                <dt>出售价格</dt>
                <dd>
                    <asp:TextBox ID="price" runat="server" CssClass="input small100" datatype="/^\d+(\.\d{1,2})?$/" errormsg="" sucmsg=" " />&nbsp;元
                    <span class="Validform_checktip"></span>
                </dd>
            </dl>
            <dl>
                <dt>有效截止日期</dt>
                <dd>
                    <asp:TextBox ID="end_date" runat="server" onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss'});" CssClass="input" datatype="/^\s*$|^\d{4}\-\d{1,2}\-\d{1,2}\s+\d{1,2}:\d{1,2}:\d{1,2}$/" errormsg="请选择正确的日期" sucmsg=" "></asp:TextBox>
                    <span class="Validform_checktip"></span>
                </dd>
            </dl>

            <dl>
                <dt>初始状态设置</dt>
                <dd>
                    <div class="rule-single-select">
                        <asp:DropDownList ID="ddlStatus" runat="server" datatype="*" errormsg="" sucmsg=" ">
                            <asp:ListItem Value="0">未使用</asp:ListItem>
                            <asp:ListItem Value="1">已使用</asp:ListItem>
                            <asp:ListItem Value="2">已停用</asp:ListItem>
                        </asp:DropDownList>
                        <span class="Validform_checktip"></span>
                    </div>
                </dd>
            </dl>
            <dl>
                <dt>备注说明</dt>
                <dd>
                    <asp:TextBox ID="remark" runat="server" CssClass="input normal" TextMode="MultiLine" ignore="ingnore" Height="100px" Width="300px" />
                </dd>
            </dl>
        </div>
        <!--/内容-->

        <!--工具栏-->
        <div class="page-footer">
            <div class="btn-wrap">
                <asp:Button ID="btnSubmit" runat="server" Text="提交保存" CssClass="btn" OnClick="btnSubmit_Click" />
                <input name="btnReturn" type="button" value="返回上一页" class="btn yellow" onclick="javascript: history.back(-1);" />
            </div>
        </div>
        <!--/工具栏-->

    </form>
</body>
</html>
