﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="softservice_buy_list.aspx.cs" Inherits="SKtms.Web.admin.plugins.softservice.softservice_buy_list" %>

<%@ Import Namespace="SKtms.Common" %>

<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=no" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <title>软件卡密管理</title>
    <link href="../../../scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
    <link href="../../skin/default/style.css" rel="stylesheet" type="text/css" />
    <link href="../../../css/pagination.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript" src="../../../scripts/jquery/jquery-1.11.2.min.js"></script>
    <script type="text/javascript" src="../../../scripts/artdialog/dialog-plus-min.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../../scripts/datepicker/WdatePicker.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../js/laymain.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../js/common.js"></script>
</head>

<body class="mainbody">
    <script type="text/javascript">
        $(function () {
            //点击右边单个删除连接
            $(".del_link").click(function () {
                $(this).parents().find(".checkall input[type='checkbox']").prop("checked", false);
                $(this).parent().parent().find(".checkall input[type='checkbox']").prop("checked", true);
                return jsConfirm($(this), '你确定要批量删除吗？<br />');
            });
            //表格点击显示下一隐藏列
            //$(".msg-tr").click(function () {
            //    $(this).next().addClass("odd_bg").toggle();
            //});
        });
    </script>
    <form id="form1" runat="server">
        <!--导航栏-->
        <div class="location">
            <a href="javascript:history.back(-1);" class="back"><i></i><span>返回上一页</span></a>
            <a href="../center.aspx" class="home"><i></i><span>首页</span></a>
            <i class="arrow"></i>
            <span>应用管理</span>
            <i class="arrow"></i>
            <span>软件卡密管理</span>
        </div>
        <!--/导航栏-->

        <!--工具栏-->
        <div id="floatHead" class="toolbar-wrap">
            <div class="toolbar">
                <div class="box-wrap">
                    <a class="menu-btn"></a>
                    <div class="l-list">
                        <ul class="icon-list">
                            <li><a class="all" href="javascript:;" onclick="checkAll(this);"><i></i><span>全选</span></a></li>
                            <li><a class="link" href="softservice_buy_detail.aspx?action=<%=BSEnums.ActionEnum.Add %>"><i></i><span>添加软件卡密</span></a></li>
                            <li><a class="link" href="softservice_buy_add_list.aspx"><i></i><span>批量添加软件卡密</span></a></li>
                            <li>
                                <asp:LinkButton ID="btnDelete" runat="server" CssClass="del" OnClientClick="return ExePostBack('btnDelete','你确定要删除吗？');" OnClick="btnDelete_Click"><i></i><span>批量删除</span></asp:LinkButton></li>
                        </ul>
                    </div>
                    <div class="r-list">
                    </div>
                </div>
            </div>
        </div>
        <!--/工具栏-->

        <!--查询栏-->
        <div class="search_bar">
            <div class="list_item">
                起始日期：<asp:TextBox ID="txtBeginDate" runat="server" CssClass="input small100" onfocus="WdatePicker({dateFmt:'yyyy-MM-dd'});" />&nbsp;&nbsp;
                终止日期：<asp:TextBox ID="txtEndDate" runat="server" CssClass="input small100" onfocus="WdatePicker({dateFmt:'yyyy-MM-dd'});" />&nbsp;&nbsp;
                购买人用户名：
                <asp:TextBox ID="txtBuyUserName" runat="server" CssClass="input small100" />&nbsp;&nbsp;
                <asp:Button ID="btnSearch1" runat="server" CssClass="btn" OnCommand="btnSearch_Click" CommandArgument="1" Text="按时间段查询"></asp:Button>
            </div>
            <div class="list_item">
                <div class="rule-single-select">
                    <asp:DropDownList ID="ddlQueryType" runat="server">
                        <asp:ListItem Selected="True" Value="">高级查询</asp:ListItem>
                        <asp:ListItem Value="1">购买人姓名</asp:ListItem>
                        <asp:ListItem Value="2">软件名称</asp:ListItem>
                        <asp:ListItem Value="3">卡密类型</asp:ListItem>
                        <asp:ListItem Value="4">卡号</asp:ListItem>
                        <asp:ListItem Value="5">密码</asp:ListItem>
                        <asp:ListItem Value="6">备注</asp:ListItem>
                    </asp:DropDownList>
                </div>
                <asp:TextBox ID="txtKeywords" runat="server" CssClass="input small100" />
                <asp:Button ID="btnSearch2" runat="server" CssClass="btn" OnCommand="btnSearch_Click" CommandArgument="2" Text="高级查询"></asp:Button>
            </div>
        </div>
        <!--/查询栏-->

        <!--列表-->
        <div class="line10"></div>
        <div class="table-container">
            <asp:Repeater ID="rptList" runat="server">
                <HeaderTemplate>
                    <table width="100%" border="0" cellspacing="0" cellpadding="0" class="ltable">
                        <tr>
                            <th align="center" width="5%">选择</th>
                            <th align="center" width="10%">软件名称</th>
                            <th align="center" width="7%">卡密类型</th>
                            <th align="center" width="10%">卡号</th>
                            <th align="center" width="10%">密码</th>
                            <th align="center" width="5%">价格</th>
                            <th align="center" width="10%">有效截止日期</th>
                            <th align="center" width="10%">购买人</th>
                            <th align="center" width="10%">购买时间</th>
                            <th align="center" width="10%">录入时间</th>
                            <th align="center" width="5%"><a href="<%=this.pageUrl %>&fg_orderby=<%=this.fg_orderby%>">状态</a></th>
                            <th align="center" width="7%">操作</th>
                        </tr>
                </HeaderTemplate>
                <ItemTemplate>
                    <tr class="msg-tr">
                        <td align="center">
                            <asp:CheckBox ID="chkId" CssClass="checkall" runat="server" Style="vertical-align: middle;" />
                            <asp:HiddenField ID="hidId" Value='<%#Eval("id")%>' runat="server" />
                        </td>
                        <td align="center"><%#Eval("title")%></td>
                        <td align="center"><%#Eval("account_type")%></td>
                        <td align="center"><%#Eval("account")%></td>
                        <td align="center"><%#Eval("password")%></td>
                        <td align="center"><%#Eval("price","{0:F2}")%></td>
                        <td align="center"><%#Eval("end_date")%></td>
                        <td align="center"><%#Eval("buy_user_name")%></td>
                        <td align="center"><%#Eval("buy_date")%></td>
                        <td align="center"><%#Eval("add_date")%></td>
                        <td align="center"><%#get_status_info(Eval("status").ToString())%></td>
                        <td align="center">
                            <%#SetIsEnableView(Eval("status").ToString(), Eval("id").ToString()) %>
                            <a href="softservice_buy_detail.aspx?id=<%#Eval("id")%>&action=<%=BSEnums.ActionEnum.Edit %>">修改</a> |
                            <asp:LinkButton ID="btnDelete_Right" runat="server" CssClass="del_link" OnClick="btnDelete_Right_Click"><i></i><span>删除</span></asp:LinkButton></td>
                    </tr>
                    <%--<tr style="display: none">
                        <td colspan="12" align="center">
                            卡密录入时间：<%#Eval("add_date")%>&nbsp;&nbsp;
                            购买人IP：<%#Eval("buy_user_ip")%>&nbsp;&nbsp;
                        </td>
                    </tr>--%>
                </ItemTemplate>
                <FooterTemplate>
                    <%#rptList.Items.Count == 0 ? "<tr><td align=\"center\" colspan=\"12\">暂无记录</td></tr>" : ""%>
                    </table>
                </FooterTemplate>
            </asp:Repeater>
        </div>
        <!--/列表-->
        <div class="line10"></div>

        <!--内容底部-->
        <div class="line10"></div>
        <div class="pagelist">
            <div class="l-btns">
                <span>显示</span><asp:TextBox ID="txtPageNum" runat="server" CssClass="pagenum" onkeydown="return checkNumber(event);"
                    OnTextChanged="txtPageNum_TextChanged" AutoPostBack="True"></asp:TextBox><span>条/页</span>
            </div>
            <div id="PageContent" runat="server" class="default"></div>
        </div>

        <div class="line10"></div>
        <div class="foot_del_bar">
            <div class="tips">
                特别提醒： 如果提现明细记录太多，影响了系统性能，可以删除一定时间段前的记录以加快速度。 
                <br />
                <div class="rule-multi-radio">
                    <asp:RadioButtonList ID="SelecteSomeTimeAgoRecords" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow" CellPadding="10" CellSpacing="10">
                        <asp:ListItem Value="1">10天前</asp:ListItem>
                        <asp:ListItem Value="2">1个月前</asp:ListItem>
                        <asp:ListItem Value="3">2个月前</asp:ListItem>
                        <asp:ListItem Value="4">3个月前</asp:ListItem>
                        <asp:ListItem Value="5" Selected="True">6个月前</asp:ListItem>
                        <asp:ListItem Value="6">1年前</asp:ListItem>
                    </asp:RadioButtonList>
                </div>
                <asp:Button ID="DeleteSomeTimeAgoRecords" CssClass="btn yellow" OnClientClick="return confirm('确实要删除有关记录吗？请慎重！')" runat="server" Text="执行删除" OnClick="DeleteSomeTimeAgoRecords_Click" />
            </div>
        </div>

        <!--/内容底部-->

    </form>
</body>
</html>
