﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="sk_collect_flow_config.aspx.cs" Inherits="SKtms.Web.admin.settings_hb.collect_flow_config" ValidateRequest="false" %>
<%@ Import Namespace="SKtms.Common" %>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=no" />
<meta name="apple-mobile-web-app-capable" content="yes" />
<title>收藏流量任务参数设置</title>
<link href="../../scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
<link href="../skin/default/style.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" charset="utf-8" src="../../scripts/jquery/jquery-1.11.2.min.js"></script>
<script type="text/javascript" charset="utf-8" src="../../scripts/jquery/Validform_v5.3.2_min.js"></script>
<script type="text/javascript" charset="utf-8" src="../../scripts/artdialog/dialog-plus-min.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/laymain.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/common.js"></script>
<script type="text/javascript">
    $(function () {
        $(".content-tab-ul-wrap>ul>li a").eq(0).addClass("selected");
        $(".tab-content").eq(0).show();
        //初始化表单验证
        $("#form1").initValidform();
        //初始化子tab
        $(".child-tab-wrap").initChildTab();
    });
</script>
</head>

<body class="mainbody">
<form id="form1" runat="server">
<!--导航栏-->
<div class="location">
    <a href="javascript:history.back(-1);" class="back"><i></i><span>返回上一页</span></a>
    <a href="../center.aspx" class="home"><i></i><span>首页</span></a>
    <i class="arrow"></i>
    <span>试客系统</span>
    <i class="arrow"></i>
    <span>收藏流量任务参数设置</span>
</div>
<div class="line10"></div>
<!--/导航栏-->

<!--内容-->
<div id="floatHead" class="content-tab-wrap">
    <div class="content-tab">
        <div class="content-tab-ul-wrap">
            <ul>
            </ul>
        </div>
    </div>
</div>

<asp:Repeater ID="rptList" runat="server" OnItemDataBound="rptList_ItemDataBound">
    <ItemTemplate>
        <script type="text/javascript">$(".content-tab-ul-wrap>ul").append('<li><a href="javascript:;"><%#Eval("group_title")%>的设置</a></li>');</script>
        <!--会员组扩展参数设置-->
        <!--第1层tab选项卡-->
        <div class="tab-content" style="display: none">
            <!--第2层tab外围选项卡-->
            <div class="child-tab-wrap">
                <div class="child-tab-bar">
                    <span class="current">收藏任务设置</span>
                    <span>流量任务设置</span>
                </div>
                <div class="child-tab-content" style="display: block;">
                <!-- 以下为收藏任务设置 --->
                <dl>
                    <dd>
                        <input type="hidden" name="group_id" value="<%#Eval("group_id")%>" />
                        <input type="hidden" name="group_title" value="<%#Eval("group_title")%>" />
                        <%#Container.ItemIndex > 0 ? "<input type=\"button\" value=\"复制上一用户组的设置\" class=\"btn green\" onclick=\"copyConfig('tab-content', " + Container.ItemIndex + ")\" />" : ""%>
                    </dd>
                </dl>
                <dl>
                    <dt>是否开启收藏任务功能</dt>
                    <dd>
                        <div class="rule-single-checkbox">
                            <asp:CheckBox ID="collect_task_enabled" runat="server" />
                        </div>
                        <span class="Validform_checktip">*是否开启客户端收藏任务功能</span>
                    </dd>
                </dl>
                <dl>
                    <dt>收藏读单随机间隔时间</dt>
                    <dd>
                        <input type="text" name="collect_read_time" class="input small" datatype="n" sucmsg=" " errormsg="请输入有效数字" value="<%#Eval("collect_read_time")%>" />
                        分钟  <span class="Validform_checktip">*随时间隔几分钟之内执行下一次 建议不小于2分钟</span>
                    </dd>
                </dl>
                <dl>
                    <dt>每个收藏的价格</dt>
                    <dd>
                        <input type="text" name="collect_point" class="input small" datatype="/^[0-9.]{1,5}$/" sucmsg=" " errormsg="请输入有效数字" value="<%#Eval("collect_point")%>" />
                        点/次  <span class="Validform_checktip">*每个收藏需要多少个收藏点</span>
                    </dd>
                </dl>
                <dl>
                    <dt>删除收藏任务退还比率</dt>
                    <dd>
                        <input type="text" name="collect_del_return_point" class="input small" datatype="/^[0-9.]{1,5}$/" sucmsg=" " errormsg="请输入有效数字" value="<%#Eval("collect_del_return_point")%>" />
                        %  <span class="Validform_checktip">*删除收藏任务退还百分之多少的收藏点,如90%(填写90),原价退还填写100</span>
                    </dd>
                </dl>
                <dl>
                    <dt>小号每天允许收藏店铺</dt>
                    <dd>
                        <input type="text" name="collect_day_max_shop_num" class="input small" datatype="n" sucmsg=" " errormsg="请输入有效数字" value="<%#Eval("collect_day_max_shop_num")%>" />
                        个  <span class="Validform_checktip">*每个收藏小号每天允许收藏多少个店铺</span>
                    </dd>
                </dl>
                <dl>
                    <dt>小号每天允许收藏商品</dt>
                    <dd>
                        <input type="text" name="collect_day_max_product_num" class="input small" datatype="n" sucmsg=" " errormsg="请输入有效数字" value="<%#Eval("collect_day_max_product_num")%>" />
                        个  <span class="Validform_checktip">*每个收藏小号每天允许收藏多少个商品</span>
                    </dd>
                </dl>
                <!-- /以下为收藏任务设置 --->
                </div>
                <div class="child-tab-content" style="display: none;">
                <!-- 以下为流量任务设置 --->
                <dl>
                    <dt>是否开启流量任务功能</dt>
                    <dd>
                        <div class="rule-single-checkbox">
                            <asp:CheckBox ID="flow_task_enabled" runat="server" />
                        </div>
                        <span class="Validform_checktip">*是否开启客户端流量任务功能</span>
                    </dd>
                </dl>
                <dl>
                    <dt>流量读单随机间隔时间</dt>
                    <dd>
                        <input type="text" name="flow_read_time" class="input small" datatype="n" sucmsg=" " errormsg="请输入有效数字" value="<%#Eval("flow_read_time")%>" />
                        分钟  <span class="Validform_checktip">*随时间隔几分钟之内执行下一次 建议不小于2分钟</span>
                    </dd>
                </dl>
                <dl>
                    <dt>普通流量任务的价格</dt>
                    <dd>
                        <input type="text" name="flow_point" class="input small" datatype="/^[0-9.]{1,5}$/" sucmsg=" " errormsg="请输入有效数字" value="<%#Eval("flow_point")%>" />
                        点/次  <span class="Validform_checktip">*普通流量任务每个流量需要多少个流量点</span>
                    </dd>
                </dl>
                <dl>
                    <dt>搜索来路流量任务的价格</dt>
                    <dd>
                        <input type="text" name="flow_search_point" class="input small" datatype="/^[0-9.]{1,5}$/" sucmsg=" " errormsg="请输入有效数字" value="<%#Eval("flow_search_point")%>" />
                        点/次  <span class="Validform_checktip">*搜索来路流量任务每个流量需要多少流量点</span>
                    </dd>
                </dl>
                <dl>
                    <dt>删除流量任务退还比率</dt>
                    <dd>
                        <input type="text" name="flow_del_return_point" class="input small" datatype="/^[0-9.]{1,5}$/" sucmsg=" " errormsg="请输入有效数字" value="<%#Eval("flow_del_return_point")%>" />
                        %  <span class="Validform_checktip">*删除流量任务退还百分之多少的流量点,如90%(填写90),原价退还填写100</span>
                    </dd>
                </dl>
                <dl>
                    <dt>允许批量发布任务数量</dt>
                    <dd>
                        <input type="text" name="flow_allow_publish_num" class="input small" datatype="n" sucmsg=" " errormsg="请输入有效数字" value="<%#Eval("flow_allow_publish_num")%>" />
                        条  <span class="Validform_checktip">*允许一次批量发布多少个流量任务</span>
                    </dd>
                </dl>
                <dl>
                    <dt>宝贝页面停留价格</dt>
                    <dd>
                        <input type="text" name="flow_page_stop_time_point" class="input txt" datatype="*1-100" sucmsg=" " errormsg="请输入有效数字" value="<%#Eval("flow_page_stop_time_point")%>" />
                        点  <span class="Validform_checktip">*使用宝贝页面停留浏览N秒钟功能需额外支付的流量点 每项以,号隔开</span>
                    </dd>
                </dl>
                <dl>
                    <dt>随机浏览宝贝价格</dt>
                    <dd>
                        <input type="text" name="flow_rnd_open_page_point" class="input txt" datatype="*1-100" sucmsg=" " errormsg="请输入有效数字" value="<%#Eval("flow_rnd_open_page_point")%>" />
                        点  <span class="Validform_checktip">*使用进入后再随机浏览N个宝贝功能需额外支付的流量点 每项以,号隔开</span>
                    </dd>
                </dl>
                <dl>
                    <dt>限制同ip每天最多浏览次数</dt>
                    <dd>
                        <input type="text" name="flow_ip_limit_point" class="input small" datatype="/^[0-9.]{1,5}$/" sucmsg=" " errormsg="请输入有效数字" value="<%#Eval("flow_ip_limit_point")%>" />
                        点  <span class="Validform_checktip">*使用限制同ip每天最多浏览N次功能需额外支付的流量点，不扣请填写0</span>
                    </dd>
                </dl>
                <dl>
                    <dt>同ip每天最多浏览次数</dt>
                    <dd>
                        <input type="text" name="flow_ip_day_view_num" class="input small" datatype="n" sucmsg=" " errormsg="请输入有效数字" value="<%#Eval("flow_ip_day_view_num")%>" />
                        次  <span class="Validform_checktip">*默认流量任务同ip每天最多浏览(所有流量任务)多少次</span>
                    </dd>
                </dl>
                <dl>
                    <dt>同ip每天浏览相同任务次数</dt>
                    <dd>
                        <input type="text" name="flow_ip_day_view_sametask_num" class="input small" datatype="n" sucmsg=" " errormsg="请输入有效数字" value="<%#Eval("flow_ip_day_view_sametask_num")%>" />
                        次  <span class="Validform_checktip">*默认流量任务同ip每天浏览同一任务最大多少次</span>
                    </dd>
                </dl>
                <!-- /以下为流量任务设置 --->
                </div>
                                
            </div>
            <!--/第2层tab外围选项卡-->
        </div>
        <!--/第1层tab选项卡-->
        <!--/会员组扩展参数设置-->
    </ItemTemplate>
    <FooterTemplate>
        <% if (rptList.Items.Count == 0)
            {%>
        <div class="tab-content">
            <dd>请先创建用户组再回来设置！
            </dd>
        </div>
        <%}%>
    </FooterTemplate>
</asp:Repeater>

<!--/内容-->

<!--工具栏-->
<div class="page-footer">
    <div class="btn-wrap">
        <asp:Button ID="btnSubmit" runat="server" Text="提交保存" CssClass="btn" OnClick="btnSubmit_Click" />
        <input name="btnReturn" type="button" value="返回上一页" class="btn yellow" onclick="javascript: history.back(-1);" />
    </div>
</div>
<!--/工具栏-->
</form>
</body>
</html>