﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="sk_safe_config.aspx.cs" Inherits="SKtms.Web.admin.settings_hb.sk_safe_config" ValidateRequest="false" %>
<%@ Import Namespace="SKtms.Common" %>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=no" />
<meta name="apple-mobile-web-app-capable" content="yes" />
<title>活动安全预警设置</title>
<link href="../../scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
<link href="../skin/default/style.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" charset="utf-8" src="../../scripts/jquery/jquery-1.11.2.min.js"></script>
<script type="text/javascript" charset="utf-8" src="../../scripts/jquery/Validform_v5.3.2_min.js"></script>
<script type="text/javascript" charset="utf-8" src="../../scripts/artdialog/dialog-plus-min.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/laymain.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/common.js"></script>
<script type="text/javascript">
    $(function () {
        $(".content-tab-ul-wrap>ul>li a").eq(0).addClass("selected");
        $(".tab-content").eq(0).show();
        $(".child-tab-content").eq(0).show();
        //初始化表单验证
        $("#form1").initValidform();
        //初始化子tab
        $(".child-tab-wrap").initChildTab();
        $(".child2-tab-wrap").initChildTab();
        //绑定复制上一用户组设置按钮
        $(".tab-content .default").each(function () {
            $(this).bind("click", function () {
                copyConfig('tab-content', $(this).attr("index"));
            });
        });
        //绑定复制上一频道组设置按钮
        $(".child-tab-content .green").each(function () {
            $(this).bind("click", function () {
                copyConfig($(".tab-content").eq($(this).attr("parent_index")).find(".child-tab-content"), $(this).attr("index"));
            });
        });
        //绑定复制上一选项卡设置按钮
        //$(".child-tab-content .green").each(function () {
        //    $(this).bind("click", function () {
        //        copyConfig('child-tab-content', $(".child-tab-content .green").index(this));
        //    });
        //});
    });
</script>
</head>

<body class="mainbody">
<form id="form1" runat="server">
<!--导航栏-->
<div class="location">
    <a href="javascript:history.back(-1);" class="back"><i></i><span>返回上一页</span></a>
    <a href="../center.aspx" class="home"><i></i><span>首页</span></a>
    <i class="arrow"></i>
    <span>试客系统</span>
    <i class="arrow"></i>
    <span>活动安全预警设置</span>
</div>
<div class="line10"></div>
<!--/导航栏-->

<!--内容-->
<div id="floatHead" class="content-tab-wrap">
    <div class="content-tab">
        <div class="content-tab-ul-wrap">
            <ul>
            </ul>
        </div>
    </div>
</div>

<asp:Repeater ID="rptList" runat="server" OnItemDataBound="rptList_ItemDataBound">
    <ItemTemplate>
        <script type="text/javascript">$(".content-tab-ul-wrap>ul").append('<li><a href="javascript:;"><%#Eval("title")%>的设置</a></li>');</script>
        <!--活动安全预警设置-->
        <!--第1层tab选项卡-->
        <div class="tab-content" style="display: none">
            <input type="hidden" name="group_id" value="<%#Eval("id")%>" />
            <input type="hidden" name="group_title" value="<%#Eval("title")%>" />

            <asp:Repeater ID="rptList_channel_category" runat="server" OnItemDataBound="rptList_channel_category_ItemDataBound">
                <HeaderTemplate>
                    <!--第2层tab外围选项卡-->
                    <div class="child-tab-wrap">
                        <div class="child-tab-bar">
                        </div>
                </HeaderTemplate>
                <ItemTemplate>
                    <script type="text/javascript">$(".child-tab-bar").last().append('<span><%#Eval("category_title")%></span>');</script>                    
                    <input type="hidden" name="category_id" value="<%#Eval("category_id")%>" />
                    <input type="hidden" name="category_title" value="<%#Eval("category_title")%>" />
                    <!--第2层tab选项卡-->
                    <div class="child-tab-content" style="display: none;">
                        <div class="child2-tab-wrap">
                            <div class="child2-tab-bar">
                                <span class="current">活动安全预警设置</span>
                            </div>
                                     
                            <div class="child2-tab-content" style="display: none;">
                                <dl <%#(Container.ItemIndex == 0 && ((RepeaterItem)(Container.Parent.Parent)).ItemIndex == 0) ? "style=\"display:none\"":""%>>
                                    <dd>
                                        <input type="button" value="复制上一试用区的设置" class="btn green" parent_index="<%#((RepeaterItem)(Container.Parent.Parent)).ItemIndex%>" index="<%#Container.ItemIndex%>" <%#Container.ItemIndex == 0 ? "style=\"display:none\"":""%> />
                                        <input type="button" value="复制上一用户组的设置" class="btn default" index="<%#((RepeaterItem)(Container.Parent.Parent)).ItemIndex%>" <%#((RepeaterItem)(Container.Parent.Parent)).ItemIndex == 0 ? "style=\"display:none\"":""%> />
                                    </dd>
                                </dl>
                                <dl>
                                    <dt>发布活动预警数量</dt>
                                    <dd>
                                        <input type="text" name="safe_day_task_num_to_notice" class="input small" datatype="n" sucmsg=" " errormsg="请输入有效数字" value="<%#Eval("safe_day_task_num_to_notice")%>" />
                                        条  <span class="Validform_checktip">*每个活动区当天发布活动数量达到多少条，发站内信和邮件给管理人员 如不启用填0</span>
                                    </dd>
                                </dl>
                                <dl>
                                    <dt>活动提前到立即好评预警金额</dt>
                                    <dd>
                                        <input type="text" name="safe_task_ahead_evaluate_money" class="input small" datatype="n" sucmsg=" " errormsg="请输入有效数字" value="<%#Eval("safe_task_ahead_evaluate_money")%>" />
                                        元  <span class="Validform_checktip">*活动金额超过N元的，提前好评时间设成立即收货的，即发通知给管理人员 如不启用填0</span>
                                    </dd>
                                </dl>
                                <dl>
                                    <dt>接收站内信通知的账号</dt>
                                    <dd>
                                        <input type="text" name="safe_notice_manage_account" class="input txt" datatype="s" sucmsg=" " ignore="ignore" value="<%#Eval("safe_notice_manage_account")%>" />
                                        <span class="Validform_checktip">*达到上面设定条件后，系统默认发送站内信给admin管理员，也可改成其他客服的网站登录账号</span>
                                    </dd>
                                </dl>
                                <dl>
                                    <dt>接收邮件通知的Email账号</dt>
                                    <dd>
                                        <input type="text" name="safe_notice_email_account" class="input txt" datatype="e" sucmsg=" " ignore="ignore" errormsg="请输入有效Email" value="<%#Eval("safe_notice_email_account")%>" />
                                        <span class="Validform_checktip">*达到上面设定条件后，系统发送Email到指定接收账号，留空则不发送</span>
                                    </dd>
                                </dl>
                                <dl>
                                    <dt>虚拟活动需要审核的金额</dt>
                                    <dd>
                                        <input type="text" name="safe_fabu_virtual_verific_money" class="input small" datatype="n" sucmsg=" " errormsg="请输入有效数字" value="<%#Eval("safe_fabu_virtual_verific_money")%>" />
                                        元  <span class="Validform_checktip">*发布虚拟活动，金额多少元(含)以上的，且符合设定N天内好评条件的，需要后台审核才显示，不启用填写0</span>
                                    </dd>
                                </dl>
                                <dl>
                                    <dt>好评时间几天内的要审核</dt>
                                    <dd>
                                        <div class="rule-single-select">
                                            <asp:DropDownList id="safe_fabu_virtual_verific_haoping_num" runat="server" datatype="*" errormsg="请选择好评时限" sucmsg=" " nullmsg="请选择！">
                                                <asp:ListItem Value="1">马上好评</asp:ListItem>
                                                <asp:ListItem Value="2">30分钟后好评</asp:ListItem>
                                                <asp:ListItem Value="3">1天后好评</asp:ListItem>
                                                <asp:ListItem Value="4">2天后好评</asp:ListItem>
                                                <asp:ListItem Value="5">3天后好评</asp:ListItem>
                                                <asp:ListItem Value="6">4天后好评</asp:ListItem>
                                                <asp:ListItem Value="7">5天后好评</asp:ListItem>
                                                <asp:ListItem Value="8">6天后好评</asp:ListItem>
                                                <asp:ListItem Value="9">7天后好评</asp:ListItem>
                                                <asp:ListItem Value="10">物流签收好评</asp:ListItem>
                                            </asp:DropDownList>
                                        </div>
                                         <span class="Validform_checktip">*虚拟活动好评时间多少天内的，且符合上面金额条件的，需要后台审核，例如选择马上好评或30分钟后好评</span>
                                    </dd>
                                </dl>
                                <dl>
                                    <dt>实物活动需要审核的金额</dt>
                                    <dd>
                                        <input type="text" name="safe_fabu_entity_verific_money" class="input small" datatype="n" sucmsg=" " errormsg="请输入有效数字" value="<%#Eval("safe_fabu_entity_verific_money")%>" />
                                        元  <span class="Validform_checktip">*发布实物活动，金额多少元(含)以上的，且符合设定N天内好评条件的，需要后台审核才显示，不启用填写0</span>
                                    </dd>
                                </dl>
                                <dl>
                                    <dt>好评时间几天内的要审核</dt>
                                    <dd>
                                        <div class="rule-single-select">
                                            <asp:DropDownList id="safe_fabu_entity_verific_haoping_num" runat="server" datatype="*" errormsg="请选择好评时限" sucmsg=" " nullmsg="请选择！">
                                                <asp:ListItem Value="1">马上好评</asp:ListItem>
                                                <asp:ListItem Value="2">30分钟后好评</asp:ListItem>
                                                <asp:ListItem Value="3">1天后好评</asp:ListItem>
                                                <asp:ListItem Value="4">2天后好评</asp:ListItem>
                                                <asp:ListItem Value="5">3天后好评</asp:ListItem>
                                                <asp:ListItem Value="6">4天后好评</asp:ListItem>
                                                <asp:ListItem Value="7">5天后好评</asp:ListItem>
                                                <asp:ListItem Value="8">6天后好评</asp:ListItem>
                                                <asp:ListItem Value="9">7天后好评</asp:ListItem>
                                                <asp:ListItem Value="10">物流签收好评</asp:ListItem>
                                            </asp:DropDownList>
                                        </div>
                                         <span class="Validform_checktip">*实物活动好评时间多少天内的，且符合上面金额条件的，需要后台审核，例如选择3天后好评，也包含2天内更短期的</span>
                                    </dd>
                                </dl>
                                <dl>
                                    <dt>套餐活动需要审核的金额</dt>
                                    <dd>
                                        <input type="text" name="safe_fabu_meal_verific_money" class="input small" datatype="n" sucmsg=" " errormsg="请输入有效数字" value="<%#Eval("safe_fabu_meal_verific_money")%>" />
                                        元  <span class="Validform_checktip">*发布套餐活动，金额多少元(含)以上的，且符合设定N天内好评条件的，需要后台审核才显示，不启用填写0</span>
                                    </dd>
                                </dl>
                                <dl>
                                    <dt>好评时间几天内的要审核</dt>
                                    <dd>
                                        <div class="rule-single-select">
                                            <asp:DropDownList id="safe_fabu_meal_verific_haoping_num" runat="server" datatype="*" errormsg="请选择好评时限" sucmsg=" " nullmsg="请选择！">
                                                <asp:ListItem Value="1">马上好评</asp:ListItem>
                                                <asp:ListItem Value="2">30分钟后好评</asp:ListItem>
                                                <asp:ListItem Value="3">1天后好评</asp:ListItem>
                                                <asp:ListItem Value="4">2天后好评</asp:ListItem>
                                                <asp:ListItem Value="5">3天后好评</asp:ListItem>
                                                <asp:ListItem Value="6">4天后好评</asp:ListItem>
                                                <asp:ListItem Value="7">5天后好评</asp:ListItem>
                                                <asp:ListItem Value="8">6天后好评</asp:ListItem>
                                                <asp:ListItem Value="9">7天后好评</asp:ListItem>
                                                <asp:ListItem Value="10">物流签收好评</asp:ListItem>
                                            </asp:DropDownList>
                                        </div>
                                         <span class="Validform_checktip">*套餐活动好评时间多少天内的，且符合上面金额条件的，需要后台审核，例如选择3天后好评，也包含2天内更短期的</span>
                                    </dd>
                                </dl>
                            </div>
                        </div>
                    </div>
                    <!--/第2层tab选项卡-->
                </ItemTemplate>
                <FooterTemplate>
                    </div>
                    <!--/第2层tab外围选项卡-->
                    <% if (this.Items.Count == 0)
                        {%>
                    <div class="child-tab-content">
                        <dd>请先创建活动栏目再回来设置！
                        </dd>
                    </div>
                    <%}%>
                </FooterTemplate>
            </asp:Repeater>

        </div>
        <!--/第1层tab选项卡-->
        <!--/活动安全预警设置-->
    </ItemTemplate>
    <FooterTemplate>
        <% if (rptList.Items.Count == 0)
            {%>
        <div class="tab-content">
            <dd>请先创建用户组再回来设置！
            </dd>
        </div>
        <%}%>
    </FooterTemplate>
</asp:Repeater>

<!--/内容-->

<!--工具栏-->
<div class="page-footer">
    <div class="btn-wrap">
        <asp:Button ID="btnSubmit" runat="server" Text="提交保存" CssClass="btn" OnClick="btnSubmit_Click" />
        <input name="btnReturn" type="button" value="返回上一页" class="btn yellow" onclick="javascript: history.back(-1);" />
    </div>
</div>
<!--/工具栏-->
</form>
</body>
</html>
