﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="sk_overtime_config.aspx.cs" Inherits="SKtms.Web.admin.settings_try.sk_overtime_config" ValidateRequest="false" %>
<%@ Import namespace="SKtms.Common" %>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=no" />
<meta name="apple-mobile-web-app-capable" content="yes" />
<title>活动超时设置</title>
<link href="../../scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
<link href="../skin/default/style.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" charset="utf-8" src="../../scripts/jquery/jquery-1.11.2.min.js"></script>
<script type="text/javascript" charset="utf-8" src="../../scripts/jquery/Validform_v5.3.2_min.js"></script>
<script type="text/javascript" charset="utf-8" src="../../scripts/artdialog/dialog-plus-min.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/laymain.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/common.js"></script>
<script type="text/javascript">
    $(function () {
        $(".content-tab-ul-wrap>ul>li a").eq(0).addClass("selected");
        $(".tab-content").eq(0).show();
        $(".child-tab-content").eq(0).show();
        //初始化表单验证
        $("#form1").initValidform();
        //初始化子tab
        $(".child-tab-wrap").initChildTab();
        $(".child2-tab-wrap").initChildTab();
        //绑定复制上一用户组设置按钮
        $(".tab-content .default").each(function () {
            $(this).bind("click", function () {
                copyConfig('tab-content', $(this).attr("index"));
            });
        });
        //绑定复制上一频道组设置按钮
        $(".child-tab-content .green").each(function () {
            $(this).bind("click", function () {
                copyConfig($(".tab-content").eq($(this).attr("parent_index")).find(".child-tab-content"), $(this).attr("index"));
            });
        });
        //绑定复制上一选项卡设置按钮
        //$(".child-tab-content .green").each(function () {
        //    $(this).bind("click", function () {
        //        copyConfig('child-tab-content', $(".child-tab-content .green").index(this));
        //    });
        //});
    });
</script>
</head>

<body class="mainbody">
<form id="form1" runat="server">
    <!--导航栏-->
    <div class="location">
      <a href="javascript:history.back(-1);" class="back"><i></i><span>返回上一页</span></a>
      <a href="../center.aspx" class="home"><i></i><span>首页</span></a>
      <i class="arrow"></i>
      <span>试客系统</span>
      <i class="arrow"></i>
      <span>活动超时设置</span>
    </div>
    <div class="line10"></div>
    <!--/导航栏-->

    <!--内容-->
    <div id="floatHead" class="content-tab-wrap">
      <div class="content-tab">
        <div class="content-tab-ul-wrap">
          <ul>
          </ul>
        </div>
      </div>
    </div>
    <asp:Repeater ID="rptList" runat="server" OnItemDataBound="rptList_ItemDataBound">
        <ItemTemplate>
        <script type="text/javascript">$(".content-tab-ul-wrap>ul").append('<li><a href="javascript:;"><%#Eval("title")%>的设置</a></li>');</script>
        <!--绑定买/卖号设置-->
        <!--第1层tab选项卡-->
        <div class="tab-content" style="display: none">
            <input type="hidden"  name="group_id" value="<%#Eval("id")%>" />
            <input type="hidden" name="group_title" value="<%#Eval("title")%>" />
            
            <asp:Repeater ID="rptList_channel_category" runat="server">
                <HeaderTemplate>
                    <!--第2层tab外围选项卡-->
                    <div class="child-tab-wrap">
                        <div class="child-tab-bar">
                        </div>
                </HeaderTemplate>
                <ItemTemplate>
                    <script type="text/javascript">$(".child-tab-bar").last().append('<span><%#Eval("category_title")%></span>');</script>                    
                    <input type="hidden" name="category_id" value="<%#Eval("category_id")%>" />
                    <input type="hidden" name="category_title" value="<%#Eval("category_title")%>" />
                    <!--第2层tab选项卡-->
                    <div class="child-tab-content" style="display: none;">
                        <div class="child2-tab-wrap">
                            <div class="child2-tab-bar">
                                <span class="current">活动超时设置</span>
                            </div>

                            <div class="child2-tab-content" style="display: none;">
                                <dl <%#(Container.ItemIndex == 0 && ((RepeaterItem)(Container.Parent.Parent)).ItemIndex == 0) ? "style=\"display:none\"":""%>>
                                    <dd>
                                        <input type="button" value="复制上一试用区的设置" class="btn green" parent_index="<%#((RepeaterItem)(Container.Parent.Parent)).ItemIndex%>" index="<%#Container.ItemIndex%>" <%#Container.ItemIndex == 0 ? "style=\"display:none\"":""%> />
                                        <input type="button" value="复制上一用户组的设置" class="btn default" index="<%#((RepeaterItem)(Container.Parent.Parent)).ItemIndex%>" <%#((RepeaterItem)(Container.Parent.Parent)).ItemIndex == 0 ? "style=\"display:none\"":""%> />
                                    </dd>
                                </dl>
                                <dl>
                                    <dt></dt>
                                    <dd>
                                        =============== 以下参数针对会员(买家)才需要设置，商家会员可忽略 ===============
                                    </dd>
                                </dl>
                                <dl>
                                <dt>支付超时时间</dt>
                                <dd>
                                    <input type="text" name="overtime_payment_second" class="input small" datatype="n" sucmsg=" " errormsg="请输入有效数字" value="<%#Utils.ObjToInt(Eval("overtime_payment_second")) / 60%>" /> 分钟 
                                    <span class="Validform_checktip">*普通试用支付并填写订单号超时时间（超时将自动关闭试用）</span>
                                </dd>
                                </dl>
                                <dl>
                                <dt>"延迟购买"支付超时时间</dt>
                                <dd>
                                    <input type="text" name="overtime_delay_buy_payment_second" class="input small" datatype="n" sucmsg=" " errormsg="请输入有效数字" value="<%#Utils.ObjToInt(Eval("overtime_delay_buy_payment_second")) / 60 / 60%>" /> 小时 
                                    <span class="Validform_checktip">*加购延迟购买试用支付并填写订单号超时时间（超时将自动关闭试用）</span>
                                </dd>
                                </dl>
                                <dl>
                                <dt>商家审核失败后可申诉时间</dt>
                                <dd>
                                    <input type="text" name="overtime_appeal_hour" class="input small" datatype="n" sucmsg=" " errormsg="请输入有效数字" value="<%#Utils.ObjToInt(Eval("overtime_appeal_hour"))%>" /> 小时 
                                    <span class="Validform_checktip">*商家审核订单号失败后，会员可在此时间内申诉（超时将关闭申诉入口）</span>
                                </dd>
                                </dl>
                                <dl>
                                <dt>提交试用报告超时时间</dt>
                                <dd>
                                    <input type="text" name="overtime_try_report_day" class="input small" datatype="n" sucmsg=" " errormsg="请输入有效数字" value="<%#Utils.ObjToInt(Eval("overtime_try_report_day"))%>" /> 天 
                                    <span class="Validform_checktip">*收货后需多少天内提交试用报告，默认7天</span>
                                </dd>
                                </dl>
                                <dl>
                                <dt></dt>
                                <dd>
                                    =============== 以下参数针对商家才需要设置，买家会员可忽略 ==================
                                </dd>
                                </dl>
                                <dl>
                                <dt>申请资格审核超时时间</dt>
                                <dd>
                                    <input type="text" name="overtime_audit_user_day" class="input small" datatype="n" sucmsg=" " errormsg="请输入有效数字" value="<%#Utils.ObjToInt(Eval("overtime_audit_user_day"))%>" /> 天 
                                    <span class="Validform_checktip">*会员申请试用资格审核时间，超时将自动关闭，默认7天</span>
                                </dd>
                                </dl>
                                <dl>
                                <dt>超时自动发货时间</dt>
                                <dd>
                                    <input type="text" name="overtime_delivery_second" class="input small" datatype="n" sucmsg=" " errormsg="请输入有效数字" value="<%#Utils.ObjToInt(Eval("overtime_delivery_second")) / 60 / 60%>" /> 小时 
                                    <span class="Validform_checktip">*买家已支付，商家超过此时间没发货，系统将自动发货，如不启用填写0</span>
                                </dd>
                                </dl>
                                <dl>
                                <dt>试用报告自动审核时间</dt>
                                <dd>
                                    <input type="text" name="overtime_haoping_second" class="input small" datatype="n" sucmsg=" " errormsg="请输入有效数字" value="<%#Utils.ObjToInt(Eval("overtime_haoping_second")) / 60 / 60%>" /> 小时 
                                    <span class="Validform_checktip">*买家已评价并提交试用报告超过多少小时后系统允许自助提取红包和担保金，如不启用填写0</span>
                                </dd>
                                </dl>
                                <dl>
                                <dt>活动自动下架时间</dt>
                                <dd>
                                    <input type="text" name="overtime_huodong_pause_hour" class="input small" datatype="n" sucmsg=" " errormsg="请输入有效数字" value="<%#Eval("overtime_huodong_pause_hour")%>" /> 小时 
                                    <span class="Validform_checktip">*活动发布后多少小时内没人申请，自动下架设为暂停状态，如不启用填写0</span>
                                </dd>
                                </dl>
                            </div>
                        </div>
                    </div>
                    <!--/第2层tab选项卡-->
                </ItemTemplate>
                <FooterTemplate>
                    </div>
                    <!--/第2层tab外围选项卡-->
                    <% if (this.Items.Count == 0)
                        {%>
                    <div class="child-tab-content">
                        <dd>请先创建试用栏目再回来设置！
                        </dd>
                    </div>
                    <%}%>
                </FooterTemplate>
            </asp:Repeater>
            
        </div>
        <!--/第1层tab选项卡-->
        <!--/绑定买/卖号设置-->
        </ItemTemplate>
        <FooterTemplate>
        <% if(rptList.Items.Count == 0){%>
        <div class="tab-content">
            <dd>
                请先创建用户组再回来设置！
            </dd>
        </div>
        <%}%>
        </FooterTemplate>
    </asp:Repeater>

    <!--/内容-->

    <!--工具栏-->
    <div class="page-footer">
      <div class="btn-wrap">
        <asp:Button ID="btnSubmit" runat="server" Text="提交保存" CssClass="btn" onclick="btnSubmit_Click" />
        <input name="btnReturn" type="button" value="返回上一页" class="btn yellow" onclick="javascript:history.back(-1);" />
      </div>
    </div>
    <!--/工具栏-->
</form>
</body>
</html>
