﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="account_edit.aspx.cs" Inherits="SKtms.Web.admin.task.account_edit" ValidateRequest="false" %>
<%@ Import namespace="SKtms.Common" %>

<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=no" />
<meta name="apple-mobile-web-app-capable" content="yes" />
<title>绑定买卖号</title>
<link href="../../scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
<link href="../skin/default/style.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" charset="utf-8" src="../../scripts/jquery/jquery-1.11.2.min.js"></script>
<script type="text/javascript" charset="utf-8" src="../../scripts/jquery/Validform_v5.3.2_min.js"></script>
<script type="text/javascript" charset="utf-8" src="../../scripts/artdialog/dialog-plus-min.js"></script>
<script type="text/javascript" charset="utf-8" src="../../scripts/webuploader/webuploader.min.js"></script>
<script type="text/javascript" charset="utf-8" src="../../editor/kindeditor-min.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/uploader.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/laymain.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/common.js"></script>
<script type="text/javascript">
    $(function () {
        //初始化表单验证
        $("#form1").initValidform();
    });
</script>
</head>

<body class="mainbody">
<form id="form1" runat="server">
<!--导航栏-->
<div class="location">
  <a href="javascript:history.back(-1);" class="back"><i></i><span>返回列表页</span></a>
  <a href="../center.aspx" class="home"><i></i><span>首页</span></a>
  <i class="arrow"></i>
  <a href="javascript:history.back(-1);"><span>买卖号管理</span></a>
  <i class="arrow"></i>
  <span>绑定<%=this.account_title%></span>
</div>
<div class="line10"></div>
<!--/导航栏-->

<!--内容-->
<div id="floatHead" class="content-tab-wrap">
  <div class="content-tab">
    <div class="content-tab-ul-wrap">
      <ul>
        <li><a class="selected" href="javascript:;">绑定<%=this.account_title%></a></li>
      </ul>
    </div>
  </div>
</div>

<div class="tab-content">
  <dl>
    <dt>所属电商平台</dt>
    <dd>
      <div class="rule-single-select">
        <asp:DropDownList id="ddlShopSite" runat="server" datatype="*" errormsg="请选择电商平台" sucmsg=" " nullmsg="请选择！"></asp:DropDownList>
      </div>
    </dd>
  </dl>
  <dl>
    <dt>请选择绑定类型</dt>
    <dd>
      <div class="rule-multi-radio">
        <asp:RadioButtonList ID="rblAccountType" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow">
        <asp:ListItem Value="1" Selected="True">买号</asp:ListItem>
        <asp:ListItem Value="2">掌柜号</asp:ListItem>
        </asp:RadioButtonList>
      </div>
    </dd>
  </dl>
  <dl>
    <dt>会员账号</dt>
    <dd><asp:TextBox ID="txtUserName" runat="server" CssClass="input txt" datatype="s3-30" sucmsg=" " ajaxurl="../../tools/submit_ajax.ashx?action=validate_username_exist"></asp:TextBox> <span class="Validform_checktip">*请填写会员登录账号</span></dd>
  </dl>
  <dl>
    <dt><%=this.account_title%></dt>
    <dd>
      <asp:TextBox ID="txtAccount" runat="server" CssClass="input txt" datatype="*3-30" sucmsg=" "></asp:TextBox>
      <span class="Validform_checktip">*输入<%=this.account_title%></span>
    </dd>
  </dl>
  <dl id="shop_url" runat="server" visible="false">
    <dt>店铺地址</dt>
    <dd>
      <asp:TextBox ID="txtShopUrl" runat="server" CssClass="input txt" datatype="*" sucmsg=" " ignore="ignore"></asp:TextBox>
      <span class="Validform_checktip">*例如你的淘宝店铺https://qwxxx.taobao.com/ 可留空</span>
    </dd>
  </dl>
  <dl>
    <dt>当前信誉值</dt>
    <dd>
      <asp:TextBox ID="txtXinYu" runat="server" CssClass="input txt" datatype="n" sucmsg=" " Text="0"></asp:TextBox>
      <span class="Validform_checktip">*买卖号的当前信誉值</span>
    </dd>
  </dl>
  <dl>
    <dt>是否已实名</dt>
    <dd>
      <div class="rule-single-checkbox">
          <asp:CheckBox ID="cbIsRealName" runat="server" />
      </div>
      <span class="Validform_checktip">*如果买号已经通过实名认证就选上</span>
    </dd>
  </dl>
  <dl>
    <dt>是否已加入消保</dt>
    <dd>
      <div class="rule-single-checkbox">
          <asp:CheckBox ID="dbIsXiaoBao" runat="server" />
      </div>
      <span class="Validform_checktip">*针对掌柜号如果加入消保可选中</span>
    </dd>
  </dl>
</div>

<!--/内容-->

<!--工具栏-->
<div class="page-footer">
  <div class="btn-wrap">
    <asp:Button ID="btnSubmit" runat="server" Text="提交保存" CssClass="btn" onclick="btnSubmit_Click" />
    <input name="btnReturn" type="button" value="返回上一页" class="btn yellow" onclick="javascript:history.back(-1);" />
  </div>
</div>
<!--/工具栏-->

</form>
</body>
</html>
