﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="buy_account_manage_list.aspx.cs" Inherits="SKtms.Web.admin.task.buy_account_manage_list" %>
<%@ Import namespace="SKtms.Common" %>

<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=no" />
<meta name="apple-mobile-web-app-capable" content="yes" />
<title>买号管理</title>
<link href="../../scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
<link href="../skin/default/style.css" rel="stylesheet" type="text/css" />
<link href="../../css/pagination.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" src="../../scripts/jquery/jquery-1.11.2.min.js"></script>
<script type="text/javascript" src="../../scripts/artdialog/dialog-plus-min.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/laymain.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/common.js"></script>
</head>

<body class="mainbody">
<script type="text/javascript">
$(function () {
    $(".del_link").click(function () {
        $(this).parent().parent().find(".checkall input[type='checkbox']").prop("checked", true);
        return ExePostBack('btnDelete');
    })
})
</script>
<form id="form1" runat="server">
<!--导航栏-->
<div class="location">
  <a href="javascript:history.back(-1);" class="back"><i></i><span>返回上一页</span></a>
  <a href="../center.aspx" class="home"><i></i><span>首页</span></a>
  <i class="arrow"></i>
  <span>试客系统</span>
  <i class="arrow"></i>
  <span>买号管理</span>
</div>
<!--/导航栏-->

<!--工具栏-->
<div id="floatHead" class="toolbar-wrap">
  <div class="toolbar">
    <div class="box-wrap">
      <a class="menu-btn"></a>
      <div class="l-list">
        <ul class="icon-list">
          <li><a class="add" href="account_edit.aspx?type=<%=this.account_type.ToString()%>&action=<%= BSEnums.ActionEnum.Add.ToString()%>"><i></i><span>添加</span></a></li>
          <li><a class="all" href="javascript:;" onclick="checkAll(this);"><i></i><span>全选</span></a></li>
          <li><asp:LinkButton ID="btnDelete" runat="server" CssClass="del" OnClientClick="return ExePostBack('btnDelete');" onclick="btnDelete_Click"><i></i><span>删除</span></asp:LinkButton></li>
          <li><asp:LinkButton ID="btnPause" runat="server" CssClass="lock" OnClientClick="return ExePostBack('btnPause','暂停的买号，用户可自行启动哦，是否要暂停？');" onclick="btnPause_Click"><i></i><span>暂停</span></asp:LinkButton></li>
          <li><asp:LinkButton ID="btnUnPause" runat="server" CssClass="edit" OnClientClick="return ExePostBack('btnUnPause','你确定要启用吗？(注：启用包括已经虚删除或锁定的也恢复为正常状态)');" onclick="btnUnPause_Click"><i></i><span>启用</span></asp:LinkButton></li>
          <li><asp:LinkButton ID="btnLock" runat="server" CssClass="lock" OnClientClick="return ExePostBack('btnLock','锁定的买号，用户无法再使用，是否要锁定？');" onclick="btnLock_Click"><i></i><span>锁定</span></asp:LinkButton></li>
          <li><asp:LinkButton ID="btnUnLock" runat="server" CssClass="edit" OnClientClick="return ExePostBack('btnUnLock','你确定要解锁吗？');" onclick="btnUnLock_Click"><i></i><span>解锁</span></asp:LinkButton></li>
        </ul>
        <div class="menu-list">
          <div class="rule-single-select">
            <asp:DropDownList ID="ddlShopSiteID" runat="server" AutoPostBack="True" onselectedindexchanged="ddlShopSiteID_SelectedIndexChanged">
            </asp:DropDownList>
          </div>
          <div class="rule-single-select">
            <asp:DropDownList ID="ddlStatus" runat="server" AutoPostBack="True" onselectedindexchanged="ddlStatus_SelectedIndexChanged">
                <asp:ListItem Selected="True" Value="0">选择买号状态</asp:ListItem>
                <asp:ListItem Value="1">正常买号</asp:ListItem>
                <asp:ListItem Value="2">危险买号</asp:ListItem>
                <asp:ListItem Value="3">暂停买号</asp:ListItem>
                <asp:ListItem Value="4">锁定买号</asp:ListItem>
            </asp:DropDownList>
          </div>
        </div>
      </div>
      <div class="r-list">
        <asp:TextBox ID="txtKeywords" runat="server" CssClass="keyword" />
        <asp:LinkButton ID="lbtnSearch" runat="server" CssClass="btn-search" onclick="btnSearch_Click">查询</asp:LinkButton>
      </div>
    </div>
  </div>
</div>
<!--/工具栏-->

<!--列表-->
<div class="table-container">
  <asp:Repeater ID="rptList" runat="server">
  <HeaderTemplate>
  <table width="100%" border="0" cellspacing="0" cellpadding="0" class="ltable">
      <tr>
        <th align="center" width="5%">选择</th>
        <th align="center" width="8%">所属电商</th>
        <th align="center" width="10%">用户名</th>
        <th align="center" width="">买号名</th>
        <th align="center" width="8%">目前信誉</th>
        <th align="center" width="8%">当日接手</th>
        <th align="center" width="8%">本周接手</th>
        <th align="center" width="10%">绑定时间</th>
        <th align="center" width="8%">是否实名</th>
        <th align="center" width="9%">是否收藏小号</th>
        <th align="center" width="8%">状态</th>
        <th align="center" width="6%">操作</th>
      </tr>
    </HeaderTemplate>
    <ItemTemplate>
      <tr>
        <td align="center">
          <asp:CheckBox ID="chkId" CssClass="checkall" runat="server" style="vertical-align:middle;" />
          <asp:HiddenField ID="hidId" Value='<%#Eval("id")%>' runat="server" />
        </td>
        <td align="center"><%#GetShopSiteTitle(Utils.StrToInt(Eval("shop_site_id").ToString(), 0))%></td>
        <td align="center"><%#Eval("user_name")%></td>
        <td align="center"><%#Eval("account")%></td>
        <td align="center"><%#Eval("xinyu")%></td>
        <td align="center"><%#GetDayCount(Utils.ObjToInt(Eval("shop_site_id"),0),Eval("account").ToString())%></td>
        <td align="center"><%#GetWeekCount(Utils.ObjToInt(Eval("shop_site_id"),0),Eval("account").ToString())%></td>
        <td align="center"><%#Eval("add_date")%></td>
        <td align="center"><%#Eval("is_realname").ToString()=="1"?"<img src=\"../../style/images/ShiMing.gif\" title=\"已通过实名认证\">":"否"%></td>
        <td align="center"><%#Eval("is_collect").ToString()=="1"?"是":"否"%></td>
        <td align="center"><%#GetStatus(Utils.ObjToInt(Eval("is_del"),0), Utils.ObjToInt(Eval("status"),0))%></td>
        <td align="center"><a href="account_edit.aspx?id=<%#Eval("id")%>&type=<%=this.account_type.ToString()%>&action=<%= BSEnums.ActionEnum.Edit.ToString()%>">修改</a> | <asp:LinkButton ID="btnDelete" runat="server" CssClass="del_link" onclick="btnDelete_Click"><i></i><span>删除</span></asp:LinkButton></td>
      </tr>
    </ItemTemplate>
    <FooterTemplate>
      <%#rptList.Items.Count == 0 ? "<tr><td align=\"center\" colspan=\"12\">暂无记录</td></tr>" : ""%>
    </table>
  </FooterTemplate>
  </asp:Repeater>
</div>
<!--/列表-->

<!--内容底部-->
<div class="line20"></div>
<div class="pagelist">
  <div class="l-btns">
    <span>显示</span><asp:TextBox ID="txtPageNum" runat="server" CssClass="pagenum" onkeydown="return checkNumber(event);"
                OnTextChanged="txtPageNum_TextChanged" AutoPostBack="True"></asp:TextBox><span>条/页</span>
  </div>
  <div id="PageContent" runat="server" class="default"></div>
</div>
<!--/内容底部-->

</form>
</body>
</html>
