﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="collect_manage_list.aspx.cs" Inherits="SKtms.Web.admin.task.collect_manage_list" %>
<%@ Import namespace="SKtms.Common" %>

<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=no" />
<meta name="apple-mobile-web-app-capable" content="yes" />
<title>收藏任务管理</title>
<link href="../../scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
<link href="../skin/default/style.css" rel="stylesheet" type="text/css" />
<link href="../../css/pagination.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" src="../../scripts/jquery/jquery-1.11.2.min.js"></script>
<script type="text/javascript" src="../../scripts/artdialog/dialog-plus-min.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/laymain.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/common.js"></script>
</head>

<body class="mainbody">
<script type="text/javascript">
    $(function () {
        //点击右边单个删除连接
        $(".del_link").click(function () {
            $(this).parents().find(".checkall input[type='checkbox']").prop("checked", false);
            $(this).parent().parent().find(".checkall input[type='checkbox']").prop("checked", true);
            return jsConfirm($(this), '你确定要删除吗？<br />注：删除后将返还收藏点！');
        });
        //点击右边单个完成连接
        $(".finish_link").click(function () {
            $(this).parents().find(".checkall input[type='checkbox']").prop("checked", false);
            $(this).parent().parent().find(".checkall input[type='checkbox']").prop("checked", true);
            return jsConfirm($(this), '你确定要设为完成状态吗？<br />注：完成后不可恢复！');
        });
        //绑定详细连接
        $(".detail").click(function () {
            var d = dialog({
                title: '任务详细浏览',
                width: 700,
                padding: '0 20px 10px',
                url: $(this).attr("href"),
                okValue: ' 关 闭 ',
                ok: function () { }
            }).show();
            return false;
        });
    });
</script>
<form id="form1" runat="server">
<!--导航栏-->
<div class="location">
  <a href="javascript:history.back(-1);" class="back"><i></i><span>返回上一页</span></a>
  <a href="../center.aspx" class="home"><i></i><span>首页</span></a>
  <i class="arrow"></i>
  <span>试客系统</span>
  <i class="arrow"></i>
  <span>收藏任务管理</span>
</div>
<!--/导航栏-->

<!--工具栏-->
<div id="floatHead" class="toolbar-wrap">
  <div class="toolbar">
    <div class="box-wrap">
      <a class="menu-btn"></a>
      <div class="l-list">
        <ul class="icon-list">
          <li><a class="all" href="javascript:;" onclick="checkAll(this);"><i></i><span>全选</span></a></li>
          <li><asp:LinkButton ID="btnDelete" runat="server" CssClass="del" OnClientClick="return ExePostBack('btnDelete','你确定要删除吗？<br />（注：本项删除不返还收藏点，仅删除任务！）');" onclick="btnDelete_Click"><i></i><span>删除</span></asp:LinkButton></li>
          <li><asp:LinkButton ID="btnPause" runat="server" CssClass="lock" OnClientClick="return ExePostBack('btnPause','你确定要暂停吗？');" onclick="btnPause_Click"><i></i><span>暂停</span></asp:LinkButton></li>
          <li><asp:LinkButton ID="btnUnPause" runat="server" CssClass="edit" OnClientClick="return ExePostBack('btnUnPause','你确定要启用（解除暂停）吗？');" onclick="btnUnPause_Click"><i></i><span>启用</span></asp:LinkButton></li>
          <li><asp:LinkButton ID="btnLock" runat="server" CssClass="lock" OnClientClick="return ExePostBack('btnLock','你确定要锁定吗？');" onclick="btnLock_Click"><i></i><span>锁定</span></asp:LinkButton></li>
          <li><asp:LinkButton ID="btnUnLock" runat="server" CssClass="edit" OnClientClick="return ExePostBack('btnUnLock','你确定要解锁吗？');" onclick="btnUnLock_Click"><i></i><span>解锁</span></asp:LinkButton></li>
          <li><asp:LinkButton ID="btnFinish" runat="server" CssClass="edit" OnClientClick="return ExePostBack('btnFinish','你确定要完成吗？');" onclick="btnFinish_Click"><i></i><span>完成</span></asp:LinkButton></li>
        </ul>
        <div class="menu-list">
          <div class="rule-single-select">
            <asp:DropDownList ID="ddlStatus" runat="server" AutoPostBack="True" onselectedindexchanged="ddlStatus_SelectedIndexChanged">
                <asp:ListItem Selected="True" Value="0">任务状态筛选</asp:ListItem>
                <asp:ListItem Value="1">待接手</asp:ListItem>
                <asp:ListItem Value="2">已接手</asp:ListItem>
                <asp:ListItem Value="3">已完成</asp:ListItem>
                <asp:ListItem Value="4">已锁定</asp:ListItem>
                <asp:ListItem Value="5">已暂停</asp:ListItem>

            </asp:DropDownList>
          </div>
        </div>
      </div>
      <div class="r-list">
        <div class="menu-list">
            <div class="rule-single-select">
                <asp:DropDownList ID="ddlSearchType" runat="server">
                    <asp:ListItem Selected="True" Value="">查找类型</asp:ListItem>
                    <asp:ListItem Value="1">按任务编号查找</asp:ListItem>
                    <asp:ListItem Value="2">按发布人查找</asp:ListItem>
                </asp:DropDownList>
            </div>
        </div>
        <asp:TextBox ID="txtKeywords" runat="server" CssClass="keyword" />
        <asp:LinkButton ID="lbtnSearch" runat="server" CssClass="btn-search" onclick="btnSearch_Click">查询</asp:LinkButton>
      </div>
    </div>
  </div>
</div>
<!--/工具栏-->

<!--列表-->
<div class="table-container">
  <asp:Repeater ID="rptList" runat="server">
  <HeaderTemplate>
  <table width="100%" border="0" cellspacing="0" cellpadding="0" class="ltable">
      <tr>
        <th align="center" width="5%">选择</th>
        <th align="center" width="5%">ID</th>
        <th align="center" width="8%">任务区</th>
        <th align="center" width="10%">任务编号</th>
        <th align="center" width="10%">发布人</th>
        <th align="center" width="8%">收藏类型</th>
        <th align="center" width="8%">收藏点</th>
        <th align="center" width="8%">收藏数量</th>
        <th align="center" width="8%">间隔时间</th>
        <th align="center" width="12%">发布时间</th>
        <th align="center" width="8%">状态/描述</th>
        <th align="center" width="">操作</th>
      </tr>
    </HeaderTemplate>
    <ItemTemplate>
      <tr class="msg-tr">
        <td align="center">
          <asp:CheckBox ID="chkId" CssClass="checkall" runat="server" style="vertical-align:middle;" />
          <asp:HiddenField ID="hidId" Value='<%#Eval("id")%>' runat="server" />
        </td>
        <td align="center"><%#Eval("id")%></td>
        <td align="center"><%#GetCategoryTitle(Utils.ObjToInt(Eval("category_id")))%></td>
        <td align="center"><a href="collect_jie_manage_list.aspx?keywords=<%#Eval("task_no")%>&search_type=1"><%#Eval("task_no")%></a></td>
        <td align="center"><a href="collect_manage_list.aspx?keywords=<%#Eval("user_name")%>&search_type=2"><%#Eval("user_name")%></a></td>
        <td align="center"><%#Utils.ObjToInt(Eval("collect_type")) == 1 ? "收藏店铺":"收藏宝贝"%></td>
        <td align="center"><%#Eval("point")%></td>
        <td align="center"><%#Utils.ObjToInt(Eval("complete_count"))%>/<%#Utils.ObjToInt(Eval("total_count"))%></td>
        <td align="center"><%#Eval("interval_minute")%> 分钟</td>
        <td align="center"><%#Eval("add_date")%></td>
        <td align="center"><%#GetStatusInfo(Utils.ObjToInt(Eval("id"),0))%></td>
        <td align="center">
            <a class="detail" href="collect_detail.aspx?id=<%#Eval("id")%>">详细</a> | 
            <asp:LinkButton ID="btnFinish_Right" runat="server" CssClass="finish_link" onclick="btnFinish_Right_Click"><i></i><span>完成</span></asp:LinkButton> | 
            <asp:LinkButton ID="btnDelete_Right" runat="server" CssClass="del_link" onclick="btnDelete_Right_Click"><i></i><span>删除</span></asp:LinkButton></td>
      </tr>
    </ItemTemplate>
    <FooterTemplate>
      <%#rptList.Items.Count == 0 ? "<tr><td align=\"center\" colspan=\"12\">暂无记录</td></tr>" : ""%>
    </table>
  </FooterTemplate>
  </asp:Repeater>
</div>
<!--/列表-->
<div class="line10"></div>

<!--内容底部-->
<div class="line10"></div>
<div class="pagelist">
  <div class="l-btns">
    <span>显示</span><asp:TextBox ID="txtPageNum" runat="server" CssClass="pagenum" onkeydown="return checkNumber(event);"
                OnTextChanged="txtPageNum_TextChanged" AutoPostBack="True"></asp:TextBox><span>条/页</span>
  </div>
  <div id="PageContent" runat="server" class="default"></div>
</div>
<!--/内容底部-->

</form>
</body>
</html>