﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="task_manage_list.aspx.cs" Inherits="SKtms.Web.admin.task.task_manage_list" %>
<%@ Import namespace="SKtms.Common" %>

<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=no" />
<meta name="apple-mobile-web-app-capable" content="yes" />
<title>任务管理</title>
<link href="../../scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
<link href="../skin/default/style.css" rel="stylesheet" type="text/css" />
<link href="../../css/pagination.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" src="../../scripts/jquery/jquery-1.11.2.min.js"></script>
<script type="text/javascript" src="../../scripts/artdialog/dialog-plus-min.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/laymain.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/common.js"></script>
</head>

<body class="mainbody">
<script type="text/javascript">
    $(function () {
        //点击右边单个删除连接
        $(".del_link").click(function () {
            $(this).parents().find(".checkall input[type='checkbox']").prop("checked", false);
            $(this).parent().parent().find(".checkall input[type='checkbox']").prop("checked", true);
            return jsConfirm($(this), '你确定要删除吗？<br />注：删除会退回任务担保金和发布点。 (红包和远程代付不返）');
        });
        //绑定详细连接
        $(".detail").click(function () {
            var d = dialog({
                title: '任务详细浏览',
                width: 700,
                padding: '0 20px 10px',
                url: $(this).attr("href"),
                okValue: ' 关 闭 ',
                ok: function () { }
            }).show();
            return false;
        });

        //锁定和解锁
        $("#btnLock, #btnUnLock").click(function () {
            if ($(".checkall input:checked").size() < 1) {
                parent.dialog({
                    title: '提示',
                    content: '对不起，请选中您要操作的记录！',
                    okValue: '确定',
                    ok: function () { }
                }).showModal();
                return false;
            }
            var msg = $(this).attr("date-title");
            var d = dialog({
                title: msg,
                content: '填写备注：<textarea id="remark" rows="3" cols="30"></textarea>',
                okValue: '确定',
                ok: function () {
                    var value = $('#remark').val() != ""? $('#remark').val() : "'";   //'号会被过滤，此只为方便判断
                    this.close(value);
                    this.remove();
                },
                cancelValue: '取消',
                cancel: function () { }
            });
            var _href = $(this).attr("href");
            d.addEventListener('close', function () {
                if (this.returnValue != '') {
                    $("#txtRemark").val(this.returnValue);
                    location.href = _href;
                }
            });
            d.show();
            return false;
        });
        //设为已接手
        $("#LinkButton1").click(function () {
            if ($(".checkall input:checked").size() < 1) {
                parent.dialog({
                    title: '提示',
                    content: '对不起，请选中您要操作的记录！',
                    okValue: '确定',
                    ok: function () { }
                }).showModal();
                return false;
            }
            var d = dialog({
                title: '输入接手信息',
                content: '接手人账号：<input id="buy_user_name" value="" /><br/><br/>接手的买号：<input id="buy_nick_name" value="" />',
                okValue: '确定',
                ok: function () {
                    var value = { username: $('#buy_user_name').val(), nickname: $('#buy_nick_name').val() };
                    this.close(value);
                    this.remove();
                },
                cancelValue: '取消',
                cancel: function () { }
            });
            var _href = $(this).attr("href");
            d.addEventListener('close', function () {
                if (this.returnValue != null && typeof (this.returnValue) == "object") {
                    $("#txtBuyUserName").val(this.returnValue.username);
                    $("#txtBuyNickName").val(this.returnValue.nickname);
                    location.href = _href;
                }
            });
            d.show();
            return false;
        });
        //表格点击显示下一隐藏列
        $(".msg-tr").click(function () {
            $(this).next().addClass("odd_bg").toggle();
        });
    });
</script>
<form id="form1" runat="server">
<!--导航栏-->
<div class="location">
  <a href="javascript:history.back(-1);" class="back"><i></i><span>返回上一页</span></a>
  <a href="../center.aspx" class="home"><i></i><span>首页</span></a>
  <i class="arrow"></i>
  <span>试客系统</span>
  <i class="arrow"></i>
  <span><%=category_title%>任务管理</span>
</div>
<!--/导航栏-->

<!--工具栏-->
<div id="floatHead" class="toolbar-wrap">
  <div class="toolbar">
    <div class="box-wrap">
      <a class="menu-btn"></a>
      <div class="l-list">
        <ul class="icon-list">
          <li><a class="all" href="javascript:;" onclick="checkAll(this);"><i></i><span>全选</span></a></li>
          <li><asp:LinkButton ID="btnDelete" runat="server" CssClass="del" OnClientClick="return ExePostBack('btnDelete','你确定要删除吗？<br />（注：本项删除不退还担保金和发布点，仅删除任务！）');" onclick="btnDelete_Click"><i></i><span>删除</span></asp:LinkButton></li>
          <li><asp:LinkButton ID="btnPause" runat="server" CssClass="lock" OnClientClick="return ExePostBack('btnPause','你确定要暂停吗？');" onclick="btnPause_Click"><i></i><span>暂停</span></asp:LinkButton></li>
          <li><asp:LinkButton ID="btnUnPause" runat="server" CssClass="edit" OnClientClick="return ExePostBack('btnUnPause','你确定要启用（解除暂停）吗？');" onclick="btnUnPause_Click"><i></i><span>启用</span></asp:LinkButton></li>
          <li><asp:LinkButton ID="btnLock" runat="server" CssClass="lock" date-title="你确定要锁定吗？" onclick="btnLock_Click"><i></i><span>锁定</span></asp:LinkButton><asp:HiddenField ID="txtRemark" runat="server" /></li>
          <li><asp:LinkButton ID="btnUnLock" runat="server" CssClass="edit" date-title="你确定要解锁吗？" onclick="btnUnLock_Click"><i></i><span>解锁</span></asp:LinkButton></li>
          <li><asp:LinkButton ID="btnUnAudit" runat="server" CssClass="lock" OnClientClick="return ExePostBack('btnUnAudit','把任务设为需要客服后台审核，任务大厅不显示该任务！');" onclick="btnUnAudit_Click"><i></i><span>拦截</span></asp:LinkButton></li>
          <li><asp:LinkButton ID="btnAudit" runat="server" CssClass="edit" OnClientClick="return ExePostBack('btnAudit','你确定审核放行吗！<br />(针对发布大额快速收货任务需要后台审核后，任务大厅才显示)');" onclick="btnAudit_Click"><i></i><span>放行</span></asp:LinkButton></li>
        </ul>
        <div class="menu-list">
          <div class="rule-single-select">
            <asp:DropDownList ID="ddlStatus" runat="server" AutoPostBack="True" onselectedindexchanged="ddlStatus_SelectedIndexChanged">
                <asp:ListItem Selected="True" Value="0">任务状态筛选</asp:ListItem>
                <asp:ListItem Value="1">等待审核放行</asp:ListItem>
                <asp:ListItem Value="2">等待接手</asp:ListItem>
                <asp:ListItem Value="3">等待支付</asp:ListItem>
                <asp:ListItem Value="4">等待发货</asp:ListItem>
                <asp:ListItem Value="5">等待收货好评</asp:ListItem>
                <asp:ListItem Value="6">等待确认审核</asp:ListItem>
                <asp:ListItem Value="7">等待追加好评</asp:ListItem>
                <asp:ListItem Value="8">等待审核追加好评</asp:ListItem>
                <asp:ListItem Value="9">已完成</asp:ListItem>
                <asp:ListItem Value="10">已评价</asp:ListItem>
                <asp:ListItem Value="11">已锁定</asp:ListItem>
                <asp:ListItem Value="12">已暂停</asp:ListItem>

            </asp:DropDownList>
          </div>
          <div class="rule-single-select">
            <asp:DropDownList ID="ddlXuShiType" runat="server" AutoPostBack="True" onselectedindexchanged="ddlXuShiType_SelectedIndexChanged">
                <asp:ListItem Selected="True" Value="0">任务类型筛选</asp:ListItem>
                <asp:ListItem Value="1">虚拟任务</asp:ListItem>
                <asp:ListItem Value="2">实物任务</asp:ListItem>
                <asp:ListItem Value="3">套餐任务</asp:ListItem>
                <asp:ListItem Value="4">快递任务</asp:ListItem>
            </asp:DropDownList>
          </div>
        </div>
      </div>
      <div class="r-list">
        <div class="menu-list">
            <div class="rule-single-select">
                <asp:DropDownList ID="ddlSearchType" runat="server">
                    <asp:ListItem Selected="True" Value="">查找类型</asp:ListItem>
                    <asp:ListItem Value="1">按任务编号查找</asp:ListItem>
                    <asp:ListItem Value="6">按任务id查找</asp:ListItem>
                    <asp:ListItem Value="2">按发布人查找</asp:ListItem>
                    <asp:ListItem Value="3">按掌柜号查找</asp:ListItem>
                    <asp:ListItem Value="4">按接手人查找</asp:ListItem>
                    <asp:ListItem Value="5">按接手买号查找</asp:ListItem>
                </asp:DropDownList>
            </div>
        </div>
        <asp:TextBox ID="txtKeywords" runat="server" CssClass="keyword" />
        <asp:LinkButton ID="lbtnSearch" runat="server" CssClass="btn-search" onclick="btnSearch_Click">查询</asp:LinkButton>
      </div>
    </div>
  </div>
</div>
<!--/工具栏-->

<!--列表-->
<div class="table-container">
  <asp:Repeater ID="rptList" runat="server">
  <HeaderTemplate>
  <table width="100%" border="0" cellspacing="0" cellpadding="0" class="ltable">
      <tr>
        <th align="center" width="5%">选择</th>
        <th align="center" width="5%">ID</th>
        <th align="center" width="9%">所属电商</th>
        <th align="center" width="9%">用户名</th>
        <th align="center" width="10%">掌柜名</th>
        <th align="center" width="8%">任务价格(元)</th>
        <th align="center" width="7%">发布点</th>
        <th align="center" width="10%">发布时间</th>
        <th align="center" width="8%">任务时限</th>
        <th align="center" width="">接手人</th>
        <th align="center" width="11%">状态/描述</th>
        <th align="center" width="6%">操作</th>
      </tr>
    </HeaderTemplate>
    <ItemTemplate>
      <tr class="msg-tr">
        <td align="center">
          <asp:CheckBox ID="chkId" CssClass="checkall" runat="server" style="vertical-align:middle;" />
          <asp:HiddenField ID="hidId" Value='<%#Eval("id")%>' runat="server" />
        </td>
        <td align="center"><%#Eval("id")%></td>
        <td align="center"><%#GetShopSiteTitle(Utils.ObjToInt(Eval("shop_site_id").ToString(), 0))%><%#GetXushiIco(Utils.ObjToInt(Eval("xushi_type"),0), Utils.ObjToInt(Eval("is_shop_cart"),0))%></td>
        <td align="center"><a href="task_manage_list.aspx?channel_id=<%=this.channel_id%>&id=<%=this.category_id%>&keywords=<%#Eval("user_name")%>&search_type=2"><%#Eval("user_name")%></a></td>
        <td align="center"><a href="task_manage_list.aspx?channel_id=<%=this.channel_id%>&id=<%=this.category_id%>&keywords=<%#Eval("shop_name")%>&search_type=3"><%#Eval("shop_name")%></a></td>
        <td align="center"><img src="../../style/images/gold_ico.gif" align="absmiddle" title="担保金"> <%#Eval("price")%></td>
        <td align="center"><%#Eval("point")%></td>
        <td align="center"><%#Eval("add_date")%></td>
        <td align="center"><%#GetHaopingLimitTitle(Utils.ObjToInt(Eval("haoping_limit").ToString(),0), Utils.ObjToInt(Eval("shop_dynamic").ToString(),0), Eval("haoping_content").ToString())%></td>
        <td align="center"><%#Eval("buy_user_name")%><%#(Eval("buy_nick_name").ToString()!="")?" <span class=\"red\">[买号:"+ Eval("buy_nick_name").ToString() + "]</span>":""%></td>
        <td align="center"><%#GetStatusInfo(Utils.ObjToInt(Eval("id"),0))%></td>
        <td align="center"><a class="detail" href="task_detail.aspx?channel_id=<%=this.channel_id%>&category_id=<%=this.category_id%>&id=<%#Eval("id")%>">详细</a> | <asp:LinkButton ID="btnDelete_Right" runat="server" CssClass="del_link" onclick="btnDelete_Right_Click"><i></i><span>删除</span></asp:LinkButton></td>
      </tr>
      <tr style="display:none">
      <td colspan="12" align="left">&nbsp; 
          任务编号：<%#Eval("task_no").ToString()%>　　
          标题：<%#Eval("title")%>　　
          商品数量：<%#Eval("product_count")%>　　
          总发布点：<%#Eval("total_point")%>　　
          发布IP：<%#Eval("add_user_ip")%>　　
          接手人IP：<%#Eval("buy_user_ip")%>　　
          接手时间：<%#Eval("buy_date")%>　　
          支付时间：<%#Eval("pay_date")%>　　
          发货时间：<%#Eval("delivery_date")%>　　
          好评时间：<%#Eval("haoping_date")%>　　
          完成时间：<%#Eval("end_date")%>
          <%#(!string.IsNullOrWhiteSpace(Eval("add_haoping_date").ToString())) ? "　　追加好评时间："+ Eval("add_haoping_date").ToString() : ""%>
          <%#(!string.IsNullOrWhiteSpace(Eval("remark").ToString())) ? "<br />&nbsp; <span style=\"color:red;\">备注(仅后台管理人员可见)：" + Eval("remark") + "</span>" : ""%>
      </td>
  </tr>
    </ItemTemplate>
    <FooterTemplate>
      <%#rptList.Items.Count == 0 ? "<tr><td align=\"center\" colspan=\"12\">暂无记录</td></tr>" : ""%>
    </table>
  </FooterTemplate>
  </asp:Repeater>
</div>
<!--/列表-->
<div class="line10"></div>

<!--底部按钮组-->
<div class="toolbar">
    <div class="box-wrap">
      <a class="menu-btn"></a>
      <div class="l-list">
        <ul class="icon-list">
            <li><a class="all" href="javascript:;" onclick="checkAll(this);"><i></i><span>全选</span></a></li>
            <li><asp:LinkButton ID="LinkButton" runat="server" CssClass="save" OnClientClick="return ExePostBack('LinkButton','您确定要将选中的任务“设未接手”吗？');" onclick="btnSetStatus_Click" CommandArgument="0"><i></i><span>设未接手</span></asp:LinkButton></li>
            <li><asp:LinkButton ID="LinkButton1" runat="server" CssClass="save" onclick="btnSetStatus_Click" CommandArgument="1"><i></i><span>设已接手</span></asp:LinkButton>
                <asp:HiddenField ID="txtBuyUserName" runat="server" />
                <asp:HiddenField ID="txtBuyNickName" runat="server" />
            </li>
            <li><asp:LinkButton ID="LinkButton2" runat="server" CssClass="save" OnClientClick="return ExePostBack('LinkButton2','您确定要将选中的任务“设已支付”吗？');" onclick="btnSetStatus_Click" CommandArgument="2"><i></i><span>设已支付</span></asp:LinkButton></li>
            <li><asp:LinkButton ID="LinkButton3" runat="server" CssClass="save" OnClientClick="return ExePostBack('LinkButton3','您确定要将选中的任务“设已发货”吗？');" onclick="btnSetStatus_Click" CommandArgument="3"><i></i><span>设已发货</span></asp:LinkButton></li>
            <li><asp:LinkButton ID="LinkButton4" runat="server" CssClass="save" OnClientClick="return ExePostBack('LinkButton4','您确定要将选中的任务“设已收货”吗？');" onclick="btnSetStatus_Click" CommandArgument="4"><i></i><span>设已收货</span></asp:LinkButton></li>
            <li><asp:LinkButton ID="LinkButton5" runat="server" CssClass="save" OnClientClick="return ExePostBack('LinkButton5','本功能为了方便自己人假刷，不用产生资金记录等而设，仅把任务设为审核，不返还资金和发布点的；<br />（如需要返还资金和发布点，请点击右边“设已审核并放款”）');" onclick="btnSetStatus_Click" CommandArgument="5"><i></i><span>设已审核</span></asp:LinkButton></li>
            <li><asp:LinkButton ID="LinkButton6" runat="server" CssClass="save" OnClientClick="return ExePostBack('LinkButton6','您确定要将选中的任务“设已审核并放款”吗？');" onclick="btnSetStatus_Click" CommandArgument="6"><i></i><span>设已审核并放款</span></asp:LinkButton></li>
            <li><asp:LinkButton ID="LinkButton7" runat="server" CssClass="save" OnClientClick="return ExePostBack('LinkButton7','您确定要将选中的任务“设已追加好评”吗？');" onclick="btnSetStatus_Click" CommandArgument="7"><i></i><span>设已追加好评</span></asp:LinkButton></li>
            <li><asp:LinkButton ID="LinkButton8" runat="server" CssClass="save" OnClientClick="return ExePostBack('LinkButton8','您确定要将选中的任务“设已审核追评”吗？');" onclick="btnSetStatus_Click" CommandArgument="8"><i></i><span>设已审核追评</span></asp:LinkButton></li>
            <li><asp:LinkButton ID="LinkButton9" runat="server" CssClass="save" OnClientClick="return ExePostBack('LinkButton9','您确定要将选中的任务“设已互评价”吗？');" onclick="btnSetStatus_Click" CommandArgument="9"><i></i><span>设已互评价</span></asp:LinkButton></li>
        </ul>        
      </div>      
    </div>
  </div>
<!--/底部按钮组-->

<!--内容底部-->
<div class="line10"></div>
<div class="pagelist">
  <div class="l-btns">
    <span>显示</span><asp:TextBox ID="txtPageNum" runat="server" CssClass="pagenum" onkeydown="return checkNumber(event);"
                OnTextChanged="txtPageNum_TextChanged" AutoPostBack="True"></asp:TextBox><span>条/页</span>
  </div>
  <div id="PageContent" runat="server" class="default"></div>
</div>
<!--/内容底部-->

</form>
</body>
</html>
