﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="apply_list.aspx.cs" Inherits="SKtms.Web.admin.trial.apply_list" %>
<%@ Import namespace="SKtms.Common" %>

<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=no" />
<meta name="apple-mobile-web-app-capable" content="yes" />
<title>试用申请管理</title>
<link href="../../scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
<link href="../skin/default/style.css" rel="stylesheet" type="text/css" />
<link href="../../css/pagination.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" src="../../scripts/jquery/jquery-1.11.2.min.js"></script>
<script type="text/javascript" src="../../scripts/artdialog/dialog-plus-min.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/laymain.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/common.js"></script>
</head>

<body class="mainbody">
<script type="text/javascript">
$(function () {
    $(".del_link").click(function () {
        $(this).parent().parent().find(".checkall input[type='checkbox']").prop("checked", true);
        return ExePostBack('btnDelete');
    })
})
</script>
<form id="form1" runat="server">
<!--导航栏-->
<div class="location">
  <a href="javascript:history.back(-1);" class="back"><i></i><span>返回上一页</span></a>
  <a href="../center.aspx" class="home"><i></i><span>首页</span></a>
  <i class="arrow"></i>
  <span>试客系统</span>
  <i class="arrow"></i>
  <span><%=category_title%>试用申请管理</span>
</div>
<!--/导航栏-->

<!--工具栏-->
<div id="floatHead" class="toolbar-wrap">
  <div class="toolbar">
    <div class="box-wrap">
      <a class="menu-btn"></a>
      <div class="l-list">
        <ul class="icon-list">
          <li><a class="all" href="javascript:;" onclick="checkAll(this);"><i></i><span>全选</span></a></li>
          <li><asp:LinkButton ID="btnDelete" runat="server" CssClass="del" OnClientClick="return ExePostBack('btnDelete');" onclick="btnDelete_Click"><i></i><span>删除</span></asp:LinkButton></li>
          <li><asp:LinkButton ID="btnSet" runat="server" CssClass="save" OnClientClick="return ExePostBack('btnSet','您确定同意通过申请吗？<br>注：同意后会创建试用订单记录，且无法再变更其他状态！');" CommandArgument="1" OnCommand="btnSet_Click"><i></i><span>同意</span></asp:LinkButton></li>
          <li><asp:LinkButton ID="btnSet2" runat="server" CssClass="lock" OnClientClick="return ExePostBack('btnSet2','您确定要拒绝申请吗？');" CommandArgument="2" OnCommand="btnSet_Click"><i></i><span>拒绝</span></asp:LinkButton></li>
          <li><asp:LinkButton ID="btnSet3" runat="server" CssClass="edit" OnClientClick="return ExePostBack('btnSet3','您确定要设置为待审批状态吗？');" CommandArgument="0" OnCommand="btnSet_Click"><i></i><span>设待审</span></asp:LinkButton></li>
          <li><asp:LinkButton ID="btnSet4" runat="server" CssClass="edit" OnClientClick="return ExePostBack('btnSet4','您确定要设置为失效状态吗？');" CommandArgument="4" OnCommand="btnSet_Click"><i></i><span>设失效</span></asp:LinkButton></li>
        </ul>
        <div class="menu-list">
          <div class="rule-single-select">
            <asp:DropDownList ID="ddlStatus" runat="server" AutoPostBack="True" onselectedindexchanged="ddlStatus_SelectedIndexChanged">
              <asp:ListItem Value="" Selected="True">筛选状态</asp:ListItem>
              <asp:ListItem Value="1">待审核</asp:ListItem>
              <asp:ListItem Value="2">同意</asp:ListItem>
              <asp:ListItem Value="3">拒绝</asp:ListItem>
              <asp:ListItem Value="5">失效</asp:ListItem>
              <asp:ListItem Value="4">主动取消</asp:ListItem>
            </asp:DropDownList>
          </div>
        </div>
      </div>
      <div class="r-list">
        <asp:TextBox ID="txtKeywords" runat="server" CssClass="keyword" />
        <asp:LinkButton ID="lbtnSearch" runat="server" CssClass="btn-search" onclick="btnSearch_Click">查询</asp:LinkButton>
      </div>
    </div>
  </div>
</div>
<!--/工具栏-->

<!--列表-->
<div class="table-container">
  <asp:Repeater ID="rptList" runat="server">
  <HeaderTemplate>
  <table width="100%" border="0" cellspacing="0" cellpadding="0" class="ltable">
      <tr>
        <th align="center" width="4%">选择</th>
        <th align="center" width="5%">ID</th>
        <th align="center" width="6%">试用区</th>
        <th align="center" width="6%">商品图片</th>
        <th align="center" width="10%">标题/价格</th>
        <th align="center" width="10%">商家账号</th>
        <th align="center" width="11%">店铺名</th>
        <th align="center" width="16%">试客账号/买号</th>
        <th align="center" width="12%">统计</th>
        <th align="center" width="12%">申请/审批时间</th>
        <th align="center" width="8%">状态</th>
      </tr>
    </HeaderTemplate>
    <ItemTemplate>
      <tr>
        <td align="center">
          <asp:CheckBox ID="chkId" CssClass="checkall" runat="server" style="vertical-align:middle;" />
          <asp:HiddenField ID="hidId" Value='<%#Eval("id")%>' runat="server" />
        </td>
        <td align="center"><%#Eval("id")%></td>
        <td align="center"><%#GetCategoryTitle(Utils.ObjToInt(Eval("category_id").ToString(), 0))%></td>
        <td align="center"><a href="<%#new SKtms.Web.UI.BasePage().linkurl("try_item", Eval("product_id"))%>" target="_blank" title="点击看大图"><img src="<%#Eval("product_pic")%>" width="40" height="40" /></a></td>
        <td align="left"><a href="<%#new SKtms.Web.UI.BasePage().linkurl("try_item", Eval("product_id"))%>" target="_blank" title="点击看试用详情"><span title="<%#Eval("title") %>"><%#Utils.CutString(Eval("title").ToString(),40)%></a><br /><span class="orange">￥<%#Eval("price")%> 元</span></span></td>
        <td align="center"><a href="apply_list.aspx?channel_id=<%=this.channel_id%>&id=<%=this.category_id%>&keywords=<%#Eval("user_name")%>"><%#Eval("user_name")%></a></td>
        <td align="center"><a href="apply_list.aspx?channel_id=<%=this.channel_id%>&id=<%=this.category_id%>&keywords=<%#Eval("shop_name")%>"><%#Eval("shop_name")%></a></td>
        <td align="center"><a href="apply_list.aspx?channel_id=<%=this.channel_id%>&id=<%=this.category_id%>&keywords=<%#Eval("buyer_user_name")%>"><%#Eval("buyer_user_name")%></a>：
            <a href="apply_list.aspx?channel_id=<%=this.channel_id%>&id=<%=this.category_id%>&keywords=<%#Eval("buyer_nick_name")%>"><span class="orange"><%#Eval("buyer_nick_name")%></span></a>
            <br><span class="green" title="<%#Eval("user_ip")%>"><%#GetUserIPInfo(Eval("user_ip").ToString()) %></span></td>
        <td align="center"><%#GetApplyCount(Container.DataItem)%></td>
        <td align="center"><%#Eval("apply_date")%><br><%#Eval("audit_date")!=null ? Eval("audit_date") : "--"%></td>
        <td align="center"><%#GetStatus(Utils.ObjToInt(Eval("status")))%></td>
      </tr>
    </ItemTemplate>
    <FooterTemplate>
      <%#rptList.Items.Count == 0 ? "<tr><td align=\"center\" colspan=\"12\">暂无记录</td></tr>" : ""%>
    </table>
  </FooterTemplate>
  </asp:Repeater>
</div>
<!--/列表-->

<!--内容底部-->
<div class="line20"></div>
<div class="pagelist">
  <div class="l-btns">
    <span>显示</span><asp:TextBox ID="txtPageNum" runat="server" CssClass="pagenum" onkeydown="return checkNumber(event);"
                OnTextChanged="txtPageNum_TextChanged" AutoPostBack="True"></asp:TextBox><span>条/页</span>
  </div>
  <div id="PageContent" runat="server" class="default"></div>
</div>
<!--/内容底部-->

</form>
</body>
</html>
