﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="pingjia_list.aspx.cs" Inherits="SKtms.Web.admin.trial.pingjia_list" %>
<%@ Import namespace="SKtms.Common" %>


<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=no" />
<meta name="apple-mobile-web-app-capable" content="yes" />
<title>评价管理</title>
<link href="../../scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
<link href="../skin/default/style.css" rel="stylesheet" type="text/css" />
<link href="../../css/pagination.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" charset="utf-8" src="../../scripts/jquery/jquery-1.11.2.min.js"></script>
<script type="text/javascript" charset="utf-8" src="../../scripts/artdialog/dialog-plus-min.js"></script>
<script type="text/javascript" charset="utf-8" src="../../scripts/datepicker/WdatePicker.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/laymain.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/common.js"></script>
</head>

<body class="mainbody">
<form id="form1" runat="server">
<!--导航栏-->
<div class="location">
  <a href="javascript:history.back(-1);" class="back"><i></i><span>返回上一页</span></a>
  <a href="../center.aspx" class="home"><i></i><span>首页</span></a>
  <i class="arrow"></i>
  <span>试客系统</span>
  <i class="arrow"></i>
  <span><%=category_title%>评价管理</span>
</div>
<!--/导航栏-->

<!--工具栏-->
<div id="floatHead" class="toolbar-wrap">
  <div class="toolbar">
    <div class="box-wrap">
      <a class="menu-btn"></a>
      <div class="l-list">
        <ul class="icon-list">
          <li><a class="all" href="javascript:;" onclick="checkAll(this);"><i></i><span>全选</span></a></li>
          <li><asp:LinkButton ID="btnDelete" runat="server" CssClass="del" OnClientClick="return ExePostBack('btnDelete');" onclick="btnDelete_Click"><i></i><span>删除</span></asp:LinkButton></li>
        </ul>
      </div>
<%--  <div class="r-list">
        <asp:TextBox ID="txtKeywords" runat="server" CssClass="keyword" />
        <asp:LinkButton ID="lbtnSearch" runat="server" CssClass="btn-search" onclick="btnSearch_Click">查询</asp:LinkButton>
      </div>--%>
    </div>
  </div>
</div>
<!--/工具栏-->

<!--查询栏-->
<script type="text/javascript">
    $(function () {            
        if ('<%=QAction%>' == "Advanced") {
            $("#AdvancedSelect option[value='<%=QType%>']").attr("selected", true);
        }
        $("#AdvancedQuery").click(function () {
            location.href = "pingjia_list.aspx?id=<%=category_id%>&channel_id=<%=channel_id%>&QAction=Advanced&QType=" + $("#AdvancedSelect").children('option:selected').val() + "&keywords=" + $("#txtKeywords").val();
        })
        $("#TimeSpandQuery").click(function () {
            location.href = "pingjia_list.aspx?id=<%=category_id%>&channel_id=<%=channel_id%>&QAction=TimeSpan&TimeStart=" + $("#timeStart").val() + "&timeEnd=" + $("#timeEnd").val() + "&keywords=" + $("#txtKeywords2").val();
        })

        $(".del_link").click(function () {
            $(this).parent().parent().find(".checkall input[type='checkbox']").prop("checked",true);
            return ExePostBack('btnDelete');
        })
    });
</script>
<div class="search_bar">
    <div class="list_item">
        高级查询：
        <div class="rule-single-select">
        <select id="AdvancedSelect" class="select">
            <option value="2"<%=(QAction == "Advanced" && QType == "2")? " selected": ""%>>试用编号</option> 
            <option value="3"<%=(QAction == "Advanced" && QType == "3")? " selected": ""%>>用户名（包含以下三种）</option>
            <option value="4"<%=(QAction == "Advanced" && QType == "4")? " selected": ""%>>来自买家的用户名</option>
            <option value="5"<%=(QAction == "Advanced" && QType == "5")? " selected": ""%>>来自商家的用户名</option>
            <option value="6"<%=(QAction == "Advanced" && QType == "6")? " selected": ""%>>给他人评价的用户名</option>
        </select>
        </div>
        <asp:TextBox ID="txtKeywords" runat="server" CssClass="input small100" />
        <input id="AdvancedQuery" name="AdvancedQuery" type="button" class="btn" value="查询" />
    </div>
    <div class="list_item">
        按时间段查询：
        开始时间：
        <%if(timeStart==""){%>
        <input name="timeStart" id="timeStart" type="text" class="input small100" onfocus="WdatePicker({dateFmt:'yyyy-MM-dd'});" value='<%=DateTime.Now.AddDays(-30).ToString("yyyy-MM-dd")%>'/>
        <%}else{%>
        <input name="timeStart" id="timeStart" type="text" class="input small100" onfocus="WdatePicker({dateFmt:'yyyy-MM-dd'});" value='<%=Utils.StrToDateTime(timeStart).ToString("yyyy-MM-dd")%>' />
        <%}%>
        结束时间：        
        <%if(timeEnd==""){%>
        <input name="timeEnd" id="timeEnd" type="text" class="input small100" onfocus="WdatePicker({dateFmt:'yyyy-MM-dd'});" value='<%=DateTime.Now.ToString("yyyy-MM-dd")%>'/>
        <%}else{%>
        <input name="timeEnd" id="timeEnd" type="text" class="input small100" onfocus="WdatePicker({dateFmt:'yyyy-MM-dd'});" value='<%=Utils.StrToDateTime(timeEnd).ToString("yyyy-MM-dd")%>' />
        <%}%>
        用户名：
        <asp:TextBox ID="txtKeywords2" runat="server" CssClass="input small100" />
        <input id="TimeSpandQuery" name="TimeSpandQuery" type="button" class="btn" value="查询" />
    </div>
</div>
<!--查询栏-->

<!--列表-->
<div class="line10"></div>
<div class="table-container">
<asp:Repeater ID="rptList" runat="server">
<HeaderTemplate>
<table width="100%" border="0" cellspacing="0" cellpadding="0" class="ltable">
  <tr>
    <th width="5%">选择</th>
    <th width="12%">试用编号</th>
    <th width="8%">试用区</th>
    <th width="10%">评价人</th>
    <th width="7%">身份</th>
    <th width="10%">被评价人</th>
    <th width="7%">评分</th>
    <th width="12%">评价时间</th>
    <th width="">评价内容</th>
    <th width="10%">操作</th>
  </tr>
</HeaderTemplate>
<ItemTemplate>
  <tr>
    <td align="center">
        <asp:CheckBox ID="chkId" CssClass="checkall" runat="server" />
        <asp:HiddenField ID="hidId" Value='<%#Eval("id")%>' runat="server" />
    </td>
    <td align="center"><%#Eval("task_no")%></td>
    <td align="center"><%#get_task_area(Utils.ObjToInt(Eval("channel_id")), Utils.ObjToInt(Eval("category_id")))%></td>
    <td align="center"><%#Eval("user_name")%></td>
    <td align="center"><%#Eval("user_type").ToString()=="1"? "卖家": "买家"%></td>
    <td align="center"><%#Eval("friend_name")%></td>
    <td align="center"><%#get_pingjia_type_str(Utils.ObjToInt((Eval("pingjia_type"))))%></td>
    <td align="center"><%#Eval("add_time","{0:yyyy-MM-dd HH:mm:ss}")%></td>
    <td align="center"><%#Eval("content")%><%#get_reply_content_str(Utils.ObjectToStr(Eval("reply_content"))) %></td>
    <td align="center"><asp:LinkButton ID="btnDelete" runat="server" CssClass="del_link" onclick="btnDelete_Click"><i></i><span>删除</span></asp:LinkButton>&nbsp;&nbsp;|&nbsp;&nbsp;<a href="pingjia_edit.aspx?action=<%#BSEnums.ActionEnum.Edit%>&id=<%#Eval("id")%>&channel_id=<%#Eval("channel_id")%>&category_id=<%#Eval("category_id")%>">查看</a></td>
  </tr>
</ItemTemplate>
<FooterTemplate>
  <%#rptList.Items.Count == 0 ? "<tr><td align=\"center\" colspan=\"10\">暂无记录</td></tr>" : ""%>
</table>
</FooterTemplate>
</asp:Repeater>
</div>
<!--/列表-->

<!--内容底部-->
<div class="line20"></div>

<div class="pagelist">
  <div class="l-btns">
    <span>显示</span><asp:TextBox ID="txtPageNum" runat="server" CssClass="pagenum" onkeydown="return checkNumber(event);"
                OnTextChanged="txtPageNum_TextChanged" AutoPostBack="True"></asp:TextBox><span>条/页</span>
  </div>
  <div id="PageContent" runat="server" class="default"></div>
</div>
<div class="line20"></div>
<div class="foot_del_bar">
    特别提醒： 信用评价记录不可以轻易删除，会影响到所有用户的信誉评价！ 
</div>
<!--/内容底部-->
</form>
</body>
</html>
