﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="report_list.aspx.cs" Inherits="SKtms.Web.admin.trial.report_list" %>
<%@ Import namespace="SKtms.Common" %>

<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=no" />
<meta name="apple-mobile-web-app-capable" content="yes" />
<title>试用报告管理</title>
<link href="../../scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
<link href="../skin/default/style.css" rel="stylesheet" type="text/css" />
<link href="../../css/pagination.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" src="../../scripts/jquery/jquery-1.11.2.min.js"></script>
<script type="text/javascript" src="../../scripts/artdialog/dialog-plus-min.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/laymain.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/common.js"></script>
</head>

<body class="mainbody">
<script type="text/javascript">
$(function () {
    $(".del_link").click(function () {
        $(this).parent().parent().find(".checkall input[type='checkbox']").prop("checked", true);
        return ExePostBack('btnDelete');
    })
})
</script>
<form id="form1" runat="server">
<!--导航栏-->
<div class="location">
  <a href="javascript:history.back(-1);" class="back"><i></i><span>返回上一页</span></a>
  <a href="../center.aspx" class="home"><i></i><span>首页</span></a>
  <i class="arrow"></i>
  <span>试客系统</span>
  <i class="arrow"></i>
  <span><%=category_title%>试用报告管理</span>
</div>
<!--/导航栏-->

<!--工具栏-->
<div id="floatHead" class="toolbar-wrap">
  <div class="toolbar">
    <div class="box-wrap">
      <a class="menu-btn"></a>
      <div class="l-list">
        <ul class="icon-list">
          <li><a class="all" href="javascript:;" onclick="checkAll(this);"><i></i><span>全选</span></a></li>
          <li><asp:LinkButton ID="btnDelete" runat="server" CssClass="del" OnClientClick="return ExePostBack('btnDelete');" onclick="btnDelete_Click"><i></i><span>删除</span></asp:LinkButton></li>
          <li><asp:LinkButton ID="btnLock" runat="server" CssClass="lock" OnClientClick="return ExePostBack('btnLock','屏蔽后在前台报告页面中不会显示，是否确定？');" onclick="btnLock_Click"><i></i><span>屏蔽</span></asp:LinkButton></li>
          <li><asp:LinkButton ID="btnUnLock" runat="server" CssClass="save" OnClientClick="return ExePostBack('btnUnLock','启用后才可在前台显示，是否确定？');" onclick="btnUnLock_Click"><i></i><span>启用</span></asp:LinkButton></li>
          <li><asp:LinkButton ID="btnRecommend" runat="server" CssClass="lock" OnClientClick="return ExePostBack('btnRecommend','设优质后，会在前台显示报告，是否确定？');" onclick="btnRecommend_Click"><i></i><span>优质</span></asp:LinkButton></li>
          <li><asp:LinkButton ID="btnUnRecommend" runat="server" CssClass="save" OnClientClick="return ExePostBack('btnUnRecommend','非优质的报告不会在前台显示，是否确定？');" onclick="btnUnRecommend_Click"><i></i><span>非优质</span></asp:LinkButton></li>
        </ul>
        <div class="menu-list">
          <div class="rule-single-select">
            <asp:DropDownList ID="ddlRecommend" runat="server" AutoPostBack="True" onselectedindexchanged="ddlRecommend_SelectedIndexChanged">
              <asp:ListItem Value="" Selected="True">优质评选</asp:ListItem>
              <asp:ListItem Value="2">优质的</asp:ListItem>
              <asp:ListItem Value="1">普通的</asp:ListItem>
            </asp:DropDownList>
          </div>
        </div>
        <div class="menu-list">
          <div class="rule-single-select">
            <asp:DropDownList ID="ddlLocked" runat="server" AutoPostBack="True" onselectedindexchanged="ddlLocked_SelectedIndexChanged">
              <asp:ListItem Value="" Selected="True">筛选显示</asp:ListItem>
              <asp:ListItem Value="2">查看已屏蔽</asp:ListItem>
              <asp:ListItem Value="1">查看正常的</asp:ListItem>
            </asp:DropDownList>
          </div>
        </div>
        <div class="menu-list">
          <div class="rule-single-select">
            <asp:DropDownList ID="ddlStatus" runat="server" AutoPostBack="True" onselectedindexchanged="ddlStatus_SelectedIndexChanged">
              <asp:ListItem Value="" Selected="True">筛选状态</asp:ListItem>
              <asp:ListItem Value="1">待审核</asp:ListItem>
              <asp:ListItem Value="2">合格</asp:ListItem>
              <asp:ListItem Value="3">不合格</asp:ListItem>
            </asp:DropDownList>
          </div>
        </div>
      </div>
      <div class="r-list">
        <asp:TextBox ID="txtKeywords" runat="server" CssClass="keyword" />
        <asp:LinkButton ID="lbtnSearch" runat="server" CssClass="btn-search" onclick="btnSearch_Click">查询</asp:LinkButton>
      </div>
    </div>
  </div>
</div>
<!--/工具栏-->

<!--列表-->
<div class="table-container">
  <asp:Repeater ID="rptList" runat="server">
  <HeaderTemplate>
  <table width="100%" border="0" cellspacing="0" cellpadding="0" class="ltable">
      <tr>
        <th align="center" width="4%">选择</th>
        <th align="center" width="5%">ID</th>
        <th align="center" width="7%">试用区</th>
        <th align="center" width="12%">试用编号</th>
        <th align="center" width="10%">试客账号</th>
        <th align="center" width="10%">商家账号</th>
        <th align="center" width="10%">公示图片</th>
        <th align="center" width="12%">提交时间</th>
        <th align="center" width="8">是否优质</th>
        <th align="center" width="8%">是否屏蔽</th>
        <th align="center" width="7%">状态</th>
        <th align="center" width="7%">操作</th>
      </tr>
    </HeaderTemplate>
    <ItemTemplate>
      <tr>
        <td align="center">
          <asp:CheckBox ID="chkId" CssClass="checkall" runat="server" style="vertical-align:middle;" />
          <asp:HiddenField ID="hidId" Value='<%#Eval("id")%>' runat="server" />
        </td>
        <td align="center"><%#Eval("id")%></td>
        <td align="center"><%#GetCategoryTitle(Utils.ObjToInt(Eval("category_id").ToString(), 0))%></td>
        <td align="center"><%#Eval("order_no")%></td>
        <td align="center"><a href="report_list.aspx?channel_id=<%=this.channel_id%>&id=<%=this.category_id%>&keywords=<%#Eval("buyer_user_name")%>"><%#Eval("buyer_user_name")%></a></td>
        <td align="center"><a href="report_list.aspx?channel_id=<%=this.channel_id%>&id=<%=this.category_id%>&keywords=<%#Eval("user_name")%>"><%#Eval("user_name")%></a></td>
        <td align="center"><a href="<%#Eval("photo_url").ToString()!="" ? Eval("photo_url") : "/style/images/noimg.png"%>" target="_blank" title="点击看大图"><img src="<%#Eval("photo_url").ToString()!="" ? Eval("photo_url") : "/style/images/noimg.png"%>" width="30" height="30" /></td>
        <td align="center"><%#Eval("add_date")%></td>
        <td align="center"><%#Eval("is_recommend").ToString() == "1" ? "<span class=green>优质</span>" : ""%></td>
        <td align="center"><%#Eval("is_locked").ToString() == "1" ? "<span class=red>已屏蔽</span>" : ""%></td>
        <td align="center"><%#GetStatus(Utils.ObjToInt(Eval("status")))%></td>
        <td align="center"><a href="report_edit.aspx?action=Edit&id=<%#Eval("id")%>&channel_id=<%#Eval("channel_id")%>&category_id=<%#Eval("category_id")%>">查看详情</a></td>
      </tr>
    </ItemTemplate>
    <FooterTemplate>
      <%#rptList.Items.Count == 0 ? "<tr><td align=\"center\" colspan=\"11\">暂无记录</td></tr>" : ""%>
    </table>
  </FooterTemplate>
  </asp:Repeater>
</div>
<!--/列表-->

<!--内容底部-->
<div class="line20"></div>
<div class="pagelist">
  <div class="l-btns">
    <span>显示</span><asp:TextBox ID="txtPageNum" runat="server" CssClass="pagenum" onkeydown="return checkNumber(event);"
                OnTextChanged="txtPageNum_TextChanged" AutoPostBack="True"></asp:TextBox><span>条/页</span>
  </div>
  <div id="PageContent" runat="server" class="default"></div>
</div>
<!--/内容底部-->

</form>
</body>
</html>
