﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="template_list.aspx.cs" Inherits="SKtms.Web.admin.trial.template_list" %>
<%@ Import namespace="SKtms.Common" %>

<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=no" />
<meta name="apple-mobile-web-app-capable" content="yes" />
<title>活动模板管理</title>
<link href="../../scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
<link href="../skin/default/style.css" rel="stylesheet" type="text/css" />
<link href="../../css/pagination.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" src="../../scripts/jquery/jquery-1.11.2.min.js"></script>
<script type="text/javascript" src="../../scripts/artdialog/dialog-plus-min.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/laymain.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/common.js"></script>
</head>

<body class="mainbody">
<script type="text/javascript">
$(function () {
    $(".del_link").click(function () {
        $(this).parent().parent().find(".checkall input[type='checkbox']").prop("checked", true);
        return ExePostBack('btnDelete');
    })
})
</script>
<form id="form1" runat="server">
<!--导航栏-->
<div class="location">
  <a href="javascript:history.back(-1);" class="back"><i></i><span>返回上一页</span></a>
  <a href="../center.aspx" class="home"><i></i><span>首页</span></a>
  <i class="arrow"></i>
  <span>试客系统</span>
  <i class="arrow"></i>
  <span><%=category_title%>活动模板管理</span>
</div>
<!--/导航栏-->

<!--工具栏-->
<div id="floatHead" class="toolbar-wrap">
  <div class="toolbar">
    <div class="box-wrap">
      <a class="menu-btn"></a>
      <div class="l-list">
        <ul class="icon-list">
          <li><a class="all" href="javascript:;" onclick="checkAll(this);"><i></i><span>全选</span></a></li>
          <li><asp:LinkButton ID="btnDelete" runat="server" CssClass="del" OnClientClick="return ExePostBack('btnDelete');" onclick="btnDelete_Click"><i></i><span>删除</span></asp:LinkButton></li>
          <li><asp:LinkButton ID="btnLock" runat="server" CssClass="lock" OnClientClick="return ExePostBack('btnLock','暂停后在发布活动页面不显示本模板，是否确定？');" onclick="btnLock_Click"><i></i><span>暂停</span></asp:LinkButton></li>
          <li><asp:LinkButton ID="btnUnLock" runat="server" CssClass="save" OnClientClick="return ExePostBack('btnUnLock','启用后才可在前台显示，是否确定？');" onclick="btnUnLock_Click"><i></i><span>启用</span></asp:LinkButton></li>
        </ul>
        <div class="menu-list">
          <div class="rule-single-select">
            <asp:DropDownList ID="ddlProperty" runat="server" AutoPostBack="True" onselectedindexchanged="ddlProperty_SelectedIndexChanged">
              <asp:ListItem Value="" Selected="True">筛选状态</asp:ListItem>
              <asp:ListItem Value="isLock">查看已暂停</asp:ListItem>
              <asp:ListItem Value="unLock">查看正常的</asp:ListItem>
            </asp:DropDownList>
          </div>
        </div>
      </div>
      <div class="r-list">
        <asp:TextBox ID="txtKeywords" runat="server" CssClass="keyword" />
        <asp:LinkButton ID="lbtnSearch" runat="server" CssClass="btn-search" onclick="btnSearch_Click">查询</asp:LinkButton>
      </div>
    </div>
  </div>
</div>
<!--/工具栏-->

<!--列表-->
<div class="table-container">
  <asp:Repeater ID="rptList" runat="server">
  <HeaderTemplate>
  <table width="100%" border="0" cellspacing="0" cellpadding="0" class="ltable">
      <tr>
        <th align="center" width="5%">选择</th>
        <th align="center" width="7%">活动区</th>
        <th align="center" width="12%">模板名称</th>
        <th align="center" width="9%">用户名</th>
        <th align="center" width="9%">掌柜名</th>
        <th align="center" width="">标题</th>
        <th align="center" width="">商品地址</th>
        <th align="center" width="7%">价格</th>
        <th align="center" width="10%">添加时间</th>
        <th align="center" width="5%">操作</th>
      </tr>
    </HeaderTemplate>
    <ItemTemplate>
      <tr>
        <td align="center">
          <asp:CheckBox ID="chkId" CssClass="checkall" runat="server" style="vertical-align:middle;" />
          <asp:HiddenField ID="hidId" Value='<%#Eval("id")%>' runat="server" />
        </td>
        <td align="center"><%#GetCategoryTitle(Utils.ObjToInt(Eval("category_id").ToString(), 0))%></td>
        <td align="center"><%#Eval("template_name")%></td>
        <td align="center"><%#Eval("user_name")%></td>
        <td align="center"><%#Eval("shop_name")%></td>
        <td align="center"><span title="<%#Eval("title")%>"><%#Utils.CutString(Eval("title").ToString(), 22)%></span></td>
        <td align="center"><input type="text" name="url" class="input txt" value="<%#Eval("product_url")%>" /></td>
        <td align="center"><%#Eval("price")%></td>
        <td align="center"><%#Eval("add_date")%></td>
        <td align="center"><%#Eval("is_pause").ToString()=="1"?"(暂停) ":""%><asp:LinkButton ID="btnDelete" runat="server" CssClass="del_link" onclick="btnDelete_Click"><i></i><span>删除</span></asp:LinkButton></td>
      </tr>
    </ItemTemplate>
    <FooterTemplate>
      <%#rptList.Items.Count == 0 ? "<tr><td align=\"center\" colspan=\"11\">暂无记录</td></tr>" : ""%>
    </table>
  </FooterTemplate>
  </asp:Repeater>
</div>
<!--/列表-->

<!--内容底部-->
<div class="line20"></div>
<div class="pagelist">
  <div class="l-btns">
    <span>显示</span><asp:TextBox ID="txtPageNum" runat="server" CssClass="pagenum" onkeydown="return checkNumber(event);"
                OnTextChanged="txtPageNum_TextChanged" AutoPostBack="True"></asp:TextBox><span>条/页</span>
  </div>
  <div id="PageContent" runat="server" class="default"></div>
</div>
<!--/内容底部-->

</form>
</body>
</html>
