﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="try_list.aspx.cs" Inherits="SKtms.Web.admin.trial.try_list" %>
<%@ Import namespace="SKtms.Common" %>

<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=no" />
<meta name="apple-mobile-web-app-capable" content="yes" />
<title>试用活动管理</title>
<link href="../../scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
<link href="../skin/default/style.css" rel="stylesheet" type="text/css" />
<link href="../../css/pagination.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" src="../../scripts/jquery/jquery-1.11.2.min.js"></script>
<script type="text/javascript" src="../../scripts/artdialog/dialog-plus-min.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/laymain.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/common.js"></script>
    <style>
        .try_type1 { background-color: #008ae5; color: #fff; padding: 1px 5px; border-radius: 4px; margin-top: 5px; display: inline-block; }
        .try_type2 { background-color: #019500; color: #fff; padding: 1px 5px; border-radius: 4px; margin-top: 5px; display: inline-block; }
        .try_type3 { background-color: #ea544a; color: #fff; padding: 1px 5px; border-radius: 4px; margin-top: 5px; display: inline-block; }
    </style>
</head>

<body class="mainbody">
<script type="text/javascript">
    $(function () {
        //点击右边单个连接
        $(".del_link").click(function () {
            $(this).parents().find(".checkall input[type='checkbox']").prop("checked", false);
            $(this).parent().parent().find(".checkall input[type='checkbox']").prop("checked", true);
            return jsConfirm($(this), '你确定要删除吗？<br />注：该删除会退还担保金及红包。 (如不想退款，请点左上角删除按钮）');
        });
        $(".audit_link").click(function () {
            $(this).parents().find(".checkall input[type='checkbox']").prop("checked", false);
            $(this).parent().parent().find(".checkall input[type='checkbox']").prop("checked", true);
            $("#btnAudit").click();
        });
        $(".audit_fail_link").click(function () {
            $(this).parents().find(".checkall input[type='checkbox']").prop("checked", false);
            $(this).parent().parent().find(".checkall input[type='checkbox']").prop("checked", true);
            $("#btnAuditFail").click();
        });
        
        //绑定详细连接
        $(".detail").click(function () {
            var d = dialog({
                title: '活动详情浏览',
                width: 780,
                padding: '0 20px 10px',
                url: $(this).attr("href"),
                okValue: ' 关 闭 ',
                ok: function () { }
            }).show();
            return false;
        });

        //锁定和解锁
        $("#btnLock, #btnUnLock").click(function () {
            if ($(".checkall input:checked").size() < 1) {
                parent.dialog({
                    title: '提示',
                    content: '对不起，请选中您要操作的记录！',
                    okValue: '确定',
                    ok: function () { }
                }).showModal();
                return false;
            }
            var msg = $(this).attr("date-title");
            var d = dialog({
                title: msg,
                content: '填写原因：<textarea id="remark" rows="3" cols="30"></textarea>',
                okValue: '确定',
                ok: function () {
                    var value = $('#remark').val() != ""? $('#remark').val() : "'";   //'号会被过滤，此只为方便判断
                    this.close(value);
                    this.remove();
                },
                cancelValue: '取消',
                cancel: function () { }
            });
            var _href = $(this).attr("href");
            d.addEventListener('close', function () {
                if (this.returnValue != '') {
                    $("#txtRemark").val(this.returnValue);
                    location.href = _href;
                }
            });
            d.show();
            return false;
        });
        //延长时间
        $("#btnOverTime").click(function () {
            if ($(".checkall input:checked").size() < 1) {
                parent.dialog({
                    title: '提示',
                    content: '对不起，请选中您要操作的记录！',
                    okValue: '确定',
                    ok: function () { }
                }).showModal();
                return false;
            }
            var msg = $(this).attr("date-title");
            var d = dialog({
                title: msg,
                content: '填写追加活动天数：<input type="text" id="remark" value="30" class="input small" /> 天',
                okValue: '确定',
                ok: function () {
                    var value = $('#remark').val() != "" ? $('#remark').val() : "30";   //如果空就默认30
                    this.close(value);
                    this.remove();
                },
                cancelValue: '取消',
                cancel: function () { }
            });
            var _href = $(this).attr("href");
            d.addEventListener('close', function () {
                if (this.returnValue != '') {
                    $("#txtRemark").val(this.returnValue);
                    location.href = _href;
                }
            });
            d.show();
            return false;
        });
        //表格点击显示下一隐藏列
        $(".msg-tr").click(function () {
            $(this).next().addClass("odd_bg").toggle();
        });
    });
</script>
<form id="form1" runat="server">
<!--导航栏-->
<div class="location">
  <a href="javascript:history.back(-1);" class="back"><i></i><span>返回上一页</span></a>
  <a href="../center.aspx" class="home"><i></i><span>首页</span></a>
  <i class="arrow"></i>
  <span>试客系统</span>
  <i class="arrow"></i>
  <span><%=category_title%>活动管理</span>
</div>
<!--/导航栏-->

<!--工具栏-->
<div id="floatHead" class="toolbar-wrap">
  <div class="toolbar">
    <div class="box-wrap">
      <a class="menu-btn"></a>
      <div class="l-list">
        <ul class="icon-list">
          <li><a class="all" href="javascript:;" onclick="checkAll(this);"><i></i><span>全选</span></a></li>
          <li><asp:LinkButton ID="btnDelete" runat="server" CssClass="del" OnClientClick="return ExePostBack('btnDelete','你确定要删除吗？<br />（注：本项删除不退还担保金和红包，仅删除记录！<br>如需要退款的请点右边的删除连接）');" onclick="btnDelete_Click"><i></i><span>删除</span></asp:LinkButton></li>
          <li><asp:LinkButton ID="btnClose" runat="server" CssClass="lock" OnClientClick="return ExePostBack('btnClose','你确定要关闭吗？<br />（注：如已经付款的活动会退款，未付款的仅关闭）');" onclick="btnSetStatus_Click" CommandArgument="11"><i></i><span>关闭</span></asp:LinkButton></li>
          <li><asp:LinkButton ID="btnAudit" runat="server" CssClass="edit" OnClientClick="return ExePostBack('btnAudit','你确定通过审核吗！<br />(注：请确定商家已经付款再通过审核)');" onclick="btnSetStatus_Click" CommandArgument="7"><i></i><span>通过审核</span></asp:LinkButton></li>
          <li><asp:LinkButton ID="btnAuditFail" runat="server" CssClass="lock" OnClientClick="return ExePostBack('btnAuditFail','你确定设为不合格吗！<br />(注：不合格的将会退款回商家账户)');" onclick="btnSetStatus_Click" CommandArgument="8"><i></i><span>不合格</span></asp:LinkButton></li>
          <li><asp:LinkButton ID="btnUnAudit" runat="server" CssClass="edit" OnClientClick="return ExePostBack('btnUnAudit','你确定设为待审核状态吗！<br />(如不小心点了审核，可以恢复到未审核状态)');" onclick="btnSetStatus_Click" CommandArgument="9"><i></i><span>设为待审</span></asp:LinkButton></li>
          <li><asp:LinkButton ID="btnUnPay" runat="server" CssClass="edit" OnClientClick="return ExePostBack('btnUnPay','你确定设为待付款状态吗！');" onclick="btnSetStatus_Click" CommandArgument="10"><i></i><span>设为待付款</span></asp:LinkButton></li>
        </ul>
        <div class="menu-list">
          <div class="rule-single-select">
            <asp:DropDownList ID="ddlStatus" runat="server" AutoPostBack="True" onselectedindexchanged="ddlStatus_SelectedIndexChanged">
                <asp:ListItem Selected="True" Value="0">状态筛选</asp:ListItem>
                <asp:ListItem Value="1">待付担保金</asp:ListItem>
                <asp:ListItem Value="2">待客服审核</asp:ListItem>
                <asp:ListItem Value="3">审核通过</asp:ListItem>
                <asp:ListItem Value="4">已到期</asp:ListItem>
                <asp:ListItem Value="5">已完成</asp:ListItem>
                <asp:ListItem Value="6">已关闭</asp:ListItem>
                <asp:ListItem Value="7">审核失败</asp:ListItem>
                <asp:ListItem Value="8">已下架</asp:ListItem>
                <asp:ListItem Value="9">已锁定</asp:ListItem>
                <asp:ListItem Value="10">已推荐</asp:ListItem>
            </asp:DropDownList>
          </div>
        </div>
        <div class="menu-list">
          <div class="rule-single-select">
            <asp:DropDownList ID="ddlProductCategory" runat="server" AutoPostBack="True" onselectedindexchanged="ddlProductCategory_SelectedIndexChanged"></asp:DropDownList>
          </div>
        </div>
      </div>
      <div class="r-list">
        <div class="menu-list">
            <div class="rule-single-select">
                <asp:DropDownList ID="ddlSearchType" runat="server">
                    <asp:ListItem Selected="True" Value="">查找类型</asp:ListItem>
                    <asp:ListItem Value="1">按商品编号查找</asp:ListItem>
                    <asp:ListItem Value="2">按商品标题查找</asp:ListItem>
                    <asp:ListItem Value="3">按发布人查找</asp:ListItem>
                    <asp:ListItem Value="4">按掌柜号查找</asp:ListItem>
                </asp:DropDownList>
            </div>
        </div>
        <asp:TextBox ID="txtKeywords" runat="server" CssClass="keyword" />
        <asp:LinkButton ID="lbtnSearch" runat="server" CssClass="btn-search" onclick="btnSearch_Click">查询</asp:LinkButton>
      </div>
    </div>
  </div>
</div>
<!--/工具栏-->

<!--列表-->
<div class="table-container">
  <asp:Repeater ID="rptList" runat="server">
  <HeaderTemplate>
  <table width="100%" border="0" cellspacing="0" cellpadding="0" class="ltable">
      <tr>
        <th align="center" width="4%">选择</th>
        <th align="center" width="5%">ID</th>
        <th align="center" width="7%">试用区</th>
        <th align="center" width="9%">商家用户名</th>
        <th align="center" width="6%">商品图片</th>
        <th align="center" width="10%">标题/掌柜名</th>
        <th align="center" width="12%">价格/红包</th>
        <th align="center" width="8%">总押金/份数</th>
        <th align="center" width="11%">统计</th>
        <th align="center" width="12%">开始/结束时间</th>
        <th align="center" width="7%">状态</th>
        <th align="center" width="9%">操作</th>
      </tr>
    </HeaderTemplate>
    <ItemTemplate>
      <tr class="msg-tr">
        <td align="center">
          <asp:CheckBox ID="chkId" CssClass="checkall" runat="server" style="vertical-align:middle;" />
          <asp:HiddenField ID="hidId" Value='<%#Eval("id")%>' runat="server" />
        </td>
        <td align="center"><a href="<%#new SKtms.Web.UI.BasePage().linkurl("try_add", "view", Eval("id"))%>" target="_blank" title="点击看详情"><%#Eval("id")%></a></td>
        <td align="center"><%#Eval("order_type").ToString()=="1" ? "<img src=\"/style/images/pc.png\" height=\"20\" align=\"absmiddle\" title=\"电脑端下单\" />" : "<img src=\"/style/images/ipad.png\" height=\"20\" align=\"absmiddle\" title=\"手机端下单\" />"%> <%#GetCategoryTitle(Utils.ObjToInt(Eval("category_id")))%>
            <br /><span class="try_type<%#Eval("try_type").ToString()%>"><%#Eval("try_type").ToString()=="3" ? "折扣试用" : (Eval("try_type").ToString()=="2" ? "发赠品" : "发正品")%></span>
        </td>
        <td align="center"><a href="try_list.aspx?channel_id=<%=this.channel_id%>&id=<%=this.category_id%>&keywords=<%#Eval("user_name")%>&search_type=3"><%#Eval("user_name")%></a></td>
        <td align="center"><a href="<%#new SKtms.Web.UI.BasePage().linkurl("try_item", Eval("id"))%>" target="_blank" title="点击看试用详情"><img src="<%#Eval("product_pic")%>" width="40" height="40" /></td>
        <td align="left"><a href="<%#new SKtms.Web.UI.BasePage().linkurl("try_item", Eval("id"))%>" target="_blank" title="点击看试用详情"><span title="<%#Eval("title") %>"><%#Utils.CutString(Eval("title").ToString(),40)%></span></a><br />
            <a href="try_list.aspx?channel_id=<%=this.channel_id%>&id=<%=this.category_id%>&keywords=<%#Eval("shop_name")%>&search_type=4"><span class="orange"><%#Eval("shop_name")%></span></a></td>
        <td align="center">下单价：<span class="red">￥<%#Eval("price")%></span> 元<br>红包：<span class="red">￥<%#Eval("redbag_price")%></span> 元</td>
        <td align="center">￥<%#Eval("total_money")%> 元<br><%#Eval("total_count")%> 份</td>
        <td align="center">
            已申请：<%#Eval("apply_count")%> 人<br />
            已通过：<span class="blue" title="已下单人数"><%#GetTradeNum(Utils.ObjToInt(Eval("id")))%></span> / <span class="orange" title="通过申请人数"><%#GetAllowApplyNum(Utils.ObjToInt(Eval("id")))%></span> 人<br />
            已完成：<span class="blue"><%#Eval("finish_count")%></span> / <%#Eval("total_count")%> 份<br /></td>
        <td align="center"><%#Eval("add_date")%><br><%#Eval("end_date")%></td>
        <td align="center"><%#GetStatusInfo(Container.DataItem)%></td>
        <td align="center"><%#Eval("status").ToString()=="1" ? "<a class=\"audit_link\" href=\"javascript:;\"><span class=\"green\">通过</span></a> | <a class=\"audit_fail_link\" href=\"javascript:;\"><span class=\"red\">不合格</span></a><br>" : ""%>
            <a class="detail" href="try_detail.aspx?channel_id=<%=this.channel_id%>&category_id=<%=this.category_id%>&id=<%#Eval("id")%>">详细</a> 
            | <asp:LinkButton ID="LinkButton1" runat="server" CssClass="del_link" onclick="btnDelete_Right_Click"><span>删除</span></asp:LinkButton>
        </td>
      </tr>
      <tr style="display:none">
      <td colspan="12" align="left">&nbsp; 
          商品编号：<%#Eval("product_no").ToString()%>　　
          类别：<%#GetCategoryTitle(Utils.ObjToInt(Eval("product_category_id")))%>　　
          试用类型：<%#Eval("try_type").ToString()=="1" ? "正品试用" : (Eval("try_type").ToString()=="2" ? "拍正品发赠品" : "折扣特价")%>　　
          商家IP地址：<span title="<%#Eval("user_ip")%>"><%#GetUserIPInfo(Eval("user_ip").ToString())%></span>　　
          增值功能：<%#GetRequireInfo(Container.DataItem)%>
      </td>
  </tr>
    </ItemTemplate>
    <FooterTemplate>
      <%#rptList.Items.Count == 0 ? "<tr><td align=\"center\" colspan=\"12\">暂无记录</td></tr>" : ""%>
    </table>
  </FooterTemplate>
  </asp:Repeater>
</div>
<!--/列表-->

    
<!--底部按钮组-->
<div class="toolbar">
    <div class="box-wrap">
      <a class="menu-btn"></a>
      <div class="l-list">
        <ul class="icon-list">
            <li><a class="all" href="javascript:;" onclick="checkAll(this);"><i></i><span>全选</span></a></li>
            <li><asp:LinkButton ID="btnRecommend" runat="server" CssClass="lock" OnClientClick="return ExePostBack('btnRecommend','您确定要设为推荐吗？');" onclick="btnSetStatus_Click" CommandArgument="5"><i></i><span>推荐</span></asp:LinkButton></li>
            <li><asp:LinkButton ID="btnUnRecommend" runat="server" CssClass="edit" OnClientClick="return ExePostBack('btnUnRecommend','您确定要取消推荐吗？');" onclick="btnSetStatus_Click" CommandArgument="6"><i></i><span>取消推荐</span></asp:LinkButton></li>
            <li><asp:LinkButton ID="btnPause" runat="server" CssClass="lock" OnClientClick="return ExePostBack('btnPause','你确定要下架吗？下架后不会在前台显示！');" onclick="btnSetStatus_Click" CommandArgument="1"><i></i><span>下架</span></asp:LinkButton></li>
            <li><asp:LinkButton ID="btnUnPause" runat="server" CssClass="edit" OnClientClick="return ExePostBack('btnUnPause','你确定要上架吗？');" onclick="btnSetStatus_Click" CommandArgument="2"><i></i><span>上架</span></asp:LinkButton></li>
            <li><asp:LinkButton ID="btnLock" runat="server" CssClass="lock" date-title="你确定要锁定吗？" onclick="btnSetStatus_Click" CommandArgument="3"><i></i><span>锁定</span></asp:LinkButton><asp:HiddenField ID="txtRemark" runat="server" /></li>
            <li><asp:LinkButton ID="btnUnLock" runat="server" CssClass="edit" date-title="你确定要解锁吗？" onclick="btnSetStatus_Click" CommandArgument="4"><i></i><span>解锁</span></asp:LinkButton></li>
            <li><asp:LinkButton ID="btnOverTime" runat="server" CssClass="save" date-title="你确定要延长活动时间吗？" onclick="btnSetStatus_Click" CommandArgument="12"><i></i><span>延长活动时间</span></asp:LinkButton></li>
        </ul>        
      </div>      
    </div>
  </div>
<!--/底部按钮组-->

<!--内容底部-->
<div class="line10"></div>
<div class="pagelist">
  <div class="l-btns">
    <span>显示</span><asp:TextBox ID="txtPageNum" runat="server" CssClass="pagenum" onkeydown="return checkNumber(event);"
                OnTextChanged="txtPageNum_TextChanged" AutoPostBack="True"></asp:TextBox><span>条/页</span>
  </div>
  <div id="PageContent" runat="server" class="default"></div>
</div>
<!--/内容底部-->

</form>
</body>
</html>
