﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="commissions_config_edit.aspx.cs" Inherits="SKtms.Web.admin.users.commissions_config_edit" ValidateRequest="false" %>
<%@ Import Namespace="SKtms.Common" %>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=no" />
<meta name="apple-mobile-web-app-capable" content="yes" />
<title>佣金奖励设置</title>
<link href="../../scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
<link href="../skin/default/style.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" charset="utf-8" src="../../scripts/jquery/jquery-1.11.2.min.js"></script>
<script type="text/javascript" charset="utf-8" src="../../scripts/jquery/Validform_v5.3.2_min.js"></script>
<script type="text/javascript" charset="utf-8" src="../../scripts/artdialog/dialog-plus-min.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/laymain.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/common.js"></script>
<script type="text/javascript">
    $(function () {
        //初始化表单验证
        $("#form1").initValidform();
        //初始化子tab
        $(".child-tab-wrap").initChildTab();
        //绑定复制上一选项卡设置按钮
        $(".child-tab-content .green").each(function () {
            $(this).bind("click", function () {
                copyConfig('child-tab-content', $(".child-tab-content .green").index(this));
            });
        });
    });
</script>
</head>

<body class="mainbody">
<form id="form1" runat="server">
<!--导航栏-->
<div class="location">
    <a href="javascript:history.back(-1);" class="back"><i></i><span>返回上一页</span></a>
    <a href="../center.aspx" class="home"><i></i><span>首页</span></a>
    <i class="arrow"></i>
    <span>会员设置</span>
    <i class="arrow"></i>
    <span>佣金奖励设置</span>
</div>
<div class="line10"></div>
<!--/导航栏-->

<!--内容-->
<div id="floatHead" class="content-tab-wrap">
    <div class="content-tab">
        <div class="content-tab-ul-wrap">
            <ul>
                <li>
                    <a href="javascript:;" class="selected">基本信息设置</a>
                </li>
            </ul>
        </div>
    </div>
</div>

<div class="tab-content">
    <dl>
        <dt>佣金组名称</dt>
        <dd>
            <asp:TextBox ID="txtTitle" CssClass="input normal" datatype="s" sucmsg=" " errormsg="请输入名称！" runat="server"></asp:TextBox>
        </dd>
    </dl>
    <dl>
        <dt>佣金组简介</dt>
        <dd>
            <asp:TextBox ID="txtDesc" CssClass="input normal" datatype="s" sucmsg=" " errormsg="请输入名称！" runat="server" TextMode="MultiLine"></asp:TextBox>
        </dd>
    </dl>
    <dl>
        <dt>奖励的佣金存入</dt>
        <dd>
            <div class="rule-multi-radio">
                <asp:RadioButtonList ID="store_type" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow">
                <asp:ListItem Value="0" Selected="True">账户佣金</asp:ListItem>
                <asp:ListItem Value="1">账户余额</asp:ListItem>
                </asp:RadioButtonList>
            </div>
            <span class="Validform_checktip">*账户佣金可提现，如需消费，需要转入账户余额才可消费</span>
        </dd>
    </dl>
    <dl>
        <dt>是否允许账户佣金转入余额</dt>
        <dd>
            <div class="rule-single-checkbox">
                <asp:CheckBox ID="is_change_to_amount" runat="server" />
            </div>
            <span class="Validform_checktip">*禁用的话，佣金就只能提现了 （当[奖励的佣金存入]账户佣金时开启本项才有效）</span>
        </dd>
    </dl>
    <dl>
        <dt>是否设为默认</dt>
        <dd>
            <div class="rule-single-checkbox">
                <asp:CheckBox ID="is_default" runat="server" />
            </div>
            <span class="Validform_checktip">设为默认，会员注册后默认就是该佣金组，如果不设默认组，注册后不加入任何佣金组</span>
        </dd>
    </dl>
    <dl>
        <dt>是否禁用</dt>
        <dd>
            <div class="rule-single-checkbox">
                <asp:CheckBox ID="is_disabled" runat="server" />
            </div>
            <span class="Validform_checktip">禁用后，属于本佣金组的用户将不会得到相应佣金</span>
        </dd>
    </dl>
    <dl>
        <dt>佣金设置</dt>
        <dd>
            <div class="table-container">
                <asp:Repeater ID="rptList" runat="server">
                    <HeaderTemplate>
                        <!--第2层tab外围选项卡-->
                        <div class="child-tab-wrap">
                            <div class="child-tab-bar">
                            </div>
                    </HeaderTemplate>
                    <ItemTemplate>
                        <script type="text/javascript">$(".child-tab-bar").last().append('<span><%#Eval("title")%>组设置</span>');</script>
                        <!--第2层tab选项卡-->
                        <div class="child-tab-content">
                            <input type="hidden" name="group_id" value="<%#Eval("id")%>" />
                            <input type="hidden" name="group_title" value="<%#Eval("title")%>" />
                            <dl <%#Container.ItemIndex == 0 ? "style=\"display:none\"":""%>>
                                <dd>
                                    <input type="button" value="复制上一选项卡的设置" class="btn green" <%#Container.ItemIndex == 0 ? "style=\"display:none\"":""%> />
                                </dd>
                            </dl>
                            <!-- 以下为动态输出奖励类别项 --->
                            <%#GetItemsConfig(Convert.ToInt32(Eval("id")))%>
                        </div>
                        <!--/第2层tab选项卡-->
                    </ItemTemplate>
                    <FooterTemplate>
                        <span style="color:red">说明：佣金奖励支持无限级提成，如需要启用多级提成，请在输入框后面追加即可，以|号间隔，例如5级提成： 1|0.7|0.5|0.2|0.1<br />如想扣佣金在前面加-(减号)，如-1</span>
                        </div>
                        <% if (rptList.Items.Count == 0)
                            {%>
                        <div class="child-tab-content">
                            <dd>请先添加用户组再回来设置！
                            </dd>
                        </div>
                        <%}%>
                        <!--/第2层tab外围选项卡-->
                    </FooterTemplate>
                </asp:Repeater>
            </div>
        </dd>
    </dl>
</div>


<!--/内容-->

<!--工具栏-->
<div class="page-footer">
    <div class="btn-wrap">
        <asp:Button ID="btnSubmit" runat="server" Text="提交保存" CssClass="btn" OnClick="btnSubmit_Click" />
        <input name="btnReturn" type="button" value="返回上一页" class="btn yellow" onclick="javascript: history.back(-1);" />
    </div>
</div>
<!--/工具栏-->
</form>
</body>
</html>
