﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="flow_point_edit.aspx.cs" Inherits="SKtms.Web.admin.users.flow_point_edit" ValidateRequest="false" %>
<%@ Import namespace="SKtms.Common" %>

<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=no" />
<meta name="apple-mobile-web-app-capable" content="yes" />
<title>流量点充值</title>
<link href="../../scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
<link href="../skin/default/style.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" charset="utf-8" src="../../scripts/jquery/jquery-1.11.2.min.js"></script>
<script type="text/javascript" charset="utf-8" src="../../scripts/jquery/Validform_v5.3.2_min.js"></script>
<script type="text/javascript" charset="utf-8" src="../../scripts/artdialog/dialog-plus-min.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/laymain.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/common.js"></script>
<script type="text/javascript">
    $(function () {
        //初始化表单验证
        $("#form1").initValidform();
    });
</script>
</head>

<body class="mainbody">
<form id="form1" runat="server">
<!--导航栏-->
<div class="location">
  <a href="flow_point_list.aspx" class="back"><i></i><span>返回列表页</span></a>
  <a href="../center.aspx" class="home"><i></i><span>首页</span></a>
  <i class="arrow"></i>
  <a href="flow_point_list.aspx"><span>流量点记录</span></a>
  <i class="arrow"></i>
  <span>流量点充值</span>
</div>
<div class="line10"></div>
<!--/导航栏-->

<!--内容-->
<div id="floatHead" class="content-tab-wrap">
  <div class="content-tab">
    <div class="content-tab-ul-wrap">
      <ul>
        <li><a class="selected" href="javascript:;">流量点充值</a></li>
      </ul>
    </div>
  </div>
</div>

<div class="tab-content">
  <dl>
    <dt>用户名</dt>
    <dd>
      <asp:TextBox ID="txtUserName" runat="server" CssClass="input normal" datatype="*2-100" sucmsg=" " ajaxurl="../../tools/submit_ajax.ashx?action=validate_username_exist"></asp:TextBox>
      <span class="Validform_checktip">*需要充值的会员用户名</span>
    </dd>
  </dl>

  <dl>
    <dt>流量点数</dt>
    <dd>
      <asp:TextBox ID="txtPoint" runat="server" CssClass="input small" datatype="/^-?(([1-9]{1}\d*)|([0]{1}))(\.(\d){1,2})?$/" sucmsg=" "></asp:TextBox>
      <span class="Validform_checktip">*给该会员充值的流量点数额，负数则扣减。</span>
    </dd>
  </dl>
  <dl>
    <dt>备注</dt>
    <dd>
      <asp:TextBox ID="txtRemark" runat="server" CssClass="input normal" datatype="*" sucmsg=" " ignore="ignore"></asp:TextBox>
      <span class="Validform_checktip">*备注,可留空</span>
    </dd>
  </dl>
  <dl>
      <dt>是否发送站内信通知</dt>
      <dd>
          <div class="rule-single-checkbox">
              <asp:CheckBox ID="IsSendMessageCheckBox" runat="server" Checked="true" />
          </div>
      </dd>
  </dl>
  <dl>
    <dt>通知内容</dt>
    <dd>
      <asp:TextBox ID="txtMessage" runat="server" CssClass="input normal" datatype="*" sucmsg=" " TextMode="MultiLine"></asp:TextBox>
      <span class="Validform_checktip">*发送站内信</span>
    </dd>
  </dl>
</div>
<!--/内容-->

<!--工具栏-->
<div class="page-footer">
  <div class="btn-wrap">
    <asp:Button ID="btnSubmit" runat="server" Text="提交保存" CssClass="btn" onclick="btnSubmit_Click" />
    <input name="btnReturn" type="button" value="返回上一页" class="btn yellow" onclick="javascript:history.back(-1);" />
  </div>
</div>
<!--/工具栏-->

</form>
</body>
</html>
