﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="group_ext_config.aspx.cs" Inherits="SKtms.Web.admin.users.group_ext_config" ValidateRequest="false" %>
<%@ Import Namespace="SKtms.Common" %>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=no" />
<meta name="apple-mobile-web-app-capable" content="yes" />
<title>会员组参数设置</title>
<link href="../../scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
<link href="../skin/default/style.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" charset="utf-8" src="../../scripts/jquery/jquery-1.11.2.min.js"></script>
<script type="text/javascript" charset="utf-8" src="../../scripts/jquery/Validform_v5.3.2_min.js"></script>
<script type="text/javascript" charset="utf-8" src="../../scripts/artdialog/dialog-plus-min.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/laymain.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/common.js"></script>
<script type="text/javascript">
    $(function () {
        $(".content-tab-ul-wrap>ul>li a").eq(0).addClass("selected");
        $(".tab-content").eq(0).show();
        //初始化表单验证
        $("#form1").initValidform();
        //初始化子tab
        $(".child-tab-wrap").initChildTab();
    });
</script>
</head>

<body class="mainbody">
<form id="form1" runat="server">
<!--导航栏-->
<div class="location">
    <a href="javascript:history.back(-1);" class="back"><i></i><span>返回上一页</span></a>
    <a href="../center.aspx" class="home"><i></i><span>首页</span></a>
    <i class="arrow"></i>
    <span>会员设置</span>
    <i class="arrow"></i>
    <span>会员组参数设置</span>
</div>
<div class="line10"></div>
<!--/导航栏-->

<!--内容-->
<div id="floatHead" class="content-tab-wrap">
    <div class="content-tab">
        <div class="content-tab-ul-wrap">
            <ul>
            </ul>
        </div>
    </div>
</div>

<asp:Repeater ID="rptList" runat="server" OnItemDataBound="rptList_ItemDataBound">
    <ItemTemplate>
        <script type="text/javascript">$(".content-tab-ul-wrap>ul").append('<li><a href="javascript:;"><%#Eval("group_title")%>的设置</a></li>');</script>
        <!--会员组扩展参数设置-->
        <!--第1层tab选项卡-->
        <div class="tab-content" style="display: none">
            <!--第2层tab外围选项卡-->
            <div class="child-tab-wrap">
                <div class="child-tab-bar">
                    <span class="current">提现设置</span>
                    <span>兑换资金设置</span>
                    <span>黑名单设置</span>
                    <span>商保服务设置</span>
                    <span>特殊入口设置</span>
                </div>
                <div class="child-tab-content" style="display: block;">
                <!-- 以下为提现设置 --->
                <dl>
                    <dd>
                        <input type="hidden" name="group_id" value="<%#Eval("group_id")%>" />
                        <input type="hidden" name="group_title" value="<%#Eval("group_title")%>" />
                        <%#Container.ItemIndex > 0 ? "<input type=\"button\" value=\"复制上一用户组的设置\" class=\"btn green\" onclick=\"copyConfig('tab-content', " + Container.ItemIndex + ")\" />" : ""%>
                    </dd>
                </dl>
                <dl>
                    <dt>是否开启提现功能</dt>
                    <dd>
                        <div class="rule-single-checkbox">
                            <asp:CheckBox ID="tixian_enabled" runat="server" />
                        </div>
                        <span class="Validform_checktip">*是否开启提现功能，关闭大家都不能提现哦</span>
                    </dd>
                </dl>
                <dl>
                    <dt>允许提现类型</dt>
                    <dd>
                        <div class="rule-multi-radio">
                            <asp:RadioButtonList ID="tixian_type" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow">
                            <asp:ListItem Value="0" Selected="True">全部</asp:ListItem>
                            <asp:ListItem Value="1">账户余额</asp:ListItem>
                            <asp:ListItem Value="2">账户佣金</asp:ListItem>
                            </asp:RadioButtonList>
                        </div>
                      <span class="Validform_checktip">*可以选择仅允许账户余额提现或账户佣金提现或全部</span>
                    </dd>
                </dl>
                <dl>
                    <dt>是否实名认证才可提现</dt>
                    <dd>
                        <div class="rule-single-checkbox">
                            <asp:CheckBox ID="tixian_real_name_limit" runat="server" />
                        </div>
                        <span class="Validform_checktip">*是否要通过实名认证的用户才可以提现</span>
                    </dd>
                </dl>
                <dl>
                    <dt>是否要接收手机验证码</dt>
                    <dd>
                        <div class="rule-single-checkbox">
                            <asp:CheckBox ID="tixian_verify_smscode" runat="server" />
                        </div>
                        <span class="Validform_checktip">*是否要接收手机验证码验证后才可以提现</span>
                    </dd>
                </dl>
                <dl>
                    <dt>账户余额提现最低金额</dt>
                    <dd>
                        <input type="text" name="tixian_amount_min_money" class="input small" datatype="n" sucmsg=" " errormsg="请输入有效数字" value="<%#Eval("tixian_amount_min_money")%>" />
                        元  <span class="Validform_checktip">*账户余额提现允许最低提现的金额多少钱</span>
                    </dd>
                </dl>
                <dl>
                    <dt>账户佣金提现最低金额</dt>
                    <dd>
                        <input type="text" name="tixian_comm_min_money" class="input small" datatype="n" sucmsg=" " errormsg="请输入有效数字" value="<%#Eval("tixian_comm_min_money")%>" />
                        元  <span class="Validform_checktip">*账户佣金提现允许最低提现的金额多少钱</span>
                    </dd>
                </dl>
                <dl>
                    <dt>每天允许提现次数</dt>
                    <dd>
                        <input type="text" name="tixian_day_num" class="input small" datatype="n" sucmsg=" " errormsg="请输入有效数字" value="<%#Eval("tixian_day_num")%>" />
                        次  <span class="Validform_checktip">*每天允许提现多少次  0为不限</span>
                    </dd>
                </dl>
                <dl>
                    <dt>向你提现的支付宝账号</dt>
                    <dd>
                        <input type="text" name="tixian_alipay_account" class="input txt" datatype="*" sucmsg=" " value="<%#Eval("tixian_alipay_account")%>" /> 姓名
                        <input type="text" name="tixian_alipay_nick_name" class="input small100" datatype="s2-4" sucmsg=" " value="<%#Eval("tixian_alipay_nick_name")%>" />
                        <span class="Validform_checktip">*用户是在提现页面中向此账号发起收款提现的</span>
                    </dd>
                </dl>
                <dl>
                    <dt>向你提现的财付通账号</dt>
                    <dd>
                        <input type="text" name="tixian_tenpay_account" class="input txt" datatype="n" sucmsg=" " value="<%#Eval("tixian_tenpay_account")%>" /> 姓名
                        <input type="text" name="tixian_tenpay_nick_name" class="input small100" datatype="s2-4" sucmsg=" " value="<%#Eval("tixian_tenpay_nick_name")%>" />
                        <span class="Validform_checktip">*用户是在提现页面中向此账号发起收款提现的</span>
                    </dd>
                </dl>
                <!-- /以下为提现设置 --->
                </div>
                <div class="child-tab-content" style="display: none;">
                <!-- 以下为回收兑换设置 --->
                <dl>
                    <dt>发布点兑换资金比率</dt>
                    <dd>1个点= <input type="text" name="exchange_task_point_to_money" class="input small" datatype="/^[0-9.]{1,4}$/" sucmsg=" " errormsg="请输入有效数字" value="<%#Eval("exchange_task_point_to_money")%>" title="一个发布点兑换成账户资金多少钱，若不想开启本项兑换功能，请填写0" />
                        元， 最少 <input type="text" name="exchange_task_point_min_num" class="input small" datatype="n" sucmsg=" " errormsg="请输入有效数字" value="<%#Eval("exchange_task_point_min_num")%>" title="请输入整数，填写0为不限制个数" /> 个起兑换
                        <span class="Validform_checktip">*若不想开启本项兑换功能，请在金额输入框填写0</span>
                    </dd>
                </dl>
                <dl>
                    <dt>收藏点兑换资金比率</dt>
                    <dd>1个点= <input type="text" name="exchange_collect_point_to_money" class="input small" datatype="/^[0-9.]{1,4}$/" sucmsg=" " errormsg="请输入有效数字" value="<%#Eval("exchange_collect_point_to_money")%>" title="一个收藏点兑换成账户资金多少钱，若不想开启本项兑换功能，请填写0" />
                        元， 最少 <input type="text" name="exchange_collect_point_min_num" class="input small" datatype="n" sucmsg=" " errormsg="请输入有效数字" value="<%#Eval("exchange_collect_point_min_num")%>" title="请输入整数，填写0为不限制个数" /> 个起兑换
                        <span class="Validform_checktip">*若不想开启本项兑换功能，请在金额输入框填写0</span>
                    </dd>
                </dl>
                <dl>
                    <dt>流量点兑换资金比率</dt>
                    <dd>1个点= <input type="text" name="exchange_flow_point_to_money" class="input small" datatype="/^[0-9.]{1,5}$/" sucmsg=" " errormsg="请输入有效数字" value="<%#Eval("exchange_flow_point_to_money")%>" title="一个流量点兑换成账户资金多少钱，若不想开启本项兑换功能，请填写0" />
                        元， 最少 <input type="text" name="exchange_flow_point_min_num" class="input small" datatype="n" sucmsg=" " errormsg="请输入有效数字" value="<%#Eval("exchange_flow_point_min_num")%>" title="请输入整数，填写0为不限制个数" /> 个起兑换
                        <span class="Validform_checktip">*若不想开启本项兑换功能，请在金额输入框填写0</span>
                    </dd>
                </dl>
                <dl>
                    <dt>积分兑换资金比率</dt>
                    <dd>1个积分= <input type="text" name="exchange_score_to_money" class="input small" datatype="/^[0-9.]{1,5}$/" sucmsg=" " errormsg="请输入有效数字" value="<%#Eval("exchange_score_to_money")%>" title="一个积分兑换成账户资金多少钱，若不想开启本项兑换功能，请填写0" />
                        元， 最少 <input type="text" name="exchange_score_min_num" class="input small" datatype="n" sucmsg=" " errormsg="请输入有效数字" value="<%#Eval("exchange_score_min_num")%>" title="请输入整数，填写0为不限制个数" /> 分起兑换
                        <span class="Validform_checktip">*若不想开启本项兑换功能，请在金额输入框填写0</span>
                    </dd>
                </dl>
                <!-- /以下为回收兑换设置 --->
                </div>
                <div class="child-tab-content" style="display: none;">
                <!-- 以下为黑名单设置 --->
                <dl>
                    <dt>允许黑名单人数</dt>
                    <dd>
                        <input type="text" name="blackList_allow_num" class="input small" datatype="n" sucmsg=" " errormsg="请输入有效数字" value="<%#Eval("blackList_allow_num")%>" />
                        人  <span class="Validform_checktip">*允许拉入黑名单多少人</span>
                    </dd>
                </dl>
                <dl>
                    <dt>人数超额另扣多少钱</dt>
                    <dd>
                        <input type="text" name="blackList_excess_need_money" class="input small" datatype="/^[0-9.]{1,4}$/" sucmsg=" " errormsg="请输入有效数字" value="<%#Eval("blackList_excess_need_money")%>" />
                        元/人  <span class="Validform_checktip">*黑名单超额，每多增加一个用户需要扣多少钱</span>
                    </dd>
                </dl>
                <dl>
                    <dt>被多少人拉黑禁止接手任务</dt>
                    <dd>
                        <input type="text" name="blackList_max_num_lockout" class="input small" datatype="n" sucmsg=" " errormsg="请输入有效数字" value="<%#Eval("blackList_max_num_lockout")%>" />
                        人  <span class="Validform_checktip">*被别人拉入黑名单达到设定数量就禁止接手任务</span>
                    </dd>
                </dl>
                <!-- /以下为黑名单设置 --->
                </div>
                <div class="child-tab-content" style="display: none;">
                <dl>
                    <dt>商保服务价格设置</dt>
                    <dd>
                        <textarea rows="20" cols="20" name="shangbao_join_and_jieshou_money" class="input" datatype="/^[\d=\s]+$/" sucmsg=" " style="height:150px;"><%#Eval("shangbao_join_and_jieshou_money").ToString().Replace(",","\r\n")%></textarea>
                        <span class="Validform_checktip"></span><br />
                        <span class="tips">*商保服务价格及可接手任务总额参数设置，一行一个定义<br />
                      格式如：100=200<br />
                      表示加入商保100元可接手未完成商保任务总额200元，其他类推可按格式无限添加</span>
                    </dd>
                </dl>
                </div>
                <div class="child-tab-content" style="display: none;">
                <dl>
                    <dt>允许自由切换买/卖家身份</dt>
                    <dd>
                      <div class="rule-single-checkbox">
                          <asp:CheckBox ID="user_type_switch" runat="server" />
                      </div>
                      <span class="Validform_checktip">*开启后，用户可在会员中心自由切换买家或卖家身份，关闭则不允许切换（目前仅针对商家有效,买家则需要购买转换商家卡）</span>
                    </dd>
                </dl>
                <dl>
                    <dt>是否开启红包试用任务入口</dt>
                    <dd>
                      <div class="rule-single-checkbox">
                          <asp:CheckBox ID="hongbao_try_enter_enabled" runat="server" />
                      </div>
                      <span class="Validform_checktip">*开启后，前台和会员中心菜单会显示红包活动（或红包试用）链接入口，关闭则不显示（另也可针对特定会员组开放）</span>
                    </dd>
                </dl>
                <dl>
                    <dt>是否开启订购空包快递入口</dt>
                    <dd>
                      <div class="rule-single-checkbox">
                          <asp:CheckBox ID="express_kb_enter_enabled" runat="server" />
                      </div>
                      <span class="Validform_checktip">*开启后，会员中心菜单会显示“订购空包快递”及相关链接入口，关闭则不显示（另也可针对特定会员组开放）</span>
                    </dd>
                </dl>
                <dl>
                    <dt>是否开启领取快递单号入口</dt>
                    <dd>
                      <div class="rule-single-checkbox">
                          <asp:CheckBox ID="express_lq_enter_enabled" runat="server" />
                      </div>
                      <span class="Validform_checktip">*开启后，会员中心菜单会显示“领取空包快递”及相关链接入口，关闭则不显示（注：目前基本不用了，一般关闭）</span>
                    </dd>
                </dl>
                <dl>
                    <dt>是否开启双向指定单号入口</dt>
                    <dd>
                      <div class="rule-single-checkbox">
                          <asp:CheckBox ID="express_zd_enter_enabled" runat="server" />
                      </div>
                      <span class="Validform_checktip">*开启后，会员中心菜单会显示“指定空包快递”及相关链接入口，关闭则不显示（注：目前基本不用了，一般关闭）</span>
                    </dd>
                </dl>
                <dl>
                    <dt>是否开启购买淘宝小号入口</dt>
                    <dd>
                      <div class="rule-single-checkbox">
                          <asp:CheckBox ID="account_buy_enter_enabled" runat="server" />
                      </div>
                      <span class="Validform_checktip">*开启后，会员中心菜单会显示“购买淘宝小号”链接入口，关闭则不显示（也通用售卖其他账号，如果没货源，建议关闭）</span>
                    </dd>
                </dl>
                <dl>
                    <dt>是否开启购买软件卡密入口</dt>
                    <dd>
                      <div class="rule-single-checkbox">
                          <asp:CheckBox ID="software_buy_enter_enabled" runat="server" />
                      </div>
                      <span class="Validform_checktip">*开启后，会员中心菜单会显示“购买软件卡密”链接入口，关闭则不显示（一般售卖激活密钥KEY或类似产品，如果没货源，建议关闭）</span>
                    </dd>
                </dl>
                </div>
            </div>
            <!--/第2层tab外围选项卡-->
        </div>
        <!--/第1层tab选项卡-->
        <!--/会员组扩展参数设置-->
    </ItemTemplate>
    <FooterTemplate>
        <% if (rptList.Items.Count == 0)
            {%>
        <div class="tab-content">
            <dd>请先创建用户组再回来设置！
            </dd>
        </div>
        <%}%>
    </FooterTemplate>
</asp:Repeater>

<!--/内容-->

<!--工具栏-->
<div class="page-footer">
    <div class="btn-wrap">
        <asp:Button ID="btnSubmit" runat="server" Text="提交保存" CssClass="btn" OnClick="btnSubmit_Click" />
        <input name="btnReturn" type="button" value="返回上一页" class="btn yellow" onclick="javascript: history.back(-1);" />
    </div>
</div>
<!--/工具栏-->
</form>
</body>
</html>