﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="recharge_edit.aspx.cs" Inherits="SKtms.Web.admin.users.recharge_edit" ValidateRequest="false" %>

<%@ Import Namespace="SKtms.Common" %>

<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=no" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <title>会员充值</title>
    <link href="../../scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
    <link href="../skin/default/style.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript" charset="utf-8" src="../../scripts/jquery/jquery-1.11.2.min.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../scripts/jquery/Validform_v5.3.2_min.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../scripts/artdialog/dialog-plus-min.js"></script>
    <script type="text/javascript" charset="utf-8" src="../js/laymain.js"></script>
    <script type="text/javascript" charset="utf-8" src="../js/common.js"></script>
    <script type="text/javascript">
        $(function () {
            //初始化表单验证
            $("#form1").initValidform();
        });
    </script>
    <script type="text/javascript">
        $(function () {
            $("#txtRechargeNo2").val($("#txtRechargeNo").val());
            $("#rbRechargeTypeSelect a").click(function () {
                var index = $(this).index($("#rbRechargeTypeSelect a"));
                if (index == 0) {
                    $("#txtRechargeNo").val($("#txtRechargeNo2").val());
                    $("#soft_recharge_extend_item").hide();
                } else {
                    if ($("#txtRechargeNo").val().length < 28) {
                        $("#txtRechargeNo").val("");
                    }
                    $("#soft_recharge_extend_item").show();
                }
            });
            if ($("#rbRechargeTypeSelect a").eq(1).hasClass("selected")) {
                $("#soft_recharge_extend_item").show();
                $("#txtUserName").focus();
            }
        });
    </script>
</head>

<body class="mainbody">
<form id="form1" runat="server">
    <!--导航栏-->
    <div class="location">
        <a href="recharge_list.aspx" class="back"><i></i><span>返回列表页</span></a>
        <a href="../center.aspx" class="home"><i></i><span>首页</span></a>
        <i class="arrow"></i>
        <a href="recharge_list.aspx"><span>充值记录</span></a>
        <i class="arrow"></i>
        <span>会员充值</span>
    </div>
    <div class="line10"></div>
    <!--/导航栏-->

    <!--内容-->
    <div id="floatHead" class="content-tab-wrap">
        <div class="content-tab">
            <div class="content-tab-ul-wrap">
                <ul>
                    <li><a class="selected" href="javascript:;">充值信息</a></li>
                </ul>
            </div>
        </div>
    </div>

    <div class="tab-content">
        <dl>
            <dt>用户名</dt>
            <dd>
                <asp:TextBox ID="txtUserName" runat="server" CssClass="input txt" datatype="*3-50" sucmsg=" " ajaxurl="../../tools/submit_ajax.ashx?action=validate_username_exist"></asp:TextBox>
                <span class="Validform_checktip">*需要充值的会员用户名</span>
            </dd>
        </dl>
        <dl>
            <dt>支付方式</dt>
            <dd>
                <div class="rule-single-select">
                    <asp:DropDownList ID="ddlPaymentId" runat="server" datatype="*" errormsg="请选择支付方式" sucmsg=" "></asp:DropDownList>
                </div>
            </dd>
        </dl>
        <dl>
            <dt>充值方式</dt>
            <dd>
                <div class="rule-multi-radio" id="rbRechargeTypeSelect">
                    <asp:RadioButtonList ID="rbRechargeType" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow">
                        <asp:ListItem Value="0" Selected="True">账户余额/网银接口充值</asp:ListItem>
                        <asp:ListItem Value="1">软件充值</asp:ListItem>
                    </asp:RadioButtonList>
                </div>
            </dd>
        </dl>
        <div id="soft_recharge_extend_item" style="display:none;">
        <dl>
            <dt>是否即时到账</dt>
            <dd>
                <div class="rule-single-checkbox">
                    <asp:CheckBox ID="IsPay" runat="server" Checked="true" Enabled="true" />
                </div>
                <span class="Validform_checktip">*选是，即时到账同时该交易号不能再充值，选否，仅提交再由软件自动充值（只对软件充值方式有效）</span>
            </dd>
        </dl>
        <dl>
            <dt>是否禁止交易号充值</dt>
            <dd>
                <div class="rule-single-checkbox">
                    <asp:CheckBox ID="IsForbiddenCheckBox" runat="server" Enabled="True" />
                </div>
                <span class="Validform_checktip">*是否禁止该交易号充值，如果上一项选了即时到账，本项就无效（只对软件充值方式有效）</span>
            </dd>
        </dl>
        </div>
        <dl>
            <dt>订单号/交易号</dt>
            <dd>
                <asp:TextBox ID="txtRechargeNo" runat="server" CssClass="input normal" datatype="*2-100" sucmsg=" "></asp:TextBox>
                <span class="Validform_checktip">*订单号:系统随机生成 &nbsp;交易号:支付宝或财付通交易的流水号</span>
                <input id="txtRechargeNo2" name="txtRechargeNo2" type="hidden" />
            </dd>
        </dl>
        <dl>
            <dt>充值金额</dt>
            <dd>
                <asp:TextBox ID="txtAmount" runat="server" CssClass="input small100" datatype="/^-?(([1-9]{1}\d*)|([0]{1}))(\.(\d){1,2})?$/" sucmsg=" "></asp:TextBox> 元
                <span class="Validform_checktip">*给该会员充值的金额，负数则扣款</span>
            </dd>
        </dl>
        <dl>
            <dt>备注</dt>
            <dd>
                <asp:TextBox ID="txtRemark" runat="server" CssClass="input normal" datatype="*" sucmsg=" " ignore="ignore"></asp:TextBox>
                <span class="Validform_checktip">*备注,可留空</span>
            </dd>
        </dl>
        <dl>
            <dt>是否发送站内信通知</dt>
            <dd>
                <div class="rule-single-checkbox">
                    <asp:CheckBox ID="IsSendMessageCheckBox" runat="server" Checked="true" />
                </div>
            </dd>
        </dl>
        <dl>
            <dt>通知内容</dt>
            <dd>
                <asp:TextBox ID="txtMessage" runat="server" CssClass="input normal" datatype="*" sucmsg=" " TextMode="MultiLine"></asp:TextBox>
                <span class="Validform_checktip">*发送站内信</span>
            </dd>
        </dl>
    </div>
    <!--/内容-->

    <!--工具栏-->
    <div class="page-footer">
        <div class="btn-wrap">
            <asp:Button ID="btnSubmit" runat="server" Text="提交保存" CssClass="btn" OnClick="btnSubmit_Click" />
            <input name="btnReturn" type="button" value="返回上一页" class="btn yellow" onclick="javascript: history.back(-1);" />
        </div>
    </div>
    <!--/工具栏-->

</form>
</body>
</html>
