﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="recharge_list.aspx.cs" Inherits="SKtms.Web.admin.users.recharge_list" %>
<%@ Import namespace="SKtms.Common" %>

<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=no" />
<meta name="apple-mobile-web-app-capable" content="yes" />
<title>充值记录</title>
<link href="../../scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
<link href="../skin/default/style.css" rel="stylesheet" type="text/css" />
<link href="../../css/pagination.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" charset="utf-8" src="../../scripts/jquery/jquery-1.11.2.min.js"></script>
<script type="text/javascript" charset="utf-8" src="../../scripts/artdialog/dialog-plus-min.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/laymain.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/common.js"></script>
</head>

<body class="mainbody">
<script type="text/javascript">
    $(function () {
        $(".invalid_link").click(function () {
            $(this).parents().find(".checkall input[type='checkbox']").prop("checked", false);
            $(this).parent().parent().find(".checkall input[type='checkbox']").prop("checked", true);
            return ExePostBack('btnInvalid', '您确定该笔款项是有误或无效吗？');
        });
        $(".audit_link").click(function () {
            $(this).parents().find(".checkall input[type='checkbox']").prop("checked", false);
            $(this).parent().parent().find(".checkall input[type='checkbox']").prop("checked", true);
            return ExePostBack('btnAudit', '您确定该笔款项已到账了吗？<br><br>注：本功能主要用于软件充值方式无法自动充值时在后台人工入款。');
        });
        setMoneyCount();
    });
    function setMoneyCount() {
        var moneyCount = 0;
        $(".money").each(function () {
            moneyCount = moneyCount + parseFloat($(this).html().replace(" 元", "").replace("+ ", ""));
        });
        $("#moneyCount").html(moneyCount + " 元");
    }
</script>
<form id="form1" runat="server">
<!--导航栏-->
<div class="location">
  <a href="javascript:history.back(-1);" class="back"><i></i><span>返回上一页</span></a>
  <a href="../center.aspx" class="home"><i></i><span>首页</span></a>
  <i class="arrow"></i>
  <span>财务管理</span>
  <i class="arrow"></i>
  <span>充值记录</span>
</div>
<!--/导航栏-->

<!--工具栏-->
<div id="floatHead" class="toolbar-wrap">
  <div class="toolbar">
    <div class="box-wrap">
      <a class="menu-btn"></a>
      <div class="l-list">
        <ul class="icon-list">
          <li><a class="add" href="recharge_edit.aspx"><i></i><span>充值</span></a></li>
          <li><a class="all" href="javascript:;" onclick="checkAll(this);"><i></i><span>全选</span></a></li>
          <li><asp:LinkButton ID="btnAudit" runat="server" CssClass="" OnClientClick="return ExePostBack('btnAudit','您确定该笔款项已到账了吗？<br><br>注：本功能主要用于软件充值方式无法自动充值时在后台人工入款。');" onclick="btnAudit_Click"><i></i><span>入款</span></asp:LinkButton></li>
          <li><asp:LinkButton ID="btnInvalid" runat="server" CssClass="lock" OnClientClick="return ExePostBack('btnInvalid','您确定该笔款项是有误或无效吗？');" onclick="btnInvalid_Click"><i></i><span>无效</span></asp:LinkButton></li>
          <li><asp:LinkButton ID="btnDelete" runat="server" CssClass="del" OnClientClick="return ExePostBack('btnDelete','您确定删除吗？');" onclick="btnDelete_Click"><i></i><span>删除</span></asp:LinkButton></li>
        </ul>
      </div>
      <div class="r-list">
        <asp:TextBox ID="txtKeywords" runat="server" CssClass="keyword" />
        <asp:LinkButton ID="lbtnSearch" runat="server" CssClass="btn-search" onclick="btnSearch_Click">查询</asp:LinkButton>
      </div>
    </div>
  </div>
</div>
<!--/工具栏-->

<!--列表-->
<div class="table-container">
<asp:Repeater ID="rptList" runat="server">
<HeaderTemplate>
<table width="100%" border="0" cellspacing="0" cellpadding="0" class="ltable">
  <tr>
    <th width="5%">选择</th>
    <th align="left" width="8%">用户名</th>
    <th align="left" width="7%">真实姓名</th>
    <th align="left" width="18%">订单号 / 交易号</th>
    <th align="left" width="10%">支付方式</th>
    <th align="left" width="7%">金额</th>
    <th align="left" width="14%">状态 / 完成时间</th>
    <th align="left" width="9%">创建时间</th>
    <th width="7%">操作员</th>
    <th width="">备注</th>
    <th width="7%">操作</th>
  </tr>
</HeaderTemplate>
<ItemTemplate>
  <tr>
    <td align="center">
      <asp:CheckBox ID="chkId" CssClass="checkall" runat="server" style="vertical-align:middle;" />
      <asp:HiddenField ID="hidId" Value='<%#Eval("id")%>' runat="server" />
    </td>
    <td><%#Eval("user_name")%></td>
    <td><%#Eval("user_real_name")%></td>
    <td><%#Eval("recharge_no")%></td>
    <td><%#new SKtms.BLL.payment().GetTitle(Convert.ToInt32(Eval("payment_id")))%><%#get_recharge_type_str(Convert.ToInt32(Eval("recharge_type")))%></td>
    <td class="money"><%#Convert.ToDecimal(Eval("amount")) > 0 ? "+" + Utils.GetNum(Eval("amount").ToString()) : Utils.GetNum(Eval("amount").ToString())%> 元</td>
    <td><%#get_status_str( Convert.ToInt32(Eval("status")), Utils.ObjectToDateTime(Eval("complete_time")) )%></td>
    <td><%#Eval("add_time")%></td>
    <td align="center"><%#Eval("inputer")%></td>
    <td align="center"><%#Eval("remark")%></td>
    <td align="center">
        <%#Convert.ToInt32(Eval("status")) == 0 && Convert.ToInt32(Eval("recharge_type")) == 1 ? "<a href=\"#\" class=\"audit_link\">入款</a> <a href=\"#\" class=\"invalid_link\">无效</a>" : ""%>
        <a href="recharge_edit.aspx?username=<%#Eval("user_name")%>">充值</a>
    </td>
  </tr>
</ItemTemplate>
<FooterTemplate>
    <tr>
        <td></td>
        <td colspan="3">今日成功充值：<%=Utils.GetNum(today_totalMoney)%> 元 （支付宝：<%=Utils.GetNum(today_alipayMoney)%> 元 &nbsp; 财付通：<%=Utils.GetNum(today_tenpayMoney)%> 元 &nbsp; 网银：<%=Utils.GetNum(today_bankMoney)%> 元 &nbsp; 其他：<%=Utils.GetNum(today_otherMoney)%> 元）</td>
        <td align="right">本页合计：</td>
        <td align="center" id="moneyCount"></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>
    <tr>
        <td></td>
        <td colspan="3">昨日成功充值：<%=Utils.GetNum(yesterday_totalMoney)%> 元 （支付宝：<%=Utils.GetNum(yesterday_alipayMoney)%> 元 &nbsp; 财付通：<%=Utils.GetNum(yesterday_tenpayMoney)%> 元 &nbsp; 网银：<%=Utils.GetNum(yesterday_bankMoney)%> 元 &nbsp; 其他：<%=Utils.GetNum(yesterday_otherMoney)%> 元）</td>
        <td align="right">成功充值总计：</td>
        <td align="center"><%=Utils.GetNum(totalMoney)%> 元</td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>
  <%#rptList.Items.Count == 0 ? "<tr><td align=\"center\" colspan=\"11\">暂无记录</td></tr>" : ""%>
</table>
</FooterTemplate>
</asp:Repeater>
</div>
<!--/列表-->

<!--内容底部-->
<div class="line20"></div>
<div class="pagelist">
  <div class="l-btns">
    <span>显示</span><asp:TextBox ID="txtPageNum" runat="server" CssClass="pagenum" onkeydown="return checkNumber(event);"
                OnTextChanged="txtPageNum_TextChanged" AutoPostBack="True"></asp:TextBox><span>条/页</span>
  </div>
  <div id="PageContent" runat="server" class="default"></div>
</div>
<!--/内容底部-->

</form>
</body>
</html>
