﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="score_log.aspx.cs" Inherits="SKtms.Web.admin.users.score_log" %>
<%@ Import namespace="SKtms.Common" %>

<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=no" />
<meta name="apple-mobile-web-app-capable" content="yes" />
<title>积分记录</title>
<link href="../../scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
<link href="../skin/default/style.css" rel="stylesheet" type="text/css" />
<link href="../../css/pagination.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" charset="utf-8" src="../../scripts/jquery/jquery-1.11.2.min.js"></script>
<script type="text/javascript" charset="utf-8" src="../../scripts/artdialog/dialog-plus-min.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/laymain.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/common.js"></script>
</head>

<body class="mainbody">
<form id="form1" runat="server">
<!--导航栏-->
<div class="location">
  <a href="javascript:history.back(-1);" class="back"><i></i><span>返回上一页</span></a>
  <a href="../center.aspx" class="home"><i></i><span>首页</span></a>
  <i class="arrow"></i>
  <span>财务管理</span>
  <i class="arrow"></i>
  <span>积分明细</span>
</div>
<!--/导航栏-->

<!--工具栏-->
<div id="floatHead" class="toolbar-wrap">
  <div class="toolbar">
    <div class="box-wrap">
      <a class="menu-btn"></a>
      <div class="l-list">
        <ul class="icon-list">
          <li><a class="add" href="score_edit.aspx"><i></i><span>充值</span></a></li>
          <li><a class="all" href="javascript:;" onclick="checkAll(this);"><i></i><span>全选</span></a></li>
          <li><asp:LinkButton ID="btnDelete" runat="server" CssClass="del" OnClientClick="return ExePostBack('btnDelete');" onclick="btnDelete_Click"><i></i><span>删除</span></asp:LinkButton></li>
        </ul>
      </div>
      <div class="r-list">
        <asp:TextBox ID="txtKeywords" runat="server" CssClass="keyword" />
        <asp:LinkButton ID="lbtnSearch" runat="server" CssClass="btn-search" onclick="btnSearch_Click">查询</asp:LinkButton>
      </div>
    </div>
  </div>
</div>
<!--/工具栏-->

<!--列表-->
<div class="table-container">
<asp:Repeater ID="rptList" runat="server">
<HeaderTemplate>
<table width="100%" border="0" cellspacing="0" cellpadding="0" class="ltable">
  <tr>
    <th align="center" width="5%">选择</th>
    <th align="center" width="10%">ID</th>
    <th align="center" width="10%">用户名</th>
    <th align="center" width="10%">消费时间</th>
    <th align="center" width="10%">IP地址</th>
    <th align="center" width="8%">收入</th>
    <th align="center" width="8%">支出</th>
    <th align="center" width="8%">摘要</th>
    <th align="center" width="8%">操作员</th>
    <th align="center" width="8%">余额</th>
    <th align="center" width="15%">备注</th>
  </tr>
</HeaderTemplate>
<ItemTemplate>
  <tr>
    <td align="center">
      <asp:CheckBox ID="chkId" CssClass="checkall" runat="server" style="vertical-align:middle;" />
      <asp:HiddenField ID="hidId" Value='<%#Eval("id")%>' runat="server" />
    </td>
    <td align="center"><%#Eval("id")%></td>
    <td align="center"><%#Eval("user_name")%></td>
    <td align="center"><%#string.Format("{0:g}", Eval("add_time"))%></td>
    <td align="center"><%#Eval("user_ip")%></td>
    <td align="center"><%#get_in_point_format( Utils.ObjToDecimal(Eval("point"),0m), Utils.ObjToInt(Eval("in_or_out_flag")) )%></td>
    <td align="center"><%#get_out_point_format( Utils.ObjToDecimal(Eval("point"),0m), Utils.ObjToInt(Eval("in_or_out_flag")) )%></td>
    <td align="center"><%#get_in_or_out_flag_format(  Utils.ObjToInt(Eval("in_or_out_flag")) )%></td>
    <td align="center"><%#Eval("inputer")%></td>
    <td align="center"><%#Eval("curr_point")%></td>
    <td align="center"><%#Eval("remark")%></td>
  </tr>
</ItemTemplate>
<FooterTemplate>
  <%#rptList.Items.Count == 0 ? "<tr><td align=\"center\" colspan=\"11\">暂无记录</td></tr>" : ""%>
</table>
</FooterTemplate>
</asp:Repeater>
</div>
<!--/列表-->

<!--内容底部-->
<div class="line20"></div>
<div class="pagelist">
  <div class="l-btns">
    <span>显示</span><asp:TextBox ID="txtPageNum" runat="server" CssClass="pagenum" onkeydown="return checkNumber(event);"
                OnTextChanged="txtPageNum_TextChanged" AutoPostBack="True"></asp:TextBox><span>条/页</span>
  </div>
  <div id="PageContent" runat="server" class="default"></div>
</div>
<!--/内容底部-->

</form>
</body>
</html>
