﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="user_edit.aspx.cs" Inherits="SKtms.Web.admin.users.user_edit" ValidateRequest="false" %>
<%@ Import Namespace="SKtms.Common" %>

<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=no" />
<meta name="apple-mobile-web-app-capable" content="yes" />
<title>编辑会员</title>
<link href="../../scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
<link href="../skin/default/style.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" charset="utf-8" src="../../scripts/jquery/jquery-1.11.2.min.js"></script>
<script type="text/javascript" charset="utf-8" src="../../scripts/jquery/Validform_v5.3.2_min.js"></script>
<script type="text/javascript" charset="utf-8" src="../../scripts/datepicker/WdatePicker.js"></script>
<script type="text/javascript" charset="utf-8" src="../../scripts/artdialog/dialog-plus-min.js"></script>
<script type="text/javascript" charset="utf-8" src="../../scripts/webuploader/webuploader.min.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/uploader.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/laymain.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/common.js"></script>
<script type="text/javascript">
    $(function () {
        //初始化表单验证
        $("#form1").initValidform();
        //初始化上传控件
        $(".upload-img").InitUploader({ sendurl: "../../tools/upload_ajax.ashx", swf: "../../scripts/webuploader/uploader.swf" });
        //绑定开启异地登录限制点击事件
        $("#isCheckLoginCity").click(function () {
            $.ajax({
                type: "get",
                url: "../../tools/admin_ajax.ashx",
                data: {action: "check_login_city", user_id: <%=BSRequest.GetQueryInt("id")%>, value: $(this).prop("checked")},
                dataType: "json",
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                    parent.dialog({
                        title: '提示',
                        content: '设置超时，请稍候再试！错误信息：' + XMLHttpRequest + "  = " + errorThrown,
                        okValue: '确定',
                        ok: function () { }
                    }).show();
                },
                success: function (data, textStatus) {
                    if (data.status == 1) {
                        var d = parent.dialog({ content: data.msg }).show();
                        setTimeout(function () {
                            d.close().remove();
                        }, 2000);
                    } else {
                        parent.dialog({
                            title: '提示',
                            content: '错误提示：' + data.msg,
                            okValue: '确定',
                            ok: function () { }
                        }).show();
                    }
                }
            });            
        });
        //绑定头像更新和放大缩小
        $("#txtAvatar").bind("change focus", function () {
            setAvatar();
        });        
        $(".preview").hover(
            function () {
                setAvatar();
                $(this).attr({width:80, height:80});
            },
            function () {
                $(this).attr({width:30, height:30});
            }
        );
        function setAvatar(){
            var avatar = $("#txtAvatar").val();
            if(avatar != ''){
                $('.preview').attr('src', avatar);
            }
        }
        setAvatar();
    });
</script>
</head>

<body class="mainbody">
<form id="form1" runat="server">
<!--导航栏-->
<div class="location">
    <a href="user_list.aspx" class="back"><i></i><span>返回列表页</span></a>
    <a href="../center.aspx" class="home"><i></i><span>首页</span></a>
    <i class="arrow"></i>
    <a href="user_list.aspx"><span>会员管理</span></a>
    <i class="arrow"></i>
    <span>编辑会员</span>
</div>
<div class="line10"></div>
<!--/导航栏-->

<!--内容-->
<div id="floatHead" class="content-tab-wrap">
    <div class="content-tab">
        <div class="content-tab-ul-wrap">
            <ul>
                <li><a class="selected" href="javascript:;">基本资料</a></li>
                <li><a href="javascript:;">资金信息</a></li>
                <li><a href="javascript:;">认证信息</a></li>
                <li><a href="javascript:;">活动/任务信息</a></li>
                <li><a href="javascript:;">日志信息</a></li>
            </ul>
        </div>
    </div>
</div>

<div class="tab-content">
    <dl>
        <dt>用户名</dt>
        <dd>
            <asp:TextBox ID="txtUserName" runat="server" CssClass="input txt" datatype="s3-30" sucmsg=" " ajaxurl="../../tools/admin_ajax.ashx?action=username_validate"></asp:TextBox>
            <span class="Validform_checktip">*登录的用户名，支持中文</span> &nbsp; 
            <asp:HyperLink ID="hlkViewAlliance" runat="server" Visible="false">查看下线</asp:HyperLink>
        </dd>
    </dl>
    <dl>
        <dt>用户昵称</dt>
        <dd>
            <asp:TextBox ID="txtNickName" runat="server" CssClass="input txt" datatype="s" errormsg="请输入用户昵称或真实姓名" ignore="ignore" sucmsg=" "></asp:TextBox>
            <span class="Validform_checktip">*用户昵称或真实姓名</span></dd>
    </dl>
    <dl>
        <dt>会员组别</dt>
        <dd>
            <div class="rule-single-select">
                <asp:DropDownList ID="ddlGroupId" runat="server" datatype="*" errormsg="请选择会员组别" sucmsg=" "></asp:DropDownList>
            </div>
        </dd>
    </dl>
    <dl>
        <dt>佣金奖励组别</dt>
        <dd>
            <div class="rule-single-select">
                <asp:DropDownList ID="ddlCommissionsID" runat="server"></asp:DropDownList>
            </div>
        </dd>
    </dl>
    <dl>
        <dt>购买的会员卡</dt>
        <dd>
            <div class="rule-single-select">
                <asp:DropDownList ID="ddlUseCardId" runat="server"></asp:DropDownList>
            </div>
            &nbsp; 开始日期　<asp:TextBox ID="txtBeginDate" runat="server" CssClass="input rule-date-input" onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss'})" datatype="/^\s*$|^\d{4}\-\d{1,2}\-\d{1,2}([\s\d:]+)?$/" errormsg="请选择正确的日期" sucmsg=" " ignore="ignore" />
            &nbsp; 结束日期　<asp:TextBox ID="txtEndDate" runat="server" CssClass="input rule-date-input" onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss'})" datatype="/^\s*$|^\d{4}\-\d{1,2}\-\d{1,2}([\s\d:]+)?$/" errormsg="请选择正确的日期" sucmsg=" " ignore="ignore" />
            <span class="Validform_checktip"></span>
        </dd>
    </dl>
    <dl>
        <dt>用户状态</dt>
        <dd>
            <div class="rule-multi-radio">
                <asp:RadioButtonList ID="rblStatus" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow">
                    <asp:ListItem Value="0" Selected="True">正常</asp:ListItem>
                    <asp:ListItem Value="1">待验证</asp:ListItem>
                    <asp:ListItem Value="2">待审核</asp:ListItem>
                    <asp:ListItem Value="3">锁定</asp:ListItem>
                </asp:RadioButtonList>
            </div>
            <span class="Validform_checktip">*锁定账户无法登录</span>
        </dd>
    </dl>
    <dl>
        <dt>登录密码</dt>
        <dd>
            <asp:TextBox ID="txtPassword" runat="server" CssClass="input txt" datatype="*6-20" nullmsg="请设置密码" errormsg="密码范围在6-20位之间" sucmsg=" "></asp:TextBox>
            <span class="Validform_checktip">*如果不想修改，请留空</span>
        </dd>
    </dl>
    <dl>
        <dt>二级密码</dt>
        <dd>
            <asp:TextBox ID="txtPayPassword" runat="server" CssClass="input txt" datatype="*6-20" nullmsg="请设置二级密码" errormsg="密码范围在6-20位之间" sucmsg=" "></asp:TextBox>
            <span class="Validform_checktip">*如果不想修改，请留空</span>
        </dd>
    </dl>
    <dl>
        <dt>密保问题</dt>
        <dd>
            <div class="rule-single-select">
                <asp:DropDownList ID="ddlQuestion" runat="server">
                    <asp:ListItem Value="">-- 请选择密保问题 --</asp:ListItem>
                    <asp:ListItem>您的出生地是？</asp:ListItem>
                    <asp:ListItem>您父亲的姓名是？</asp:ListItem>
                    <asp:ListItem>您母亲的姓名是？</asp:ListItem>
                    <asp:ListItem>您配偶的姓名是？</asp:ListItem>
                    <asp:ListItem>您小学的学校名称是？</asp:ListItem>
                    <asp:ListItem>您的旺旺账号是？</asp:ListItem>
                    <asp:ListItem>您的QQ账号是？</asp:ListItem>
                    <asp:ListItem>您父亲的生日是？</asp:ListItem>
                    <asp:ListItem>您母亲的生日是？</asp:ListItem>
                    <asp:ListItem>您配偶的生日是？</asp:ListItem>
                    <asp:ListItem>我的宠物名字是？</asp:ListItem>
                    <asp:ListItem>我最好的朋友是谁？</asp:ListItem>
                    <asp:ListItem>我最喜爱的颜色？</asp:ListItem>
                    <asp:ListItem>我最喜爱的电影？</asp:ListItem>
                    <asp:ListItem>我最喜爱的影星？</asp:ListItem>
                    <asp:ListItem>我最喜爱的歌曲？</asp:ListItem>
                    <asp:ListItem>我最喜爱的食物？</asp:ListItem>
                    <asp:ListItem>我最大的爱好？</asp:ListItem>
                    <asp:ListItem>我的座右铭是？</asp:ListItem>
                </asp:DropDownList>
            </div>
        </dd>
    </dl>
    <dl>
        <dt>密保答案</dt>
        <dd>
            <asp:TextBox ID="txtAnswer" runat="server" CssClass="input txt" datatype="*2-20" nullmsg="请填写密保答案" errormsg="请填写密保答案" sucmsg=" " ignore="ignore"></asp:TextBox>
            <span class="Validform_checktip">*如果不想修改，请留空</span>
        </dd>
    </dl>
    <dl>
        <dt>推荐人</dt>
        <dd>
            <asp:TextBox ID="txtAllianceUser" runat="server" CssClass="input txt" datatype="s" sucmsg=" " ignore="ignore" ajaxurl="../../tools/submit_ajax.ashx?action=validate_username_exist"></asp:TextBox>
            <span class="Validform_checktip">输入推荐人账号，可留空</span> &nbsp; 
            <asp:HyperLink ID="hlkViewAllianceUser" runat="server" Visible="false">查看该推荐人下线</asp:HyperLink>
        </dd>
    </dl>
    <dl>
        <dt>头像地址</dt>
        <dd>
            <asp:TextBox ID="txtAvatar" runat="server" CssClass="input normal upload-path"></asp:TextBox>
            <div class="upload-box upload-img"></div>
             &nbsp; <img src="../../templates/main/images/user-avatar.png" class="preview" align="absmiddle" width="32" height="32" title="头像">
        </dd>
    </dl>
    <dl>
        <dt>用户性别</dt>
        <dd>
            <div class="rule-multi-radio">
                <asp:RadioButtonList ID="rblSex" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow">
                    <asp:ListItem Value="保密" Selected="True">保密</asp:ListItem>
                    <asp:ListItem Value="男">男</asp:ListItem>
                    <asp:ListItem Value="女">女</asp:ListItem>
                </asp:RadioButtonList>
            </div>
        </dd>
    </dl>
    <dl>
        <dt>生日日期</dt>
        <dd>
            <asp:TextBox ID="txtBirthday" runat="server" CssClass="input rule-date-input" onfocus="WdatePicker({dateFmt:'yyyy-MM-dd'})" datatype="/^\s*$|^\d{4}\-\d{1,2}\-\d{1,2}$/" errormsg="请选择正确的日期" sucmsg=" " />
        </dd>
    </dl>
    <dl>
        <dt>QQ号码</dt>
        <dd>
            <asp:TextBox ID="txtQQ" runat="server" CssClass="input txt" datatype="n5-13" errormsg="请填写正确QQ号" sucmsg=" "></asp:TextBox>
        </dd>
    </dl>
    <dl>
        <dt>邮箱账号</dt>
        <dd>
            <asp:TextBox ID="txtEmail" runat="server" CssClass="input txt" datatype="e" sucmsg=" "></asp:TextBox>
            <span class="Validform_checktip">*取回密码时用到</span>
        </dd>
    </dl>
    <dl>
        <dt>固定电话号码</dt>
        <dd>
            <asp:TextBox ID="txtTelphone" runat="server" CssClass="input txt"></asp:TextBox>
        </dd>
    </dl>
    <dl>
        <dt>联系地址</dt>
        <dd>
            <asp:TextBox ID="txtAddress" runat="server" CssClass="input normal"></asp:TextBox>
        </dd>
    </dl>
    <dl>
        <dt>个性签名</dt>
        <dd>
            <asp:TextBox ID="txtSign" runat="server" CssClass="input normal"></asp:TextBox>
        </dd>
    </dl>
    <dl>
        <dt>收藏流量助手机器码</dt>
        <dd>
            <asp:TextBox ID="txtClientMachineCode" runat="server" CssClass="input normal"></asp:TextBox></dd>
    </dl>
    <dl>
        <dt>备注<br />
            (仅后台管理可见)</dt>
        <dd>
            <asp:TextBox ID="txtRemark" runat="server" CssClass="input input-lg" TextMode="MultiLine"></asp:TextBox>
        </dd>
    </dl>
</div>

<div class="tab-content" style="display: none;">
    <dl>
        <dt>禁止兑换资金</dt>
        <dd>
            <div class="rule-single-checkbox">
                <asp:CheckBox ID="isForbidExchangeMoney" runat="server" />
            </div>
            <span class="Validform_checktip">* 不允许该用户使用发布点收藏流量点等兑换资金</span>
        </dd>
    </dl>
    <dl>
        <dt>账户余额</dt>
        <dd>
            <asp:TextBox ID="txtAmount" runat="server" CssClass="input small100" datatype="/^-?(([1-9]{1}\d*)|([0]{1}))(\.(\d){1,2})?$/" sucmsg=" " ReadOnly="true">0</asp:TextBox>
            元 &nbsp; 
            <asp:HyperLink ID="hlkAmount" runat="server" NavigateUrl="recharge_edit.aspx?username=">修改</asp:HyperLink>
            <span class="Validform_checktip">*账户上的余额</span>
        </dd>
    </dl>
    <dl>
        <dt>账户佣金</dt>
        <dd>
            <asp:TextBox ID="txtCommissions" runat="server" CssClass="input small100" datatype="/^-?(([1-9]{1}\d*)|([0]{1}))(\.(\d){1,2})?$/" sucmsg=" " ReadOnly="true">0</asp:TextBox>
            元 &nbsp; 
            <asp:HyperLink ID="hlkCommissions" runat="server" NavigateUrl="Commissions_edit.aspx?username=">修改</asp:HyperLink>
            <span class="Validform_checktip">*账户上的佣金</span>
        </dd>
    </dl>
    <dl>
        <dt>账户发布点</dt>
        <dd>
            <asp:TextBox ID="txtPoint" runat="server" CssClass="input small100" datatype="/^-?(([1-9]{1}\d*)|([0]{1}))(\.(\d){1,2})?$/" sucmsg=" " ReadOnly="true">0</asp:TextBox>
            点 &nbsp; 
            <asp:HyperLink ID="hlkPoint" runat="server" NavigateUrl="point_edit.aspx?username=">修改</asp:HyperLink>
            <span class="Validform_checktip">*发布点可兑换成资金哦</span>
        </dd>
    </dl>
    <dl>
        <dt>账户收藏点</dt>
        <dd>
            <asp:TextBox ID="txtCollectPoint" runat="server" CssClass="input small100" datatype="/^-?(([1-9]{1}\d*)|([0]{1}))(\.(\d){1,3})?$/" sucmsg=" " ReadOnly="true">0</asp:TextBox>
            点 &nbsp; 
            <asp:HyperLink ID="hlkCollectPoint" runat="server" NavigateUrl="collect_point_edit.aspx?username=">修改</asp:HyperLink>
            <span class="Validform_checktip">*收藏点可兑换成资金哦</span>
        </dd>
    </dl>
    <dl>
        <dt>账户流量点</dt>
        <dd>
            <asp:TextBox ID="txtFlowPoint" runat="server" CssClass="input small100" datatype="/^-?(([1-9]{1}\d*)|([0]{1}))(\.(\d){1,3})?$/" sucmsg=" " ReadOnly="true">0</asp:TextBox>
            点 &nbsp; 
            <asp:HyperLink ID="hlkFlowPoint" runat="server" NavigateUrl="flow_point_edit.aspx?username=">修改</asp:HyperLink>
            <span class="Validform_checktip">*流量点可兑换成资金哦</span>
        </dd>
    </dl>
    <dl>
        <dt>账户可用积分</dt>
        <dd>
            <asp:TextBox ID="txtScore" runat="server" CssClass="input small100" datatype="n" sucmsg=" " ReadOnly="true">0</asp:TextBox>
            分 &nbsp; 
            <asp:HyperLink ID="hlkScore" runat="server" NavigateUrl="score_edit.aspx?username=">修改</asp:HyperLink>
            <span class="Validform_checktip">*积分也可做为交易或兑换</span>
        </dd>
    </dl>
    <dl>
        <dt>累计积分升级经验值</dt>
        <dd>
            <asp:TextBox ID="txtExp" runat="server" CssClass="input small100" datatype="n" sucmsg=" ">0</asp:TextBox>
            分
            <span class="Validform_checktip">*根据积分累计得来，与积分不同的是只增不减</span>
        </dd>
    </dl>
</div>

<div class="tab-content" style="display: none">
    <dl>
        <dt>手机号码</dt>
        <dd>
            <asp:TextBox ID="txtMobile" runat="server" CssClass="input normal" datatype="m" sucmsg=" " errormsg="请输入正确手机号码" ignore="ignore"></asp:TextBox>
        </dd>
    </dl>
    <dl>
        <dt>手机认证</dt>
        <dd>
            <div class="rule-single-checkbox">
                <asp:CheckBox ID="IsMobileAuthCheckBox" runat="server" />
            </div>
            &nbsp; 认证日期：<asp:TextBox ID="txtMobileAuthDate" runat="server" CssClass="input rule-date-input" onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss'})" datatype="/^\s*$|^\d{4}\-\d{1,2}\-\d{1,2}([\s\d:]+)?$/" errormsg="请选择正确的日期" sucmsg=" " ignore="ignore" />
            <span class="Validform_checktip">*是否通过手机认证</span>
        </dd>
    </dl>
    <dl>
        <dt>实名认证</dt>
        <dd>
            <div class="rule-single-checkbox">
                <asp:CheckBox ID="IsRealNameAuthCheckBox" runat="server" />
            </div>
            &nbsp; 认证日期：<asp:TextBox ID="txtRealnameAuthDate" runat="server" CssClass="input rule-date-input" onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss'})" datatype="/^\s*$|^\d{4}\-\d{1,2}\-\d{1,2}([\s\d:]+)?$/" errormsg="请选择正确的日期" sucmsg=" " ignore="ignore" /> &nbsp; 身份证号：
            <asp:TextBox ID="txtIDCard" runat="server" CssClass="input small150" datatype="s15-20" sucmsg=" " errormsg="请输入正确身份证号码" ignore="ignore"></asp:TextBox>
            <span class="Validform_checktip"></span>
            <asp:HyperLink ID="RealNameAuthLink" runat="server" Visible="false">查看详细</asp:HyperLink>
        </dd>
    </dl>
    <dl>
        <dt>视频认证</dt>
        <dd>
            <div class="rule-single-checkbox">
                <asp:CheckBox ID="IsVideoAuthCheckBox" runat="server" />
            </div>
            &nbsp; 认证日期：<asp:TextBox ID="txtVideoAuthDate" runat="server" CssClass="input rule-date-input" onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss'})" datatype="/^\s*$|^\d{4}\-\d{1,2}\-\d{1,2}([\s\d:]+)?$/" errormsg="请选择正确的日期" sucmsg=" " ignore="ignore" />
            <span class="Validform_checktip">*是否通过视频认证</span>
            <asp:HyperLink ID="VideoAuthLink" runat="server" Visible="false">查看详细</asp:HyperLink>
        </dd>
    </dl>
    <dl>
        <dt>是否加入商保服务</dt>
        <dd>
            <div class="rule-single-checkbox">
                <asp:CheckBox ID="IsShangBaoCheckBox" runat="server" />
            </div>
            <span class="Validform_checktip">*开启或关闭商保请注意商保保证金，若开启需保存后方可修改保证金</span>
        </dd>
    </dl>
    <dl>
        <dt>商保保证金</dt>
        <dd>
            <asp:Label ID="lblShangbaoMoney" runat="server" Text="-"></asp:Label> &nbsp; 
            <asp:HyperLink ID="linkShangbaoEdit" runat="server" Visible="false" NavigateUrl="shangbao_edit.aspx?username=">修改</asp:HyperLink>
        </dd>
    </dl>
    <dl>
        <dt>加入商保日期</dt>
        <dd>
            <asp:Label ID="lblShangbaoDate" runat="server" Text="-"></asp:Label>
        </dd>
    </dl>
    <dl>
        <dt>加入商保IP</dt>
        <dd>
            <asp:Label ID="lblShangbaoIP" runat="server" Text="-"></asp:Label>
        </dd>
    </dl>
    <dl>
        <dt>IP所在地</dt>
        <dd>
            <asp:Label ID="lblShangbaoIPArea" runat="server" Text="-"></asp:Label>
        </dd>
    </dl>
</div>

<div class="tab-content" style="display: none">
    <dl>
        <dt>允许最大发布活动/任务数</dt>
        <dd>
            <asp:TextBox ID="txtFabuMaxXinYu" runat="server" CssClass="input small100" datatype="n" sucmsg=" " errormsg="请输入整数">0</asp:TextBox>
            份 &nbsp; 
            <div class="rule-single-select">
            <select name="XinYuPoint" id="XinYuPoint" onchange="$('#txtFabuMaxXinYu').val(this.options[this.selectedIndex].value)">
                <option value="0">无限发布</option>
                <option value="251">发一钻</option>
                <option value="501">发二钻</option>
                <option value="1001">发三钻</option>
                <option value="2001">发四钻</option>
                <option value="5001">发五钻</option>
                <option value="10001">发皇冠</option>
            </select>
            </div>
            <span class="Validform_checktip">*默认0为无限制</span>
        </dd>
    </dl>
    <dl>
        <dt>禁止发布活动/任务</dt>
        <dd>
            <div class="rule-single-checkbox">
                <asp:CheckBox ID="isForbidFabuTask" runat="server" />
            </div>
            <span class="Validform_checktip">*(含收藏流量任务)</span>
        </dd>
    </dl>
    <dl>
        <dt>禁止接手活动/任务</dt>
        <dd>
            <div class="rule-single-checkbox">
                <asp:CheckBox ID="isForbidJieshouTask" runat="server" />
            </div>
            <span class="Validform_checktip">*(含收藏流量任务)</span>
        </dd>
    </dl>
    <dl>
        <dt>发布已完成试用/任务总数</dt>
        <dd>
            <asp:TextBox ID="txtFabuXinyuTaskCount" runat="server" CssClass="input small100" datatype="n" sucmsg=" " title="注：商家审核放款后才算完成">0</asp:TextBox> 条
            <span class="Validform_checktip"></span>
            <span class="blue">本周发布试用：<asp:Label ID="week_fabu_try" runat="server" CssClass="red"></asp:Label> 次，共（<asp:Label ID="week_fabu_try_count" runat="server" CssClass="red"></asp:Label> 份）</span> &nbsp; 
            <span class="blue">本月发布试用：<asp:Label ID="month_fabu_try" runat="server" CssClass="red"></asp:Label> 次，共（<asp:Label ID="month_fabu_try_count" runat="server" CssClass="red"></asp:Label> 份）</span> &nbsp; 
            本周发布红包任务：<asp:Label ID="week_fabu_shua" runat="server" CssClass="red"></asp:Label> 条 &nbsp; 
            本月发布红包任务：<asp:Label ID="month_fabu_shua" runat="server" CssClass="red"></asp:Label> 条
        </dd>
    </dl>
    <dl>
        <dt>下单已完成试用/任务总数</dt>
        <dd>
            <asp:TextBox ID="txtJieshouXinyuTaskCount" runat="server" CssClass="input small100" datatype="n" sucmsg=" " title="注：商家审核放款后才算完成">0</asp:TextBox> 条
            <span class="Validform_checktip"></span>
            <span class="blue">本周下单试用活动：<asp:Label ID="week_jie_try" runat="server" CssClass="red"></asp:Label> 条</span> &nbsp; 
            <span class="blue">本月下单试用活动：<asp:Label ID="month_jie_try" runat="server" CssClass="red"></asp:Label> 条</span> &nbsp; 
            本周下单红包任务：<asp:Label ID="week_jie_shua" runat="server" CssClass="red"></asp:Label> 条 &nbsp; 
            本月下单红包任务：<asp:Label ID="month_jie_shua" runat="server" CssClass="red"></asp:Label> 条
        </dd>
    </dl>
    <dl>
        <dt>发布收藏任务总数</dt>
        <dd>
            <asp:TextBox ID="txtFabuCollectTaskCount" runat="server" CssClass="input small100" datatype="n" sucmsg=" ">0</asp:TextBox> 条
            <span class="Validform_checktip"></span>
            本周发布任务：<asp:Label ID="week_fabu_collect" runat="server" CssClass="red"></asp:Label> 条 &nbsp; 
            本月发布任务：<asp:Label ID="month_fabu_collect" runat="server" CssClass="red"></asp:Label> 条
        </dd>
    </dl>
    <dl>
        <dt>接手收藏任务总数</dt>
        <dd>
            <asp:TextBox ID="txtJieshouCollectTaskCount" runat="server" CssClass="input small100" datatype="n" sucmsg=" ">0</asp:TextBox> 条
            <span class="Validform_checktip"></span>
            本周接手任务：<asp:Label ID="week_jie_collect" runat="server" CssClass="red"></asp:Label> 条 &nbsp; 
            本月接手任务：<asp:Label ID="month_jie_collect" runat="server" CssClass="red"></asp:Label> 条
        </dd>
    </dl>
    <dl>
        <dt>发布流量任务总数</dt>
        <dd>
            <asp:TextBox ID="txtFabuFlowTaskCount" runat="server" CssClass="input small100" datatype="n" sucmsg=" ">0</asp:TextBox> 条
            <span class="Validform_checktip"></span>
            本周发布任务：<asp:Label ID="week_fabu_flow" runat="server" CssClass="red"></asp:Label> 条 &nbsp; 
            本月发布任务：<asp:Label ID="month_fabu_flow" runat="server" CssClass="red"></asp:Label> 条
        </dd>
    </dl>
    <dl>
        <dt>接手流量任务总数</dt>
        <dd>
            <asp:TextBox ID="txtJieshouFlowTaskCount" runat="server" CssClass="input small100" datatype="n" sucmsg=" ">0</asp:TextBox> 条
            <span class="Validform_checktip"></span>
            本周接手任务：<asp:Label ID="week_jie_flow" runat="server" CssClass="red"></asp:Label> 条 &nbsp; 
            本月接手任务：<asp:Label ID="month_jie_flow" runat="server" CssClass="red"></asp:Label> 条
        </dd>
    </dl>
    <dl>
        <dt>信用好评次数</dt>
        <dd>
            <asp:TextBox ID="txtHaoPingCount" runat="server" CssClass="input small100" datatype="n" sucmsg=" ">0</asp:TextBox> 次
            <span class="Validform_checktip"></span></dd>
    </dl>
    <dl>
        <dt>信用中评次数</dt>
        <dd>
            <asp:TextBox ID="txtZhongPingCount" runat="server" CssClass="input small100" datatype="n" sucmsg=" ">0</asp:TextBox> 次
            <span class="Validform_checktip"></span></dd>
    </dl>
    <dl>
        <dt>信用差评次数</dt>
        <dd>
            <asp:TextBox ID="txtChaPingCount" runat="server" CssClass="input small100" datatype="n" sucmsg=" ">0</asp:TextBox> 次
            <span class="Validform_checktip"></span></dd>
    </dl>
    <dl>
        <dt>好评率</dt>
        <dd>
            <asp:Label ID="lblHaoPingRate" Text="-" runat="server"></asp:Label>
        </dd>
    </dl>
</div>

<div class="tab-content" style="display: none">
    <dl>
        <dt>注册时间</dt>
        <dd>
            <asp:Label ID="lblRegTime" Text="-" runat="server"></asp:Label>
        </dd>
    </dl>
    <dl>
        <dt>注册IP</dt>
        <dd>
            <asp:Label ID="lblRegIP" Text="-" runat="server"></asp:Label> 　　
            <asp:Label ID="lblRegIPArea" Text="" runat="server"></asp:Label>
        </dd>
    </dl>
    <dl>
        <dt>上一次登录时间</dt>
        <dd>
            <asp:Label ID="lblLastTime" Text="-" runat="server"></asp:Label>
        </dd>
    </dl>
    <dl>
        <dt>上一次登录IP</dt>
        <dd>
            <asp:Label ID="lblLastIP" Text="-" runat="server"></asp:Label> 　　
            <asp:Label ID="lblLastIPArea" Text="" runat="server"></asp:Label>
        </dd>
    </dl>
    <dl>
        <dt>最后登录时间</dt>
        <dd>
            <asp:Label ID="lbl2LastTime" Text="-" runat="server"></asp:Label>
        </dd>
    </dl>
    <dl>
        <dt>最后登录IP</dt>
        <dd>
            <asp:Label ID="lbl2LastIP" Text="-" runat="server"></asp:Label> 　　
            <asp:Label ID="lbl2LastIPArea" Text="" runat="server"></asp:Label>
        </dd>
    </dl>
    <dl>
        <dt>登录总次数</dt>
        <dd>
            <asp:Label ID="lblLoginTimes" Text="-" runat="server"></asp:Label> 次
        </dd>
    </dl>
    <dl>
        <dt>开启异地登录限制</dt>
        <dd>
            <div class="rule-single-checkbox">
                <asp:CheckBox ID="isCheckLoginCity" runat="server" />
            </div>
            <span class="Validform_checktip">*开启后，不同城市的IP段不能登录网站</span>
        </dd>
    </dl>
    <div class="line20"></div>
    <dl>
        <dt>上次锁定账号时间</dt>
        <dd>
            <asp:Label ID="lblLastLockoutTime" Text="-" runat="server"></asp:Label>
        </dd>
    </dl>
    <dl>
        <dt>上次修改密码时间</dt>
        <dd>
            <asp:Label ID="lblLastPasswordChangedTime" Text="-" runat="server"></asp:Label>
        </dd>
    </dl>
    <dl>
        <dt>上次找回密码时间</dt>
        <dd>
            <asp:Label ID="lblLastGetPasswordTime" Text="-" runat="server"></asp:Label>
        </dd>
    </dl>
</div>
<!--/内容-->

<!--工具栏-->
<div class="page-footer">
    <div class="btn-wrap">
        <asp:Button ID="btnSubmit" runat="server" Text="提交保存" CssClass="btn" OnClick="btnSubmit_Click" />
        <input name="btnReturn" type="button" value="返回上一页" class="btn yellow" onclick="javascript: history.back(-1);" />
    </div>
</div>
<!--/工具栏-->

</form>
</body>
</html>
