﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="user_realname_auth_edit.aspx.cs" Inherits="SKtms.Web.admin.users.user_realname_auth_edit" ValidateRequest="false" %>

<%@ Import Namespace="SKtms.Common" %>

<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=no" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <title>审核实名认证</title>
    <link href="../../scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
    <link href="../skin/default/style.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript" charset="utf-8" src="../../scripts/jquery/jquery-1.11.2.min.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../scripts/jquery/Validform_v5.3.2_min.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../scripts/datepicker/WdatePicker.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../scripts/artdialog/dialog-plus-min.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../scripts/webuploader/webuploader.min.js"></script>
    <script type="text/javascript" charset="utf-8" src="../js/uploader.js"></script>
    <script type="text/javascript" charset="utf-8" src="../js/laymain.js"></script>
    <script type="text/javascript" charset="utf-8" src="../js/common.js"></script>
    <script type="text/javascript">
        $(function () {
            //初始化表单验证
            $("#form1").initValidform();
            $(".upload-img").InitUploader({ sendurl: "../../tools/upload_ajax.ashx", swf: "../../scripts/webuploader/uploader.swf" });
            $(".preview").click(function () {
                window.open($(this).attr("src"));
            })
        });
    </script>
</head>

<body class="mainbody">
    <form id="form1" runat="server">
        <!--导航栏-->
        <div class="location">
            <a href="user_realname_auth_list.aspx" class="back"><i></i><span>返回列表页</span></a>
            <a href="../center.aspx" class="home"><i></i><span>首页</span></a>
            <i class="arrow"></i>
            <span>会员设置</span>
            <i class="arrow"></i>
            <span>审核实名认证</span>
        </div>
        <div class="line10"></div>
        <!--/导航栏-->

        <!--内容-->
        <div id="floatHead" class="content-tab-wrap">
            <div class="content-tab">
                <div class="content-tab-ul-wrap">
                    <ul>
                        <li><a class="selected" href="javascript:;">审核实名认证</a></li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="tab-content">
            <dl>
                <dt>认证状态</dt>
                <dd>
                    <div class="rule-multi-radio">
                        <asp:RadioButtonList ID="radioStatus" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow">
                            <asp:ListItem Value="0">未审核</asp:ListItem>
                            <asp:ListItem Value="1">认证通过</asp:ListItem>
                            <asp:ListItem Value="2">认证不通过</asp:ListItem>
                        </asp:RadioButtonList>
                        <span class="Validform_checktip">*绑定账号类型</span>
                    </div>
                </dd>
            </dl>
            <dl>
                <dt>认证通过奖励充值卡</dt>
                <dd>
                    <div class="rule-single-checkbox">
                        <asp:CheckBox ID="is_award" runat="server" Checked="true" />
                    </div>
                    <span class="Validform_checktip">*认证通过是否奖励充值卡，奖励设置在会员系统参数设置》认证奖励设置</span>
                </dd>
            </dl>
            <dl>
                <dt>用户名</dt>
                <dd>
                    <asp:TextBox ID="txtUserName" runat="server" CssClass="input normal" datatype="*4-32"  sucmsg=" "></asp:TextBox>
                    <span class="Validform_checktip">*用户名，长度为4-32位</span>
                </dd>
            </dl>
            <dl>
                <dt>真实姓名</dt>
                <dd>
                    <asp:TextBox ID="txtRealName" runat="server" CssClass="input normal" datatype="*1-32" ignore="ignore" sucmsg=" "></asp:TextBox>
                    <span class="Validform_checktip">*真实姓名</span>
                </dd>
            </dl>
            <dl>
                <dt>身份证号码</dt>
                <dd>
                    <asp:TextBox ID="txtIdCardNum" runat="server" CssClass="input normal" datatype="*10-20" sucmsg=" " />
                    <span class="Validform_checktip">*身份证号码</span>
                </dd>
            </dl>
            <style type="text/css">
                .preview{
                    padding-top:15px;
                }
            </style>
            <dl>
                <dt>身份证正面照片</dt>
                <dd>
                    <div style="width:390px;">
                        <asp:TextBox ID="txtIdCard_path" runat="server" CssClass="input normal upload-path" datatype="*" sucmsg=" " />
                        <div class="upload-box upload-img"></div>
                        <asp:Image ID="ImageIdCard_path"  CssClass="preview" runat="server" Width="200px" Height="200px" />
                    </div>
                </dd>
            </dl>
            
            <dl>
                <dt>身份证背面照片</dt>
                <dd>
                    <div style="width:390px;">
                        <asp:TextBox ID="txtIdCard2_path" runat="server" CssClass="input normal upload-path" datatype="*" sucmsg=" " />
                        <div class="upload-box upload-img"></div>
                        <asp:Image ID="ImageIdCard2_path" CssClass="preview" runat="server" Width="200px" Height="200px" />
                    </div>
                </dd>
            </dl>
            <dl>
                <dt>手持身份证照</dt>
                <dd>
                    <div style="width:390px;">
                        <asp:TextBox ID="txtIdCard3_path" runat="server" CssClass="input normal upload-path" datatype="*" sucmsg=" " />
                        <div class="upload-box upload-img"></div>
                        <asp:Image ID="ImageIdCard3_path"  CssClass="preview" runat="server" Width="200px" Height="200px" />
                    </div>
                </dd>
            </dl>
            <dl>
                <dt>IP</dt>
                <dd>
                    <asp:TextBox ID="txtIP" runat="server" CssClass="input normal" datatype="*" sucmsg=" " />
                    <span class="Validform_checktip">*IP</span>
                </dd>
            </dl>
            <dl>
                <dt>提交时间</dt>
                <dd>
                    <asp:TextBox ID="txtAddTime" runat="server" CssClass="input normal" datatype="*" sucmsg=" " />
                    <span class="Validform_checktip">*提交时间</span>
                </dd>
            </dl>
        </div>
        <!--/内容-->

        <!--工具栏-->
        <div class="page-footer">
            <div class="btn-wrap">
                <asp:Button ID="btnSubmit" runat="server" Text="提交保存" CssClass="btn" OnClick="btnSubmit_Click" />
                <input name="btnReturn" type="button" value="返回上一页" class="btn yellow" onclick="javascript: history.back(-1);" />
            </div>
        </div>
        <!--/工具栏-->

    </form>
</body>
</html>
