﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="user_realname_auth_list.aspx.cs" Inherits="SKtms.Web.admin.users.user_realname_auth_list" %>
<%@ Import namespace="SKtms.Common" %>


<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=no" />
<meta name="apple-mobile-web-app-capable" content="yes" />
<title>实名认证管理</title>
<link href="../../scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
<link href="../skin/default/style.css" rel="stylesheet" type="text/css" />
<link href="../../css/pagination.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" charset="utf-8" src="../../scripts/jquery/jquery-1.11.2.min.js"></script>
<script type="text/javascript" charset="utf-8" src="../../scripts/artdialog/dialog-plus-min.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/laymain.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/common.js"></script>
</head>

<body class="mainbody">
<form id="form1" runat="server">
<!--导航栏-->
<div class="location">
  <a href="javascript:history.back(-1);" class="back"><i></i><span>返回上一页</span></a>
  <a href="../center.aspx" class="home"><i></i><span>首页</span></a>
  <i class="arrow"></i>
  <span>会员管理</span>
  <i class="arrow"></i>
  <span>实名认证管理</span>
</div>
<!--/导航栏-->

<!--工具栏-->
<div id="floatHead" class="toolbar-wrap">
  <div class="toolbar">
    <div class="box-wrap">
      <a class="menu-btn"></a>
      <div class="l-list">
        <ul class="icon-list">
          <li><a class="all" href="javascript:;" onclick="checkAll(this);"><i></i><span>全选</span></a></li>
          <li><asp:LinkButton ID="btnDelete" runat="server" CssClass="del" OnClientClick="return ExePostBack('btnDelete');" onclick="btnDelete_Click"><i></i><span>删除</span></asp:LinkButton></li>
          <li><asp:LinkButton ID="btnPassAuth" runat="server" CssClass="lock" OnClientClick="if(confirm('确定要批量认证通过吗？\r\n\r\n注意：如果【会员系统参数设置》认证奖励设置】设置了奖励，认证后会有奖励。')){return CheckPostBack('btnPassAuth');}else{return false;}" onclick="btnPassAuth_Click"><i></i><span>批量认证通过</span></asp:LinkButton></li>
          <li><asp:LinkButton ID="btnNotPassAuth" runat="server" CssClass="lock" OnClientClick="if(confirm('确定要批量认证不通过吗？')){return CheckPostBack('btnNotPassAuth');}else{return false;}" onclick="btnNotPassAuth_Click"><i></i><span>批量认证不通过</span></asp:LinkButton></li>
        </ul>
      </div>
      <div class="r-list">
        <asp:TextBox ID="txtKeywords" runat="server" CssClass="keyword" />
        <asp:LinkButton ID="lbtnSearch" runat="server" CssClass="btn-search" onclick="btnSearch_Click">查询</asp:LinkButton>
      </div>
    </div>
  </div>
</div>
<!--/工具栏-->

<!--列表-->
<div class="table-container">
<asp:Repeater ID="rptList" runat="server">
<HeaderTemplate>
<table width="100%" border="0" cellspacing="0" cellpadding="0" class="ltable">
  <tr>
    <th width="5%">选择</th>
    <th width="10%">用户名</th>
    <th width="10%">真实姓名</th>
    <th width="10%">身份证号码</th>
    <th width="10%">身份证正面</th>
    <th width="10%">身份证背面</th>
    <th width="10%">手持身份证照</th>
    <th width="10%">IP</th>
    <th width="5%">状态</th>
    <th width="15%">时间</th>
    <th width="5%">操作</th>
  </tr>
</HeaderTemplate>
<ItemTemplate>
  <tr>
    <td align="center">
      <asp:CheckBox ID="chkId" CssClass="checkall" runat="server" style="vertical-align:middle;" />
      <asp:HiddenField ID="hidId" Value='<%#Eval("ID")%>' runat="server" />
    </td>
    <td align="center"><%#Eval("user_name")%></td>
    <td align="center"><%#Eval("real_name")%></td>
    <td align="center"><%#Eval("idcard_num")%><%#GetCountIdCard(Eval("idcard_num").ToString(), Utils.ObjToInt(Eval("status")))%></td>
    <td align="center">
        <a href="user_realname_auth_edit.aspx?action=<%#BSEnums.ActionEnum.Edit %>&id=<%#Eval("id")%>">
        <%#Eval("idcard_path").ToString() != "" ? "<img width=\"64\" height=\"64\" src=\"" + Eval("idcard_path") + "\" />" : "<b class=\"user-avatar\"></b>"%>
      </a>
    </td>
    <td align="center">
        <a href="user_realname_auth_edit.aspx?action=<%#BSEnums.ActionEnum.Edit %>&id=<%#Eval("id")%>">
        <%#Eval("idcard2_path").ToString() != "" ? "<img width=\"64\" height=\"64\" src=\"" + Eval("idcard2_path") + "\" />" : "<b class=\"user-avatar\"></b>"%>
      </a>
    </td>
    <td align="center">
        <a href="user_realname_auth_edit.aspx?action=<%#BSEnums.ActionEnum.Edit %>&id=<%#Eval("id")%>">
        <%#Eval("idcard3_path").ToString() != "" ? "<img width=\"64\" height=\"64\" src=\"" + Eval("idcard3_path") + "\" />" : "<b class=\"user-avatar\"></b>"%>
      </a>
    </td>
    <td align="center"><%#Eval("user_ip")%></td>
    <td align="center"><%#getStatusString(Utils.ObjToInt(Eval("status")))%></td>   
    <td align="center"><%#string.Format("{0:g}", Eval("add_time"))%></td>
    <td align="center">
        <a href="user_realname_auth_edit.aspx?action=<%#BSEnums.ActionEnum.Edit %>&id=<%#Eval("ID")%>">查看</a>
    </td>
  </tr>
</ItemTemplate>
<FooterTemplate>
  <%#rptList.Items.Count == 0 ? "<tr><td align=\"center\" colspan=\"11\">暂无记录</td></tr>" : ""%>
</table>
</FooterTemplate>
</asp:Repeater>
</div>
<!--/列表-->

<!--内容底部-->
<div class="line20"></div>
<div class="pagelist">
  <div class="l-btns">
    <span>显示</span><asp:TextBox ID="txtPageNum" runat="server" CssClass="pagenum" onkeydown="return checkNumber(event);"
                OnTextChanged="txtPageNum_TextChanged" AutoPostBack="True"></asp:TextBox><span>条/页</span>
  </div>
  <div id="PageContent" runat="server" class="default"></div>
</div>
<!--/内容底部-->
</form>
</body>
</html>
