﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="user_tixian_list.aspx.cs" Inherits="SKtms.Web.admin.users.user_tixian_list" %>
<%@ Import namespace="SKtms.Common" %>

<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=no" />
<meta name="apple-mobile-web-app-capable" content="yes" />
<title>提现管理</title>
<link href="../../scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
<link href="../skin/default/style.css" rel="stylesheet" type="text/css" />
<link href="../../css/pagination.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" charset="utf-8" src="../../scripts/jquery/jquery-1.11.2.min.js"></script>
<script type="text/javascript" charset="utf-8" src="../../scripts/artdialog/dialog-plus-min.js"></script>
<script type="text/javascript" charset="utf-8" src="../../scripts/datepicker/WdatePicker.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/laymain.js"></script>
<script type="text/javascript" charset="utf-8" src="../js/common.js"></script>
</head>

<body class="mainbody">
<form id="form1" runat="server">
<!--导航栏-->
<div class="location">
  <a href="javascript:history.back(-1);" class="back"><i></i><span>返回上一页</span></a>
  <a href="../center.aspx" class="home"><i></i><span>首页</span></a>
  <i class="arrow"></i>
  <span>财务管理</span>
  <i class="arrow"></i>
  <span>提现管理</span>
</div>
<!--/导航栏-->

<!--工具栏-->
<div id="floatHead" class="toolbar-wrap">
  <div class="toolbar">
    <div class="box-wrap">
      <a class="menu-btn"></a>
      <div class="l-list">
        <ul class="icon-list">
          <li><a class="all" href="javascript:;" onclick="checkAll(this);"><i></i><span>全选</span></a></li>
          <li><asp:LinkButton ID="btnDelete" runat="server" CssClass="del" OnClientClick="return ExePostBack('btnDelete');" onclick="btnDelete_Click"><i></i><span>删除</span></asp:LinkButton></li>
          <li><asp:LinkButton ID="btnChngStatus2" runat="server" CssClass="edit" OnClientClick="return ExePostBack('btnChngStatus2','你确定要批量设处理中吗？');" OnCommand="btnChngStatus_Click" CommandArgument="1"><i></i><span>批量设处理中</span></asp:LinkButton></li>          
          <li><asp:LinkButton ID="btnChngStatus3" runat="server" CssClass="edit" OnClientClick="return ExePostBack('btnChngStatus3','你确定要批量设已打款吗？');" OnCommand="btnChngStatus_Click" CommandArgument="2"><i></i><span>批量设已打款</span></asp:LinkButton></li>
          <li><asp:LinkButton ID="LinkButton1" runat="server" CssClass="edit" OnClientClick="$('#refuse').slideToggle();return false"><i></i><span>批量设拒绝</span></asp:LinkButton></li>
        </ul>
      </div>
<%--  <div class="r-list">
        <asp:TextBox ID="txtKeywords" runat="server" CssClass="keyword" />
        <asp:LinkButton ID="lbtnSearch" runat="server" CssClass="btn-search" onclick="btnSearch_Click">查询</asp:LinkButton>
      </div>--%>
    </div>
  </div>
</div>
<!--/工具栏-->

<!--查询栏-->
<script type="text/javascript">
    $(function () {
        $("#QuicklySelect").change(function () {
            location.href = "user_tixian_list.aspx?QAction=Quickly&QType=" + $(this).children('option:selected').val();
        });
        $("#AdvancedQuery").click(function () {
            location.href = "user_tixian_list.aspx?QAction=Advanced&QType=" + $("#AdvancedSelect").children('option:selected').val() + "&keywords=" + $("#txtKeywords").val();
        });
        $("#TimeSpandQuery").click(function () {
            location.href = "user_tixian_list.aspx?QAction=TimeSpan&TimeStart=" + $("#timeStart").val() + "&timeEnd=" + $("#timeEnd").val();
        });
    });
</script>
<div class="search_bar">
    <div class="list_item">
        快速查询：
        <div class="rule-single-select">
            <select name="QuicklySelect" id="QuicklySelect">
                <option value="0">所有提现申请记录</option> 
                <option value="1"<%=(QAction == "Quickly" && QType == "1")? " selected": ""%>>3天内的提现申请</option> 
                <option value="2"<%=(QAction == "Quickly" && QType == "2")? " selected": ""%>>等待处理申请</option> 
                <option value="3"<%=(QAction == "Quickly" && QType == "3")? " selected": ""%>>处理中的申请</option> 
                <option value="4"<%=(QAction == "Quickly" && QType == "4")? " selected": ""%>>已经完成的申请</option> 
                <option value="5"<%=(QAction == "Quickly" && QType == "5")? " selected": ""%>>已拒绝的申请</option> 
                <option value="6"<%=(QAction == "Quickly" && QType == "6")? " selected": ""%>>已撤销申请</option> 
            </select>
        </div>
        &nbsp; &nbsp; |&nbsp; &nbsp; 
        高级查询：
        <div class="rule-single-select">
        <select name="AdvancedSelect" id="AdvancedSelect">
            <option value="1">用户名</option> 
            <option value="2"<%=(QAction == "Advanced" && QType == "2")? " selected": ""%>>客户姓名</option> 
            <option value="3"<%=(QAction == "Advanced" && QType == "3")? " selected": ""%>>提现时间</option>
            <option value="4"<%=(QAction == "Advanced" && QType == "4")? " selected": ""%>>提现编号</option>
        </select>
        </div>
        <asp:TextBox ID="txtKeywords" runat="server" CssClass="input small100" />
        <input id="AdvancedQuery" name="AdvancedQuery" type="button" class="btn" value="查询" />
    </div>
    <div class="list_item">
        按时间段查询：
        开始时间：
        <%if(timeStart==""){%>
        <input name="timeStart" id="timeStart" type="text" class="input small100" maxlength="10"  onfocus="WdatePicker({dateFmt:'yyyy-MM-dd'});" value='<%=DateTime.Now.AddDays(-1).ToString("yyyy-MM-dd")%>'/>
        <%}else{%>
        <input name="timeStart" id="timeStart" type="text" class="input small100" onfocus="WdatePicker({dateFmt:'yyyy-MM-dd'});" value='<%=Utils.StrToDateTime(timeStart).ToString("yyyy-MM-dd")%>' />
        <%}%>
        结束时间：        
        <%if(timeEnd==""){%>
        <input name="timeEnd" id="timeEnd" type="text" class="input small100" onfocus="WdatePicker({dateFmt:'yyyy-MM-dd'});" value='<%=DateTime.Now.ToString("yyyy-MM-dd")%>'/>
        <%}else{%>
        <input name="timeEnd" id="timeEnd" type="text" class="input small100" onfocus="WdatePicker({dateFmt:'yyyy-MM-dd'});" value='<%=Utils.StrToDateTime(timeEnd).ToString("yyyy-MM-dd")%>' />
        <%}%>
        <input id="TimeSpandQuery" name="TimeSpandQuery" type="button" class="btn" value="查询" />
    </div>
    <div class="list_item" id="refuse" style="display:none">
        拒绝原因：<asp:TextBox ID="RefuseDescription" runat="server" Text ="提现商品的价格与提现金额不一致" CssClass="input txt"></asp:TextBox>
        <asp:Button ID="btnChngStatus1" runat="server" CssClass="btn" OnClientClick="return ExePostBack('btnChngStatus1','你确定要批量设已拒绝吗？');" OnCommand="btnChngStatus_Click"  CommandArgument="3" Text="批量设已拒绝"></asp:Button>
    </div>
</div>
<!--查询栏-->

<!--列表-->
<div class="line10"></div>
<script type="text/javascript">
    $(function () {
        setMoneyCount();
        bindingChangeStatus();
        //表格点击显示下一隐藏列
        $(".msg-tr").click(function () {
            $(this).next().toggle();
        });
    });
    function setMoneyCount() {
        var moneyCount = 0;
        $(".money").each(function () {
            moneyCount = moneyCount + parseFloat($(this).html().replace(" 元",""));
        });
        $("#moneyCount").html(moneyCount + " 元");
    }
    function bindingChangeStatus() {
        $(".change-status").click(function () {
            var id = $(this).attr("data-id");
            var todo = $(this).attr("data-todo");

            if (todo == 1) {
                if (confirm('您确定现在要处理吗？')) {
                    $(this).attr('href', '?Action=Status&ToDo=' + todo + '&ID=' + id + '&url=' + '<%=Utils.UrlEncode(this.pageUrl)%>' + '&page=' + '<%=this.page%>');
                    return true;
                }
            }
            if (todo == 2) {
                if (confirm('您确定已经给客户打款了吗？')) {
                    $(this).attr('href', '?Action=Status&ToDo=' + todo + '&ID=' + id + '&url=' + '<%=Utils.UrlEncode(this.pageUrl)%>' + '&page=' + '<%=this.page%>');
                    return true;
                }
            }
            if (todo == 3) {
                if (confirm('您确定该申请不符合提现要求吗？')) {
                    var a = prompt('请填写拒绝原因！', '提现商品的价格与提现金额不一致');
                    if (a != null && a != '') {
                        $(this).attr('href', '?Action=Status&ToDo=3&ID=' + id + '&msg=' + a + '&url=' + '<%=Utils.UrlEncode(this.pageUrl)%>' + '&page=' + '<%=this.page%>');
                        return true;
                    }
                }
            }
        });
    }
</script>

<div class="table-container">
<asp:Repeater ID="rptList" runat="server">
<HeaderTemplate>
<table width="100%" border="0" cellspacing="0" cellpadding="0" class="ltable">
  <tr>
    <th width="3%">选择</th>
    <th width="7%">提现编号</th>
    <th width="10%">用户名</th>
    <th width="10%">商保/未完任务金额</th>
    <th width="10%">30天内任务金额</th>
    <th width="6%"><strong>提现金额</strong></th>
    <th width="6%">余额</th>
    <th width="7%">收款姓名</th>
    <th width="6%">提现方式</th>
    <th width="9%">收款账号</th>
    <th width="9%">提现银行</th>
    <th width="9%">状态/操作</th>
    <th width="">备注/说明</th>
  </tr>
</HeaderTemplate>
<ItemTemplate>
  <tr class="msg-tr">
    <td align="center">
      <asp:CheckBox ID="chkId" CssClass="checkall" runat="server" style="vertical-align:middle;" />
      <asp:HiddenField ID="hidId" Value='<%#Eval("id")%>' runat="server" />
    </td>
    <td align="center"><%#Eval("order_id")%></td>
    <td align="center"><a href="user_tixian_list.aspx?QAction=Advanced&QType=1&keywords=<%#Eval("user_name")%>"><%#Eval("user_name")%></a><span class="red" title="提现次数"> (<%#GetUserTixinCount(Utils.ObjToInt(Eval("user_id"))) %>)</span><%#GetUserAppealCount(Utils.ObjToInt(Eval("user_id")), Eval("user_name").ToString())%></td>
    <td align="center"><%#GetShanbaoMoney(Utils.ObjToInt(Eval("user_id"))) %></td>
    <td align="center"><%#GetTaskMoney(Utils.ObjToInt(Eval("user_id")) ,30) %></td>
    <td align="center"><strong class="red money"><%#Utils.GetNum(Eval("money").ToString())%> 元</strong></td>
    <td align="center"><%#Utils.GetNum(Eval("money_current").ToString())%> 元</td>
    <td align="center"><%#Eval("real_name")%><%#CheckRealname(Utils.ObjToInt(Eval("user_id")), Eval("real_name").ToString())%></td>
    <td align="center"><%#PaymentTypeStr[Utils.ObjToInt(Eval("payment_type"))]%></td>
    <td align="center"><%#Eval("account")%></td>
    <td align="center"><%#Eval("bank_name")%></td>
    <td align="center"><%#TixianStatus(Utils.ObjToInt(Eval("status")))%><%#GetDealString(Utils.ObjToInt(Eval("id")),Utils.ObjToInt(Eval("status"))) %></td>
    <td align="center"><%#Eval("description")%></td>
  </tr>
  <tr style="display:none">
      <td colspan="13" align="center">
          <span>出款方式：<%#Eval("tixian_type").ToString() == "0"? "账户资金": "账户佣金"%></span>&nbsp; &nbsp;
          <span>账号注册IP：<%#GetUserIP(Eval("user_name").ToString(),1)%></span>&nbsp; &nbsp;
          <span>提现时IP：<%#GetUserIP(Eval("user_ip").ToString(),2)%></span>&nbsp; &nbsp;
          <span>提现时间：<%#Eval("add_date")%></span>&nbsp; &nbsp;
          <span>更新/完成日期：<%#Eval("end_date")%></span>
      </td>
  </tr>
</ItemTemplate>
<FooterTemplate>
    <tr>
        <td></td>
        <td colspan="4">今日提现：<%=Utils.GetNum(today_totalMoney)%> 元 （支付宝：<%=Utils.GetNum(today_alipayMoney)%> 元 &nbsp; 财付通：<%=Utils.GetNum(today_tenpayMoney)%> 元 &nbsp; 银行：<%=Utils.GetNum(today_bankMoney)%> 元）</td>
        <td colspan="2">今日撤销/拒绝：<%=Utils.GetNum(today_rejectMoney)%> 元</td>
        <td></td>
        <td align="right">本页合计：</td>
        <td align="left" id="moneyCount"></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>
    <tr>
        <td></td>
        <td colspan="4">昨日提现：<%=Utils.GetNum(yesterday_totalMoney)%> 元 （支付宝：<%=Utils.GetNum(yesterday_alipayMoney)%> 元 &nbsp; 财付通：<%=Utils.GetNum(yesterday_tenpayMoney)%> 元 &nbsp; 银行：<%=Utils.GetNum(yesterday_bankMoney)%> 元）</td>
        <td colspan="2">昨日撤销/拒绝：<%=Utils.GetNum(yesterday_rejectMoney)%> 元</td>
        <td></td>
        <td align="right">提现总计：</td>
        <td align="left"><%=Utils.GetNum(totalMoney)%> 元</td>
        <td></td>
        <td></td>
        <td></td>
    </tr>
  <%#rptList.Items.Count == 0 ? "<tr><td align=\"center\" colspan=\"13\">暂无记录</td></tr>" : ""%>
</table>
</FooterTemplate>
</asp:Repeater>

</div>
<!--/列表-->

<!--内容底部-->
<div class="line20"></div>

<div class="pagelist">
  <div class="l-btns">
    <span>显示</span><asp:TextBox ID="txtPageNum" runat="server" CssClass="pagenum" onkeydown="return checkNumber(event);" OnTextChanged="txtPageNum_TextChanged" AutoPostBack="True"></asp:TextBox><span>条/页</span>
  </div>
  <div id="PageContent" runat="server" class="default"></div>
</div>

<div class="line10"></div>
<div class="foot_del_bar">
    <div class="tips">
        特别提醒： 如果提现明细记录太多，影响了系统性能，可以删除一定时间段前的记录以加快速度。 
        <br />
        <div class="rule-multi-radio">
        <asp:RadioButtonList ID="SelecteSomeTimeAgoRecords" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow" CellPadding="10" CellSpacing="10">
            <asp:ListItem Value="1">10天前</asp:ListItem>
            <asp:ListItem Value="2">1个月前</asp:ListItem>
            <asp:ListItem Value="3">2个月前</asp:ListItem>
            <asp:ListItem Value="4">3个月前</asp:ListItem>
            <asp:ListItem Value="5" Selected="True">6个月前</asp:ListItem>
            <asp:ListItem Value="6">1年前</asp:ListItem>
        </asp:RadioButtonList>
        </div>
        <asp:Button ID="DeleteSomeTimeAgoRecords" CssClass="btn yellow" OnClientClick="return confirm('确实要删除有关记录吗？请慎重！')" runat="server" Text="执行删除" OnClick="DeleteSomeTimeAgoRecords_Click" />
    </div>
</div>
<!--/内容底部-->
</form>
</body>
</html>
