﻿<%@ Page Language="C#" AutoEventWireup="true" EnableViewState="false" CodeBehind="view_statistics.aspx.cs" Inherits="SKtms.Web.admin.users.view_statistics" %>

<%@ Import Namespace="SKtms.Common" %>

<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=no" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <title>账务综合统计</title>
    <link href="../../scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
    <link href="../skin/default/style.css" rel="stylesheet" type="text/css" />
    <link href="../../css/pagination.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript" src="../../scripts/jquery/jquery-1.11.2.min.js"></script>
    <script type="text/javascript" src="../../scripts/artdialog/dialog-plus-min.js"></script>
    <script type="text/javascript" charset="utf-8" src="../../scripts/datepicker/WdatePicker.js"></script>
    <script type="text/javascript" charset="utf-8" src="../js/laymain.js"></script>
    <script type="text/javascript" charset="utf-8" src="../js/common.js"></script>
</head>

<body class="mainbody">
    <style type="text/css">
        .gray { color: gray; }
        .red { padding-left: 3px; padding-right: 3px; color: red; }
        .orange { padding-left: 3px; padding-right: 3px; color: orange; }
        .blue { padding-left: 3px; padding-right: 3px; color: blue; }
    </style>
    <form id="form1" runat="server">
        <!--导航栏-->
        <div class="location">
            <a href="javascript:history.back(-1);" class="back"><i></i><span>返回上一页</span></a>
            <a href="../center.aspx" class="home"><i></i><span>首页</span></a>
            <i class="arrow"></i>
            <span>财务管理</span>
            <i class="arrow"></i>
            <span>账务综合统计</span>
        </div>
        <!--/导航栏-->

        <!--列表-->
        <div class="line10"></div>
        <div class="table-container">
            <!--综合统计-->
            <table width="100%" border="0" cellspacing="0" cellpadding="0" class="ltable">
                <thead>
                    <tr>
                        <td width="8%">&nbsp;</td>
                        <th colspan="2" align="left"><strong>综合统计</strong></th>
                    </tr>
                </thead>
                <tr>
                    <td width="8%">&nbsp;</td>
                    <td colspan="2"><span class="red">说明：账号可用资金及可用发布点包含管理员及新注册会员赠送资金和发布点，以下有关发布点价格均按默认
                    <div class="rule-single-select">
                    <asp:DropDownList ID="ddlRate" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddlRate_SelectedIndexChanged">
                        <asp:ListItem Value="">兑换比率</asp:ListItem>
                        <asp:ListItem Value="0.60">0.60</asp:ListItem>
                        <asp:ListItem Value="0.65">0.65</asp:ListItem>
                        <asp:ListItem Value="0.70">0.70</asp:ListItem>
                        <asp:ListItem Value="0.75">0.75</asp:ListItem>
                        <asp:ListItem Value="0.80">0.80</asp:ListItem>
                        <asp:ListItem Value="0.85">0.85</asp:ListItem>
                        <asp:ListItem Value="0.90">0.90</asp:ListItem>
                        <asp:ListItem Value="0.95">0.95</asp:ListItem>
                        <asp:ListItem Value="1.00">1.00</asp:ListItem>
                    </asp:DropDownList>
                    </div>
                    元/点计算,供参考值,因会有购买一钻或二钻卡价格差异)</span></td>
                </tr>
                <tr>
                    <td width="8%">&nbsp;</td>
                    <td width="42%">所有用户账号可用余额共计：<asp:Literal ID="all_user_user_amount_count" runat="server" />元<br>
                        <span class="gray">[含新注册普通会员未产生消费的赠送金额：<asp:Literal ID="new_register_user_present_amount_count" runat="server" />元] 
                            [商家：<asp:Literal ID="new_register_seller_present_amount_count" runat="server" />元]</span></td>
                    <td>所有加入商保服务金额共计：<asp:Literal ID="all_user_join_shangbao_count" runat="server" />元</td>
                </tr>
                <tr>
                    <td width="8%">&nbsp;</td>
                    <td width="42%">所有用户账号可用发布点共计：<asp:Literal ID="all_user_fabu_point_count" runat="server" />点<br>
                        <span class="gray">[含新注册会员未产生消费的赠送发布点：<asp:Literal ID="new_register_user_present_fabu_point_count" runat="server" />点]</span></td>
                    <td>合计人民币约：<asp:Literal ID="all_user_fabu_point_transfer_money_count" runat="server" />元</td>
                </tr>
                <tr>
                    <td width="8%">&nbsp;</td>
                    <td width="42%">已发布未完成任务押扣金额：<asp:Literal ID="no_finish_fabu_task_amount_count" runat="server" />元</td>
                    <td>已发布未完成任务押扣发布点共计：<asp:Literal ID="no_finish_fabu_task_fabu_point_count" runat="server" />点 &nbsp; 合计人民币约：<asp:Literal ID="no_finish_fabu_task_fabu_point_transfer_money_count" runat="server" />元</td>
                </tr>

                <!--充值统计-->
                <tr>
                    <td width="8%">&nbsp;</td>
                    <td width="42%">平台总充值共计：<asp:Literal ID="all_platform_recharge_money_count" runat="server" />元</td>
                    <td>今日充值共计：<asp:Literal ID="today_all_platform_recharge_money_count" runat="server" />元&nbsp;&nbsp;&nbsp;昨日充值共计：<asp:Literal ID="yesterday_all_platform_recharge_money_count" runat="server" />元</td>
                </tr>
                <tr>
                    <td width="8%">&nbsp;</td>
                    <td width="42%">今日支付宝软件充值共计：<asp:Literal ID="today_alipay_recharge_money_count" runat="server" />元<asp:Literal ID="today_alipay_recharge_times_count" runat="server" />笔&nbsp;&nbsp;&nbsp;昨日支付宝软件充值共计：<asp:Literal ID="yesterday_alipay_recharge_money_count" runat="server" />元<asp:Literal ID="yesterday_alipay_recharge_times_count" runat="server" /> 笔</td>
                    <td>今日财付通软件充值共计：<asp:Literal ID="today_tenpay_recharge_money_count" runat="server" />元<asp:Literal ID="today_tenpay_recharge_times_count" runat="server" />笔 &nbsp;&nbsp;&nbsp;昨日财付通软件充值共计：<asp:Literal ID="yesterday_tenpay_recharge_money_count" runat="server" />元 <asp:Literal ID="yesterday_tenpay_recharge_times_count" runat="server" /> 笔</td>
                </tr>
                <!--/充值统计-->

                <!--发布点等兑换统计-->
                <tr>
                    <td width="8%">&nbsp;</td>
                    <td width="42%">平台发布点兑换资金共计：<asp:Literal ID="fabu_point_transfer_money_count" runat="server" />点 <asp:Literal ID="fabu_point_transfer_money_count_amount" runat="server" />元</td>
                    <td>今日发布点兑换资金共计：<asp:Literal ID="today_fabu_point_transfer_money_count" runat="server" />点 <asp:Literal ID="today_fabu_point_transfer_money_count_amount" runat="server" />元&nbsp;&nbsp;&nbsp;昨日发布点兑换资金共计：<asp:Literal ID="yesterday_fabu_point_transfer_money_count" runat="server" />点 <asp:Literal ID="yesterday_fabu_point_transfer_money_count_amount" runat="server" />元</td>
                </tr>
				<tr>
                    <td width="8%">&nbsp;</td>
                    <td width="42%">平台流量点兑换资金共计：<asp:Literal ID="flow_point_transfer_money_count" runat="server" />点 <asp:Literal ID="flow_point_transfer_money_count_amount" runat="server" />元</td>
                    <td>今日流量点兑换资金共计：<asp:Literal ID="today_flow_point_transfer_money_count" runat="server" />点 <asp:Literal ID="today_flow_point_transfer_money_count_amount" runat="server" />元&nbsp;&nbsp;&nbsp;昨日流量点兑换资金共计：<asp:Literal ID="yesterday_flow_point_transfer_money_count" runat="server" />点 <asp:Literal ID="yesterday_flow_point_transfer_money_count_amount" runat="server" />元</td>
                </tr>
				<tr>
                    <td width="8%">&nbsp;</td>
                    <td width="42%">平台收藏点兑换资金共计：<asp:Literal ID="collect_point_transfer_money_count" runat="server" />点 <asp:Literal ID="collect_point_transfer_money_count_amount" runat="server" />元</td>
                    <td>今日收藏点兑换资金共计：<asp:Literal ID="today_collect_point_transfer_money_count" runat="server" />点 <asp:Literal ID="today_collect_point_transfer_money_count_amount" runat="server" />元&nbsp;&nbsp;&nbsp;昨日收藏点兑换资金共计：<asp:Literal ID="yesterday_collect_point_transfer_money_count" runat="server" />点 <asp:Literal ID="yesterday_collect_point_transfer_money_count_amount" runat="server" />元</td>
                </tr>
                <tr>
                    <td width="8%">&nbsp;</td>
                    <td width="42%">平台积分兑换资金共计：<asp:Literal ID="score_transfer_money_count" runat="server" />点 <asp:Literal ID="score_transfer_money_count_amount" runat="server" />元</td>
                    <td>今日积分兑换资金共计：<asp:Literal ID="today_score_transfer_money_count" runat="server" />点 <asp:Literal ID="today_score_transfer_money_count_amount" runat="server" />元&nbsp;&nbsp;&nbsp;昨日积分兑换资金共计：<asp:Literal ID="yesterday_score_transfer_money_count" runat="server" />点 <asp:Literal ID="yesterday_score_transfer_money_count_amount" runat="server" />元</td>
                </tr>
                <!--/发布点等兑换统计-->

                <!--提现统计-->
                <tr>
                    <td width="8%">&nbsp;</td>
                    <td width="42%">平台总提现共计：<asp:Literal ID="all_platform_tixian_money_count" runat="server" />元</td>
                    <td>今日提现共计：<asp:Literal ID="today_all_platform_tixian_money_count" runat="server" />元 &nbsp; (已打款：<asp:Literal ID="today_finish_tixian_money_count" runat="server" />元)&nbsp;&nbsp;&nbsp;
                        昨日提现共计：<asp:Literal ID="yesterday_all_platform_tixian_money_count" runat="server" />元 &nbsp; (已打款：<asp:Literal ID="yesterday_finish_tixian_money_count" runat="server" />元)
                    </td>
                </tr>
                <tr>
                    <td width="8%">&nbsp;</td>
                    <td width="42%">今日支付宝提现共计：<asp:Literal ID="today_alipay_tixian_money_count" runat="server" />元&nbsp;&nbsp; 昨日支付宝提现共计：<asp:Literal ID="yesterday_alipay_tixian_money_count" runat="server" />元</td>
                    <td>今日财付通提现共计：<asp:Literal ID="today_tenpay_tixian_money_count" runat="server" />元&nbsp;&nbsp; 昨日财付通提现共计：<asp:Literal ID="yesterday_tenpay_tixian_money_count" runat="server" />元</td>
                </tr>
                <tr>
                    <td width="8%">&nbsp;</td>
                    <td width="42%">今日银行卡提现共计：<asp:Literal ID="today_bank_cark_tixian_money_count" runat="server" />元&nbsp;&nbsp; 昨日银行卡提现共计：<asp:Literal ID="yesterday_bank_cark_tixian_money_count" runat="server" />元</td>
                    <td>&nbsp;</td>
                </tr>
                <!--/提现统计-->

                <!--购买点卡统计-->
                <asp:Literal ID="card_statistics" runat="server" />
                <!--/购买点卡统计-->

                <tr>
                    <td width="8%">&nbsp;</td>
                    <td width="42%">今日完成任务利润发布点共计：<asp:Literal ID="today_finish_task_fabu_point_count" runat="server" />点</td>
                    <td>今日任务利润合计约：<asp:Literal ID="today_finish_task_fabu_point_transfer_money_count" runat="server" />元</td>
                </tr>
                <tr>
                    <td width="8%">&nbsp;</td>
                    <td width="42%">昨日完成任务利润发布点共计：<asp:Literal ID="yesterday_finish_task_fabu_point_count" runat="server" />点</td>
                    <td>昨日任务利润合计约：<asp:Literal ID="yesterday_finish_task_fabu_point_transfer_money_count" runat="server" />元</td>
                </tr>
                <tr>
                    <td width="8%">&nbsp;</td>
                    <td colspan="2">今日消费支出金额共计：<asp:Literal ID="today_expense_money_count" runat="server" />元 (不含提现的其他所有支出)</td>
                </tr>
                <tr>
                    <td width="8%">&nbsp;</td>
                    <td colspan="2">昨日消费支出金额共计：<asp:Literal ID="yesterday_expense_money_count" runat="server" />元 (不含提现的其他所有支出)</td>
                </tr>
            </table>
            <!--/综合统计-->

            <div class="line20"></div>

            <!--任务统计-->
            <table width="100%" border="0" cellspacing="0" cellpadding="0" class="ltable">
                <thead>
                    <tr>
                        <td width="8%">&nbsp;</td>
                        <th colspan="2" align="left"><strong>任务统计</strong></th>
                    </tr>
                </thead>
                <asp:Literal ID="task_statistics" runat="server" />
            </table>
            <!--/任务统计-->

            <div class="line20"></div>

            <!--会员统计-->
            <table width="100%" border="0" cellspacing="0" cellpadding="0" class="ltable">
                <thead>
                    <tr>
                        <th width="8%">&nbsp;</th>
                        <th colspan="2" align="left"><strong>会员统计</strong></th>
                    </tr>
                </thead>
                <tr>
                    <td width="8%">&nbsp;</td>
                    <td width="42%">平台共有会员：<asp:Literal ID="all_platform_member_count" runat="server" />个</td>
                    <td>今日注册会员：<asp:Literal ID="today_all_platform_member_count" runat="server" />个</td>
                </tr>
                <!--会员组统计-->
                <asp:Literal ID="user_group_statistics" runat="server" />
                <!--会员组统计-->
            </table>
            <!--/会员统计-->

            <div class="line20"></div>

            <!--推广统计-->
            <table width="100%" border="0" cellspacing="0" cellpadding="0" class="ltable">
                <thead>
                    <tr>
                        <th width="8%">&nbsp;</th>
                        <th colspan="2" align="left"><strong>推广统计</strong></th>
                    </tr>
                </thead>
                <tr>
                    <td width="8%">&nbsp;</td>
                    <td width="42%">平台由推广进来的会员有<asp:Literal ID="member_by_recommend_count" runat="server" />人</td>
                    <td>今日有推广进来的会员有<asp:Literal ID="today_member_by_recommend_count" runat="server" />人</td>
                </tr>
            </table>
            <!--/推广统计-->

        </div>
        <!--/列表-->
        <div class="line10"></div>

    </form>
</body>
</html>
