﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="bind_account.aspx.cs" Inherits="SKtms.Web.tasks.bind_account" %>
<%@ Import namespace="SKtms.Common" %>
<%@ Register Src="__head.ascx" TagPrefix="uc1" TagName="head" %>
<%@ Register Src="__center_nav.ascx" TagPrefix="uc1" TagName="center_nav" %>
<%@ Register Src="__foot.ascx" TagPrefix="uc1" TagName="foot" %>

<uc1:head runat="server" id="head" />

<script type="text/javascript">
    $(function () {
        //提交绑定
        $("#ibtnSubmit").click(function () {
            if (!$("input[name='rblAccountType']:checked").val()) {
                alert('请选择绑定类型！');
                $('rblAccountType').focus();
                return false;
            }
            if ($("#txtAccount").val() == '') {
                alert('请输入绑定账号！');
                $('#txtAccount').focus();
                return false;
            }
        });
        taobao_or_jd(); //加载完执行
        $("#ddlShopSite").change(function () {
            $('#SiteName').html($('#ddlShopSite>option:selected').text());
            if ($("input[name='rblAccountType']:checked").val() != null) {
                $('#MaiNum').html($("input[name='rblAccountType']:checked").val() == '1' ? '买号' : $('#ddlShopSite>option:selected').val() == '1' ? "掌柜号" : "店铺名");
            }
            taobao_or_jd();
        });
        $("input[name='rblAccountType']").click(function () {
            $('#MaiNum').html($(this).val() == '1' ? '买号' : $('#ddlShopSite>option:selected').val() == '1' ? "掌柜号" : "店铺名");
            taobao_or_jd();
        });

        //删除
        $(".btnDelete").click(function () {
            return confirm('您确定要删除吗？\n\n删除后将不能再重新添加的哦，请慎重考虑！');
        });

        //更新
        $(".btnUpdate").click(function () {
            var str = "";
            var siteid = $(this).attr("siteid");
            if (siteid && siteid != '') {
                var sex = $(this).attr("sex");
                var age = $(this).attr("age");
                str = '性别：<select name="update_sex" id="update_sex">';
                str += '<option value="1"' + (sex == '1' ? ' selected="selected"' : '') + '>男</option>';
                str += '<option value="2"' + (sex == '2' ? ' selected="selected"' : '') + '>女</option>';
                str += '</select><br> <br>';

                str += '年龄：<select name="update_age" id="update_age">';
                str += '<option value="1"' + (age == '1' ? ' selected="selected"' : '') + '>20岁以下</option>';
                str += '<option value="2"' + (age == '2' ? ' selected="selected"' : '') + '>21-25岁</option>';
                str += '<option value="3"' + (age == '3' ? ' selected="selected"' : '') + '>26-32岁</option>';
                str += '<option value="4"' + (age == '4' ? ' selected="selected"' : '') + '>33-40岁</option>';
                str += '<option value="5"' + (age == '5' ? ' selected="selected"' : '') + '>41岁以上</option>';
                str += '</select><br> <br>';

                var obj = $('#ddlShopSite>option[value="' + siteid + '"]');
                var bind_type = obj.attr("bind_type");
                var flag = '', auto = '';
                if (bind_type == '1' || bind_type == '2') {
                    flag = " disabled";
                    auto = '<option value="">自动识别</option>';
                }
                if (siteid == '1' || siteid == '2') {
                    str += '信用等级：<select name="update_xinyu" id="update_xinyu"' + flag + '>' + auto + tao_opt + '</select><br> <br>';
                } else if (siteid == '3') {
                    str += '会员等级：<select name="update_xinyu" id="update_xinyu"' + flag + '>' + auto + jd_opt + '</select><br> <br>';
                }
                if (flag == '') {
                    str += '是否实名：<select name="update_isRealname" id="update_isRealname">' + realname_opt + '</select><br> <br>';
                }
            }
            str += "采集接口：<label><input name='port' id='port' type='radio' value='0' checked />默认</label> &nbsp; <label><input name='port' id='port' type='radio' value='1' />接口</label>";
            //防止打开多个对话框
            if (dialog.get('dialogBox')) {
                dialog.get('dialogBox').close().remove();
            }
            var d = dialog({
                id: 'dialogBox',
                title: "更新买卖号信息",
                content: str,
                padding: '30px',
                align: 'left',
                okValue: '确定',
                ok: function () {
                    var value = {
                        port: $("input[name='port']:checked").val(), xinyu: $('#update_xinyu>option:selected').val(), realname: $('#update_isRealname>option:selected').val(),
                        sex: $('#update_sex>option:selected').val(), age: $('#update_age>option:selected').val()
                    };
                    this.close(value);
                    this.remove();
                },
                cancelValue: '取消',
                cancel: function () { }
            });
            var _href = $(this).attr("href");
            d.addEventListener('close', function () {
                if (this.returnValue != null && this.returnValue != '') {
                    $("#UpdateParam").val(JSON.stringify(this.returnValue));
                    location.href = _href;
                }
            });
            d.show(this);
            return false;
        });
    });

    //淘宝京东等级切换
    var tao_opt = '<option value="0">新号</option><option value="4">1心</option><option value="11">2心</option><option value="41">3心</option><option value="91">4心</option><option value="151">5心</option><option value="251">1钻以上</option>';
    var jd_opt = '<option value="0">注册会员</option><option value="1">铜牌会员</option><option value="2000">银牌会员</option><option value="10000">金牌会员</option><option value="30000">钻石会员</option>';
    var mgj_opt = '<option value="0">新号V0</option><option value="200">V1</option><option value="600">V2</option><option value="1200">V3</option><option value="3000">V4</option><option value="10000">V5</option>';
    var realname_opt = '<option value="1">已通过实名认证</option><option value="0">未通过实名认证</option>';
    function taobao_or_jd() {
        if ($("input[name='rblAccountType']:checked").val() == '2') {
            $("#xinyu_tr").hide();
            $("#sex_tr").hide();
            $("#age_tr").hide();
            return;
        }
        $("#xinyu_tr").show()
        $("#sex_tr").show();
        $("#age_tr").show();
        var obj = $('#ddlShopSite>option:selected');
        var bind_type = obj.attr("bind_type");
        var flag = false;
        var tao = tao_opt;
        var jd = jd_opt;
        var mgj = mgj_opt;
        var realname = realname_opt;
        if (bind_type == '1' || bind_type == '2') {
            flag = true;
            var auto = '<option value="">自动识别</option>';
            tao = auto + tao_opt;
            jd = auto + jd_opt;
            mgj = auto + mgj_opt;
            realname = auto + realname_opt;
            $("#isRealname").hide();
        }
        else {
            $("#isRealname").show();
        }
        $("#xinyu").prop("disabled", flag);
        $("#isRealname").prop("disabled", flag);
        $("#isRealname").html(realname);
        var siteId = obj.val();
        if (siteId == '1' || siteId == '2') {
            $("#grade").html('信用积分等级：');
            $("#xinyu").html(tao);
        } else if (siteId == '3') {
            $("#grade").html('会员等级：');
            $("#xinyu").html(jd);
        } else if (siteId == '4') {
            $("#grade").html('会员等级：');
            $("#xinyu").html(mgj);
        }
        else if (siteId == '5') {
            $("#xinyu_tr").hide()
        }
    }

    //激活掌柜
    function dialogOpen(title, id) {
        var d = dialog({
            title: title,
            width: 650,
            padding: '10px',
            url: '/tasks/dialog/activate_shop.aspx?id=' + id,
            okValue: ' 关 闭 ',
            ok: function () { }
        }).show();
        return false;
    }
</script>
<form id="form1" runat="server">
  <div class="clear"></div>
  <!-- 中间内容外围 start -->
  <div class="task_content"> 
	<div class="taskHall">
	  <!-- 中间子导航 -->
        <ul class="task_tab">
            <uc1:center_nav runat="server" id="center_nav" />
        </ul>
      <div class="clear"></div>
    <!-- 买卖号绑定 -->
    <div class="BingDing">
        <span class="title">买/卖号绑定 &nbsp; &nbsp; <span class="red">【亲，绑定的买卖号务必真实哦，一旦发现虚假，锁定处理】</span></span>
        <div class="center">
            <div class="left">
            
                <table width="100%" border="0" cellspacing="0" cellpadding="4">
                <tr>
                  <td align="right"></td>
                  <td height="10" align="left"></td>
                </tr>
                <tr>
                  <td width="38%" align="right">电商平台类型：</td>
                  <td width="62%" height="40" align="left">&nbsp;
                      <asp:DropDownList ID="ddlShopSite" runat="server"></asp:DropDownList>
                    </td>
                </tr>
                <tr>
                  <td align="right">绑定类型：</td>
                  <td height="30" align="left">&nbsp;
                      <asp:RadioButtonList ID="rblAccountType" runat="server" RepeatLayout="Flow" RepeatDirection="Horizontal">
                          <asp:ListItem Value="1" title="买号用来接手任务，帮卖家购买商品的账号。">绑定买号</asp:ListItem>
                          <asp:ListItem Value="2" title="掌柜号用来发布任务，买家帮您购买商品的店铺账号">绑定店铺掌柜号</asp:ListItem>
                      </asp:RadioButtonList></td>
                </tr>
                <tr>
                  <td align="right"><span id="SiteName">淘宝</span><span id="MaiNum">买号</span>：</td>
                  <td height="40" align="left">&nbsp; <asp:TextBox ID="txtAccount" MaxLength="30" onblur="this.value=Trim(this.value.toLowerCase());" runat="server"></asp:TextBox>
                  </td>
                </tr>
                <tr id="sex_tr">
                  <td align="right">性别：</td>
                  <td height="40" align="left">&nbsp; 
                        <select name="sex" id="sex">
                            <option value="1">男</option>
                            <option value="2">女</option>
                        </select>
                  </td>
                </tr>
                <tr id="age_tr">
                  <td align="right">年龄：</td>
                  <td height="40" align="left">&nbsp; 
                       <select name="age" id="age">
                            <option value="1">20岁以下</option>
                            <option value="2" selected="selected">21-25岁</option>
                            <option value="3">26-32岁</option>
                            <option value="4">33-40岁</option>
                            <option value="5">41岁以上</option>
                        </select>
                  </td>
                </tr>
                <tr id="xinyu_tr">
                    <td align="right" id="grade">信用积分等级：</td>
                    <td height="40" align="left">&nbsp;
                        <select name="xinyu" id="xinyu">
                            <option value="0">新号</option>
                            <option value="4">1心</option>
                            <option value="11">2心</option>
                            <option value="41">3心</option>
                            <option value="91">4心</option>
                            <option value="151">5心</option>
                            <option value="251">1钻以上</option>
                        </select>&nbsp;
                        <select name="isRealname" id="isRealname">
                            <option value="1">已通过实名认证</option>
                            <option value="0">未通过实名认证</option>
                        </select>
                    </td>
                </tr>
                <tr>
                  <td align="right"></td>
                  <td height="30" align="left">&nbsp;
                      <asp:RadioButtonList ID="rblPort" runat="server" RepeatLayout="Flow" RepeatDirection="Horizontal" title="账号/店铺名采集检验接口">
                          <asp:ListItem Value="0" Selected="True">默认</asp:ListItem>
                          <asp:ListItem Value="1">接口</asp:ListItem>
                      </asp:RadioButtonList>
                  </td>
                </tr>
                <tr>
                  <td align="right">&nbsp;<asp:hiddenfield id="UpdateParam" runat="server"></asp:hiddenfield></td>
                  <td height="60" align="left" valign="middle">&nbsp;
                      <asp:ImageButton ID="ibtnSubmit" runat="server" ImageUrl="/style/images/ConfirmButton_2.gif" OnClick="ibtnSubmit_Click" />
                  </td>
                </tr>			
                <tr>
                  <td height="20" colspan="3" align="center">注：绑定后账号将无法修改，同时删除后也无法再重新添加！</td>
                </tr>
              </table>
            
            </div>
            <div class="right">
              <p><span class="orange rough">绑定买号tips：</span><br />
              注：普通会员每个任务区可以绑定<asp:Label ID="binding_buy_name_num" runat="server" Text="0" class="orange"></asp:Label>个买号，VIP会员不限制！ <a href="<%=linkurl("cards","buy")%>" target="_blank" class="orange">升级为VIP会员或更高级别会员</a></p>
              <p>1、请尽量绑定多个备选买号，接手任务时轮换使用；<a href="/service/show-17.html" target="_blank" class="orange">什么是买号？</a><a href="/service/show-29.html" target="_blank" class="orange">&nbsp; 查看各会员组绑定数量？</a><br />
                2、根据淘宝的最新安全策略，所有买号都要求必须是填写完整个人信息后才能进行绑定；为了您的买号与卖家网店安全请您先将买号个人信息完善后再接手任务；<br />
                3、请不要同一买号在多个平台接任务，避免因接任务过多被淘宝等稽查系统列入监控目标给卖家店铺造成损失。<br />
                <span class="blue rough">姓别和年龄的作用：例如卖家发布的任务要求只能21-25岁的女性用户接手，若你想接此任务，你的买号必需适合这个条件才可以接手，所以请如实选择性别与年龄。</span><br />
              </p><br>
              <p><span class="orange rough">绑定掌柜号tips：</span><br />
                注：普通会员每个任务区可以绑定<asp:Label ID="binding_shop_name_num" runat="server" Text="0" class="orange"></asp:Label>个掌柜号，想要绑定更多，<a href="<%=linkurl("cards","buy")%>" target="_blank" class="orange">请升级为VIP会员或更高级别会员</a><br />
                  建议：如果您的店铺加入了淘宝的消保，发布任务时尽量过滤下低积分接手，避免受到损失！<br />
              </p>
            </div>
        </div>
    </div>
    <!-- /买卖号绑定 -->
    
	<ul class="screening" style="border-top: 1px solid #ACDAFF; margin-top: 20px;">
        <li>任务区筛选：
        <asp:DropDownList ID="ddlOrderby" runat="server" style="margin-right:10px" AutoPostBack="True" OnSelectedIndexChanged="ddlOrderby_SelectedIndexChanged">
      </asp:DropDownList> 
                
        <span class="orderSub">
            <asp:Literal ID="orderFields" runat="server"></asp:Literal>
        </span>
        </li>
    </ul>

	<div class="clear"></div>
	<!-- 列表内容 -->
	<div class="t_list">

    <asp:Repeater ID="rptShopName" runat="server" Visible="false" OnItemCommand="rptShopName_ItemCommand">
        <HeaderTemplate>
            <table style="border-bottom: 1px solid #ACDAFF; margin-bottom: 6px;" border="0" cellspacing="0" cellpadding="4" height="40" width="100%">
                <tr>
                    <th width="20%">任务区</th>
                    <th width="20%">绑定掌柜帐号</th>
                    <th width="20%">绑定时间</th>
                    <th width="20%">状态</th>
                    <th width="">操作</th>
                </tr>
            </table>
            <table class="list_tbl" border="0" cellspacing="0" cellpadding="4" width="100%">
        </HeaderTemplate>
        <ItemTemplate>
            <tr>
                <td width="20%" align="center"><%#GetShopSiteTitle(Utils.ObjToInt(Eval("shop_site_id").ToString()))%></td>
                <td width="20%" align="center"><%#Eval("account")%><%#GetAccountInfo(Utils.ObjToInt(Eval("id")))%></td>
                <td width="20%" align="center"><%#Eval("add_date")%></td>
                <td width="20%" align="center"><%#GetStatusInfo(Utils.ObjToInt(Eval("id")))%></td>
                <td width="" align="center">
                    <asp:LinkButton ID="btnUpdate" runat="server" CssClass="link_btn btnUpdate" CommandName="Update" CommandArgument='<%#Eval("id")%>'>更新</asp:LinkButton>　
                    <asp:LinkButton ID="btnDelete" runat="server" CssClass="link_btn red btnDelete" CommandName="Delete" CommandArgument='<%#Eval("id")%>'>删除</asp:LinkButton>
                </td>
            </tr>
        </ItemTemplate>
        <FooterTemplate>
            <%#rptShopName.Items.Count == 0 ? "<tr><td align=\"center\" colspan=\"5\">暂无记录</td></tr>" : ""%>
            </table>
        </FooterTemplate>
    </asp:Repeater>

    <asp:Repeater ID="rptNickName" runat="server" Visible="false" OnItemCommand="rptNickName_ItemCommand">
        <HeaderTemplate>
            <table style="border-bottom: 1px solid #ACDAFF; margin-bottom: 6px;" border="0" cellspacing="0" cellpadding="4" height="40" width="100%">
                <tr>
                    <th width="90">任务区</th>
                    <th width="190">绑定的买号</th>
                    <th width="110">性别/年龄</th>
                    <th width="130">目前买号信誉</th>
                    <th width="120">今日接手任务数</th>
                    <th width="120">本周接手任务数</th>
                    <th>绑定时间</th>
                    <th width="110">状态</th>
                    <th width="140">操作</th>
                </tr>
            </table>
            <table class="list_tbl" border="0" cellspacing="0" cellpadding="4" width="100%">
        </HeaderTemplate>
        <ItemTemplate>
            <tr>
                <td width="90" align="center"><%#GetShopSiteTitle(Utils.ObjToInt(Eval("shop_site_id").ToString()))%></td>
                <td width="190" align="center"><%#Eval("account")%><%#GetAccountInfo(Utils.ObjToInt(Eval("id")))%></td>
                <td width="110" align="center"><%#GetSex(Utils.ObjToInt(Eval("sex").ToString()))%>/<%#GetAgeTitle(Utils.ObjToInt(Eval("age").ToString()))%></td>
                <td width="130" align="center"><span class="orange"><%#Eval("xinyu")%></span> <%#GetExpGradeIco(Utils.ObjToInt(Eval("xinyu").ToString()), Utils.ObjToInt(Eval("shop_site_id").ToString()))%></td>
                <td width="120" align="center"><%#GetTodayBuy(Utils.ObjToInt(Eval("user_id").ToString()), Eval("account").ToString())%></td>
                <td width="120" align="center"><%#GetWeekBuy(Utils.ObjToInt(Eval("user_id").ToString()), Eval("account").ToString())%></td>
                <td align="center"><%#Eval("add_date")%></td>
                <td width="110" align="center"><%#GetStatusInfo(Utils.ObjToInt(Eval("id")))%></td>
                <td width="140" align="center">
                    <asp:LinkButton ID="btnUpdate" runat="server" CssClass="link_btn btnUpdate" siteid='<%#Eval("shop_site_id").ToString()%>' sex='<%#Eval("sex").ToString()%>' age='<%#Eval("age").ToString()%>' CommandName="Update" CommandArgument='<%#Eval("id")%>'>更新</asp:LinkButton>　
                    <asp:LinkButton ID="btnDelete" runat="server" CssClass="link_btn red btnDelete" CommandName="Delete" CommandArgument='<%#Eval("id")%>'>删除</asp:LinkButton>
                </td>
            </tr>
        </ItemTemplate>
        <FooterTemplate>
            <%#rptNickName.Items.Count == 0 ? "<tr><td align=\"center\" colspan=\"9\">暂无记录</td></tr>" : ""%>
            </table>
        </FooterTemplate>
    </asp:Repeater>

    </div>
    <!-- /列表内容 -->

	<div class="multipage">
      <div id="PageContent" runat="server" class="flickr"></div>
	</div>

  </div>
  </div>
  <!-- 中间内容外围 end -->
</form>

<uc1:foot runat="server" id="foot" />