﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="index.aspx.cs" Inherits="SKtms.Web.tasks.index" %>
<%@ Import namespace="System.Data" %>
<%@ Import namespace="SKtms.Common" %>

<%@ Register Src="__head.ascx" TagPrefix="uc1" TagName="head" %>
<%@ Register Src="__center_nav.ascx" TagPrefix="uc1" TagName="center_nav" %>
<%@ Register Src="__foot.ascx" TagPrefix="uc1" TagName="foot" %>

<uc1:head runat="server" id="head" />

<link rel="stylesheet" href="../css/jquery.tipsy.css">
<script type="text/javascript" src="../scripts/jquery/jquery.tipsy.js"></script>
<script type="text/javascript">
    $(function () {
        $('.td_center img').tipsy();
        //tab菜单初始化
        var SDmodel = new scrollDoor();
        SDmodel.sd(["gg_m1", "gg_m2"], ["gg_d1", "gg_d2"], "currently", "''");
        SDmodel.sd(["bbs_m1", "bbs_m2", "bbs_m3"], ["bbs_d1", "bbs_d2", "bbs_d3"], "title1", "title2");

        //收缩点击
        $(".menber_tab .dianji").click(function () {
            $("div.options").slideToggle("fast");
            $(this).toggleClass("collapsed_yes");
            if (document.getElementById("dianji").className != "dianji") {
                setCookie("index_options_box", "none");
                $("#notice").show();
            }
            else {
                setCookie("index_options_box", "block");
                $("#notice").hide();
            }
        });

        //自动刷新
        function TaskAutoRefresh() {
            if ($('#AutoRefresh').prop("checked")) {
                setCookie("Index_AutoRefresh", "yes");
                window.location.reload();
            } else {
                setCookie("Index_AutoRefresh", "");
            }
            window.setTimeout(TaskAutoRefresh, 10000);
        }
        if (getCookie("Index_AutoRefresh") == "yes") {
            $('#AutoRefresh').prop("checked", true);
        }
        window.setTimeout(TaskAutoRefresh, 10000);
    });
</script>

<div class="clear"></div>
<form id="form1" runat="server">
<!-- 会员信息 start -->
<div class="menber_tab">
    <div class="dh">
        <span class="top">你在这里能看到什么？</span>
        <span class="center" id="notice">
            <ul>
                <%
                DataTable new_list = get_article_list("service", 3, 5, "status=0", "is_top desc, sort_id asc, id desc");
                foreach(DataRow dr in new_list.Rows) 
                {%>
                <li><a href="<%=linkurl("article_show",dr["id"].ToString())%>" target="_blank" title="<%=dr["title"]%>"><%=Utils.CutString(dr["title"].ToString(),80)%></a></li>
                <%}%>
            </ul>
        </span>
        <span id="dianji" class="dianji"><a href="javascript:;"><img src="/style/images/manber_bg7.gif" /><img src="/style/images/manber_bg8.gif" class="showpic" /></a>
        </span>
    </div>

    <div class="clear"></div>
    <div class="options">
        <script type="text/javascript">
            //收缩后的内容向上滚动
            if (document.getElementById('notice')) {
                var sl_ii = $("#notice ul li").length;
                var sl_i = sl_ii + 1;
                $("#notice ul li").hide();
                $("#notice ul li").eq(0).show();
                var sI = setInterval("sl()", 5000);
                function sl(sl_q) {
                    if (sI) { clearInterval(sI); }
                    sI = setInterval("sl()", 5000);
                    if (sl_q == null) {
                        sl_j = sl_i % sl_ii;
                    } else {
                        sl_i = sl_q + sl_ii + 1;
                        sl_j = sl_i % sl_ii;
                    }
                    $("#notice ul li").hide();
                    $("#notice ul li").eq(sl_j).show("slow");
                    sl_i++;
                }
            }

            if (getCookie('index_options_box') != "block") {
                document.getElementById("dianji").className = "dianji collapsed_yes";
                $("div.options").hide();
                $("#notice").show();
            }
        </script>
        <div class="left">
            <div class="d2h">尊敬的<asp:Label ID="lbUserName" CssClass="orange" runat="server" Text="X先生"></asp:Label>，欢迎您回来！</div>
            <div class="nr">
                <p>
                    账户余额：<span class="orange"><%=userModel.amount.ToString("C")%></span> 
                    元 &nbsp; 发布点：<span class="orange"><%=userModel.point.ToString("G")%></span>
                    点
                </p>
                <p>
                    可用积分：<span class="orange"><%=userModel.score.ToString()%></span>
                    <asp:Literal ID="expIco" runat="server"></asp:Literal>&nbsp;
                    <asp:Literal ID="authIco" runat="server"></asp:Literal>
                    <asp:Literal ID="shangbaoIco" runat="server"></asp:Literal>
                    <asp:Literal ID="userGroupIco" runat="server"></asp:Literal>
                </p>
                <p class="one">
                    接手方：待支付任务
                    <asp:HyperLink ID="hlkBuyStatus1" CssClass="orange" runat="server">0</asp:HyperLink>
                    条 &nbsp; 待收货好评任务
                    <asp:HyperLink ID="hlkBuyStatus3" CssClass="orange" runat="server">0</asp:HyperLink>
                    条
                </p>
                <p class="one">
                    发布方：待发货任务
                    <asp:HyperLink ID="hlkAddStatus2" CssClass="orange" runat="server">0</asp:HyperLink>
                    条 &nbsp; 待确认审核任务
                    <asp:HyperLink ID="hlkAddStatus4" CssClass="orange" runat="server">0</asp:HyperLink>
                    条
                </p>
                <p class="one">
                    注意项：待处理申诉
                    <asp:HyperLink ID="hlkAppeal" CssClass="orange" runat="server">0</asp:HyperLink>
                    条 &nbsp; 我被拉入黑名单
                    <asp:Label ID="lbBlacklist" CssClass="orange" runat="server" Text="0"></asp:Label>
                    人
                </p>
            </div>
        </div>

        <div class="right">
            <div class="we"><span id="bbs_m1" class="title1">平台公告</span><span id="bbs_m2" class="title2">买家教程</span><span id="bbs_m3" class="title2">卖家教程</span></div>

            <div class="clear"></div>
            <div id="bbs_d1" class="bbsbox">
                <ul>
                    <%
                    new_list = get_article_list("service", 3, 5, "status=0", "is_top desc, sort_id asc, id desc");
                    foreach(DataRow dr in new_list.Rows) 
                    {%>
                    <li><a href="<%=linkurl("article_show",dr["id"].ToString())%>" target="_blank" title="<%=dr["title"]%>"><%=Utils.CutString(dr["title"].ToString(),44)%></a></li>
                    <%}%>
                </ul>
            </div>

            <div id="bbs_d2" class="bbsbox" style="display: none;">
                <ul>
                    <%
                    new_list = get_article_list("service", 8, 5, "status=0", "is_top desc, sort_id asc, id desc");
                    foreach(DataRow dr in new_list.Rows) 
                    {%>
                    <li><a href="<%=linkurl("article_show",dr["id"].ToString())%>" target="_blank" title="<%=dr["title"]%>"><%=Utils.CutString(dr["title"].ToString(),44)%></a></li>
                    <%}%>
                </ul>
            </div>

            <div id="bbs_d3" class="bbsbox" style="display: none;">
                <ul>
                    <%
                    new_list = get_article_list("service", 9, 5, "status=0", "is_top desc, sort_id asc, id desc");
                    foreach(DataRow dr in new_list.Rows) 
                    {%>
                    <li><a href="<%=linkurl("article_show",dr["id"].ToString())%>" target="_blank" title="<%=dr["title"]%>"><%=Utils.CutString(dr["title"].ToString(),44)%></a></li>
                    <%}%>
                </ul>
            </div>

        </div>

        <div class="right2">
            <div class="gg_box_2">
                <div class="menu">
                    <ul>
                        <li id="gg_m1" class="currently"><span>新手帮助</span></li>
                        <li id="gg_m2"><span>常见问题</span></li>
                    </ul>
                </div>
                <div class="tabcon1">
                    <ul id="gg_d1" style="padding:7px 15px;">
                        <%
                        new_list = get_article_list("service", 6, 5, "status=0", "is_top desc, sort_id asc, id desc");
                        foreach(DataRow dr in new_list.Rows) 
                        {%>
                        <li><a href="<%=linkurl("article_show",dr["id"].ToString())%>" target="_blank" title="<%=dr["title"]%>"><%=Utils.CutString(dr["title"].ToString(),44)%></a></li>
                        <%}%>
                    </ul>
                    <ul id="gg_d2" style="display:none; padding:7px 15px;">                 
                        <%
                        new_list = get_article_list("service", 7, 5, "status=0", "is_top desc, sort_id asc, id desc");
                        foreach(DataRow dr in new_list.Rows) 
                        {%>
                        <li><a href="<%=linkurl("article_show",dr["id"].ToString())%>" target="_blank" title="<%=dr["title"]%>"><%=Utils.CutString(dr["title"].ToString(),44)%></a></li>
                        <%}%>
                    </ul>
                </div>
            </div>
        </div>

    </div>
    <!-- options end -->
</div>
<!-- 会员信息 end -->

<div class="clear"></div>
<!-- 中间内容外围 -->
  <div class="task_content"> 
	<!-- 列表头 -->
	<div class="taskHall">
        <ul class="task_tab">
            <li id="tab_m1" class="current"><a href="javascript:;"><span><asp:literal id="tab_task_name" runat="server"></asp:literal></span></a></li>
            <!-- 中间子导航 -->
            <uc1:center_nav runat="server" ID="center_nav" />
        </ul>
        <div class="clear"></div>
        <ul class="search">
            <li>任务搜索：
                <asp:dropdownlist id="ddlSearchType" runat="server">
                <asp:ListItem Text="任务编号" Value="1"></asp:ListItem>
                <asp:ListItem Text="发布人" Value="2"></asp:ListItem>
                </asp:dropdownlist>
                <asp:textbox id="txtKeyWord" maxlength="20" cssclass="text" runat="server"></asp:textbox>
                <asp:imagebutton id="ibtnSubmit" imageurl="/style/images/search.gif" imagealign="AbsMiddle" runat="server" onclick="ibtnSubmit_Click" />
            </li>
            <li class="task_refresh_button">
                <input id="AutoRefresh" type="checkbox" name="AutoRefresh" class="checkbox" />
                <label title="勾上每隔10秒自动刷新" for="AutoRefresh">自动刷新页面</label>&nbsp; 
                <img src="/style/images/task_reflesh.gif" align="absmiddle" style="cursor: pointer;" onclick="window.location.reload();" title="刷新本页面">
            </li>
        </ul>
        <ul class="screening">
            <li>筛选方式：
                <asp:dropdownlist id="ddlOrderby" style="margin-right: 10px;" runat="server" autopostback="True" onselectedindexchanged="ddlOrderby_SelectedIndexChanged"></asp:dropdownlist>
                <asp:label id="orderFields" cssclass="orderSub" runat="server" text=""></asp:label>
            </li>
        </ul>
    </div>
	<!-- /列表头 -->

    <!-- 列表内容 -->
    <div id="task_list_wrap">
        <asp:Repeater ID="rptList" runat="server">
            <HeaderTemplate>
                <table border="0" cellpadding="0" cellspacing="0" width="100%">
        	</HeaderTemplate>
            <ItemTemplate>
                <tr class="task_list">
                    <td>
                        <div class="list_content">
                            <div class="top">
                                <span class="top_title">
                                    <span class="left"><%#GetXushiIco(Utils.ObjToInt(Eval("xushi_type")), Utils.ObjToInt(Eval("is_shop_cart")))%>　<span title="任务编号"><%#Eval("task_no")%></span></span>
                                    <span class="addtime" title="发布时间"><%#Eval("add_date").ToString()%></span>
                                </span>
                            </div>
                            <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                <tr>
                                    <td class="td_left">
                                        <%#GetUserAvatar(Utils.ObjToInt(Eval("user_id")), Utils.ObjToInt(Eval("shop_site_id")))%>
                                      <%--<%#!string.IsNullOrWhiteSpace(Eval("product_pic").ToString()) ? "<img class=\"preview\" src=\""+ Eval("product_pic").ToString() + "\">" : "<img src=\"/style/images/nopic_" + Eval("shop_site_id") + ".png\">" %>--%>
                                    </td>
                                    <td class="td_center">
                                        <ul>
                                            <li>
                                                发布人：<%#GetUserInfo(Utils.ObjToInt(Eval("user_id")))%>
                                            </li>
                                            <li>
                                                任务金额：<span class="gold red"><%#Utils.GetNum(Eval("price").ToString())%></span> 元<%#CheckModPrice(Utils.ObjToInt(Eval("is_mod_price")))%>
                                            </li>
                                            <li>
                                                 发布点：<span class="red"><%#Utils.GetNum(Eval("point").ToString())%></span> 点
                                            </li>
                                            <li>
                                                收货时限：<span class="orange"><%#GetHaopingLimitTitle(Utils.ObjToInt(Eval("haoping_limit")), Utils.ObjToInt(Eval("shop_dynamic")), Eval("haoping_content").ToString())%></span>
                                            </li>
                                        </ul>
                                        <div class="ico_msg">
                                            <%#GetRequireInfo(Container.DataItem)%>
                                        </div>
                                    </td>
                                    <td class="td_right">
                                        <%#GetStatusAndButton(Utils.ObjToInt(Eval("id")), Utils.ObjToInt(Eval("status")))%>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </td>
                </tr>
            </ItemTemplate>
            <FooterTemplate>
                <%#rptList.Items.Count == 0 ? "<tr><td align=\"center\">暂无任务记录</td></tr>" : ""%>
            </table>
            </FooterTemplate>
        </asp:Repeater>
    </div>
	<!-- /列表内容 -->

    <div class="multipage">
        <div id="PageContent" runat="server" class="flickr"></div>
    </div>

    <!-- ad -->
    <div class="fajie_task_flow clearfix">
        <div class="fa">
            <p>掌柜发布任务流程</p>
            <img src="/templates/main/images/ad/task_fabu.png" width="1030" height="104" alt="">
        </div>
        <div class="jie">
            <p>试客接手任务流程</p>
            <img src="/templates/main/images/ad/task_jie.png" width="1030" height="104" alt="">
        </div>
    </div>

  </div>
<!-- /中间内容外围 -->
</form>

<uc1:foot runat="server" id="foot" />