﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="shop_account_info.aspx.cs" Inherits="SKtms.Web.tasks.shop_account_info" Title="买号基本信息" %>

<%@ Import Namespace="SKtms.Common" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>买号基本信息</title>
    <meta name="renderer" content="webkit" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <link href="/templates/main/css/style.css" rel="stylesheet" type="text/css">
    <link href="/scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript" src="/scripts/jquery/jquery-1.11.2.min.js"></script>
    <script type="text/javascript" src="/scripts/artdialog/dialog-plus-min.js"></script>
    <style type="text/css">
        .u-tab-content { width: 240px; height:280px; min-height: 260px; padding: 0; }
        .u-tab-content .title-div { height: 10px; }
        .form-box dl dt { width: 90px; line-height: 24px; min-height: 24px; }
        .form-box dl dd { text-align: left; padding: 0 0 0 10px; line-height: 24px; min-height:24px; }
        .form-box dl dd img {vertical-align:middle; }
    </style>
</head>
<body>
    <div class="u-tab-content">
        <div class="title-div">
            <strong>买号基本信息</strong>
        </div>
        <div class="form-box">
            <dl>
                <dt>买家名：</dt>
                <dd><%=model.account %></dd>
            </dl>
            <dl>
                <dt>信誉等级：</dt>
                <dd>
                    <%=model.xinyu%> <%
                    if (!string.IsNullOrWhiteSpace(model.rank_img)) {
                        this.echo("<img src=\"" + model.rank_img + "\" align=\"absmiddle\" />");
                    } else {
                        this.echo(GetExpGradeIco(model.xinyu, model.shop_site_id));
                    } %>
                </dd>
            </dl>
            <dl>
                <dt>注册日期：</dt>
                <dd>
                    <%=model.reg_date != null ? model.reg_date.GetValueOrDefault().ToShortDateString() : "未知"%>
                </dd>
            </dl>
            <dl>
                <dt>性别：</dt>
                <dd>
                    <%=model.sex==1 ? "男" : "女"%>
                </dd>
            </dl>
            <dl>
                <dt>年龄：</dt>
                <dd>
                    <%=Utils.GetAgeTitle(model.age)%> 
                </dd>
            </dl>
            <dl>
                <dt>是否实名：</dt>
                <dd>
                    <%if (model.is_realname == 1)
                        {
                            this.echo("已实名 <img src=\"/style/images/ShiMing.gif\" height=\"18\" align=\"absmiddle\" title=\"已通过支付宝实名认证\" />");
                        }
                        else
                        {
                            this.echo("未实名");
                        } %>
                </dd>
            </dl>
            <%if (!string.IsNullOrWhiteSpace(model.tmall_rank_img)) {%>
                <dl>
                    <dt>天猫等级：</dt>
                    <dd>
                        <img src="<%=model.tmall_rank_img%>" align="absmiddle" />
                    </dd>
                </dl>
            <% } %>
        </div>
    </div>
</body>
</html>
