﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="user_info.aspx.cs" Inherits="SKtms.Web.tasks.user_info" Title="用户基本信息" %>
<%@ Import Namespace="SKtms.Common" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title><%=site.seo_title %></title>
    <meta name="renderer" content="webkit" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <link href="/style/css/task.css" type="text/css" rel="stylesheet" />
    <link href="/css/pagination.css" rel="stylesheet" type="text/css" />
    <link href="/scripts/artdialog/ui-dialog.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript" src="/scripts/jquery/jquery-1.11.2.min.js"></script>
    <script type="text/javascript" src="/scripts/artdialog/dialog-plus-min.js"></script>
    <script type="text/javascript" src="/style/js/common.js"></script>
    <link href="/style/css/user_info.css" type="text/css" rel="stylesheet"/>
</head>
  
<!-- 基本信息外框 -->
<div class="menber_tab">
    <div class="dh">
        <span class="top">用户基本信息</span>
    </div>

    <div class="options">

        <div class="info_l">
            <ul>
                <div align="center" class="avatar">
                    <%if (!string.IsNullOrWhiteSpace(model.avatar))
                      {%>
                    <img src="<%=model.avatar%>" width="140" height="140">
                    <% }
                      else
                      { %>
                    <img src="/templates/main/images/user-avatar.png" title="还没上传头像" width="140" height="140">
                    <%} %>
                    <br />
                    <div class="userinfomenu">
                        <li><a href="javascript:void(0)" onclick="alert('如需发站内信请到与该用户有交易的页面点击图标链接！');"><%--sendMsg('<%=model.user_name%>')--%>
                            <img src="/style/images/sendmsg.gif" border="0" align="absmiddle">
                            发站内信</a>
                        </li>
                        <li><a href="javascript:;" onclick="alert('如需发手机短信请到与该用户有交易的页面点击图标链接！');"><%--sendSMS('<%=model.user_name%>', '<%=linkurl("send_sms", "send", model.user_name)%>')--%>
                            <img src="/style/images/mobile.gif" border="0" align="absmiddle">
                            发手机短信</a>
                        </li>
                    </div>
                </div>
            </ul>
        </div>

        <div class="info_center">
            <ul>
                <li>用户名：<%=Utils.Left(model.user_name,2) + "***" + Utils.Right(model.user_name,2) %></li>
                <li>用户组：<%=GetUserGroupNameAndIco(model.group_id)%></li>
                <li>注册时间：<%=model.reg_time%></li>
                <li>经验等级：<%=model.exp%> <%=Utils.GetUserExpGradeIco(model.exp)%></li>
                <li>认证信息：<%if (model.mobile_auth == 1)
                    {
                        this.echo("<img src=\"/style/images/mobile_1.gif\" align=\"absmiddle\" title=\"已通过手机认证\">");
                    }
                    else
                    {
                        this.echo("<img src=\"/style/images/mobile_2.gif\" align=\"absmiddle\" title=\"尚未通过手机认证\">");
                    }
                    if (model.realname_auth == 1)
                    {
                        this.echo(" <img src=\"/style/images/shiming.gif\" align=\"absmiddle\" title=\"已通过身份证实名认证\">");
                    }
                    else
                    {
                        this.echo(" <img src=\"/style/images/shiming_2.gif\" align=\"absmiddle\" title=\"尚未通过身份证实名认证\">");
                    }
                    if (model.video_auth == 1)
                    {
                        this.echo(" <img src=\"/style/images/video.gif\" align=\"absmiddle\" title=\"已通过视频认证\">");
                    }
                    else
                    {
                        this.echo(" <img src=\"/style/images/video_2.gif\" align=\"absmiddle\" title=\"尚未通过视频认证\">");
                    }
                    if(userModel.is_shangbao)
                    {
                        this.echo(" <img src=\"/style/images/ShangBao.gif\" align=\"absmiddle\" title=\"已加入商保服务\">");
                    }
                %>
                </li>
                <%--<li>
                    <a href='#'><img src="/style/images/space_bt.gif" width="120" height="36" style="padding-top: 4px;" /></a>
                </li>--%>
            </ul>
        </div>

        <div class="info_r">
            <table width="100%" border="0" cellspacing="0" cellpadding="0">
            <tr>
                <td>已发布免费试用活动：<asp:Label ID="lbAddTrykNum" CssClass="orange" runat="server" Text="0"></asp:Label> 份</td>
                <td>已发布红包试用任务：<asp:Label ID="lbAddTaskNum" CssClass="orange" runat="server" Text="0"></asp:Label> 份</td>
                <td>被申诉次数：<asp:Label ID="blAppealNum" CssClass="orange" runat="server" Text="0"></asp:Label> 次</td>
            </tr>
            <tr>
                <td>已申领免费试用商品：<asp:Label ID="lbJieTryNum" CssClass="orange" runat="server" Text="0"></asp:Label> 份</td>
                <td>已参与红包试用任务：<asp:Label ID="lbJieTaskNum" CssClass="orange" runat="server" Text="0"></asp:Label> 份</td>
                <td>被拉入黑名单人数：<asp:Label ID="lbBlacklistNum" CssClass="orange" runat="server" Text="0"></asp:Label> 人</td>
            </tr>
            </table>
            <div>
            <table width="100%" border="0" cellspacing="0" cellpadding="0">
                <tr>
                <td align="center" class="rough">满意度评价</td>
                <td class="blue">好评<img src="/style/images/emot/haoping.gif" align="absmiddle" /></td>
                <td class="orange">中评<img src="/style/images/emot/zhongping.gif" align="absmiddle" /></td>
                <td class="red">差评<img src="/style/images/emot/chaping.gif" align="absmiddle" /></td>
                <td class="blue rough">好评率</td>
                </tr>
                <tr>
                <td align="center" class="rough">身为商家：</td>
                <td class="blue">
                    <asp:Literal ID="fa_haoping" runat="server"></asp:Literal>
                </td>
                <td class="orange">
                    <asp:Literal ID="fa_zhongping" runat="server"></asp:Literal>
                </td>
                <td class="red">
                    <asp:Literal ID="fa_chaping" runat="server"></asp:Literal>
                </td>
                <td class="blue rough">
                    <asp:Literal ID="fa_rate" runat="server"></asp:Literal>
                </td>
                </tr>
                <tr>
                <td align="center" class="rough">身为买家：</td>
                <td class="blue">
                    <asp:Literal ID="jie_haoping" runat="server"></asp:Literal>
                </td>
                <td class="orange">
                    <asp:Literal ID="jie_zhongping" runat="server"></asp:Literal>
                </td>
                <td class="red">
                    <asp:Literal ID="jie_chaping" runat="server"></asp:Literal>
                </td>
                <td class="blue rough">
                    <asp:Literal ID="jie_rate" runat="server"></asp:Literal>
                </td>
                </tr>
            </table>
            </div>
        </div>
    </div>
</div>

<div class="clear"></div>
<div class="pinjia_content"> 
    <!-- 列表tab -->
    <div class="pinjiaHall">

        <ul class="pinjia_tab">
            <li<%=this.tab < 2 ? " class='current'":""%>><a href="<%=linkurl("user_info",this.user_id,"1")%>"><span>来自买家的评价</span></a></li>
            <li<%=this.tab == 2 ? " class='current'":""%>><a href="<%=linkurl("user_info",this.user_id,"2")%>"><span>来自商家的评价</span></a></li>
            <li<%=this.tab == 3 ? " class='current'":""%>><a href="<%=linkurl("user_info",this.user_id,"3")%>"><span>给他人的评价</span></a></li>
            <%--<li<%=this.tab==4? " class='current'":""%>><a href="<%=linkurl("user_info",this.user_id,"3")%>"><span>被他人申诉情况</span></a></li>--%>
        </ul>

        <div class="clear"></div>

        <!-- 列表 -->
        <div class="Pingjia_list">
            <table style="border-bottom: 1px solid #ACDAFF; margin-bottom: 6px;" border="0" cellspacing="0" cellpadding="4" height="30" width="100%">
                <tr>
                    <th width="60">序号</th>
                    <th width="150">活动区</th>
                    <th width="160"><%
                        if (this.tab == 3)
                        {
                            this.echo("被评价人");
                        }
                        else if (this.tab == 2)
                        {
                            this.echo("评价人（商家）");
                        }
                        else
                        {
                            this.echo("评价人（买家）");
                        }%></th>
                    <th width="150">评分</th>
                    <th width="160">评价时间</th>
                    <th width="">评价内容</th>
                </tr>
            </table>
            <asp:Repeater ID="rptList" runat="server">
                <HeaderTemplate>
                    <table class="list_tbl" border="0" cellspacing="0" cellpadding="4" width="100%">
                </HeaderTemplate>
                <ItemTemplate>
                    <tr>
                        <td width="60" align="center"><%#Container.ItemIndex + 1%></td>
                        <td width="150" align="center"><%#this.get_category_title(Utils.ObjToInt(Eval("category_id"), 0), "")%></td>
                        <td width="160" align="center"><%#CheckHaopingUserType(Utils.ObjToInt(Eval("user_type"), 0))%><%#Eval("friend_name")%></td>
                        <td width="150" align="center"><%#GetHaopingType(Utils.ObjToInt(Eval("pingjia_type"),0))%></td>
                        <td width="160" align="center"><%#Eval("add_time")%></td>
                        <td width="" align="center"><%#Eval("content").ToString().Replace("\"","")%>&nbsp;</td>
                    </tr>
                </ItemTemplate>
                <FooterTemplate>
                    <%#rptList.Items.Count == 0 ? "<tr><td align=\"center\" colspan=\"6\">暂无评价记录</td></tr>" : ""%>
	                </table>
                </FooterTemplate>
            </asp:Repeater>
            <div class="multipage">
                <div id="PageContent" runat="server" class="flickr"></div>
            </div>
        </div>
        <!-- /列表 -->
    </div>
    <!-- /列表tab -->
</div>
<!-- /基本信息外框  -->
