﻿//====================初始化验证表单====================
$(function(){
    //提交表单
    $("#btnSubmit").bind("click", function() {
        if ($("#txtUserName").val() == "" || $("#txtPassword").val() == "") {
            $("#msgtips").show().text("请填写用户名和登录密码！");
            return false;
        }
        if (typeof (login_question) != "undefined" && login_question == 1) {
            if ($("#question").val() == "") {
                $("#msgtips").show().text("请选择问题！");
                return false;
            }
            if ($("#txtAnswer").val() == "") {
                $("#msgtips").show().text("请填写答案！");
                return false;
            }
        }
        if ($("#txtCode").val() == "") {
            $("#msgtips").show().text("请填写验证码！");
            return false;
        }
        $.ajax({
            type: "POST",
            url: $("#loginform").attr("url"),
            dataType: "json",
            data: {
                "txtUserName" : $("#txtUserName").val(),
                "txtPassword" : $("#txtPassword").val(),
                "question" : $("#question").val(),
                "txtAnswer" : $("#txtAnswer").val(),
                "txtCode" : $("#txtCode").val(),
                "chkRemember" : $("#chkRemember").prop("checked")
            },
            timeout: 20000,
            beforeSend: function(XMLHttpRequest) {
                $("#btnSubmit").attr("disabled", true);
                $("#msgtips").show();
                $("#msgtips").text("正在登录，请稍候...");
            },
            success: function(data, textStatus) {
                if (data.status == 1){
                    if(typeof(data.url)=="undefined"){
                        top.location.href = $("#turl").val();
                    }else{
                        top.location.href = data.url;
                    }
                } else {
                    $("#btnSubmit").attr("disabled", false);
                    $("#msgtips").text(data.msg);
                    if (data.msg != "") {
                        if ($(".send").children("img").eq(0).attr("src").indexOf("verify_code") > 0) {
                            $(".send").click();
                        }
                    }
                }
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                $("#msgtips").text("状态：" + textStatus + "；出错提示：" + errorThrown);
                $("#btnSubmit").attr("disabled", false);
            } 
        });
        return false;
    });

    //提示问题字体颜色控制
    if ($("#question")) {
        var question_color = $("#question").css("color");
        $("#question").change(function () {
            if ($(this).val() == '') {
                $(this).css("color", question_color);
            } else {
                $(this).css("color", "#333");
            }
        });
    }
});