﻿using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using Wechat.Model;
using RFramework.SQLQuery;
using weixinopen;
using Wechat;
using RFramework.SQLServer;
using RFramework.SQLQuery.SQLExpands;
using RFrameGenerate.Common;
using RFrameGenerate.Model.PageModel;

namespace RFrameGenerate.BLL
{
    public class AgentAccountManage
    {
        public static bool IsCountPrestore { get; set; }
        public static bool IsCountFsBalance { get; set; }

        #region 新增预存代理账户流水 -充值
        /// <summary>
        /// 新增预存代理账户流水 - 充值
        /// </summary>
        /// <param name="entity"></param>
        /// <returns></returns>
        public static Result AddAgentAccount(Guid guid, decimal TradingAmountTe, string RemarkTe)
        {
            using (var tran = new SqlRTransaction())
            {
                var query = Factory.CreateT_BAS_AdvanceAgentAccount(tran);
                var queryMer = Factory.CreateT_BAS_Merchants(tran);
                try
                {
                    if (AgentAccountManage.IsCountPrestore)
                    {
                        return new Result(false, "系统繁忙，请稍后重试");
                    }
                    //lock (CrowdPeriodLock.GetLock(guid.ToString() + "A3"))//备用 
                    //{

                    var currMoney = GetAgentAccount(guid);
                    var pre = TradingAmountTe + currMoney;
                    queryMer.Update(c => new object[]{
                             c. Prestore==pre   
                             }, c => c.MerchantGuid == guid, isFilterMerchant: false);

                    query.Add(new T_BAS_AdvanceAgentAccount()
                    {
                        AdvanceAgentAccountGuid = Guid.NewGuid(),
                        MerchantGuid = guid,
                        FlagshipOrdersGuid = null,
                        TradingCode = DateTime.Now.ToString("yyyyMMddHHmmss") + string.Format("{0:D2}", AdvanceAgentAccountConst.TradingType.用户充值),
                        TradingType = AdvanceAgentAccountConst.TradingType.用户充值,
                        TradingMain = string.Empty,
                        AvailableBalance = TradingAmountTe + currMoney,
                        TradingAmount = TradingAmountTe,
                        Discount = null,
                        Remark = RemarkTe,
                        TradingDate = DateTime.Now
                    });
                    //}
                    if (AgentAccountManage.IsCountPrestore)
                    {
                        return new Result(false, "系统繁忙，请稍后重试");
                    }
                    tran.Commit();
                    return new Result(true);
                }
                catch (Exception ex)
                {
                    tran.Rollback();
                    return new Result(false, ex.Message);
                }
            }
        }
        #endregion



        #region 获取预存代理账户可用余额(仅下单自风险管控使用)
        /// <summary>
        /// 获取预存代理账户可用余额(仅下单自风险管控使用)
        /// </summary>
        /// <param name="entity"></param>
        /// <returns></returns>
        public static decimal GetAgentAccount(Guid MerchantGuid)
        {
            using (var query = Factory.CreateT_BAS_Merchants())
            {
                //decimal currMoney = 0m;
                //var entity = query.GetFirstData(c => c.MerchantGuid == MerchantGuid, false, c => c.TradingDate, DAL.Enums.OrderMethods.DESC, RFramework.SQLServer.Enums.LockType.Default, false);
                //if (entity != null && entity.AvailableBalance != null)
                //{
                //    currMoney = entity.AvailableBalance.Value;
                //}
                //if (!AgentAccountManage.IsCountAc)  
                //{
                var currMoney = (query.GetFirstData(c => c.MerchantGuid == MerchantGuid, isFilterMerchant: false).Prestore ?? 0M);
                return currMoney;
                //}

            }
        }
        #endregion




        #region 获取预存代理流水-分页
        /// <summary>
        /// 获取预存代理流水-分页
        /// </summary>
        /// <param name="gridModel"></param>
        /// <param name="UserID"></param>
        /// <param name="TradingCode"></param>
        /// <param name="beginTime"></param>
        /// <param name="endTime"></param>
        /// <returns></returns>
        public static List<T_BAS_AdvanceAgentAccountWithLite> GetPageList(GridModel gridModel, string UserID, string TradingCode, DateTime? beginTime, DateTime? endTime)
        {
            using (var query = Factory.CreateT_BAS_AdvanceAgentAccountWithLite())
            {
                endTime = endTime != null ? endTime.Value.AddDays(1) : endTime;
                var isTop = MerchantManage.IsTop();
                if (isTop)
                {
                    var guids = AgentAuditManage.GetAllSubordinateAgentByMerGuid(CurrentManage.MerchantGuid);
                    var list = query.GetPageList(gridModel, c => c.UserID.SqlLike(UserID) && c.TradingCode.SqlLike(TradingCode) && c.TradingDate >= beginTime && c.TradingDate <= endTime && c.MerchantGuid.SqlIn(guids.ToArray()), true, c => c.TradingDate, DAL.Enums.OrderMethods.DESC, RFramework.SQLServer.Enums.LockType.Default, isFilterMerchant: false);
                    return list;
                }
                else
                {
                    var list = query.GetPageList(gridModel, c => c.UserID.SqlLike(UserID) && c.TradingCode.SqlLike(TradingCode) && c.TradingDate >= beginTime && c.TradingDate <= endTime && c.MerchantGuid == Common.CurrentManage.MerchantGuid, true, c => c.TradingDate, DAL.Enums.OrderMethods.DESC, RFramework.SQLServer.Enums.LockType.Default, isFilterMerchant: false);
                    return list;

                }


            }
        }
        #endregion


    }




}
