﻿using RFrameGenerate.Common;
using RFrameGenerate.Model;
using RFramework.SQLServer;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Text;
using RFramework.SQLQuery;
namespace RFrameGenerate.BLL
{
    public class AgentApplyManage
    {
        /// <summary>
        /// 代理商申请列表（分页）
        /// </summary>
        /// <param name="gridModel"></param>
        /// <param name="userId"></param>
        /// <returns></returns>
        public static List<T_BAS_OpenAgentsApply> GetPageList(GridModel gridModel, string userId)
        {
            using (var query = Factory.CreateT_BAS_OpenAgentsApply())
            {
                Expression<Func<T_BAS_OpenAgentsApply, bool>> condition = m => m.UserID.SqlLike(userId);
                return query.GetPageList(gridModel, condition, true, null, DAL.Enums.OrderMethods.Default, RFramework.SQLServer.Enums.LockType.Default);
            }
        }
        /// <summary>
        /// 保存代理商申请
        /// </summary>
        /// <param name="entity"></param>
        /// <returns></returns>
        public static Result Save(T_BAS_OpenAgentsApply entity)
        {
            using (var tran=new SqlRTransaction())
            {
                var query_merchant=Factory.CreateT_BAS_Merchants(tran);
                var query_openAgentsApply = Factory.CreateT_BAS_OpenAgentsApply(tran);
                var isExist = query_merchant.IsExist(a => a.UserID == entity.UserID, isFilterMerchant: false);
                if (isExist) return new Result(false, "该代理商ID已存在，请重新输入！");
                if (entity.OpenAgentsApplyGuid == null || entity.OpenAgentsApplyGuid == Guid.Empty)
                {
                    entity.OpenAgentsApplyGuid = Guid.NewGuid();
                    entity.FatherMerchantGuid = CurrentManage.MerchantGuid;
                    entity.ApplyState = DictionaryConst.AgentApplyState.Audit;
                    entity.ApplyDate = DateTime.Now;
                    entity.Password = entity.Password;
                    query_openAgentsApply.Add(entity);
                }
                else
                {
                    query_openAgentsApply.Update(a => new Object[] { 
                        a.StoreTitle==entity.StoreTitle,
                        a.Address==entity.Address,
                        a.ApplyState == DictionaryConst.AgentApplyState.Audit,
                        a.Contact==entity.Contact,
                        a.Telephone==entity.Telephone,
                        a.Remark==entity.Remark
                    }, a => a.OpenAgentsApplyGuid == entity.OpenAgentsApplyGuid);
                }
                return new Result(true);
            }
            
        }
        /// <summary>
        /// 根据Guid获取实体
        /// </summary>
        /// <param name="guid">代理商申请Guid</param>
        /// <returns>代理商申请entity</returns>
        public static T_BAS_OpenAgentsApply GetEntityByGuid(Guid? guid)
        {
            if (guid == null || guid == Guid.Empty) return new T_BAS_OpenAgentsApply();
            using (var query = Factory.CreateT_BAS_OpenAgentsApply())
            {
                return query.GetDataByGuid(guid.Value);
            }
        }
        /// <summary>
        /// 根据代理商申请Guid删除代理商申请Entity
        /// </summary>
        /// <param name="guid"></param>
        /// <returns></returns>
        public static Result Del(Guid guid)
        {
            using (var query = Factory.CreateT_BAS_OpenAgentsApply())
            {
                try
                {
                    var model = query.GetFirstData(a => a.OpenAgentsApplyGuid == guid);
                    if (model == null) return new Result(false, "找不到该代理商申请！");
                    if (model.ApplyState == DictionaryConst.AgentApplyState.AuditPass) return new Result(false, "该代理商已开通不允许删除！");
                    query.Delete(guid);
                    return new Result(true);
                }
                catch (Exception err)
                {
                    return new Result(false, err.Message);
                }
            }
        }
    }
}
