﻿using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Text;
using RFramework.SQLQuery;
using RFramework.SQLServer;
namespace RFrameGenerate.BLL
{
    public class AgentAuditManage
    {
        /// <summary>
        /// 代理商申请审核列表（分页）
        /// </summary>
        /// <param name="gridModel"></param>
        /// <param name="userId"></param>
        /// <returns></returns>
        public static List<T_BAS_OpenAgentsApply> GetPageList(GridModel gridModel, string userId)
        {
            using (var query = Factory.CreateT_BAS_OpenAgentsApply())
            {
                var guidList = GetAllSubordinateAgent();
                if (guidList != null && guidList.Count > 0)
                {
                    Expression<Func<T_BAS_OpenAgentsApply, bool>> condition = m => m.UserID.SqlLike(userId) && m.SMerchantGuid.SqlIn(guidList.ToArray());
                    return query.GetPageList(gridModel, condition, true, null, DAL.Enums.OrderMethods.Default, RFramework.SQLServer.Enums.LockType.Default, false);
                }
                return new List<T_BAS_OpenAgentsApply>();
            }
        }
        /// <summary>
        /// 获取所有下级代理
        /// </summary>
        /// <returns></returns>
        public static List<Guid?> GetAllSubordinateAgent()
        {
            var flag = true;
            List<Guid?> merchantList = new List<Guid?>();
            List<Guid?> listGuid = new List<Guid?>();
            merchantList.Add(Common.CurrentManage.MerchantGuid);
            using (var query = Factory.CreateT_BAS_AgentsFlagship())
            {
                while (flag)
                {
                    var list = query.GetList(a => a.FatherMerchantGuid.SqlIn(merchantList.ToArray()), isFilterMerchant: false);
                    if (list == null || list.Count == 0)
                    {
                        flag = false;
                    }
                    else
                    {
                        merchantList = new List<Guid?>();
                        merchantList.AddRange(list.Select(a => a.MerchantGuid));
                        listGuid.AddRange(list.Select(a => a.MerchantGuid));
                    }
                }
                return listGuid;
            }
        }


        /// <summary>
        /// 获取指定商家的所有下级代理
        /// </summary>
        /// <returns></returns>
        public static List<Guid?> GetAllSubordinateAgentByMerGuid(Guid? guid)
        {
            var flag = true;
            List<Guid?> listGuid = new List<Guid?>();
            List<Guid?> merchantList = new List<Guid?>();
            merchantList.Add(guid);
            using (var query = Factory.CreateT_BAS_AgentsFlagship())
            {
                while (flag)
                {
                    var list = query.GetList(a => a.FatherMerchantGuid.SqlIn(merchantList.ToArray()), isFilterMerchant: false);
                    if (list == null || list.Count == 0)
                    {
                        flag = false;
                    }
                    else
                    {
                        listGuid.AddRange(list.Select(a => a.MerchantGuid));
                        merchantList = new List<Guid?>();
                        merchantList.AddRange(list.Select(a => a.MerchantGuid));
                    }
                }
                return listGuid;
            }
        }

        public static List<T_BAS_Merchants> GetMerchantLists(List<Guid?> list, SqlRTransaction tran = null)
        {
            using (var query = Factory.CreateT_BAS_Merchants(tran))
            {
                var listMerchants = query.GetList(c => c.MerchantGuid.SqlIn((Guid[])(list.Select(m => m.Value).ToArray())), true, null, DAL.Enums.OrderMethods.Default, RFramework.SQLServer.Enums.LockType.Default, isFilterMerchant: false);
                return listMerchants;
            }

        }


        /// <summary>
        /// 获取下级代理同组代理
        /// </summary>
        /// <returns></returns>
        public static List<T_BAS_AgentsFlagship> GetGroupAgentByMerGuid(Guid merGuid)
        {
            using (var query = Factory.CreateT_BAS_AgentsFlagship())
            {
                var entity = query.GetFirstData(c => c.MerchantGuid == merGuid, isFilterMerchant: false);
                //if (entity==null)
                //{
                //    throw new Exception("当前代");
                //}
                if (entity.AgentProductDiscountGuid == null)
                {
                    return query.GetList(c => c.FlagshipGroupGuid == entity.FlagshipGroupGuid && c.AgentProductDiscountGuid.SqlIsNull(), false, null, DAL.Enums.OrderMethods.Default, RFramework.SQLServer.Enums.LockType.Default, isFilterMerchant: false);
                }
                else
                {
                    return query.GetList(c => c.FlagshipGroupGuid == entity.FlagshipGroupGuid && c.AgentProductDiscountGuid == entity.AgentProductDiscountGuid, false, null, DAL.Enums.OrderMethods.Default, RFramework.SQLServer.Enums.LockType.Default, isFilterMerchant: false);
                }
            }

        }


        /// <summary>
        /// 根据Guid获取代理商申请entity
        /// </summary>
        /// <param name="guid"></param>
        /// <returns></returns>
        public static T_BAS_OpenAgentsApply GetEntity(Guid guid)
        {
            using (var query = Factory.CreateT_BAS_OpenAgentsApply())
            {
                return query.GetDataByGuid(guid, false);
            }
        }
        /// <summary>
        /// 审核不通过
        /// </summary>
        /// <param name="guid"></param>
        /// <returns></returns>
        public static Result AuditNotPass(Guid guid, string Remark)
        {
            using (var query = Factory.CreateT_BAS_OpenAgentsApply())
            {
                try
                {
                    query.Update(a => new Object[] { 
                        a.ApplyState == DictionaryConst.AgentApplyState.AuditNotPass ,
                        a.Remark==Remark
                    }, a => a.OpenAgentsApplyGuid == guid, false);
                    return new Result(true);
                }
                catch (Exception err)
                {
                    return new Result(false, err.Message);
                }
            }
        }
    }
}
