﻿using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using Wechat.Model;
using RFramework.SQLQuery;
using weixinopen;
using Wechat;
using RFramework.SQLServer;
using RFramework.SQLQuery.SQLExpands;
using RFrameGenerate.Common;
using RFrameGenerate.Model.PageModel;

namespace RFrameGenerate.BLL
{
    public class AgentComUpRuleManage
    {

        #region 获取代理升级规则-分页数据（根据代理分组规则）
        /// <summary>
        /// 获取代理升级规则分页数据（根据代理分组规则）
        /// </summary>
        /// <param name="gridModel"></param>
        /// <param name="name"></param>
        /// <returns></returns>
        public static List<T_BAS_FlagAgentComUp> GetPageList(GridModel gridModel, Guid? FlagshipParaGuid)
        {
            using (var query = Factory.CreateT_BAS_FlagAgentComUp())
            {
                var list = query.GetPageList(gridModel, c => c.FlagshipParaGuid == FlagshipParaGuid, false, c => c.Sort, DAL.Enums.OrderMethods.ASC, RFramework.SQLServer.Enums.LockType.Default);
                return list;
            }
        }
        #endregion

        #region 新增代理升级规则
        /// <summary>
        /// 新增代理升级规则
        /// </summary>
        /// <param name="entity"></param>
        /// <returns></returns>
        public static Result AddAgentComUpRule(T_BAS_FlagAgentComUp entity)
        {
            using (var query = Factory.CreateT_BAS_FlagAgentComUp())
            {
                try
                {
                    entity.FlagAgentComUpGuid = Guid.NewGuid();
                    query.Add(entity);
                    return new Result(true);
                }
                catch (Exception ex)
                {
                    return new Result(false, ex.Message);
                }
            }
        }
        #endregion

        #region 更新代理升级规则
        /// <summary>
        /// 更新代理升级规则
        /// </summary>
        /// <param name="entity"></param>
        /// <returns></returns>
        public static Result UpdateAgentComUpRule(T_BAS_FlagAgentComUp entity)
        {
            using (var query = Factory.CreateT_BAS_FlagAgentComUp())
            {
                try
                {
                    query.Update(c => new object[]
                    { 
                     c.AgentComRatio==entity.AgentComRatio,
                     c.AgentLevel==entity.AgentLevel,
                     c.LevelUpValue==entity.LevelUpValue,
                     c.Sort==entity.Sort,
                    }, c => c.FlagAgentComUpGuid == entity.FlagAgentComUpGuid);
                    return new Result(true);
                }
                catch (Exception ex)
                {
                    return new Result(false, ex.Message);
                }
            }
        }
        #endregion

        #region 删除代理升级规则
        /// <summary>
        /// 删除代理升级规则
        /// </summary>
        /// <param name="entity"></param>
        /// <returns></returns>
        public static Result DelAgentComUpRule(Guid guid)
        {
            using (SqlRTransaction tran = new SqlRTransaction())
            {
                var query_FlagAgentComUp = Factory.CreateT_BAS_FlagAgentComUp(tran);
                tran.BeginTransaction();
                try
                {
                    query_FlagAgentComUp.Delete(c => c.FlagAgentComUpGuid == guid, isFilterMerchant: false);
                    tran.Commit();
                    return new Result(true);
                }
                catch (Exception ex)
                {
                    tran.Rollback();
                    return new Result(false, ex.Message);
                }
            }
        }
        #endregion


    }




}
