﻿using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using Wechat.Model;
using RFramework.SQLQuery;
using weixinopen;
using Wechat;
using RFramework.SQLServer;
using RFramework.SQLQuery.SQLExpands;
using RFrameGenerate.Common;
using RFrameGenerate.Model.PageModel;

namespace RFrameGenerate.BLL
{
    public class AgentCommissionManage
    {

        #region 获取代理佣金-分页数据
        /// <summary>
        /// 获取代理佣金-分页数据 
        /// </summary>
        /// <param name="gridModel"></param>
        /// <param name="name"></param>
        /// <returns></returns>
        public static List<T_BAS_FactorageAccount> GetPageList(GridModel gridModel, int? TradingType, string TradingCode, DateTime? beginTime, DateTime? endTime)
        {
            using (var query = Factory.CreateT_BAS_FactorageAccount())
            {
                endTime = endTime != null ? endTime.Value.AddDays(1) : endTime;
                var list = query.GetPageList(gridModel, c => c.MerchantGuid == Common.CurrentManage.MerchantGuid && c.TradingType == TradingType && c.TradingCode.SqlLike(TradingCode) && c.TradingDate >= beginTime && c.TradingDate <= endTime, true, c => c.TradingDate, DAL.Enums.OrderMethods.DESC, RFramework.SQLServer.Enums.LockType.Default, false);
                return list;
            }
        }
        #endregion

        #region 获取代理佣金-分页数据(总部)-暂定
        /// <summary>
        /// 获取代理佣金-分页数据(总部)-暂定
        /// </summary>
        /// <param name="gridModel"></param>
        /// <param name="name"></param>
        /// <returns></returns>
        public static List<T_BAS_FactorageAccountWithMer> GetPageListHq(GridModel gridModel, string UserID, int? TradingType, string TradingCode, DateTime? beginTime, DateTime? endTime)
        {
            using (var query = Factory.CreateT_BAS_FactorageAccountWithMer())
            {
                endTime = endTime != null ? endTime.Value.AddDays(1) : endTime;
                var agentArr = AgentAuditManage.GetAllSubordinateAgent().ToArray();
                if (agentArr == null || agentArr.Count() == 0)
                {
                    return null;
                }
                var list = query.GetPageList(gridModel, c => c.UserID == UserID && c.TradingType == TradingType && c.TradingCode.SqlLike(TradingCode) && c.TradingDate >= beginTime && c.TradingDate <= endTime && c.MerchantGuid.SqlIn(agentArr), true, c => c.TradingDate, DAL.Enums.OrderMethods.DESC, RFramework.SQLServer.Enums.LockType.Default, false);
                return list;
            }
        }
        #endregion


        #region 获取代理商佣金-可用余额，冻结金额
        /// <summary>
        /// 获取代理商佣金-可用余额，冻结金额
        /// </summary>
        /// <param name="curr"></param>
        /// <param name="total"></param>
        public static void GetAvailableAndFreeze(Guid guid, ref decimal available, ref decimal freeze)
        {
            using (var tran = new SqlRTransaction())
            {
                //var query_FactorageAccount = Factory.CreateT_BAS_FactorageAccount(tran);
                //var query_FactorageWithdrawal = Factory.CreateT_BAS_FactorageWithdrawal(tran);
                //var curr_FactorageAccount = query_FactorageAccount.GetFirstData(c => c.MerchantGuid == guid, false, c => c.TradingDate, DAL.Enums.OrderMethods.DESC, RFramework.SQLServer.Enums.LockType.Default, false);
                //var list_FactorageWithdrawal = query_FactorageWithdrawal.GetList(c => c.MerchantGuid == guid && c.TradingType == FactorageWithdrawalConst.TradingType.审核通过 || c.TradingType == FactorageWithdrawalConst.TradingType.审核中, false, null, DAL.Enums.OrderMethods.DESC, RFramework.SQLServer.Enums.LockType.Default, false);
                //available = (curr_FactorageAccount == null ? 0m : curr_FactorageAccount.AvailableBalance.Value);
                //freeze = ((list_FactorageWithdrawal != null && list_FactorageWithdrawal.Count > 0) == false ? 0m : list_FactorageWithdrawal.Sum(c => c.TradingAmount).Value);

                var queryMer = Factory.CreateT_BAS_Merchants(tran);
                 
                var entity = queryMer.GetFirstData(c => c.MerchantGuid ==guid /* Common.CurrentManage.MerchantGuid*/, isFilterMerchant: false);
                available = (entity.FsBalance ?? 0M);
                freeze = (entity.ComFreeze ?? 0M);

            }
        }
        #endregion

        #region 设置备注
        /// <summary>
        /// 设置备注
        /// </summary>
        /// <param name="guid"></param>
        /// <param name="Remark"></param>
        /// <returns></returns>
        public static object SetRemark(Guid guid, string Remark)
        {
            using (var query_FactorageAccount = Factory.CreateT_BAS_FactorageAccount())
            {
                try
                {
                    query_FactorageAccount.Update(c => new object[]{
                     c.Remark==Remark
                }, c => c.FactorageAccountGuid == guid, false);
                    return new Result(true);
                }
                catch (Exception ex)
                {
                    return new Result(false, ex.Message);
                }
            }
        }
        #endregion
    }

}
