﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RFrameGenerate.Model;
using RFramework.SQLQuery;
using RFrameGenerate.DAL.Interface;

namespace RFrameGenerate.BLL
{
    public class AgentProductDisManage
    {

        /// <summary>
        /// 根据分组GUID获取代理折扣
        /// </summary>
        /// <param name="groupGuid"></param>
        /// <returns></returns>
        public static List<T_BAS_AgentProductDiscount> GetAgentProDisByGroup(Guid? groupGuid)
        {
            using (var query = Factory.CreateT_BAS_AgentProductDiscount())
            {
                var list = query.GetList(c => c.FlagshipGroupGuid == groupGuid, isFilterMerchant: false);
                return list;
            }
        }


        /// <summary>
        /// 根据折扣GUID获取代理折扣
        /// </summary>
        /// <param name="guid"></param>
        /// <returns></returns>
        public static T_BAS_AgentProductDiscount GetAgentProDisByFk(Guid? guid)
        {
            using (var query = Factory.CreateT_BAS_AgentProductDiscount())
            {
                var model = query.GetFirstData(c => c.AgentProductDiscountGuid == guid, isFilterMerchant: false);
                return model;
            }
        }








    }
}
