﻿using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using Wechat.Model;
using RFramework.SQLQuery;
using weixinopen;
using Wechat;
using RFramework.SQLServer;
using RFramework.SQLQuery.SQLExpands;
using RFrameGenerate.Common;
using RFrameGenerate.Model.PageModel;

namespace RFrameGenerate.BLL
{
    public class AgentRulesManage
    {
        #region 获取代理规则列表
        /// <summary>
        /// 获取代理规则列表
        /// </summary>
        /// <returns></returns>
        public static List<T_BAS_FlagshipPara> GetList()
        {
            using (var query = Factory.CreateT_BAS_FlagshipPara())
            {
                var list = query.GetList(c => c.MerchantGuid == Common.CurrentManage.MerchantGuid, true, c => c.Sort, DAL.Enums.OrderMethods.ASC, RFramework.SQLServer.Enums.LockType.Default);
                return list;
            }
        }
        #endregion

        #region 获取指定代理商家的代理规则
        /// <summary>
        /// 获取指定商家的代理规则
        /// </summary>
        /// <param name="guid"></param>
        /// <returns></returns>
        public static USP_GetAgentRuleByMerchant GetAgentRuleByMerchant(Guid merchantGuid)
        {
            using (var query = Factory.CreateProcedure())
            {
                var entity = query.GetAgentRuleByMerchant(merchantGuid);
                return entity;
            }
        }
        #endregion


        #region 获取指定分组对应代理规则（暂用于添加代理时）
        /// <summary>
        /// 获取指定分组对应代理规则（暂用于添加代理时）
        /// </summary>
        /// <returns></returns>
        public static USP_GetAgentRuleByGroup GetUnifyFlagshipParaByGro(Guid groupGuid)
        {
            using (var query = Factory.CreateProcedure())
            {
                var entity = query.GetAgentRuleByGroup(groupGuid);
                return entity;
            }
        }
        #endregion

        #region  获取指定商家对应代理规则（暂用于下单时）
        /// <summary>
        /// 获取指定商家对应代理规则（暂用于下单时）
        /// </summary>
        /// <returns></returns>
        public static USP_GetAgentRuleByMerchant GetUnifyFlagshipParaByMer(Guid merchantGuid)
        {
            using (var tran = new SqlRTransaction())
            {
                var query = Factory.CreateProcedure(tran);
                var entity = query.GetAgentRuleByMerchant(merchantGuid);

                if (entity == null)
                {
                    //entity = new USP_GetAgentRuleByMerchant()
                    //{
                    //    FlagshipParaGuid = Guid.Empty,
                    //    //IsOpenAgents = false,
                    //    IsSoldOut = false,
                    //    IsCustomCommission = true,
                    //    FlagshipParaName = "默认代理规则",
                    //    UserWeChatType = AgentRuleConst.UserWeChatType.代理商,
                    //    GoodsDeliveryType = AgentRuleConst.GoodsDeliveryType.代理商,
                    //    CommodityRefundAudit = AgentRuleConst.CommodityRefundAudit.代理商,
                    //    AgentComType = AgentRuleConst.AgentComType.无分红,
                    //    AgentComRatio = 0
                    //};
                }
                else if (entity.IsAgentComUp == true)
                {
                    //switch (entity.IsAgentComUpType)
                    //{
                    //    case AgentRuleConst.IsAgentComUpType.分销商数量:
                    //        var listDis = query.GetDistributionLite(merchantGuid);
                    //        var disCount_First = 0;
                    //        disCount_First = listDis.Count(c => c.ParentDistributionPropGuid == null);
                    //        var queryAgentComUp = Factory.CreateT_BAS_FlagAgentComUp(tran);
                    //        var listComUp = queryAgentComUp.GetList(c => c.FlagshipParaGuid == entity.FlagshipParaGuid, false, c => c.LevelUpValue, DAL.Enums.OrderMethods.DESC, RFramework.SQLServer.Enums.LockType.Default, false);
                    //        if (listComUp == null || listComUp.Count == 0)
                    //        {
                    //            break;
                    //        }
                    //        var comUp = listComUp.First(c => disCount_First >= c.LevelUpValue);
                    //        if (comUp == null)
                    //        {
                    //            break;
                    //        }
                    //        entity.AgentComRatio = comUp.AgentComRatio;
                    //        break;
                    //    case AgentRuleConst.IsAgentComUpType.分销商销售额:
                    //        throw new Exception("分销商销售额 TODO");
                    //        break;
                    //}

                    entity.AgentComRatio = 0;
                    var queryAgentComUp = Factory.CreateT_BAS_FlagAgentComUp(tran);
                    var listComUp = queryAgentComUp.GetList(c => c.FlagshipParaGuid == entity.FlagshipParaGuid, false, c => c.LevelUpValue, DAL.Enums.OrderMethods.DESC, RFramework.SQLServer.Enums.LockType.Default, false);
                    if (listComUp != null && listComUp.Count > 0)
                    {
                        //需求动态计算店铺当前销售额，暂定
                        var totalSales = (entity.TotalSales ?? 0M);
                        var te = listComUp.FirstOrDefault(c => totalSales >= c.LevelUpValue);
                        if (te != null)
                        {
                            entity.AgentComRatio = te.AgentComRatio;
                        }

                    }

                }
                return entity;
            }
        }
        #endregion

        #region  获取指定商家的数据关联总部类型
        /// <summary>
        /// 获取指定商家的数据关联总部类型 
        /// </summary>
        /// <returns></returns>
        public static T_BAS_MerchantsWithLite GetMerchantDataByMer(Guid? merchantGuid = null)
        {
            using (var queryMer = Factory.CreateT_BAS_MerchantsWithLite())
            {
                if (merchantGuid == null)
                {
                    merchantGuid = Common.CurrentManage.MerchantGuid;
                }
                var mer = queryMer.GetFirstData(c => c.MerchantGuid == merchantGuid, isFilterMerchant: false);
                return mer;
            }
        }
        #endregion

        #region 获取指定订单的旗舰订单规则

        /// <summary>
        /// 获取指定订单的旗舰订单规则
        /// </summary>
        /// <param name="orderGuid"></param>
        /// <returns></returns>
        public static T_BAS_FlagshipOrders GetOrderRule(Guid orderGuid)
        {
            using (var query = Factory.CreateT_BAS_FlagshipOrders())
            {
                var entity = query.GetFirstData(c => c.OrderGuid == orderGuid, isFilterMerchant: false);
                return entity;
            }

        }

        #endregion
    }
}
